var searchIndex = [
    
    {
        "uri": "/manual/architecture/nodes/actionnode.html",
        "title": "Action",
        "tags": [],
        "description": "",
        "summary": "Action is a node that executes a process and immediately transitions to the next node.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Output port OutputTransitionPort Transitions to the destination node    Supported node components  ActionComponent The process is executed when the node becomes active.\nOutputs the result in bool type. EvaluateComponent  ",
        "content": "Action is a node that executes a process and immediately transitions to the next node.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Output port OutputTransitionPort Transitions to the destination node    Supported node components  ActionComponent The process is executed when the node becomes active.\nOutputs the result in bool type. EvaluateComponent  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/composites/behaviortreeexecute.html",
        "title": "Behavior Tree Execute",
        "tags": [],
        "description": "",
        "summary": "Executes one child node and returns the child node's result as its own execution result.\nBehavior based on child node results    Results Behavior     Success Finishes execution and Behavior Tree Execute itself also returns success.   Failure Execution ends and Behavior Tree Execute itself also returns failure.    Properties    Property name Type Description     Execute OutputBehaviorTreePort Executes the connected child node and receives the execution result.",
        "content": "Executes one child node and returns the child node's result as its own execution result.\nBehavior based on child node results    Results Behavior     Success Finishes execution and Behavior Tree Execute itself also returns success.   Failure Execution ends and Behavior Tree Execute itself also returns failure.    Properties    Property name Type Description     Execute OutputBehaviorTreePort Executes the connected child node and receives the execution result. Only one child node can be connected.    "
    },
    {
        "uri": "/manual/architecture/nodes/converts/downcastnode.html",
        "title": "Downcast",
        "tags": [],
        "description": "",
        "summary": "Outputs the value type by downcasting it.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     GameObject Interface Not possible   value type (No conditions) not allowed   (No conditions) Interface Possible   (No conditions) Derived from input type Possible    Other than the above is not possible",
        "content": "Outputs the value type by downcasting it.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     GameObject Interface Not possible   value type (No conditions) not allowed   (No conditions) Interface Possible   (No conditions) Derived from input type Possible    Other than the above is not possible\n"
    },
    {
        "uri": "/manual/architecture/nodecomponents/decorator/evaluatedecorator.html",
        "title": "EvaluateDecorator",
        "tags": [],
        "description": "",
        "summary": "Decorator that evaluates whether to execute the node.\nCommon properties    Property name Type Description     Abort Flags AbortFlags Abort method flags. SelfIf the Decorator evaluation result becomes false while the self node is running, a failure is returned to the parent node. Lower PriorityIf the parent node is Selector, a node with a lower priority than the own node (its position in the graph is lower than the own node) is being executed.",
        "content": "Decorator that evaluates whether to execute the node.\nCommon properties    Property name Type Description     Abort Flags AbortFlags Abort method flags. SelfIf the Decorator evaluation result becomes false while the self node is running, a failure is returned to the parent node. Lower PriorityIf the parent node is Selector, a node with a lower priority than the own node (its position in the graph is lower than the own node) is being executed. If the Decorator evaluation result becomes true, the running node is forcibly interrupted and the execution of the own node is interrupted.    Logical Condition LogicalCondition Evaluation settings using logical operations. If there are multiple EvaluateDecorators on the own node, perform a logical operation and obtain the result.    "
    },
    {
        "uri": "/manual/scripting/nodecomponents/decorator/evaluatedecorator.html",
        "title": "EvaluateDecorator",
        "tags": [],
        "description": "",
        "summary": "EvaluateDecorator can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Decorator \u0026gt; Evaluate Decorator C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.BehaviorTree.EvaluateDecorator. Apply System.SerializableAttribute to the type. Implement protected override bool OnEvaluate() and write the processing at runtime.",
        "content": "EvaluateDecorator can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Decorator \u0026gt; Evaluate Decorator C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.BehaviorTree.EvaluateDecorator. Apply System.SerializableAttribute to the type. Implement protected override bool OnEvaluate() and write the processing at runtime. protected override void OnActivated() is called when activated. protected override void OnDeactivated() is called when it becomes inactive. protected override void OnEnterEvaluation() is called when it becomes the evaluation target.\nIf Lower Priority is set in the Abort Flags of the Decorator set as a child node of the Selector, even if a node with a lower priority (younger node) is running, it will be subject to evaluation. protected override void OnLeaveEvaluation() is called when it is no longer subject to evaluation.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\rusing LogicToolkit.BehaviorTrees;\r[System.Serializable]\rpublic class EvaluateDecoratorExample : EvaluateDecorator\r{\rprivate float startTime = float.MaxValue;\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\rstartTime = Time.time;\r}\r// OnEnterEvaluation is called when entering the evaluation target\r protected override void OnEnterEvaluation()\r{\r}\r// OnEvaluate is called when evaluating the condition\r protected override bool OnEvaluate()\r{\rreturn Time.time - startTime \u0026lt;= 1f;\r}\r// OnLeaveEvaluation is called when leaving the evaluation target\r protected override void OnLeaveEvaluation()\r{\r}\r// OnDeactivated is called when it is deactivated.\r protected override void OnDeactivated()\r{\r}\r}\r  In this example, setting Abort Flags to Self will cause the node to abort after 1 second of activation.\nIn addition, a script called TimeLimit is included in advance as a similar function.\n"
    },
    {
        "uri": "/manual/architecture/nodecomponents/eventcomponent.html",
        "title": "EventComponent",
        "tags": [],
        "description": "",
        "summary": "This is a node component that performs the process of notifying the node that an event has arrived.\nUsed to wait for Unity messages (such as OnCollisionEnter) or input events.\nBehavior when set to node Event Event\nExecutes the connected node when an event occurs.\nTask Task\nTransitions to the destination node when an event occurs.\nBehaviorTree BehaviorTree\nReturns the result to the parent node when the event occurs.\nAdditional properties",
        "content": "This is a node component that performs the process of notifying the node that an event has arrived.\nUsed to wait for Unity messages (such as OnCollisionEnter) or input events.\nBehavior when set to node Event Event\nExecutes the connected node when an event occurs.\nTask Task\nTransitions to the destination node when an event occurs.\nBehaviorTree BehaviorTree\nReturns the result to the parent node when the event occurs.\nAdditional properties\n   Property name Type Description     Result InputField\u0026lt;bool\u0026gt; Set the result to be returned when the event arrives.    State State\nOutputs a signal when an event occurs.\nAdditional properties\n   Property name Type Description     Result InputField\u0026lt;bool\u0026gt; Set the signal to be returned when the event arrives.   Completed OutputSignalPort Outputs Result as a signal when an event arrives.    Script generation The script generation function uses ActionComponent for the following member access scripts.\n field of type delegate Field of type UnityEvent Properties of delegate type *Property of type UnityEvent event  For details, please refer to Script generation.\n"
    },
    {
        "uri": "/manual/architecture/wires/executewire.html",
        "title": "ExecuteWire",
        "tags": [],
        "description": "",
        "summary": "A wire for running a connected node.\nCombinations of ports that can be connected    Output port Input port     OutputExecutePort InputExecutePort    ",
        "content": "A wire for running a connected node.\nCombinations of ports that can be connected    Output port Input port     OutputExecutePort InputExecutePort    "
    },
    {
        "uri": "/manual/architecture/nodes/functions/functionstartnode.html",
        "title": "Function Start",
        "tags": [],
        "description": "",
        "summary": "This is the first node executed when Function Graph is called.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node.   Parameter list List of parameters to output Get the parameters from the parent graph and output the data values. The setting items for each parameter are as follows. NameData typeOutputDataPort    ",
        "content": "This is the first node executed when Function Graph is called.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node.   Parameter list List of parameters to output Get the parameters from the parent graph and output the data values. The setting items for each parameter are as follows. NameData typeOutputDataPort    "
    },
    {
        "uri": "/manual/getting-started.html",
        "title": "Getting started",
        "tags": [],
        "description": "",
        "summary": "This section provides a basic overview of Logic Toolkit and how to install it.\nWhat is Logic Toolkit? Logic Toolkit is an editor extension asset for Unity that has the following features.\n Editor that allows you to visually organize the flow of behavior Compatible with a wide variety of nodes Node components can be created using C# scripts Supports script generation  For more information, see Overview.\nInstall Logic Toolkit For the installation procedure of Logic Toolkit, please refer to Installation steps.",
        "content": "This section provides a basic overview of Logic Toolkit and how to install it.\nWhat is Logic Toolkit? Logic Toolkit is an editor extension asset for Unity that has the following features.\n Editor that allows you to visually organize the flow of behavior Compatible with a wide variety of nodes Node components can be created using C# scripts Supports script generation  For more information, see Overview.\nInstall Logic Toolkit For the installation procedure of Logic Toolkit, please refer to Installation steps.\nBasic workflow Describes Basic Workflow using Logic Toolkit.\n"
    },
    {
        "uri": "/manual/windows/logiceditor/sidepanel/graphs.html",
        "title": "Graphs tab",
        "tags": [],
        "description": "",
        "summary": "Let's talk about the Graphs tab in the side panel.\nGraph tree Displays the graph hierarchy tree within the selected object.\nBy placing the function graph execution node within the graph, the child graphs will be displayed.\nMethod of operation Graph selection  Click on the graph from the tree\nWhen selected, the graph view will change accordingly.  Rename graph  Start name input mode\nPlease use one of the following methods to enter input mode.",
        "content": "Let's talk about the Graphs tab in the side panel.\nGraph tree Displays the graph hierarchy tree within the selected object.\nBy placing the function graph execution node within the graph, the child graphs will be displayed.\nMethod of operation Graph selection  Click on the graph from the tree\nWhen selected, the graph view will change accordingly.  Rename graph  Start name input mode\nPlease use one of the following methods to enter input mode.  Right-click on the graph and select Rename from the menu *Click on the graph to make it active, then click again Select the graph and press F2 key (Win)/Enter key (Mac)   Enter your name Confirm with Enter key  Functions column A list of function graphs of the selected object is displayed.\nMethod of operation Creating a function graph  Creation menu display\nPlease display using one of the following methods  Click the “+” button Click inside the Functions list field and press Ctrl + Shift + N key (Win)/command ⌘ + shift ⇧ + N key (Mac) Right-click inside the Functions list field and select Create from the menu   Select the type of graph you want to create from the menu The graph will be created and you will be in graph name input mode, so enter the name. Confirm with Enter key  Select function graph  Click on the graph in the list\nWhen selected, the graph view will change accordingly.  Renaming function graphs  Start name input mode\nPlease use one of the following methods to enter input mode.  Right-click on the graph and select Rename from the menu Click on the graph to make it active, then click again Select the graph and press F2 key (Win)/Enter key (Mac)   Enter your name Confirm with Enter key  Delete function graph You can delete it using one of the following methods:\n Right-click the graph you want to delete and select Delete from the menu Select the graph and press the Delete key.  "
    },
    {
        "uri": "/manual/architecture/nodes/organizes/groupnode.html",
        "title": "Group",
        "tags": [],
        "description": "",
        "summary": "This node is used to organize multiple nodes into a group.\nYou can change the size by dragging the node frame.\nAdditional right-click menu    Contents Description     Color Settings You can set the color of the node.    Shortcuts    Contents How to operate     Create Select multiple nodes that you want to surround with Group node and press G key (If no nodes are selected, it will be created at the mouse cursor position)    ",
        "content": "This node is used to organize multiple nodes into a group.\nYou can change the size by dragging the node frame.\nAdditional right-click menu    Contents Description     Color Settings You can set the color of the node.    Shortcuts    Contents How to operate     Create Select multiple nodes that you want to surround with Group node and press G key (If no nodes are selected, it will be created at the mouse cursor position)    "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/ifnode.html",
        "title": "If",
        "tags": [],
        "description": "",
        "summary": "This node switches the node to be executed according to the conditions.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Conditions List of IfCondition List of boolean values and ExecutePort to judge. Determine in order from the top, and if Input is true, execute the node connected to Then. InputInputField of boolean value to judgeThenIf Input is true, connect destination node Execute OutputExecutePort   Else OutputExecutePort Executes when none of the conditions in Conditions are met.",
        "content": "This node switches the node to be executed according to the conditions.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Conditions List of IfCondition List of boolean values and ExecutePort to judge. Determine in order from the top, and if Input is true, execute the node connected to Then. InputInputField of boolean value to judgeThenIf Input is true, connect destination node Execute OutputExecutePort   Else OutputExecutePort Executes when none of the conditions in Conditions are met.   Completed OutputTransitionPort Transition occurs when the running node reaches Exit.    Accepting flow termination nodes  Exit\nFinishes execution and transitions to Completed.  "
    },
    {
        "uri": "/manual/scripting/nodecomponents/interfaces/ipausereceiver.html",
        "title": "IPauseReceiver",
        "tags": [],
        "description": "",
        "summary": "You can implement a method to call when the graph is paused.\nAbout pausing the graph  Pause with the Pause() method of LogicToolkit.LogicPlayerBase. Resume with the Resume() method of LogicToolkit.LogicPlayerBase. Pausing is also performed in conjunction with the isActiveAndEnabled property of LogicToolkit.LogicPlayerBase.  How to write a script  Implement LogicToolkit.IPauseReceiver in types that inherit from various NodeComponents. Implement public void OnPause(bool pause).  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28  using System.",
        "content": "You can implement a method to call when the graph is paused.\nAbout pausing the graph  Pause with the Pause() method of LogicToolkit.LogicPlayerBase. Resume with the Resume() method of LogicToolkit.LogicPlayerBase. Pausing is also performed in conjunction with the isActiveAndEnabled property of LogicToolkit.LogicPlayerBase.  How to write a script  Implement LogicToolkit.IPauseReceiver in types that inherit from various NodeComponents. Implement public void OnPause(bool pause).  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class PauseExample : ServiceComponent, IPauseReceiver\r{\rprivate Animator animator;\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\ranimator = Player.GetComponent\u0026lt;Animator\u0026gt;();\r}\rpublic void OnPause(bool pause)\r{\rif (pause)\r{\ranimator.speed = 0f;\r}\relse\r{\ranimator.speed = 1f;\r}\r}\r}\r  In this example, when using this component, such as in a Service node, the Animator will pause in conjunction with the pose of the graph.\n"
    },
    {
        "uri": "/manual/architecture/objects/logicbehavior.html",
        "title": "Logic Behavior",
        "tags": [],
        "description": "",
        "summary": "This is the main component of Logic Toolkit that can be added to GameObject. It has a built-in Logic Controller, which allows you to control behavior using a node graph.\nHow to add Add to existing GameObject  Select the GameObject you want to add in the Hierarchy window. Click the \u0026ldquo;Add Component\u0026rdquo; button in the Inspector window. Select Logic Toolkit \u0026gt; Logic Behavior from the menu.  Creating GameObject with Logic Behavior  Click the \u0026ldquo;+\u0026rdquo; button in the Hierarchy window.",
        "content": "This is the main component of Logic Toolkit that can be added to GameObject. It has a built-in Logic Controller, which allows you to control behavior using a node graph.\nHow to add Add to existing GameObject  Select the GameObject you want to add in the Hierarchy window. Click the \u0026ldquo;Add Component\u0026rdquo; button in the Inspector window. Select Logic Toolkit \u0026gt; Logic Behavior from the menu.  Creating GameObject with Logic Behavior  Click the \u0026ldquo;+\u0026rdquo; button in the Hierarchy window. Select Logic Toolkit \u0026gt; Logic Behavior from the menu. The GameObject will enter name input mode, so enter the name. Confirm with Enter key.  Created in the Logic Editor window  Click the \u0026ldquo;+\u0026rdquo; button in the Logic Editor window. Select Logic Behavior from the menu.  Properties    Properties Description     Play On Awake Start playing when GameObject is Awake   Debug Graph Settings Graph debug settings   Edit button Open Logic Editor window    "
    },
    {
        "uri": "/manual/windows/logiceditor.html",
        "title": "Logic Editor window",
        "tags": [],
        "description": "",
        "summary": "This section describes the Logic Editor window.\nHow to open You can open it using one of the following methods.\n Select Window \u0026gt; Logic Toolkit \u0026gt; Logic Editor from the menu. Logic Behavior and Logic Asset Click the \u0026ldquo;Edit\u0026rdquo; button from the Inspector window.  UI (A) Toolbar Displays options for selecting available objects, setting buttons, etc.\n(B) Side panel Displays the graph tree hierarchy, nodes, Blackboard, etc. of the currently selected object.",
        "content": "This section describes the Logic Editor window.\nHow to open You can open it using one of the following methods.\n Select Window \u0026gt; Logic Toolkit \u0026gt; Logic Editor from the menu. Logic Behavior and Logic Asset Click the \u0026ldquo;Edit\u0026rdquo; button from the Inspector window.  UI (A) Toolbar Displays options for selecting available objects, setting buttons, etc.\n(B) Side panel Displays the graph tree hierarchy, nodes, Blackboard, etc. of the currently selected object.\n Graphs\nA list of graph trees and function graphs will be displayed. Nodes\nA list of nodes of the currently selected graph is displayed. Blackboard\nYou can edit related Blackboard.  (C) Minimap A minimap of the currently selected graph is displayed.\nYou can scroll the view frame, change or reset the magnification, etc. by dragging the view frame.\n(D) Graph View This is the area where you can edit the currently selected graph.\nFor details, see Graph View.\n(E) Breadcrumbs The hierarchy up to the currently selected graph is displayed.\nYou can switch the selected graph by clicking the parent graph.\n"
    },
    {
        "uri": "/manual/architecture/graphs/logicgraph.html",
        "title": "Logic Graph",
        "tags": [],
        "description": "",
        "summary": "The main node graph that controls the behavior.\nIn Logic Graph, you can execute connected nodes starting from an event node.\nSince multiple event nodes can be placed, multiple flows can be executed simultaneously and in parallel within one graph.\nHow to create To create it, you need to create various objects that contain Logic Controller.\nPlease refer to the following page for details.\n Logic Behavior Logic Asset  Available nodes The nodes available in Logic Graph are as follows.",
        "content": "The main node graph that controls the behavior.\nIn Logic Graph, you can execute connected nodes starting from an event node.\nSince multiple event nodes can be placed, multiple flows can be executed simultaneously and in parallel within one graph.\nHow to create To create it, you need to create various objects that contain Logic Controller.\nPlease refer to the following page for details.\n Logic Behavior Logic Asset  Available nodes The nodes available in Logic Graph are as follows.\n Action Task State BehaviorTree Event nodes Flow control nodes Signal nodes Data calculation nodes Data conversion nodes Graph organizing nodes  "
    },
    {
        "uri": "/manual/migration/arbor3.html",
        "title": "Migration from Arbor3",
        "tags": [],
        "description": "",
        "summary": "We will explain the migration from \u0026ldquo;Arbor 3: FSM \u0026amp; BT Graph Editor (hereinafter referred to as Arbor3)\u0026quot;.\nArbor3 and Logic Toolkit are not compatible.\nIf you want to switch a project developed with Arbor3 to Logic Toolkit, you will need to reassemble it with reference to the following points.\nArchitecture differences    Element Arbor3 Logic Toolkit     State Machine ArborFSM Component State   Behavior Tree BehaviourTree component BehaviorTree   Data Flow DataSlotFlexibleFieldCalculator OutputDataPort[InputDataPort]({{ \u0026lt; relref \u0026ldquo;/manual/architecture/ports/inputdataport.",
        "content": "We will explain the migration from \u0026ldquo;Arbor 3: FSM \u0026amp; BT Graph Editor (hereinafter referred to as Arbor3)\u0026quot;.\nArbor3 and Logic Toolkit are not compatible.\nIf you want to switch a project developed with Arbor3 to Logic Toolkit, you will need to reassemble it with reference to the following points.\nArchitecture differences    Element Arbor3 Logic Toolkit     State Machine ArborFSM Component State   Behavior Tree BehaviourTree component BehaviorTree   Data Flow DataSlotFlexibleFieldCalculator OutputDataPort[InputDataPort]({{ \u0026lt; relref \u0026ldquo;/manual/architecture/ports/inputdataport.md\u0026rdquo; \u0026gt;}})InputFieldData calculation nodesData conversion nodes   Graph Hierarchy SubStateMachineSubBehaviorTree Function Graph(Task Graph, Evaluate Graph)   Variable ParameterContainer Blackboard   API call Built-in scriptCall by reflectionCreate your own script Built-in scriptScript generationScripting   Script for nodes MonoBehaviour SerializeReference    Graph differences Arbor3  State machine and behavior tree are available as graph types. Managed by \u0026ldquo;Unity object\u0026rdquo; derived from MonoBehaviour. Child graphs are also realized internally by adding components to the same GameObject. Graphs can be reused in a pseudo manner by creating a prefab with a graph component.  Logic Toolkit  How it is executed is controlled only by the node type.  State machine is realized with State. Behavior tree is realized with BehaviorTree.   Managed by SerializeReference. Child graphs can be added without restrictions on Unity objects. Logic Asset and Task Graph Asset, Evaluate Graph Asset allows graph reuse.  Differences in scripts for nodes Arbor3  Managed by \u0026ldquo;Unity object\u0026rdquo; derived from MonoBehaviour. MonoBehaviour messages (such as OnCollisionEnter) are also called. Node scripts cannot be used\nOnly the StateBehaviour script can be used for State, so if you want to create the same process in BehaviorTree, you must also create an ActionBehaviour script separately. To access API members, a high-load reflection call or script writing is required.  Logic Toolkit  Managed by SerializeReference. MonoBehaviour messages (such as OnCollisionEnter) are not called.  Requires replacement such as waiting for events via MonoBehaviour script that receives messages.   Node scripts can be used\nActionComponent and TaskComponent can be used for both State and BehaviorTree. Scripts can be generated to access API members.  About built-in features Arbor3  Supported by various components and related scripts. *For unsupported functions, users are required to write scripts for each function.  Logic Toolkit  In order to narrow down the functions of the asset itself, only the minimum built-in functions are implemented. Since member access is possible through the script generation function, there are fewer cases where it is necessary to write individual scripts. Compatible packages will be provided separately if necessary.  "
    },
    {
        "uri": "/manual/architecture/graphs.html",
        "title": "Node Graph",
        "tags": [],
        "description": "",
        "summary": "Node graph is a function that allows you to connect nodes and create a flow of behavior.\nTypes of node graphs Logic Graph The main node graph for controlling behavior.\nIt is built into Logic Controller and Logic Behavior You can create graphs by creating objects such as or Logic Asset.\nFor details, see Logic Graph.\nFunction graph It is a node graph that can be called like a function as a child graph of Logic Graph.",
        "content": "Node graph is a function that allows you to connect nodes and create a flow of behavior.\nTypes of node graphs Logic Graph The main node graph for controlling behavior.\nIt is built into Logic Controller and Logic Behavior You can create graphs by creating objects such as or Logic Asset.\nFor details, see Logic Graph.\nFunction graph It is a node graph that can be called like a function as a child graph of Logic Graph.\nIt can be created using the internal function graph of Logic Controller, or Task Graph Asset or Evaluate Graph Asset.\n Task Graph\nA graph that runs continuously. Evaluate Graph\nThis is a graph that performs processing that can be completed in an instant.  Blackboard(Local) The node graph has a built-in Blackboard, which can be used to temporarily store values in the graph like a local variable of a function. can.\n"
    },
    {
        "uri": "/manual/scripting/nodecomponents.html",
        "title": "NodeComponent scripts",
        "tags": [],
        "description": "",
        "summary": "This section describes NodeComponent related scripts.\n Script generation\nThis section explains how to generate a simple script that only calls methods and inputs and outputs properties. ActionComponent\nDescribes the ActionComponent script. EvaluateComponent\nDescribes the EvaluateComponent script. TaskComponent\nDescribes the TaskComponent script. EventComponent\nDescribes the EventComponent script. ServiceComponent\nDescribes the ServiceComponent script. Decorator\nDescribes the Decorator script. Rename Type\nThis section explains type renaming of NodeComponent.  ",
        "content": "This section describes NodeComponent related scripts.\n Script generation\nThis section explains how to generate a simple script that only calls methods and inputs and outputs properties. ActionComponent\nDescribes the ActionComponent script. EvaluateComponent\nDescribes the EvaluateComponent script. TaskComponent\nDescribes the TaskComponent script. EventComponent\nDescribes the EventComponent script. ServiceComponent\nDescribes the ServiceComponent script. Decorator\nDescribes the Decorator script. Rename Type\nThis section explains type renaming of NodeComponent.  "
    },
    {
        "uri": "/manual/architecture/ports/outputexecuteport.html",
        "title": "OutputExecutePort",
        "tags": [],
        "description": "",
        "summary": "This is an output port for executing the connection destination port.\nConnectable wires  ExecuteWire\nExecutes the node connected to InputExecutePort first.  ",
        "content": "This is an output port for executing the connection destination port.\nConnectable wires  ExecuteWire\nExecutes the node connected to InputExecutePort first.  "
    },
    {
        "uri": "/manual/getting-started/overview.html",
        "title": "Overview",
        "tags": [],
        "description": "",
        "summary": "Logic Toolkit is an editor extension asset of the Visual Scripting category that allows you to construct the flow of behavior in a visual node graph format.\nVisualize the flow of behavior The Unity Editor extension window allows you to visually edit your node graph.\nTest play on Unity allows you to check the current values of running nodes and data, which is also useful for debugging.\n3 concepts Logic Toolkit achieves high reusability by structuring the flow of behavior into three general concepts.",
        "content": "Logic Toolkit is an editor extension asset of the Visual Scripting category that allows you to construct the flow of behavior in a visual node graph format.\nVisualize the flow of behavior The Unity Editor extension window allows you to visually edit your node graph.\nTest play on Unity allows you to check the current values of running nodes and data, which is also useful for debugging.\n3 concepts Logic Toolkit achieves high reusability by structuring the flow of behavior into three general concepts.\nAction For example, a process that can be completed in an instant, such as firing a bullet (materializing a bullet object), is called an action here. (Also called synchronous processing in programming terminology)\nProcessing such as storing or retrieving the number of remaining bullets in a variable, or determining whether there are any remaining bullets, can also be considered a type of action.\nTask For example, processes that are performed continuously, such as \u0026ldquo;wait for a certain period of time\u0026rdquo; or \u0026ldquo;move in a straight line from point A to point B and wait until the movement is complete\u0026rdquo; are called tasks here. (Also called asynchronous processing in programming terminology)\nEvent For example, the process of waiting for \u0026ldquo;when a key is input\u0026rdquo; or \u0026ldquo;when an object collides with something\u0026rdquo; is called an event here. (Also called an event in programming terminology)\nYou can also think of \u0026ldquo;tasks that wait until an event arrives\u0026rdquo;, so you can also use the event function where you can use the task function.\n4 flows Logic Toolkit organizes the processing flow into four categories.\nExecution flow The flow of what kind of processing is to be done and in what order is called the execution flow here.\nFor example, if a character is attacked, the flow will be as follows.\n Damage calculation Show hit effect and damage amount Has your physical strength become 0 or less?  Death animation play Wait for a certain amount of time to pass Destroy object    State machine A process flow that focuses on \u0026ldquo;states\u0026rdquo; and \u0026ldquo;conditions for switching states\u0026rdquo; is called a state machine.\nFor example, there are enemy monsters that have built state machines like the one below.\n   State Description Transition     Patrol Patrol a fixed route in search of player characters Go to \u0026ldquo;Normal attack\u0026rdquo; state when a player is found   Normal attack Approaches the player and attacks normally Goes into \u0026ldquo;Goes crazy\u0026rdquo; state when less than half of his health remains   Goes crazy Attack power increases by 1.5 times and attacks aggressively Goes into \u0026ldquo;Escape\u0026rdquo; state when remaining health is 10% or less   Escape Move away from the player and wait for your own physical strength to recover naturally If you are a certain distance away from the player, go to the \u0026ldquo;Patrol\u0026rdquo; state. If your physical strength has recovered to more than half, go to the \u0026ldquo;Normal attack\u0026rdquo; state.    Behavior tree The flow of processing that focuses on \u0026ldquo;priorities\u0026rdquo; and \u0026ldquo;conditions for behavior\u0026rdquo; is called a behavior tree.\nFor example, the behavior of an enemy monster can be expressed in a behavior tree as shown below.\n   Priority Behavior Condition Description     1 Ready for battle Found a player Ready for battle by taking the following actions against the player you found   1-1 Escape Less than 10% of your health remaining Move away from the player and wait for your health to recover naturally   1-2 Going crazy Less than half of your health left Performs a powerful attack   1-3 Normal attack Unconditional Approach the player and attack normally   2 Patrol Unconditional Search for player characters and patrol a fixed route    (Due to the tree structure, child elements are represented here as \u0026ldquo;1-1\u0026rdquo;)\nData flow The flow of data that performs values acquisition, calculations, etc. is called data flow here.\nFor example, the damage calculation is as follows.\n Get attack power Get defensive power Get remaining health Calculate \u0026ldquo;Remaining Health - (Attack Power/2 - Defense Power/4)\u0026rdquo; Set the remaining health to the value in 4.  Nodes Logic Toolkit allows you to realize the above \u0026ldquo;4 concepts\u0026rdquo; and \u0026ldquo;4 flows\u0026rdquo; with various nodes.\nAction A node that performs a single process.\nIt runs instantly and immediately transitions to the next node.\nFor details, see Action.\nTask A node that continuously executes processing.\nWait until the process is completed and then transition to the next node.\nFor details, see Task.\nFlow control nodes A group of nodes that control the execution flow of nodes.\nYou can branch the node to be executed and repeatedly execute the connected node.\nFor details, please refer to Flow control nodes.\nEvent nodes A group of nodes for starting node execution. According to the execution start conditions, if the conditions are met, execute the connected node.\nFor details, please refer to Event nodes.\nState This is a node that handles states.\nThe execution status is sent as a signal, and the connected signal node transitions to the next node depending on the result of the condition judgment.\nFor details, see State.\nSignal nodes A group of nodes that determine conditions for transitioning from State to other nodes.\nFor details, please refer to Signal nodes.\nBehaviorTree This node switches execution nodes in behavior tree format.\nThey are executed in the priority order of the connected nodes, and the child nodes return their execution results to the parent node, and the parent node controls the execution of the child nodes based on the received results.\nFor details, see BehaviorTree.\nData calculation nodes A group of nodes for performing arithmetic operations, obtaining values, etc.\nFor details, please refer to Data calculation nodes.\nData conversion nodes A group of nodes for converting data types.\nFor details, please refer to Data conversion nodes.\nNode Component A node component is a component for a node that implements the behavior. By setting a node component to a node, you can configure how the running node behaves.\nFor details, see Node Component.\nC# scripts Various node components can be added using C# scripts.\nProcesses that would be too complex on a graph can be easily organized by writing C# scripts.\nFor details, see Scripting.\nGenerate API call script You can generate scripts for node components to call APIs such as Unity itself and packages.\nThe necessary node components are generated just by selecting the member you want to call, so you can concentrate on editing the node graph without having to write simple scripts.\nFor details, see Script generation.\n"
    },
    {
        "uri": "/manual/windows/logiceditor/sidepanel.html",
        "title": "Side panel",
        "tags": [],
        "description": "",
        "summary": "This section describes the side panel of the Logic Editor window.\nThe side panel displays the currently selected object's graph tree hierarchy, nodes, Blackboard, etc.\n Graphs\nA list of graph trees and function graphs will be displayed. Nodes\nA list of nodes of the currently selected graph is displayed. Blackboard\nYou can edit related Blackboard.  ",
        "content": "This section describes the side panel of the Logic Editor window.\nThe side panel displays the currently selected object's graph tree hierarchy, nodes, Blackboard, etc.\n Graphs\nA list of graph trees and function graphs will be displayed. Nodes\nA list of nodes of the currently selected graph is displayed. Blackboard\nYou can edit related Blackboard.  "
    },
    {
        "uri": "/manual/architecture/nodes/signals/signalevaluationnode.html",
        "title": "Signal Evaluation",
        "tags": [],
        "description": "",
        "summary": "A node that evaluates signals.\nRuns the node component and waits for completion while the signal evaluates to true.\nProperties    Property name Type Description     Output port OutputSignalPort Outputs the signal resulting from Inputs and Conditions. If you connect with TransitionWire, it will transition to the destination node if the signal is on.   Inputs List of LogicalElement\u0026lt;InputSignalPort\u0026gt; Find the result of logical operation on the signals obtained from each InputSignalPort Masu.",
        "content": "A node that evaluates signals.\nRuns the node component and waits for completion while the signal evaluates to true.\nProperties    Property name Type Description     Output port OutputSignalPort Outputs the signal resulting from Inputs and Conditions. If you connect with TransitionWire, it will transition to the destination node if the signal is on.   Inputs List of LogicalElement\u0026lt;InputSignalPort\u0026gt; Find the result of logical operation on the signals obtained from each InputSignalPort Masu.   Conditions List of TaskComponent If the judgment result of Inputs is on, each set [TaskComponent] ](/manual/architecture/nodecomponents/taskcomponent.html) is executed. When the execution of the task is completed, the execution result is reflected in the signal.    Supported node components  TaskComponent\nReflects the execution result in the output signal. EvaluateComponent\nReflect the judgment results in the output signal.  "
    },
    {
        "uri": "/manual/architecture/nodes/events/startnode.html",
        "title": "Start",
        "tags": [],
        "description": "",
        "summary": "Start is the node that is called when the graph starts.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    ",
        "content": "Start is the node that is called when the graph starts.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types.html",
        "title": "Types",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     Decorator Basic type of Decorator used for BehaviorTree nodes   EvaluateDecorator Decorator that evaluates the execution of BehaviorTree nodes   LoopCheckDecorator Decorator that checks for loops in BehaviorTree nodes   ResultChangeDecorator Decorator that changes the execution result of the BehaviorTree node    ",
        "content": "   Type Name Description     Decorator Basic type of Decorator used for BehaviorTree nodes   EvaluateDecorator Decorator that evaluates the execution of BehaviorTree nodes   LoopCheckDecorator Decorator that checks for loops in BehaviorTree nodes   ResultChangeDecorator Decorator that changes the execution result of the BehaviorTree node    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types.html",
        "title": "Types",
        "tags": [],
        "description": "",
        "summary": "Type Name Description     AdvancedMenu Advanced Menu   AdvancedMenuItem Items in AdvancedMenu   ComponentMenuCreator Class that creates items for the node component selection menu   TypeMenuCreator Create a script selection menu   ConstantPropertyDrawer A base type that extends the representation of constant fields in InputField\u0026lt;T\u0026gt;   InputFieldElementBase Basic type of UI element for InputField   InputFieldElementUtility Utility class for InputFieldElement   FieldAssignor Class for assigning values to fields when a node or node component is created   PortFieldAssignor Class for connecting ports when a node or node component is created   GraphEditor Class for editing graphs   NodeComponentEditor Editor extension for NodeComponent   NodeEditor Editor extension for Node   PortConnector Class that manages port connections   NodeContentContainer UI element that serves as a container for the node's content   PortField Port UI elements   PooledObject\u0026lt;T\u0026gt; Manage pooled objects.",
        "content": "   Type Name Description     AdvancedMenu Advanced Menu   AdvancedMenuItem Items in AdvancedMenu   ComponentMenuCreator Class that creates items for the node component selection menu   TypeMenuCreator Create a script selection menu   ConstantPropertyDrawer A base type that extends the representation of constant fields in InputField\u0026lt;T\u0026gt;   InputFieldElementBase Basic type of UI element for InputField   InputFieldElementUtility Utility class for InputFieldElement   FieldAssignor Class for assigning values to fields when a node or node component is created   PortFieldAssignor Class for connecting ports when a node or node component is created   GraphEditor Class for editing graphs   NodeComponentEditor Editor extension for NodeComponent   NodeEditor Editor extension for Node   PortConnector Class that manages port connections   NodeContentContainer UI element that serves as a container for the node's content   PortField Port UI elements   PooledObject\u0026lt;T\u0026gt; Manage pooled objects.   SerializableTypeProperty Structure that references SerializableType by SerializedProperty   TypeMenuInfo Type menu information   BaseFieldExt\u0026lt;TValueType\u0026gt; A class that extends BaseField\u0026lt;TValueType\u0026gt;   BasePopupFieldExt\u0026lt;TValueType\u0026gt; Base class for popup field UI elements   SerializableTypeField UI elements for SerializableType    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Types.html",
        "title": "Types",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     OutputSignalPort Output signal port    ",
        "content": "   Type Name Description     OutputSignalPort Output signal port    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types.html",
        "title": "Types",
        "tags": [],
        "description": "",
        "summary": "Type Name Description     AssetInfo Asset information   Blackboard Blackboard to manage Variable   BlackboardAsset Asset containing BlackboardAsset.Blackboard.\nMainly used for referencing from BlackboardDataLinkReference and sharing as a data link.   BlackboardDataLink Datalinks that share Blackboard between objects   BlackboardDataLinkReference Data link reference information for BlackboardDataLinkReference.Blackboard   Variable Variables stored in Blackboard   VariableBase\u0026lt;T\u0026gt; Generic basic type of variables stored in Blackboard   Variable\u0026lt;T\u0026gt; Generic type of variables stored in Blackboard   VariableList\u0026lt;T\u0026gt; List type variable stored in Blackboard   VariableReference Reference to VariableReference.",
        "content": "   Type Name Description     AssetInfo Asset information   Blackboard Blackboard to manage Variable   BlackboardAsset Asset containing BlackboardAsset.Blackboard.\nMainly used for referencing from BlackboardDataLinkReference and sharing as a data link.   BlackboardDataLink Datalinks that share Blackboard between objects   BlackboardDataLinkReference Data link reference information for BlackboardDataLinkReference.Blackboard   Variable Variables stored in Blackboard   VariableBase\u0026lt;T\u0026gt; Generic basic type of variables stored in Blackboard   Variable\u0026lt;T\u0026gt; Generic type of variables stored in Blackboard   VariableList\u0026lt;T\u0026gt; List type variable stored in Blackboard   VariableReference Reference to VariableReference.Variable   ConstantContainer\u0026lt;T\u0026gt; Constant container   GameObjectConstantContainer Container for constants of type GameObject   ComponentConstantContainer\u0026lt;T\u0026gt; Container for constants of type Component   InputFieldBase Basic type of input field   InputFieldBase\u0026lt;T\u0026gt; Base type of input field of generic type   InputQuaternion Input field for Quaternion.\nFixed values can be set in Euler angles.   InputField\u0026lt;TValue, TContainer\u0026gt; Input field that can have a constant ConstantContainer\u0026lt;T\u0026gt;   InputField\u0026lt;T\u0026gt; Generic type input field   InputList\u0026lt;T\u0026gt; Input field of type IList\u0026lt;T\u0026gt;   InputGameObject Input field of type GameObject   InputComponent\u0026lt;T\u0026gt; Input field of type Component   InputSystemType Input field of type Type   InputFieldUtility Input field utility class   ComputeNodeBase Base class for compute nodes   ConvertNode Node that converts data type   DataPort Data port   DataPort\u0026lt;T\u0026gt; Generic type data port   DataPortWithType Typeable data port   InputDataPort\u0026lt;T\u0026gt; Generic type input data port   InputDataPortWithType Typeable input data port   OutputDataPort\u0026lt;T\u0026gt; Generic type output data port   OutputDataPortWithType Typeable output data port   LogicController Main classes that control logic   ActionComponent A component that performs a process that completes execution in an instant.   ActivatableComponent Components that switch between active states   EvaluateComponent Component to be evaluated   EventComponent Component that listens for events   NodeComponent Basic type of component for adding to nodes   ServiceComponent Components that perform resident processing   AsyncOperationComponent\u0026lt;TAsyncOperation\u0026gt; Component that waits for AsyncOperation to complete   TaskComponent Components that perform operations that take a long time to complete   WaitForSeconds Component that waits for a specified number of seconds to elapse   TweenComponent\u0026lt;TTarget, TInputField, T\u0026gt; A component that performs tween animation of parameters by specifying the target.   TweenComponentBase\u0026lt;T\u0026gt; Basic type of component that performs tweened animation of parameters   NodeGraph Basic type of node graph   ActivatableNode Node whose active state changes   ExecuteNode Execution node   BreakNode Flow end node to exit from the loop   CompleteNode Flow end node to complete the task   ContinueNode Flow end node to transition to next loop   ExitNode Flow end node to end node execution   FlowExitNode Basic type of flow end node   Node Basic type of node   ServiceNode Node that performs resident processing   ServiceNodeBase Basic type of node that performs resident processing   LogicAsset Assets that handle LogicAsset.LogicController   LogicBehavior A component for internally holding and playing LogicBehavior.LogicController   LogicPlayer Component that references and plays LogicAsset   LogicPlayerBase Basic type of component that plays LogicPlayerBase.LogicController   OutputExecutePort Output execution port   Port Basic type of normal port   PortBase Basic type of port   OutputTransitionPort Output transition port   TransitionalPort Basic type of port that handles transitions   ProgressPlayer Progress player\nImplement and use IProgressComponent in NodeComponent.   RefArgument\u0026lt;T, TInputField\u0026gt; A type that handles reference arguments. Mainly used for script generation.   Wire Basic type of wire   SerializableType Structure for handling SerializableType.Type with Unity's serialization system   UniqueId Structure that handles unique IDs   Timer Measure the passage of time   EaseBase Basic type for easing   Interpolator\u0026lt;T\u0026gt; Basic type for interpolation processing   ByteLerp Linear interpolation of type byte   SByteLerp Linear interpolation of type sbyte   CharLerp Linear interpolation of type char   ShortLerp Linear interpolation of type short   UShortLerp Linear interpolation of type ushort   IntLerp Linear interpolation of type int   UIntLerp Linear interpolation of type uint   LongLerp Linear interpolation of type long   ULongLerp Linear interpolation of type ulong   FloatLerp Linear interpolation of type float   DoubleLerp Linear interpolation of type double   Vector2Lerp Linear interpolation of type Vector2   Vector2IntLerp Linear interpolation of type Vector2Int   Vector3Lerp Linear interpolation of type Vector3   Vector3Slerp Spherical linear interpolation of type Vector3   Vector3IntLerp Linear interpolation of type Vector3Int   Vector4Lerp Linear interpolation of type Vector4   ColorLerp Linear interpolation of type Color   QuaternionLerp Linear interpolation of type Quaternion   QuaternionSlerp Spherical linear interpolation of type Quaternion   CompareUtility Utility class for value comparisons   TypeUtility Type utility class   ListAccessorUtility ListAccessor utility class   ValueContainer\u0026lt;T\u0026gt; Class that handles value containers   ValueFlowExtensions Value flow extension class    "
    },
    {
        "uri": "/manual/scripting/nodecomponents/generator.html",
        "title": "スクリプト生成",
        "tags": [],
        "description": "",
        "summary": "You can generate scripts to access members such as methods and properties. Just select the member you want to access from the list and it will be created. You can quickly implement it without having to write each script one by one. Condition The conditions for members to have access are as follows. Must be a type defined in the Assembly Definition File or pre-compiled managed DLL Must be a",
        "content": "You can generate scripts to access members such as methods and properties.\nJust select the member you want to access from the list and it will be created.\nYou can quickly implement it without having to write each script one by one.\nCondition The conditions for members to have access are as follows.\n Must be a type defined in the Assembly Definition File or pre-compiled managed DLL Must be a public member of a public type Must be other than a generic type or method LogicToolkit.IgnoreGeneratorAttribute is not applied to the type or member  Supported member access The supported member access is as follows.\nGet field Create a script to get the field's value.\nComponent created\nThe component created changes depending on the field type.\n   Type of field Component created Description     bool type EvaluateComponent Create a script that returns a value as the evaluation result.   delegate type EventComponent Create a script that waits for the event to be called. Outputs the argument value received when the event is called from OutputDataPort.   UnityEvent type EventComponent Create a script that waits for the event to be called. Outputs the argument value received when the event is called from OutputDataPort.   Miscellaneous ActionComponent Create a script to get the value and output it from OutputDataPort.    Set field Create a script to set the field's value.\nComponent created\nActionComponent\nTween field Create a script that gradually interpolates the value of a field until it reaches a specified value.\nOnly tweenable types can be generated.\nComponent created\nTaskComponent\nGet property Create a script to get the property's value.\nComponent created\nThe component created varies depending on the property type.\n   Property type Component created Description     bool type EvaluateComponent Create a script that returns a value as the evaluation result.   delegate type EventComponent Create a script that waits for the event to be called. Outputs the argument value received when the event is called from OutputDataPort.   UnityEvent type EventComponent Create a script that waits for the event to be called. Outputs the argument value received when the event is called from OutputDataPort.   Miscellaneous ActionComponent Create a component that retrieves a value and outputs it from the OutputDataPort.    Set property Create a script to set the property's value.\nComponent created\nActionComponent\nTween property Create a script that gradually interpolates the value of a property until it reaches a specified value. Only tweenable types can be generated.\nComponent created\nTaskComponent\nWaiting for the event Create a script that waits for an event to be called.\nOutputs the argument value received when the event is called from OutputDataPort.\nComponent created\nEventComponent\nInvoke method Create a script that invokes the method.\nComponent created\nThe component created depends on the return type.\n   Return Type Component Created Description     bool type EvaluateComponent Create a script that returns the return value as the evaluation result.   Asynchronous (awaitable type or async) method TaskComponent Create a script that waits until completion.   AsyncOperation TaskComponent Create a script that waits until it completes.   Miscellaneous ActionComponent Create a script that invokes the method.    If the method argument is out or ref, the result of the argument will also be output from OutputDataPort after execution.\nHow to create You can create a script to access members in the following ways:\nNode/Component selection menu  Open the graph view node creation menu and component selection menu Select the Members tab. Search by name of the member you want to access. Select the members you want to access. (If using the node creation menu, select the type of node to create.)  If you have already generated a script to access the selected member, use the existing script.\nIf it has not been generated yet, generation processing and compilation will be performed, and after completion, nodes will be created, etc.\nAlready generated scripts are also displayed in the Scripts tab.\nLogic Script Generator window You can create multiple scripts in advance in the Logic Script Generator window.\n Select Logic Toolkit \u0026gt; Logic Script Generator from the menu to open the Logic Script Generator window. Click the \u0026ldquo;+\u0026rdquo; button on the left pane. Check the members you want to add from the tree. Click the \u0026ldquo;Add\u0026rdquo; button in the add menu. Return to the Logic Script Generator window and click the \u0026ldquo;Apply\u0026rdquo; button at the bottom of the left pane.  For details, see Logic Script Generator Window.\nImportant point Access information for members is managed using type names, member names, etc. If you change or delete members of a generated script later, a compilation error will occur. Open the \u0026ldquo;Logic Script Generator window\u0026rdquo; and modify or delete the relevant script.\nIf you change the type name, the migration will be done automatically by applying MovedFromAttribute.\n"
    },
    {
        "uri": "/manual/architecture/nodecomponents/actioncomponent.html",
        "title": "ActionComponent",
        "tags": [],
        "description": "",
        "summary": "This is a node component that performs processing that can be completed in an instant.\nIt is used for calling members, calculating data, etc.\nBehavior when set to node Action Action\nThe process is executed when the node becomes active.\nCompute Compute\nProcessing is executed when data output is required. Only ActionComponents with output DataPorts can be used.\nBehaviorTree BehaviorTree\nPerforms processing when a node becomes active and immediately returns results to the parent node.",
        "content": "This is a node component that performs processing that can be completed in an instant.\nIt is used for calling members, calculating data, etc.\nBehavior when set to node Action Action\nThe process is executed when the node becomes active.\nCompute Compute\nProcessing is executed when data output is required. Only ActionComponents with output DataPorts can be used.\nBehaviorTree BehaviorTree\nPerforms processing when a node becomes active and immediately returns results to the parent node.\nAdditional properties\n   Property name Type Description     Result InputField\u0026lt;bool\u0026gt; Specifies the result to return to the parent node.    Services The process is executed when the node becomes active.\nAdditional properties\n   Property name Type Description     Methods CallMethods Specifies the methods to run. NothingDo not runOnActivatedRun only once when activated. OnUpdateExecute every frame. OnDeactivatedRun only once when deactivated.     State State\nThe process is executed when the node becomes active.\nAdditional properties\n   Property name Type Description     Methods CallMethods Specifies the methods to run. NothingDo not runOnActivateRun only once when activated. OnUpdateExecute every frame. OnDeactivatedRun only once when deactivated.     Script generation Due to the script generation function, ActionComponent is used for the following member access scripts.\n Get field value Set field value Get property value Set property value method call  It may be other than ActionComponent depending on the field type etc.\nFor details, please refer to Script generation.\n"
    },
    {
        "uri": "/manual/scripting/nodecomponents/actioncomponent.html",
        "title": "ActionComponent",
        "tags": [],
        "description": "",
        "summary": "ActionComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Action Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.ActionComponent. Apply System.SerializableAttribute to the type. Implement protected override void OnAction() and write the processing at runtime.",
        "content": "ActionComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Action Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.ActionComponent. Apply System.SerializableAttribute to the type. Implement protected override void OnAction() and write the processing at runtime.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class ActionExample : ActionComponent\r{\r// OnAction is called when the node is executed.\r protected override void OnAction()\r{\rDebug.Log(\u0026#34;Hello, world!\u0026#34;);\r}\r}\r  When executed, this example prints Hello, world! to the Console.\nIn addition, a script called Debug.Log is already included as a similar function.\n"
    },
    {
        "uri": "/manual/architecture.html",
        "title": "Architecture",
        "tags": [],
        "description": "",
        "summary": "Explains architecture in Logic Toolkit.\n Node graph Logic Controller Object Node Node Component Port Wire InputField Blackboard DataLink  ",
        "content": "Explains architecture in Logic Toolkit.\n Node graph Logic Controller Object Node Node Component Port Wire InputField Blackboard DataLink  "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/branchnode.html",
        "title": "Branch",
        "tags": [],
        "description": "",
        "summary": "The transition destination is branched depending on the value of the Condition field.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Condition InputField\u0026lt;bool\u0026gt; Set the truth value to judge.   True OutputTransitionPort Transition when Condition is true.   False OutputTransitionPort Transition when Condition is false.    ",
        "content": "The transition destination is branched depending on the value of the Condition field.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Condition InputField\u0026lt;bool\u0026gt; Set the truth value to judge.   True OutputTransitionPort Transition when Condition is true.   False OutputTransitionPort Transition when Condition is false.    "
    },
    {
        "uri": "/manual/architecture/nodes/organizes/commentnode.html",
        "title": "Comment",
        "tags": [],
        "description": "",
        "summary": "A node that allows you to leave comments on the graph.\nShortcuts    Contents How to operate     Create Move the mouse cursor to the position you want to create on the graph and press C key    ",
        "content": "A node that allows you to leave comments on the graph.\nShortcuts    Contents How to operate     Create Move the mouse cursor to the position you want to create on the graph and press C key    "
    },
    {
        "uri": "/manual/scripting/dataflow.html",
        "title": "Data flow",
        "tags": [],
        "description": "",
        "summary": "This section explains how to write code related to data flow.\nData input/output To input data values, use InputDataPort\u0026lt;T\u0026gt;. To output data values, use OutputDataPort\u0026lt;T\u0026gt;.\nHow to write a script  Declare the element where you want to input data as a public or InputDataPort\u0026lt;T\u0026gt; type field with UnityEngine.SerializeField applied. Declare the element that you want to output data as a public or OutputDataPort\u0026lt;T\u0026gt; type field with UnityEngine.SerializeField applied. Enter data using InputDataPort\u0026lt;T\u0026gt;.",
        "content": "This section explains how to write code related to data flow.\nData input/output To input data values, use InputDataPort\u0026lt;T\u0026gt;. To output data values, use OutputDataPort\u0026lt;T\u0026gt;.\nHow to write a script  Declare the element where you want to input data as a public or InputDataPort\u0026lt;T\u0026gt; type field with UnityEngine.SerializeField applied. Declare the element that you want to output data as a public or OutputDataPort\u0026lt;T\u0026gt; type field with UnityEngine.SerializeField applied. Enter data using InputDataPort\u0026lt;T\u0026gt;.GetValue(). Output the data using OutputDataPort\u0026lt;T\u0026gt;.SetValue(T value).  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class DataFlowExample : ActionComponent\r{\rpublic InputDataPort\u0026lt;int\u0026gt; min;\rpublic InputDataPort\u0026lt;int\u0026gt; max;\rpublic OutputDataPort\u0026lt;int\u0026gt; output;\r// OnAction is called when the node is executed.\r protected override void OnAction()\r{\rvar minValue = min.GetValue();\rvar maxValue = max.GetValue();\rvar result = Random.Range(minValue, maxValue);\routput.SetValue(result);\r}\r}\r  This example prints a random integer value between the value received on the min port and the value received on the max port minus 1 each time the action is executed.\nA similar script can be created by selecting Random.Range(int, int) when generating the script.\nInputField For data input, InputField also allows you to set fixed values directly in fields within nodes.\nHow to write a script  Declare a field of type InputField\u0026lt;T\u0026gt; that is either public or has UnityEngine.SerializeField applied to it. Enter data using InputField\u0026lt;T\u0026gt;.value.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class InputFieldExample : ActionComponent\r{\rpublic InputField\u0026lt;int\u0026gt; min;\rpublic InputField\u0026lt;int\u0026gt; max;\rpublic OutputDataPort\u0026lt;int\u0026gt; output;\r// OnAction is called when the node is executed.\r protected override void OnAction()\r{\rvar minValue = min.value;\rvar maxValue = max.value;\rvar result = Random.Range(minValue, maxValue);\routput.SetValue(result);\r}\r}\r  This is an example of replacing the previous example with InputField.\nFor the min and max fields, you can choose to set them to fixed values or receive them from the input port.\nInputField types  InputField\u0026lt;T\u0026gt;\nThis is a normal input field.\nYou can choose to set a fixed value or receive it from InputDataPort\u0026lt;T\u0026gt;. InputGameObject\nThis is an input field for GameObject.\nIn addition to fixed values and InputDataPort\u0026lt;GameObject\u0026gt;, there is also a Self setting that retrieves the GameObject that is running its own graph. InputComponent\u0026lt;T\u0026gt;\nComponent input field.\nIn addition to fixed values and InputDataPort\u0026lt;T\u0026gt;, there is also a Self setting to get the component of the GameObject that is running its own graph, and a GameObject setting to get the component from the specified GameObject. InputQuaternion\nQuaternion input field.\nIn addition to fixed values and InputDataPort\u0026lt;Quaternion\u0026gt;, there is also the Euler setting to obtain a quaternion by specifying the Euler angle. InputSystemType\nThis is an input field for System.Type.\nIt supports fixed value setting of System.Type by internally serializing the type name.  "
    },
    {
        "uri": "/manual/architecture/nodes/converts/explicitnumericconvertnode.html",
        "title": "ExplicitNumericConvert",
        "tags": [],
        "description": "",
        "summary": "Performs explicit type conversion of numeric types.\nConversion conditions Compliant with C# specifications.\nFor more information, see Explicit numeric conversions.",
        "content": "Performs explicit type conversion of numeric types.\nConversion conditions Compliant with C# specifications.\nFor more information, see Explicit numeric conversions.\n"
    },
    {
        "uri": "/manual/architecture/nodes/functions/functionreturnnode.html",
        "title": "Function Return",
        "tags": [],
        "description": "",
        "summary": "A node that ends the execution of the function graph and returns to the execution of the parent graph.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Parameter list List of parameters to input Receives parameters and returns them to the parent graph. The setting items for each parameter are as follows. NameData typeInputDataPort    ",
        "content": "A node that ends the execution of the function graph and returns to the execution of the parent graph.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Parameter list List of parameters to input Receives parameters and returns them to the parent graph. The setting items for each parameter are as follows. NameData typeInputDataPort    "
    },
    {
        "uri": "/manual/getting-started/install.html",
        "title": "Installation steps",
        "tags": [],
        "description": "",
        "summary": "Purchase assets To use it, you need to purchase the asset.\nPlease open the asset store from the link below and purchase with the account you want to use.\n\rSystem requirements  Logic Toolkit requires Unity 2023.2 or later. Please check Unity system requirements for details.  Create project If there is no Unity project you want to install, please create a new project.\nFor information on how to create a project, see Add and remove projects in the Unity Hub.",
        "content": "Purchase assets To use it, you need to purchase the asset.\nPlease open the asset store from the link below and purchase with the account you want to use.\n\rSystem requirements  Logic Toolkit requires Unity 2023.2 or later. Please check Unity system requirements for details.  Create project If there is no Unity project you want to install, please create a new project.\nFor information on how to create a project, see Add and remove projects in the Unity Hub.\nImport To deploy assets, import them using Package Manager.\n Select Window \u0026gt; Package Manager from the menu. Select My Assets on the left side of the Package Manager window. Enter Logic Toolkit in \u0026ldquo;Search My Assets\u0026rdquo; and search. Select Logic Toolkit displayed in the list. Click the \u0026ldquo;Download\u0026rdquo; button to the right of the asset name in the details column. Click the \u0026ldquo;Import version number to project\u0026rdquo; button to the right of the asset name in the details column. Click the \u0026ldquo;All\u0026rdquo; button in the \u0026ldquo;Import Unity Package\u0026rdquo; window to select everything. Click the \u0026ldquo;Import\u0026rdquo; button.  "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Interfaces.html",
        "title": "Interfaces",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     IAbortReceiver Receive execution abort of BehaviorTree node. By implementing it in the main component or Decorator, the IAbortReceiver.OnAbort() method will be called when execution is aborted.    ",
        "content": "   Type Name Description     IAbortReceiver Receive execution abort of BehaviorTree node. By implementing it in the main component or Decorator, the IAbortReceiver.OnAbort() method will be called when execution is aborted.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces.html",
        "title": "Interfaces",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     IBindItem Interface received when binding item to VisualElement   IConnectPortToComponentContext The interface that connects to the port being dragged when the node component is created.   ITypeMenuContext Interface called when creating a node component from the type selection menu   IDataPortConnector Interface that defines data port connections    ",
        "content": "   Type Name Description     IBindItem Interface received when binding item to VisualElement   IConnectPortToComponentContext The interface that connects to the port being dragged when the node component is created.   ITypeMenuContext Interface called when creating a node component from the type selection menu   IDataPortConnector Interface that defines data port connections    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces.html",
        "title": "Interfaces",
        "tags": [],
        "description": "",
        "summary": "Type Name Description     ICheckRecompute Interface to determine whether recomputation is necessary\nBy implementing it in ActionComponent, you can determine whether to perform recomputation when using it with a Compute node.   IInputDataPortBase Input data port basic interface   IInputDataPort Input data port interface   IOutputDataPort Output data port basic interface   IProgressComponent Interface for displaying progress bar on NodeComponent   IInputPort Interface that defines the input port   IOutputPort Interface that defines the output port   IPauseReceiver Interface to receive graph pauses   IUpdateReceiver Interface that receives update calls   IEasingFunction Interface that defines easing functions   IValueContainer Interface that defines a container for values   IValueContainer\u0026lt;T\u0026gt; Generic type interface that defines a container for values   IValueGetter Interface that defines the types whose values can be retrieved   IValueGetter\u0026lt;T\u0026gt; Generic type interface that defines types whose values can be retrieved   IValueSetter Interface that defines a type whose value can be set   IValueSetter\u0026lt;T\u0026gt; Generic type interface that defines a settable type   IValueTryGetter Interface that defines the type whose value is attempted to be retrieved   IValueTrySetter Interface that defines the type that attempts to set the value.",
        "content": "   Type Name Description     ICheckRecompute Interface to determine whether recomputation is necessary\nBy implementing it in ActionComponent, you can determine whether to perform recomputation when using it with a Compute node.   IInputDataPortBase Input data port basic interface   IInputDataPort Input data port interface   IOutputDataPort Output data port basic interface   IProgressComponent Interface for displaying progress bar on NodeComponent   IInputPort Interface that defines the input port   IOutputPort Interface that defines the output port   IPauseReceiver Interface to receive graph pauses   IUpdateReceiver Interface that receives update calls   IEasingFunction Interface that defines easing functions   IValueContainer Interface that defines a container for values   IValueContainer\u0026lt;T\u0026gt; Generic type interface that defines a container for values   IValueGetter Interface that defines the types whose values can be retrieved   IValueGetter\u0026lt;T\u0026gt; Generic type interface that defines types whose values can be retrieved   IValueSetter Interface that defines a type whose value can be set   IValueSetter\u0026lt;T\u0026gt; Generic type interface that defines a settable type   IValueTryGetter Interface that defines the type whose value is attempted to be retrieved   IValueTrySetter Interface that defines the type that attempts to set the value.   IListAccessor Interface that defines list access    "
    },
    {
        "uri": "/manual/scripting/nodecomponents/interfaces/iprogresscomponent.html",
        "title": "IProgressComponent",
        "tags": [],
        "description": "",
        "summary": "A progress bar can be displayed in the header of NodeComponent.\nHow to write a script  Implement LogicToolkit.IProgressComponent as a type that inherits various NodeComponents. Implement public LogicToolkit.ProgressPlayer ProgressPlayer{ get; }. Switch the display of the progress bar with the IsActive property of LogicToolkit.ProgressPlayer. Switch the progress bar progress (0 to 1) with the CurrentProgress property of LogicToolkit.ProgressPlayer.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38  using System.",
        "content": "A progress bar can be displayed in the header of NodeComponent.\nHow to write a script  Implement LogicToolkit.IProgressComponent as a type that inherits various NodeComponents. Implement public LogicToolkit.ProgressPlayer ProgressPlayer{ get; }. Switch the display of the progress bar with the IsActive property of LogicToolkit.ProgressPlayer. Switch the progress bar progress (0 to 1) with the CurrentProgress property of LogicToolkit.ProgressPlayer.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class ProgressExample : TaskComponent, IProgressComponent\r{\rprivate ProgressPlayer progressPlayer = new ProgressPlayer();\rpublic ProgressPlayer ProgressPlayer =\u0026gt; progressPlayer;\rprivate float startTime;\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\rprogressPlayer.IsActive = true;\rprogressPlayer.CurrentProgress = 0f;\rstartTime = Time.time;\r}\r// OnExecute is called when it is executed.\r protected override TaskStatus OnExecute()\r{\rfloat progress = Time.time - startTime / 1f;\rprogressPlayer.CurrentProgress = progress;\r// Return Running, Success, or Failure depending on the task execution status.\r return progress \u0026gt;= 1f? TaskStatus.Success : TaskStatus.Running;\r}\r// OnDeactivated is called when it is deactivated.\r protected override void OnDeactivated()\r{\rprogressPlayer.IsActive = false;\r}\r}\r  In this example, the progress of the TaskComponent while it is waiting for 1 second is displayed as a progress bar in the NodeComponent header.\nIn addition, a script called Wait For Seconds is included in advance as a similar function.\n"
    },
    {
        "uri": "/manual/architecture/logiccontroller.html",
        "title": "Logic Controller",
        "tags": [],
        "description": "",
        "summary": "Logic Controller is the main functionality for controlling behavior.\nIt is built into Logic Behavior and Logic Asset, and is used to create node graphs. Used for editing and execution.\nLogic Controller is made up of the following set of components:\n Logic Graph\nThis is the main graph for controlling behavior. List of Function graphs\nIt is a graph that groups common functions together, like programming functions, and can be shared and used from multiple locations.",
        "content": "Logic Controller is the main functionality for controlling behavior.\nIt is built into Logic Behavior and Logic Asset, and is used to create node graphs. Used for editing and execution.\nLogic Controller is made up of the following set of components:\n Logic Graph\nThis is the main graph for controlling behavior. List of Function graphs\nIt is a graph that groups common functions together, like programming functions, and can be shared and used from multiple locations. Blackboard(Root)\nIt can be accessed from the list of Logic Graph and Function Graph You can manage variables. DataLink\nThis is a function to share Blackboard between multiple GameObjects.  "
    },
    {
        "uri": "/manual/architecture/objects/logicplayer.html",
        "title": "Logic Player",
        "tags": [],
        "description": "",
        "summary": "A component for playing Logic Asset.\nHow to add Add to existing GameObject  Select the GameObject you want to add in the Hierarchy window. Click the \u0026ldquo;Add Component\u0026rdquo; button in the Inspector window. Select Logic Toolkit \u0026gt; Logic Player from the menu.  Creating GameObject with Logic Player  Click the \u0026ldquo;+\u0026rdquo; button in the Hierarchy window. Select Logic Toolkit \u0026gt; Logic Player from the menu. The GameObject will enter name input mode, so enter the name.",
        "content": "A component for playing Logic Asset.\nHow to add Add to existing GameObject  Select the GameObject you want to add in the Hierarchy window. Click the \u0026ldquo;Add Component\u0026rdquo; button in the Inspector window. Select Logic Toolkit \u0026gt; Logic Player from the menu.  Creating GameObject with Logic Player  Click the \u0026ldquo;+\u0026rdquo; button in the Hierarchy window. Select Logic Toolkit \u0026gt; Logic Player from the menu. The GameObject will enter name input mode, so enter the name. Confirm with Enter key.  Properties    Properties Description     Play On Awake Start playing when GameObject is Awake   Debug Graph Settings Graph debug settings   Asset Play Logic Asset    "
    },
    {
        "uri": "/manual/windows/generator.html",
        "title": "Logic Script Generator window",
        "tags": [],
        "description": "",
        "summary": "This window is for generating scripts that perform simple processing such as method calls and property input/output.\nHow to open You can open it using one of the following methods.\n Select Window \u0026gt; Logic Toolkit \u0026gt; Logic Script Generator from the menu. Click the \u0026ldquo;⋮\u0026rdquo; button on the toolbar of Logic Editor and select Logic Script Generator from the menu.  Method of operation Add script  Click the \u0026ldquo;+\u0026rdquo; button on the toolbar.",
        "content": "This window is for generating scripts that perform simple processing such as method calls and property input/output.\nHow to open You can open it using one of the following methods.\n Select Window \u0026gt; Logic Toolkit \u0026gt; Logic Script Generator from the menu. Click the \u0026ldquo;⋮\u0026rdquo; button on the toolbar of Logic Editor and select Logic Script Generator from the menu.  Method of operation Add script  Click the \u0026ldquo;+\u0026rdquo; button on the toolbar. Select the script to add from the menu. *Click the \u0026ldquo;Add\u0026rdquo; button in the footer.  Script settings  Select script from list. Set in details field  Delete script  Uncheck the scripts you want to remove from the list.  Applying the script Additions, settings, and deletions will be reflected in the generated results by applying them.\n Click the \u0026ldquo;Apply\u0026rdquo; button in the footer.  Revert settings  Click the \u0026ldquo;Revert\u0026rdquo; button in the footer.  Script type Get properties/fields Generates an ActionComponent script that retrieves C# type properties and fields and outputs them to the DataPort.\nSetting    Setting items Description     Dont Use Compute Applies an attribute that should not be used on a Compute node.   Recompute Mode Settings Specify how to set the recompute mode when you want to use it with the Compute node. AutoIf it is a value type, fix it to Dirty.If it is a GameObject or Component, set the initial value to Frame. DefaultSet the initial value when creating the Compute node. FixedSet fixed recalculation mode   Recompute Mode If Recompute Mode Settings is Default or Fixed, specify the Recompute Mode to be set. DirtyRecalculate when the data received by the input port has been updatedFramePreviously calculated frame and current frame Recalculate if different NodeRecalculate if the destination node of the output port is differentComponentOutput port Recalculate when the connected node component is differentAlwaysAlways recalculate    Setting properties/fields Generates an ActionComponent script that sets the value received from InputField to a C# type property or field. If the type is a value type, outputs the result of the setting word to the DataPort.\nSetting Items are displayed only if the type is a value type.\n   Setting items Description     Dont Use Compute Applies an attribute that should not be used on a Compute node.   Recompute Mode Settings Specify how to set the recompute mode when you want to use it with the Compute node. AutoIf it is a value type, fix it to Dirty.If it is a GameObject or Component, set the initial value to Frame. DefaultSet the initial value when creating the Compute node. FixedSet fixed recalculation mode   Recompute Mode If Recompute Mode Settings is Default or Fixed, specify the Recompute Mode to be set. DirtyRecalculate when the data received by the input port has been updatedFramePreviously calculated frame and current frame Recalculate if different NodeRecalculate if the destination node of the output port is differentComponentOutput port Recalculate when the connected node component is differentAlwaysAlways recalculate    Invoke methods Generates an ActionComponent script that calls a C# type method. If there is a return value, out, or ref argument, output the value to the DataPort after the call.\nSetting The item is only visible if there is an output DataPort.\n   Setting items Description     Dont Use Compute Applies an attribute that should not be used on a Compute node.   Recompute Mode Settings Specify how to set the recompute mode when you want to use it with the Compute node. AutoIf it is a value type, fix it to Dirty.If it is a GameObject or Component, set the initial value to Frame. DefaultSet the initial value when creating the Compute node. FixedSet fixed recalculation mode   Recompute Mode If Recompute Mode Settings is Default or Fixed, specify the Recompute Mode to be set. DirtyRecalculate when the data received by the input port has been updatedFramePreviously calculated frame and current frame Recalculate if different NodeRecalculate if the destination node of the output port is differentComponentOutput port Recalculate when the connected node component is differentAlwaysAlways recalculate    Waiting for events Set fields and events of delegate type, and generate an EventComponent script that handles the event when called.\nTween Generates a TweenComponent script that gradually changes the properties and fields of a class.\n"
    },
    {
        "uri": "/manual/architecture/nodecomponents/decorator/loopcheckdecorator.html",
        "title": "LoopCheckDecorator",
        "tags": [],
        "description": "",
        "summary": "A Decorator that controls whether the node repeats when it completes.",
        "content": "A Decorator that controls whether the node repeats when it completes.\n"
    },
    {
        "uri": "/manual/scripting/nodecomponents/decorator/loopcheckdecorator.html",
        "title": "LoopCheckDecorator",
        "tags": [],
        "description": "",
        "summary": "LoopCheckDecorator can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Decorator \u0026gt; Loop Check Decorator C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.BehaviorTree.LoopCheckDecorator. Apply System.SerializableAttribute to the type. Implement protected override bool OnNext() and write the processing at runtime.",
        "content": "LoopCheckDecorator can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Decorator \u0026gt; Loop Check Decorator C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.BehaviorTree.LoopCheckDecorator. Apply System.SerializableAttribute to the type. Implement protected override bool OnNext() and write the processing at runtime. protected override void OnActivated() is called when activated. protected override void OnDeactivated() is called when it becomes inactive.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\rusing LogicToolkit.BehaviorTrees;\r[System.Serializable]\rpublic class LoopCheckDecoratorExample : LoopCheckDecorator\r{\rprivate int count;\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\rcount = 0;\r}\r// Called when the node finishes executing\r protected override bool OnNext()\r{\rcount++;\r// Returns true if the node is executed repeatedly\r return count \u0026lt; 10;\r}\r// OnDeactivated is called when it is deactivated.\r protected override void OnDeactivated()\r{\r}\r}\r  This example repeats the node up to 10 times.\nIn addition, a script called LoopCount is included in advance as a similar function.\n"
    },
    {
        "uri": "/manual/windows/logiceditor/sidepanel/nodes.html",
        "title": "Nodes tab",
        "tags": [],
        "description": "",
        "summary": "This section describes the Nodes tab in the side panel.\nNode list A list of currently selected nodes will be displayed.\nMethod of operation Node selection When you select from the Nodes list, it will scroll to the position of the selected node in conjunction with the selection state of the node in the graph view.\n Click a node from the list.  If you select while holding down Ctrl (Win)/Command ⌘ (Mac), you can add/cancel selected nodes individually.",
        "content": "This section describes the Nodes tab in the side panel.\nNode list A list of currently selected nodes will be displayed.\nMethod of operation Node selection When you select from the Nodes list, it will scroll to the position of the selected node in conjunction with the selection state of the node in the graph view.\n Click a node from the list.  If you select while holding down Ctrl (Win)/Command ⌘ (Mac), you can add/cancel selected nodes individually. You can select all at once by holding down Shift while selecting.    Change node name  Start name input mode\nPlease use one of the following methods to enter input mode.  Right-click the node and select Rename from the menu Click on a node to make it active, then click again Select a node and press F2 key (Win)/Enter key (Mac)   Enter your name Confirm with Enter key  Cutting a node You can cut it using one of the following methods.\n Right-click the node and select Cut from the menu Select the node and press Ctrl + X key (Win)/command ⌘ + X key (Mac)  Copy node You can copy using one of the following methods.\n Right-click the node and select Copy from the menu Select the node and press Ctrl + C (Win)/command ⌘ + C (Mac)  Paste Node You can paste it using one of the following methods.\n Right-click the node and select Paste from the menu Select the node and press Ctrl + V key (Win)/command ⌘ + V key (Mac)  Delete node You can delete it using one of the following methods:\n Right-click the node and select Delete from the menu Select the node and press Delete key  "
    },
    {
        "uri": "/manual/architecture/ports/outputtransitionport.html",
        "title": "OutputTransitionPort",
        "tags": [],
        "description": "",
        "summary": "This is an output port for transitioning to the connection destination node.\nConnectable wires  TransitionWire\nTransit to the connection destination node.  ",
        "content": "This is an output port for transitioning to the connection destination node.\nConnectable wires  TransitionWire\nTransit to the connection destination node.  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/composites/selector.html",
        "title": "Selector",
        "tags": [],
        "description": "",
        "summary": "Executes child nodes in order from top to bottom. Execution ends when any child node returns success.\nBehavior based on child node results    Results Behavior     Success Finishes execution and the Selector itself also returns success.   Fail Execute next child node. If there is no next child node, execution ends and the Selector itself returns failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results.",
        "content": "Executes child nodes in order from top to bottom. Execution ends when any child node returns success.\nBehavior based on child node results    Results Behavior     Success Finishes execution and the Selector itself also returns success.   Fail Execute next child node. If there is no next child node, execution ends and the Selector itself returns failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results. You can connect multiple child nodes. Child nodes are executed from top to bottom.    "
    },
    {
        "uri": "/manual/architecture/nodes/signals/signalbranchnode.html",
        "title": "Signal Branch",
        "tags": [],
        "description": "",
        "summary": "This is a node that branches the output signal depending on the input signal.\nProperties    Property name Type Description     Input port InputSignalPort Receives a signal.   On OutputSignalPort Outputs an on signal when the input port signal is on.   Off OutputSignalPort Outputs an on signal when the input port signal is off.    ",
        "content": "This is a node that branches the output signal depending on the input signal.\nProperties    Property name Type Description     Input port InputSignalPort Receives a signal.   On OutputSignalPort Outputs an on signal when the input port signal is on.   Off OutputSignalPort Outputs an on signal when the input port signal is off.    "
    },
    {
        "uri": "/manual/architecture/nodes/tasknode.html",
        "title": "Task",
        "tags": [],
        "description": "",
        "summary": "A Task is a node that performs continuous processing and transitions after completion.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Output port OutputTransitionPort Transitions to the destination node when the node component completes    Supported node components  TaskComponent\nIt starts executing when it becomes active, and transitions to the connection destination port when the TaskComponent completes execution.",
        "content": "A Task is a node that performs continuous processing and transitions after completion.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Output port OutputTransitionPort Transitions to the destination node when the node component completes    Supported node components  TaskComponent\nIt starts executing when it becomes active, and transitions to the connection destination port when the TaskComponent completes execution. EventComponent\nTransitions to the destination node when an event occurs. EvaluateComponnet\nProcessing is performed every frame while the node is active. There are settings that allow you to change the task execution state depending on the results.  "
    },
    {
        "uri": "/manual/architecture/graphs/taskgraph.html",
        "title": "Task Graph",
        "tags": [],
        "description": "",
        "summary": "Task Graph is a function graph for collectively sharing continuously executed processes.\nTask Graph allows you to perform asynchronous processing (that is, processing that does not complete immediately).\nIt can be used to receive parameters from the caller, perform some processing asynchronously, and then return the execution results to the caller.\nHot to create Function graph within Logic Controller  Logic Behavior and Logic Asset in the Logic Editor window. Select the Graphs tab in the side panel.",
        "content": "Task Graph is a function graph for collectively sharing continuously executed processes.\nTask Graph allows you to perform asynchronous processing (that is, processing that does not complete immediately).\nIt can be used to receive parameters from the caller, perform some processing asynchronously, and then return the execution results to the caller.\nHot to create Function graph within Logic Controller  Logic Behavior and Logic Asset in the Logic Editor window. Select the Graphs tab in the side panel. Click the \u0026ldquo;+\u0026rdquo; button in the Functions column. Select Task Graph from the menu. You will be in name input mode, so enter your name. Confirm with Enter key  Task Graph Asset For details, see Task Graph Asset.\nAvailable nodes The nodes available in Task Graph are as follows.\n Action Task State BehaviorTree Function graph nodes Flow control nodes Signal nodes Data calculation nodes Data conversion nodes Graph organizing nodes  "
    },
    {
        "uri": "/manual/architecture/wires/transitionwire.html",
        "title": "TransitionWire",
        "tags": [],
        "description": "",
        "summary": "This is a wire for transitioning running nodes.\nCompatible with Reroute.\nCombinations of ports that can be connected    Output port Input port     OutputSignalPort InputExecutePort   OutputTransitionPort InputExecutePort    ",
        "content": "This is a wire for transitioning running nodes.\nCompatible with Reroute.\nCombinations of ports that can be connected    Output port Input port     OutputSignalPort InputExecutePort   OutputTransitionPort InputExecutePort    "
    },
    {
        "uri": "/manual/architecture/nodes/events/updatenode.html",
        "title": "Update",
        "tags": [],
        "description": "",
        "summary": "Update is the node called by the MonoBehaviour's Update message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    ",
        "content": "Update is the node called by the MonoBehaviour's Update message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    "
    },
    {
        "uri": "/manual/getting-started/workflow.html",
        "title": "Basic workflow",
        "tags": [],
        "description": "",
        "summary": "This section describes a basic workflow using Logic Toolkit.\nLogic Behavior To use Logic Toolkit, you need to add Logic Behavior to your GameObject.\nHow to create a Logic Behavior Here, we will introduce how to create a new GameObject with Logic Behavior.\n Click the \u0026ldquo;+\u0026rdquo; button in the Hierachy window. Select Logic Toolkit \u0026gt; Logic Behavior from the menu. A GameObject named \u0026ldquo;Logic Behavior\u0026rdquo; is created.  Displaying the Logic Editor window To edit the graph, you need to open the Logic Editor window.",
        "content": "This section describes a basic workflow using Logic Toolkit.\nLogic Behavior To use Logic Toolkit, you need to add Logic Behavior to your GameObject.\nHow to create a Logic Behavior Here, we will introduce how to create a new GameObject with Logic Behavior.\n Click the \u0026ldquo;+\u0026rdquo; button in the Hierachy window. Select Logic Toolkit \u0026gt; Logic Behavior from the menu. A GameObject named \u0026ldquo;Logic Behavior\u0026rdquo; is created.  Displaying the Logic Editor window To edit the graph, you need to open the Logic Editor window.\nHere we will show you how to open it from Logic Behavior in the Inspector window.\n In the Hierarchy window, select \u0026ldquo;Logic Behavior\u0026rdquo; that you created earlier. Click the \u0026ldquo;Edit\u0026rdquo; button in Logic Behavior in the Inspector window. The Logic Editor window is displayed and Logic Behavior is selected.  Logic Editor window UI For details, see Logic Editor Window.\nSide panel You can edit graphs, node lists, etc.\nGraph view You can edit the currently selected graph.\nEdit graph Let's edit the main graph of the currently selected Logic Behavior.\nCreating a Task node Let's place task nodes that perform processing on the graph.\nHere, we will create Wait For Seconds that waits for a specified number of seconds.\n Left-click on the graph view to focus it. Press the Spacebar on your keyboard (default shortcut setting). Select Tasks \u0026gt; Wait For Seconds from the node menu. The node will be created and you will be able to edit the node name, so press the Enter key to complete the renaming.  *Here, we will leave the node name as the default for the sake of explanation, but we recommend setting it appropriately when performing full-scale development.\nNode UI We will explain the node UI using the created \u0026ldquo;Task\u0026rdquo; node as an example.\nHeader section The node name and major input/output ports are displayed.\nNode component Node processing is controlled by scripts called node components.\nThis time, a component script called Wait For Seconds is assigned.\nEditing a node component Wait For Seconds has several fields and ports.\nThis time, let's set the Seconds field to 1.\n Click the input field of the Seconds field in Wait For Seconds of the Task node. Enter 1.  Connecting nodes Connect nodes by dragging the ports displayed around the nodes.\n Drag the output port on the right side of the Start node that is placed from the beginning Drop it onto the input port on the left side of the Task node you created earlier.  ExecuteWire The output port on the right side of the Start node and the Task node were connected by ExecuteWire.\nThis ExecuteWire means the wire (wire connecting ports) for executing the connected node.\nIn this case, the Start node will first execute the Task node, which is the node to which it is connected with ExecuteWire.\nSee ExecuteWire for details.\nCreating an Action node Let's execute an action after waiting is completed with Wait For Seconds.\nHere we will use an action component script called Debug.Log which outputs debugging output.\n Drag the output port to the right of the Completed field of Wait For Seconds Move the mouse cursor to the right from there and drop it somewhere on the graph Select Actions \u0026gt; Debug \u0026gt; Debug.Log from the node menu that appears The node will be created and you will be able to edit the node name, so press the Enter key to complete the renaming.  In this way, if you drag a port and drop it on an empty spot on the graph, a menu of nodes that can be connected to the port being dragged will be displayed, and the port will be connected when the node is created.\nTransitionWire The Task node and Action node were connected by TransitionWire. TransitionWire means a wire (a line connecting ports) for transitioning execution nodes. In this case, when the Task node's Wait For Seconds is completed, it will transition to the Action node, which is the node to which the Completed port is connected.\nSee TransitionWire for details.\nAbout the executor There are two types of wires that have appeared so far, but the one that performs the node execution process is the connection of ExecuteWire. It is being done.\nIf the node (executor) on the output port side of ExecuteWire becomes inactive, the execution of the connected node will also be disabled. Stop.\nSetting Debug.Log Let's temporarily display the message \u0026ldquo;Complete!\u0026quot;.\n Click the input field of the Message field in Debug.Log of the Action node. Type Complete!  Play to see if it works Once you have configured this, let's play and see how it works.\n Messages in Debug.Log are displayed in the Console window.\nIf it is not open, select \u0026ldquo;Window \u0026gt; General \u0026gt; Console\u0026rdquo; from the menu. Click the play button at the top of Unity  Take a look at the Logic Editor window while you play. The active nodes are highlighted with a blue frame, so you can visually check which nodes are in operation. When the Action node's Debug.Log is executed, \u0026ldquo;Complete!\u0026rdquo; will be displayed in the Console window. After that, the only active node is the Start node, and nothing changes after that.\nRepeat Now, let's wait 1 second and repeat the \u0026ldquo;Complete!\u0026rdquo; display.\nIt is also possible to connect the Action node's output port to the Task node's input port, but Here, we will use the convenient flow termination node Restart.\n Drag the output port of the Action node Move the mouse cursor to the right from there and drop it somewhere on the graph Select Flow Controls \u0026gt; Restart from the node menu  Flow exit node This Restart is called a flow termination node, and it is a node that notifies the executing port of the end of execution.\nIt is passed back to the executing node, and termination processing is performed by various nodes.\nThis time, Restart will be notified to the Start node.\nIf the Start node is notified of Restart, it will restart execution from the first node.\nPlay again Let's play again and see how it works.\n Messages in Debug.Log are displayed in the Console window.\nIf it is not open, select \u0026ldquo;Window \u0026gt; General \u0026gt; Console\u0026rdquo; from the menu. Click the play button at the top of Unity  \u0026ldquo;Complete!\u0026rdquo; is now displayed repeatedly at 1 second intervals.\nThis is the basic workflow.\n"
    },
    {
        "uri": "/manual/windows/logiceditor/sidepanel/blackboard.html",
        "title": "Blackboard tab",
        "tags": [],
        "description": "",
        "summary": "Describes the Blackboard tab in the side panel.\nFor more information about Blackboard, see Blackboard.\nThe displayed contents differ depending on the type of object selected.\n*For Logic Behavior and Logic Asset, it is divided into Root/Local/Data Link tabs. *For Function Graph Asset, only Local Blackboard is displayed.\nRoot tab A Blackboard that is directly associated with the object will be displayed.\nRoot Blackboard can be accessed from any graph within the same object.",
        "content": "Describes the Blackboard tab in the side panel.\nFor more information about Blackboard, see Blackboard.\nThe displayed contents differ depending on the type of object selected.\n*For Logic Behavior and Logic Asset, it is divided into Root/Local/Data Link tabs. *For Function Graph Asset, only Local Blackboard is displayed.\nRoot tab A Blackboard that is directly associated with the object will be displayed.\nRoot Blackboard can be accessed from any graph within the same object.\nLocal tab The Blackboard associated with the currently selected graph will be displayed.\nLocal Blackboard can only be accessed from the associated graph.\nData Link tab A list of DataLinks directly linked to the object will be displayed.\nFor details, see DataLink.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Enums.html",
        "title": "Enums",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     AbortFlags Abort flags    ",
        "content": "   Type Name Description     AbortFlags Abort flags    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums.html",
        "title": "Enums",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     PortType Port type   AssemblySources Assembly type flags   TypeFilters Type filter flags    ",
        "content": "   Type Name Description     PortType Port type   AssemblySources Assembly type flags   TypeFilters Type filter flags    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Enums.html",
        "title": "Enums",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     SignalExpiration Signal expiration time    ",
        "content": "   Type Name Description     SignalExpiration Signal expiration time    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums.html",
        "title": "Enums",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     MemberIconKind Member icon kind   BlackboardDataLinkShareType How to share the Blackboard instance referenced from BlackboardDataLinkReference   BlackboardSource Reference source of Blackboard   FieldPlacement Placement of fields   RecomputeMode Recomputation mode   TaskStatus Task status   PlayState Play status   TimerType Time Type   EasingMode Easing Mode   ComparisonOp Comparison operator    ",
        "content": "   Type Name Description     MemberIconKind Member icon kind   BlackboardDataLinkShareType How to share the Blackboard instance referenced from BlackboardDataLinkReference   BlackboardSource Reference source of Blackboard   FieldPlacement Placement of fields   RecomputeMode Recomputation mode   TaskStatus Task status   PlayState Play status   TimerType Time Type   EasingMode Easing Mode   ComparisonOp Comparison operator    "
    },
    {
        "uri": "/manual/architecture/graphs/evaluategraph.html",
        "title": "Evaluate Graph",
        "tags": [],
        "description": "",
        "summary": "Evaluate Graph is a function graph for collectively sharing processes that can be completed in an instant.\nEvaluate Graph can only perform synchronous (complete execution immediately) operations.\nIt can be used to receive parameters from the caller, perform some processing synchronously, and then return the execution results to the caller.\nHow to create Function graph within Logic Controller  Logic Behavior and Logic Asset in the Logic Editor window. Select the Graphs tab in the side panel.",
        "content": "Evaluate Graph is a function graph for collectively sharing processes that can be completed in an instant.\nEvaluate Graph can only perform synchronous (complete execution immediately) operations.\nIt can be used to receive parameters from the caller, perform some processing synchronously, and then return the execution results to the caller.\nHow to create Function graph within Logic Controller  Logic Behavior and Logic Asset in the Logic Editor window. Select the Graphs tab in the side panel. Click the \u0026ldquo;+\u0026rdquo; button in the Functions column. Select Evaluate Graph from the menu. You will be in name input mode, so enter your name. Confirm with Enter key  Evaluate Graph Asset For details, see Evaluate Graph Asset.\nAvailable nodes The nodes available in Evaluate Graph are as follows.\n Action Function graph nodes Flow control nodes Data calculation nodes Data conversion nodes Graph organizing nodes  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/evaluatecomponent.html",
        "title": "EvaluateComponent",
        "tags": [],
        "description": "",
        "summary": "A node component that performs conditional judgment.\nIt is used to determine state transitions and behavior tree execution.\nBehavior when set to node Action Action\nThe process is executed when the node becomes active.\nAdditional properties\n   Property name Type Description     Result OutputDataPort\u0026lt;bool\u0026gt; Outputs the judgment result in bool type.    Compute Compute\nProcessing is executed when data output is required.\nAdditional properties",
        "content": "A node component that performs conditional judgment.\nIt is used to determine state transitions and behavior tree execution.\nBehavior when set to node Action Action\nThe process is executed when the node becomes active.\nAdditional properties\n   Property name Type Description     Result OutputDataPort\u0026lt;bool\u0026gt; Outputs the judgment result in bool type.    Compute Compute\nProcessing is executed when data output is required.\nAdditional properties\n   Property name Type Description     Result OutputDataPort\u0026lt;bool\u0026gt; Outputs the judgment result in bool type.    Task Task\nProcessing is performed every frame while the node is active.\nAdditional properties\n   Property name Type Description     True Status InputField\u0026lt;TaskStatus\u0026gt; Set the execution status when the judgment result is true   False Status InputField\u0026lt;TaskStatus\u0026gt; Set the execution status when the judgment result is false    About TaskStatus\n   Contents Description     Running Continue running   Success Return Success   Failure Return failure    BehaviorTree BehaviorTree\nProcessing is performed every frame while the node is active.\nAdditional properties\n   Property name Type Description     True Status InputField\u0026lt;TaskStatus\u0026gt; Set the execution status when the judgment result is true   False Status InputField\u0026lt;TaskStatus\u0026gt; Set the execution status when the judgment result is false    About TaskStatus\n   Contents Description     Running Continue running   Success Return Success   Failure Return failure    Decorators Decorator will be judged.\nAdditional properties\n   Property name Type Description     Mode DecoratorMode Set the judgment content of Decorator. EvaluateNode execution judgmentLookCheckLoop judgment    There are additional properties that are added depending on the Mode selection.\nFor details, see EvaluateDecorator and LoopCheckDecorator.\nServices Processing is performed every frame while the node is active.\nAdditional properties\n   Property name Type Description     Result OutputDataPort\u0026lt;bool\u0026gt; Outputs the judgment result in bool type.    State State\nProcessing is performed every frame while the node is active.\nAdditional properties\n   Property name Type Description     Signal OutputSignalPort Outputs the judgment result as a signal.    Signal Evaluation Signal Evaluation\nIt becomes active when the judgment result of the input signal is true, and the judgment result is reflected in the output signal.\nScript generation Due to the script generation function, EvaluateComponent is used for the following member access scripts.\n Get the value of bool type field Get the value of bool type property Calling a method whose return value is bool  For details, please refer to Script generation.\n"
    },
    {
        "uri": "/manual/scripting/nodecomponents/evaluatecomponent.html",
        "title": "EvaluateComponent",
        "tags": [],
        "description": "",
        "summary": "EvaluateComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Evaluate Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.EvaluateComponent. Apply System.SerializableAttribute to the type. Implement protected override bool OnEvaluate() and write the processing at runtime.",
        "content": "EvaluateComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Evaluate Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.EvaluateComponent. Apply System.SerializableAttribute to the type. Implement protected override bool OnEvaluate() and write the processing at runtime.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class EvaluateExample : EvaluateComponent\r{\r// OnEvaluate() is called when performing an evaluation\r protected override bool OnEvaluate()\r{\rreturn Input.GetKeyDown(KeyCode.Space);\r}\r}\r  In this example, when executed, it will check whether the space key has been pressed and return the result.\nA similar script can be created by selecting Input.GetKeyDown(KeyCode) when generating the script.\n"
    },
    {
        "uri": "/manual/architecture/nodes/events/fixedupdatenode.html",
        "title": "Fixed Update",
        "tags": [],
        "description": "",
        "summary": "Fixed Update is the node called by the MonoBehaviour's FixedUpdate message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    ",
        "content": "Fixed Update is the node called by the MonoBehaviour's FixedUpdate message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/forintnode.html",
        "title": "ForInt",
        "tags": [],
        "description": "",
        "summary": "This is a node that repeats execution as long as the condition is met while changing the int type value.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Start Value int Starting numbers   Comparison Op ComparisonOp How to compare numbersEaualsCurrent value == Comparison ValueNot EqualsCurrent value != ComparisonValueGreater ThanCurrent value \u0026gt; Comparison ValueGreater Than Or EqualCurrent value \u0026gt; Comparison ValueLess ThanCurrent value \u0026lt; Comparison ValueLess Than Or EqualCurrent value \u0026lt;= Comparison Value   Comparison Value int Numeric value to compare with current value   Amount int Amount of change in current value when Body completes execution   Body OutputExecutePort Execute the destination node during the loop   Value int Outputs the current value.",
        "content": "This is a node that repeats execution as long as the condition is met while changing the int type value.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Start Value int Starting numbers   Comparison Op ComparisonOp How to compare numbersEaualsCurrent value == Comparison ValueNot EqualsCurrent value != ComparisonValueGreater ThanCurrent value \u0026gt; Comparison ValueGreater Than Or EqualCurrent value \u0026gt; Comparison ValueLess ThanCurrent value \u0026lt; Comparison ValueLess Than Or EqualCurrent value \u0026lt;= Comparison Value   Comparison Value int Numeric value to compare with current value   Amount int Amount of change in current value when Body completes execution   Body OutputExecutePort Execute the destination node during the loop   Value int Outputs the current value.   Completed OutputTransitionPort The transition occurs when the numerical comparison result becomes false or the execution node from the Body reaches Break.    Accepting flow termination nodes  Break\nFinishes execution and transitions to Completed. Continue, Exit\nEnds the run, changes the current value and starts the next run.  "
    },
    {
        "uri": "/manual/architecture/nodes/functions/functioncancelnode.html",
        "title": "Function Cancel",
        "tags": [],
        "description": "",
        "summary": "This is the node that is executed when the execution of Function Graph is stopped by the parent graph.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    ",
        "content": "This is the node that is executed when the execution of Function Graph is stopped by the parent graph.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    "
    },
    {
        "uri": "/manual/architecture/nodes/converts/getcomponentnode.html",
        "title": "GetComponent",
        "tags": [],
        "description": "",
        "summary": "Get Component from GameObject.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     GameObject Derived from Component or interface Possible    Other than the above is not possible",
        "content": "Get Component from GameObject.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     GameObject Derived from Component or interface Possible    Other than the above is not possible\n"
    },
    {
        "uri": "/manual/windows/logiceditor/graphview.html",
        "title": "Graph View",
        "tags": [],
        "description": "",
        "summary": "In graph view, you can edit the selected graph on the Graphs tab.\nBasic operation method    Operation details Windows Mac     Scroll Middle mouse button dragAlt + Left mouse button drag Middle mouse button dragoption ⌥ + Mouse button drag   Vertical scroll Mouse wheel Mouse wheel   Horizontal scroll Shift + mouse wheel shift ⇧ + mouse wheel   Zoom Ctrl + Mouse WheelCtrl + Right Mouse Button Drag command ⌘ + Mouse Wheelcommand ⌘ + control ⌃ +  Mouse button drag   Menu display Right mouse button click control ⌃ + mouse button click   Select a node Click the left mouse button on the node Click the mouse button on the node   Add/cancel selection Ctrl + left mouse button click on the node command ⌘ + mouse button click on the node   Rectangular selection of nodes Left mouse button drag Mouse button drag   Add mode Shift + left mouse button drag shift ⇧ + mouse button drag   Release mode Ctrl + left mouse button drag command ⌘ + mouse button drag   Moving a node Drag left mouse button on a node Drag mouse button on a node    Shortcut keys    Operation details Windows Mac     Scroll WASD key WASD key   Enlarge Ctrl + ]key command ⌘ + ]key   Reduce Ctrl + [key command ⌘ + [key   Create node Space key Space key   Move selected node Arrow keys Arrow keys   Delete selected node Delete key Delete key   Screenshot Shift key + P key shift ⇧ + P key   Display comments for all nodes Ctrl + Shift + K key command ⌘ + shift ⇧ + K key   Hide comments for all nodes Ctrl + Shift + L key command ⌘ + shift ⇧ + L key   Display comment for selected node Ctrl + K key command ⌘ + K key   Hide comments of selected node Ctrl + L key command ⌘ + L key   Create group node(When selecting a node, create a size that encloses the selected node) G key G key   Create comment node C key C key   Put all nodes in the frame Home key Home key   Toggle breakpoint on selected node F9 key F9 key   Disable breakpoints on all nodes Alt + F9 key option ⌥ + F9 key    Depending on your keyboard layout, the default shortcut keys may not respond.",
        "content": "In graph view, you can edit the selected graph on the Graphs tab.\nBasic operation method    Operation details Windows Mac     Scroll Middle mouse button dragAlt + Left mouse button drag Middle mouse button dragoption ⌥ + Mouse button drag   Vertical scroll Mouse wheel Mouse wheel   Horizontal scroll Shift + mouse wheel shift ⇧ + mouse wheel   Zoom Ctrl + Mouse WheelCtrl + Right Mouse Button Drag command ⌘ + Mouse Wheelcommand ⌘ + control ⌃ +  Mouse button drag   Menu display Right mouse button click control ⌃ + mouse button click   Select a node Click the left mouse button on the node Click the mouse button on the node   Add/cancel selection Ctrl + left mouse button click on the node command ⌘ + mouse button click on the node   Rectangular selection of nodes Left mouse button drag Mouse button drag   Add mode Shift + left mouse button drag shift ⇧ + mouse button drag   Release mode Ctrl + left mouse button drag command ⌘ + mouse button drag   Moving a node Drag left mouse button on a node Drag mouse button on a node    Shortcut keys    Operation details Windows Mac     Scroll WASD key WASD key   Enlarge Ctrl + ]key command ⌘ + ]key   Reduce Ctrl + [key command ⌘ + [key   Create node Space key Space key   Move selected node Arrow keys Arrow keys   Delete selected node Delete key Delete key   Screenshot Shift key + P key shift ⇧ + P key   Display comments for all nodes Ctrl + Shift + K key command ⌘ + shift ⇧ + K key   Hide comments for all nodes Ctrl + Shift + L key command ⌘ + shift ⇧ + L key   Display comment for selected node Ctrl + K key command ⌘ + K key   Hide comments of selected node Ctrl + L key command ⌘ + L key   Create group node(When selecting a node, create a size that encloses the selected node) G key G key   Create comment node C key C key   Put all nodes in the frame Home key Home key   Toggle breakpoint on selected node F9 key F9 key   Disable breakpoints on all nodes Alt + F9 key option ⌥ + F9 key    Depending on your keyboard layout, the default shortcut keys may not respond. If necessary, open the Shortcuts window from \u0026ldquo;Edit \u0026gt; Shortcuts\u0026hellip;\u0026rdquo; in the menu, select the \u0026ldquo;Logic Toolkit\u0026rdquo; category, and configure settings.\nHow to operate nodes Creating a node  Displaying the node menu Please display using one of the following methods.  Right-click on the graph and select Create Node from the menu *Click on the graph and press the Spacebar while the focus is on it.   Select the node you want to create from the menu The node will be created and you will be in name input mode, so enter the name. Confirm with Enter key  Delete node You can delete it using one of the following methods:\n Right-click the node and select Delete from the menu Select the node and press the Delete key  Node comment Nodes have the ability to leave comments.\nDisplaying node comments You can display it using one of the following methods:\n Select Show Comment from the right-click menu Click the \u0026ldquo;\u0026hellip;\u0026rdquo; icon that appears when you hover over the node Select a node and press Ctrl + K key (Windows) / command ⌘ + K key (Mac) To display all node comments, press Ctrl + Shift + K key (Windows) / command ⌘ + shift ⇧ + K key (Mac)  Editing node comments Click the displayed node comment field and enter the string.\nHide node comments You can hide it using one of the following methods:\n Select Show Comment from the right-click menu *Click the \u0026ldquo;▼\u0026rdquo; icon that appears when you hover over the node comment field Select a node and press Ctrl + L key (Windows) / command ⌘ + L key (Mac) To hide all node comments, press Ctrl + Shift + L key (Windows) / command ⌘ + shift ⇧ + L key (Mac)  Fixed size of node comments You can fix the size of the displayed node comment even when you zoom the graph.\n*Click the \u0026ldquo;🔒\u0026rdquo; icon that appears when you hover over the node comment field\nHow to operate ports/wires Connecting ports  Start dragging ports Drop to destination port  Create a node by dragging ports  Start dragging ports Drop it on an empty spot on the graph Select the node you want to create from the menu The node will be created and you will be in name input mode, so enter the name. Confirm with Enter key  Cutting the wire You can disconnect using one of the following methods:\n Right-click on the wire and select Disconnect from the menu Right-click the port to which the wire is connected and select Disconnect or Disconnect All from the menu Hold down Alt (Windows)/option ⌥ (Mac) and click the left mouse button on the wire  Inserting a reroute node You can insert a reroute node in one of the following ways:\n Right-click on the wire and select Reroute from the menu Hold down Ctrl (Windows)/command ⌘ (Mac) and click the left mouse button on the wire  Create a reroute node by dragging ports  Start dragging ports Hold down Ctrl (Windows)/command ⌘ (Mac) and drop it on an empty area of the graph.  Input drag of reroute port  Hold down Shift and drag the left mouse button  Insert reroute node by dragging port  Start dragging ports Hold down Ctrl (Windows)/command ⌘ (Mac) and drop it on the wire you want to insert.  "
    },
    {
        "uri": "/manual/architecture/ports/inputexecuteport.html",
        "title": "InputExecutePort",
        "tags": [],
        "description": "",
        "summary": "This is an input port installed on the node to be executed.\nConnectable wires  ExecuteWire\nNodes connected from OutputExecutePort are executed first. TransitionWire\nIt is executed by transitioning from the node connected to OutputTransitionPort or OutputSignalPort.  ",
        "content": "This is an input port installed on the node to be executed.\nConnectable wires  ExecuteWire\nNodes connected from OutputExecutePort are executed first. TransitionWire\nIt is executed by transitioning from the node connected to OutputTransitionPort or OutputSignalPort.  "
    },
    {
        "uri": "/manual/architecture/objects/logicasset.html",
        "title": "Logic Asset",
        "tags": [],
        "description": "",
        "summary": "This is the main object of Logic Toolkit that can be created as an asset (ScriptableObject). It has a built-in Logic Controller, which allows behavior control using graphs.\nTo play, you need to place a GameObject with Logic Player in the scene.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Logic Asset from the menu.",
        "content": "This is the main object of Logic Toolkit that can be created as an asset (ScriptableObject). It has a built-in Logic Controller, which allows behavior control using graphs.\nTo play, you need to place a GameObject with Logic Player in the scene.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Logic Asset from the menu. Enter the name to enter name input mode. Confirm with Enter key  Logic Editor window  Click the \u0026ldquo;+\u0026rdquo; button in the Logic Editor window. Select Logic Asset from the menu. The save destination dialog will be displayed. Select the save destination folder, enter the file name, and save.  Properties    Properties Description     Edit button Open Logic Editor window    Supplement  Objects in the scene cannot be directly referenced from graphs created with Logic Asset.  "
    },
    {
        "uri": "/manual/windows/datalink.html",
        "title": "Logic Data Link window",
        "tags": [],
        "description": "",
        "summary": "[Blackboard](/manual/architecture/blackboard.html shared by DataLink ) instance viewer.\nHow to open You can open it using one of the following methods.\n Select Window \u0026gt; Logic Toolkit \u0026gt; Logic Data Link from the menu. Click the \u0026ldquo;⋮\u0026rdquo; button on the toolbar of Logic Editor and select Logic Data Link from the menu.  ",
        "content": "[Blackboard](/manual/architecture/blackboard.html shared by DataLink ) instance viewer.\nHow to open You can open it using one of the following methods.\n Select Window \u0026gt; Logic Toolkit \u0026gt; Logic Data Link from the menu. Click the \u0026ldquo;⋮\u0026rdquo; button on the toolbar of Logic Editor and select Logic Data Link from the menu.  "
    },
    {
        "uri": "/manual/architecture/objects.html",
        "title": "Object",
        "tags": [],
        "description": "",
        "summary": "Describes Unity components and assets available in Logic Toolkit.\nObject types  Logic Behavior Logic Player Logic Asset Task Graph Asset Evaluate Graph Asset Blackboard Asset  ",
        "content": "Describes Unity components and assets available in Logic Toolkit.\nObject types  Logic Behavior Logic Player Logic Asset Task Graph Asset Evaluate Graph Asset Blackboard Asset  "
    },
    {
        "uri": "/manual/architecture/nodes/organizes/reroutenode.html",
        "title": "Reroute",
        "tags": [],
        "description": "",
        "summary": "This is a node inserted between wire and used to change the route.\nCompatible wires  DataWire TransitionWire SignalWire  Additional right-click menu    Contents Description     Delete (Keep Connection) Delete a Reroute node while maintaining the connection between connected ports    Shortcuts    Contents Windows Mac     Create by dragging a port Hold down Ctrl and drop while dragging a port Drop while holding down Command ⌘ while dragging a port   Insert onto an existing wire Mouse over the wire, hold down Ctrl and click the left mouse button Mouse over the wire, hold down Command ⌘ and click the left mouse button   Insert on existing wire while dragging a port Hold Ctrl while dragging a port and drop it on the wire Hold Command ⌘ while dragging a port and drop it on the wire   Drag input port Start dragging while holding Shift Start dragging while holding shift ⇧    ",
        "content": "This is a node inserted between wire and used to change the route.\nCompatible wires  DataWire TransitionWire SignalWire  Additional right-click menu    Contents Description     Delete (Keep Connection) Delete a Reroute node while maintaining the connection between connected ports    Shortcuts    Contents Windows Mac     Create by dragging a port Hold down Ctrl and drop while dragging a port Drop while holding down Command ⌘ while dragging a port   Insert onto an existing wire Mouse over the wire, hold down Ctrl and click the left mouse button Mouse over the wire, hold down Command ⌘ and click the left mouse button   Insert on existing wire while dragging a port Hold Ctrl while dragging a port and drop it on the wire Hold Command ⌘ while dragging a port and drop it on the wire   Drag input port Start dragging while holding Shift Start dragging while holding shift ⇧    "
    },
    {
        "uri": "/manual/architecture/nodecomponents/decorator/resultchangedecorator.html",
        "title": "ResultChangeDecorator",
        "tags": [],
        "description": "",
        "summary": "Decorator that changes the execution result of a node.",
        "content": "Decorator that changes the execution result of a node.\n"
    },
    {
        "uri": "/manual/scripting/nodecomponents/decorator/resultchangedecorator.html",
        "title": "ResultChangeDecorator",
        "tags": [],
        "description": "",
        "summary": "ResultChangeDecorator can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Decorator \u0026gt; Result Change Decorator C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.BehaviorTree.ResultChangeDecorator. Apply System.SerializableAttribute to the type. Implement protected override bool OnResult(bool result) and write the processing at runtime.",
        "content": "ResultChangeDecorator can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Decorator \u0026gt; Result Change Decorator C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.BehaviorTree.ResultChangeDecorator. Apply System.SerializableAttribute to the type. Implement protected override bool OnResult(bool result) and write the processing at runtime. protected override void OnActivated() is called when activated. protected override void OnDeactivated() is called when it becomes inactive.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\rusing LogicToolkit.BehaviorTrees;\r[System.Serializable]\rpublic class ResultChangeDecoratorExample : ResultChangeDecorator\r{\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\r}\r// Called when the node finishes executing\r protected override bool OnResult(bool result)\r{\rreturn !result;\r}\r// OnDeactivated is called when it is deactivated.\r protected override void OnDeactivated()\r{\r}\r}\r  This example returns the node results inverted.\nIn addition, a script called InvertResult is included in advance as a similar function.\n"
    },
    {
        "uri": "/manual/architecture/nodecomponents/composites/sequence.html",
        "title": "Selector",
        "tags": [],
        "description": "",
        "summary": "Executes child nodes in order from top to bottom. Execution ends when any child node returns failure.\nBehavior based on child node results    Results Behavior     Success Executes the next child node. If there is no next child node, execution ends and the Sequence itself returns success.   Failure Terminates the next execution and the Sequence itself also returns failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results.",
        "content": "Executes child nodes in order from top to bottom. Execution ends when any child node returns failure.\nBehavior based on child node results    Results Behavior     Success Executes the next child node. If there is no next child node, execution ends and the Sequence itself returns success.   Failure Terminates the next execution and the Sequence itself also returns failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results. You can connect multiple child nodes. Child nodes are executed from top to bottom.    "
    },
    {
        "uri": "/manual/architecture/nodes/signals/signalinvertnode.html",
        "title": "Signal Invert",
        "tags": [],
        "description": "",
        "summary": "A node that inverts the input signal.\nProperties    Property name Type Description     Input port InputSignalPort Receives a signal.   Output port OutputSignalPort Off signal if the input port signal is on, on signal if it is off will be output.    ",
        "content": "A node that inverts the input signal.\nProperties    Property name Type Description     Input port InputSignalPort Receives a signal.   Output port OutputSignalPort Off signal if the input port signal is on, on signal if it is off will be output.    "
    },
    {
        "uri": "/manual/architecture/wires/signalwire.html",
        "title": "SignalWire",
        "tags": [],
        "description": "",
        "summary": "A wire for transmitting signals.\nCompatible with Reroute.\nCombinations of ports that can be connected    Output port Input port     OutputSignalPort InputSignalPort    ",
        "content": "A wire for transmitting signals.\nCompatible with Reroute.\nCombinations of ports that can be connected    Output port Input port     OutputSignalPort InputSignalPort    "
    },
    {
        "uri": "/manual/architecture/nodes/statenode.html",
        "title": "State",
        "tags": [],
        "description": "",
        "summary": "State is a node that represents a state in a state machine.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Output port OutputSignalPort Emit a signal when activated. If you connect with TransitionWire, the transition will occur immediately.    Supported node components  TaskComponent\nStarts execution when it becomes active, and outputs the result as a signal when the TaskComponent completes execution.",
        "content": "State is a node that represents a state in a state machine.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Output port OutputSignalPort Emit a signal when activated. If you connect with TransitionWire, the transition will occur immediately.    Supported node components  TaskComponent\nStarts execution when it becomes active, and outputs the result as a signal when the TaskComponent completes execution. ActionComponent\nThe process is executed when the node becomes active. EvaluateComponent\nProcessing is performed every frame while the node is active.\nOutputs the result as a signal. EventComponent\nOutputs a signal when an event occurs. ServiceComponent Starts execution when the node becomes active.  "
    },
    {
        "uri": "/manual/scripting/variable.html",
        "title": "Variable",
        "tags": [],
        "description": "",
        "summary": "You can script types for Blackboard Variables.\nHow to write a script  Create the type in public. Defines a type that Unity can serialize.  Class or struct applying System.SerializableAttribute enum type Classes that inherit from UnityEngine.Object    Code example 1 2 3 4 5 6 7  [System.Serializable]\rpublic struct CharacterStats\r{\rpublic int health;\rpublic int attack;\rpublic int defence;\r}\r  After creating this script, Serializable \u0026gt; Character Stats will be added to the Variable addition menu.",
        "content": "You can script types for Blackboard Variables.\nHow to write a script  Create the type in public. Defines a type that Unity can serialize.  Class or struct applying System.SerializableAttribute enum type Classes that inherit from UnityEngine.Object    Code example 1 2 3 4 5 6 7  [System.Serializable]\rpublic struct CharacterStats\r{\rpublic int health;\rpublic int attack;\rpublic int defence;\r}\r  After creating this script, Serializable \u0026gt; Character Stats will be added to the Variable addition menu.\nHideInVariableMenuAttribute By applying HideInVariableMenuAttribute to the type, you can hide it from the Variable addition menu.\n"
    },
    {
        "uri": "/manual/windows.html",
        "title": "Windows",
        "tags": [],
        "description": "",
        "summary": " Logic Editor window\nThis is the main window for editing graphs. Logic Script Generator window\nThis is a window for generating scripts. Logic Data Link window\n[Blackboard](/manual/architecture/blackboard.html shared by DataLink ) instance viewer. Project Settings window\nDescribes the Logic Toolkit settings in the Project Settings window.  ",
        "content": " Logic Editor window\nThis is the main window for editing graphs. Logic Script Generator window\nThis is a window for generating scripts. Logic Data Link window\n[Blackboard](/manual/architecture/blackboard.html shared by DataLink ) instance viewer. Project Settings window\nDescribes the Logic Toolkit settings in the Project Settings window.  "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes.html",
        "title": "Attributes",
        "tags": [],
        "description": "",
        "summary": "   Type Name Description     CustomTypeMenuCreator Attribute that extends the script selection menu by applying it to TypeMenuCreator.   CustomNodeComponentEditor Attributes that extend the editor of NodeComponent by applying them to NodeComponentEditor   CustomNodeEditor Attributes that extend the editor of Node by applying them to NodeEditor   CustomAttribute Basic type of attributes for editor extension    ",
        "content": "   Type Name Description     CustomTypeMenuCreator Attribute that extends the script selection menu by applying it to TypeMenuCreator.   CustomNodeComponentEditor Attributes that extend the editor of NodeComponent by applying them to NodeComponentEditor   CustomNodeEditor Attributes that extend the editor of Node by applying them to NodeEditor   CustomAttribute Basic type of attributes for editor extension    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes.html",
        "title": "Attributes",
        "tags": [],
        "description": "",
        "summary": "Type Name Description     HideInTypePopupAttribute Hides types to which this attribute is applied from the type selection window.   HideInVariableMenuAttribute Hide types to which this attribute is applied from the Variable addition menu.   HideTypeInVariableMenuAttribute Applying this attribute to an assembly hides the specified type from the Add Variable menu.   IgnoreGeneratorAttribute Mark to exclude from script generation   MemberIconAttribute Display member icon on NodeComponent icon   MenuKeywordsAttribute Set keywords in the script selection menu.",
        "content": "   Type Name Description     HideInTypePopupAttribute Hides types to which this attribute is applied from the type selection window.   HideInVariableMenuAttribute Hide types to which this attribute is applied from the Variable addition menu.   HideTypeInVariableMenuAttribute Applying this attribute to an assembly hides the specified type from the Add Variable menu.   IgnoreGeneratorAttribute Mark to exclude from script generation   MemberIconAttribute Display member icon on NodeComponent icon   MenuKeywordsAttribute Set keywords in the script selection menu.   MenuNameAttribute Set a name in the script selection menu.   ScriptGeneratedAttribute Mark as generated script   ValueTypeAttribute Restrict types that can be selected with SerializableType to types derived from the specified base type   AllowedTypesAttribute Set the types that are allowed to be used.   DisallowedTypesAttribute Set types that are not allowed to be used.   FieldPlacementAttribute Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.   ConstantColorUsageAttribute Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.   ConstantDelayedAttribute Attribute that delays the finalization of constant changes.\nIf this attribute is applied, constant changes will not be committed until the user presses the enter key or takes focus from the field.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;, InputField\u0026lt;string\u0026gt;.   ConstantGradientUsageAttribute Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.   ConstantMinAttribute Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.   ConstantPropertyAttribute The base type of an attribute that, when applied to a field in InputField\u0026lt;T\u0026gt;, sets the configuration of a field of constant values.   ConstantRangeAttribute Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.   ConstantTextAreaAttribute An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.   FixedRecomputeModeAttribute Attribute to fix recompute mode   DefaultRecomputeModeAttribute Attribute that sets the default recomputation mode   DontUseComputeAttribute Attributes prohibited from use on Compute nodes   FieldOrderAttribute Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.   FixedTitleNameAttribute Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.   HideResultFieldAttribute Attribute that hides the Result field that outputs the execution results of TaskComponent. Mainly used for processing that always completes successfully.    "
    },
    {
        "uri": "/manual/architecture/nodes/behaviortreenode.html",
        "title": "BehaviorTree",
        "tags": [],
        "description": "",
        "summary": "BehaviorTree is a node that is executed in the form of a behavior tree.\nProperties    Property name Type Description     Input port InputBehaviorTreePort Executed when connected to parent BehaviorTreePort.    Supported node components Main  ActionComponent\nPerforms processing when a node becomes active and immediately returns results to the parent node. TaskComponent\nIt starts executing when it becomes active and returns the result to the parent node when the TaskComponent completes execution.",
        "content": "BehaviorTree is a node that is executed in the form of a behavior tree.\nProperties    Property name Type Description     Input port InputBehaviorTreePort Executed when connected to parent BehaviorTreePort.    Supported node components Main  ActionComponent\nPerforms processing when a node becomes active and immediately returns results to the parent node. TaskComponent\nIt starts executing when it becomes active and returns the result to the parent node when the TaskComponent completes execution. EventComponent\nReturns the result to the parent node when the event occurs. ActionComponnet\nPerforms the operation and returns the result to the node as success. EvaluateComponent\nProcessing is performed every frame while the node is active.\nThere are settings that allow you to change the task execution state depending on the results. ServiceComponent Starts execution when the node becomes active.  Decorators  Decorator\nIt is used to determine whether to execute a node or to modify execution results. EvaluateComponent\nIt is used to determine whether or not to execute a node.  Services  ActionComponnet\nExecute the process.\nYou can also set it to be called every frame using the Methods field. TaskComponent\nExecutes the process and outputs the running status. EvaluateComponent\nProcessing is performed every frame while the node is active.\nOutputs the result in bool type.  "
    },
    {
        "uri": "/manual/architecture/wires/behaviortreewire.html",
        "title": "BehaviorTreeWire",
        "tags": [],
        "description": "",
        "summary": "A wire for executing connected nodes in behavior tree format.\nCombinations of ports that can be connected    Output port Input port     OutputBehaviorTreePort InputBehaviorTreePort    ",
        "content": "A wire for executing connected nodes in behavior tree format.\nCombinations of ports that can be connected    Output port Input port     OutputBehaviorTreePort InputBehaviorTreePort    "
    },
    {
        "uri": "/manual/scripting/convertnode.html",
        "title": "ConvertNode",
        "tags": [],
        "description": "",
        "summary": "When connecting data ports, you can use a script to create a node that performs data type conversion.\nHow to write a script  Create a class that inherits from LogicToolkit.ConvertNode. Apply System.SerializableAttribute to the type. Define a method called static bool Convertible(System.Type from, System.Type to) to determine whether type conversion is possible. Define a method called protected override void Convert(IInputDataPort input, IOutputDataPort output) and write the type conversion process.  When you connect a port with a data type that meets the conditions, a conversion node is automatically inserted.",
        "content": "When connecting data ports, you can use a script to create a node that performs data type conversion.\nHow to write a script  Create a class that inherits from LogicToolkit.ConvertNode. Apply System.SerializableAttribute to the type. Define a method called static bool Convertible(System.Type from, System.Type to) to determine whether type conversion is possible. Define a method called protected override void Convert(IInputDataPort input, IOutputDataPort output) and write the type conversion process.  When you connect a port with a data type that meets the conditions, a conversion node is automatically inserted. Each input/output port is created from the data type when connected.\nCode example The built-in EvaluateToQuaternionNode is implemented as follows.\n1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rnamespace LogicToolkit\r{\r[System.Serializable]\rpublic class EulerToQuaternionNode : ConvertNode\r{\rstatic bool Convertible(System.Type from, System.Type to)\r{\rreturn from == typeof(Vector3) \u0026amp;\u0026amp; to == typeof(Quaternion);\r}\rprotected override void Convert(IInputDataPort input, IOutputDataPort output)\r{\rif (input.TryGetValue\u0026lt;Vector3\u0026gt;(out var value))\r{\routput.TrySetValue(Quaternion.Euler(value));\r}\r}\r}\r}\r  "
    },
    {
        "uri": "/manual/architecture/wires/datawire.html",
        "title": "DataWire",
        "tags": [],
        "description": "",
        "summary": "A wire for exchanging data.\nCompatible with Reroute.\nCombinations of ports that can be connected    Output port Input port     OutputDataPort InputDataPort    Supplement You can connect only if the data value types are compatible.",
        "content": "A wire for exchanging data.\nCompatible with Reroute.\nCombinations of ports that can be connected    Output port Input port     OutputDataPort InputDataPort    Supplement You can connect only if the data value types are compatible.\n"
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/forlongnode.html",
        "title": "ForLong",
        "tags": [],
        "description": "",
        "summary": "This is a node that repeats execution as long as the condition is met while changing the long type value.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Start Value long Starting numbers   Comparison Op ComparisonOp How to compare numbersEaualsCurrent value == Comparison ValueNot EqualsCurrent value != ComparisonValueGreater ThanCurrent value \u0026gt; Comparison ValueGreater Than Or EqualCurrent value \u0026gt; Comparison ValueLess ThanCurrent value \u0026lt; Comparison ValueLess Than Or EqualCurrent value \u0026lt;= Comparison Value   Comparison Value long Numeric value to compare with current value   Amount long Amount of change in current value when Body completes execution   Body OutputExecutePort Execute the destination node during the loop   Value long Outputs the current value.",
        "content": "This is a node that repeats execution as long as the condition is met while changing the long type value.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Start Value long Starting numbers   Comparison Op ComparisonOp How to compare numbersEaualsCurrent value == Comparison ValueNot EqualsCurrent value != ComparisonValueGreater ThanCurrent value \u0026gt; Comparison ValueGreater Than Or EqualCurrent value \u0026gt; Comparison ValueLess ThanCurrent value \u0026lt; Comparison ValueLess Than Or EqualCurrent value \u0026lt;= Comparison Value   Comparison Value long Numeric value to compare with current value   Amount long Amount of change in current value when Body completes execution   Body OutputExecutePort Execute the destination node during the loop   Value long Outputs the current value.   Completed OutputTransitionPort The transition occurs when the numerical comparison result becomes false or the execution node from the Body reaches Break.    Accepting flow termination nodes  Break\nFinishes execution and transitions to Completed. Continue, Exit\nEnds the run, changes the current value and starts the next run.  "
    },
    {
        "uri": "/manual/architecture/nodes/converts/getgameobjectnode.html",
        "title": "GetGameObject",
        "tags": [],
        "description": "",
        "summary": "Get GameObject from Component.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     Derived from Component GameObject Possible    Other than the above is not possible",
        "content": "Get GameObject from Component.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     Derived from Component GameObject Possible    Other than the above is not possible\n"
    },
    {
        "uri": "/manual/architecture/nodes/events/lateupdatenode.html",
        "title": "Late Update",
        "tags": [],
        "description": "",
        "summary": "Late Update is the node called by the MonoBehaviour's LateUpdate message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    ",
        "content": "Late Update is the node called by the MonoBehaviour's LateUpdate message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.    "
    },
    {
        "uri": "/manual/architecture/nodes.html",
        "title": "Node",
        "tags": [],
        "description": "",
        "summary": "A node is a part that is placed in a graph.\nInside the nodes, there are terminals called ports that connect the nodes, and by connecting the ports with wires, we build processing that spans the nodes.\nAdditionally, some nodes can have one or more node components that perform processing while the node is running.\nNode types There are multiple types of nodes depending on their functionality.\n Action\nThis is a node for processing that can be completed in an instant.",
        "content": "A node is a part that is placed in a graph.\nInside the nodes, there are terminals called ports that connect the nodes, and by connecting the ports with wires, we build processing that spans the nodes.\nAdditionally, some nodes can have one or more node components that perform processing while the node is running.\nNode types There are multiple types of nodes depending on their functionality.\n Action\nThis is a node for processing that can be completed in an instant. Task\nThis is a node for continuous processing. State\nA node that performs processing according to the state. BehaviorTree\nThis node switches execution nodes on the tree based on priority. Service\nNode A node that runs constantly while the graph is playing. Event nodes\nA group of nodes for starting execution when an event occurs. Flow control nodes\nA group of nodes that control branching and repetition of executed nodes. Signal nodes\nA group of nodes that determine conditions for transitioning from State to other nodes. Data calculation nodes\nA group of nodes for performing calculations, data acquisition, etc. Data conversion nodes\nA group of nodes for converting data types. Function graph nodes\nA group of nodes related to function graphs. Graph organizing nodes\nA group of nodes that can be used to organize graphs.  "
    },
    {
        "uri": "/manual/architecture/ports/outputsignalport.html",
        "title": "OutputSignalPort",
        "tags": [],
        "description": "",
        "summary": "This is an output port for passing signals from the state to other nodes.\nConnectable wires  SignalWire\nPasses the signal to the connected input port. TransitionWire\nTransit to the connection destination node.  ",
        "content": "This is an output port for passing signals from the state to other nodes.\nConnectable wires  SignalWire\nPasses the signal to the connected input port. TransitionWire\nTransit to the connection destination node.  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/composites/parallelselector.html",
        "title": "Parallel Selector",
        "tags": [],
        "description": "",
        "summary": "Executes child nodes at the same time. Execution ends when any child node returns success.\nBehavior based on child node results    Results Behavior     Success Finishes execution and the Parallel Selector itself also returns success.   Failure Wait for other child nodes to finish executing. If all child nodes have finished executing, Parallel Selector itself will also return failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results.",
        "content": "Executes child nodes at the same time. Execution ends when any child node returns success.\nBehavior based on child node results    Results Behavior     Success Finishes execution and the Parallel Selector itself also returns success.   Failure Wait for other child nodes to finish executing. If all child nodes have finished executing, Parallel Selector itself will also return failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results. You can connect multiple child nodes. Child nodes start executing from top to bottom.    "
    },
    {
        "uri": "/manual/windows/projectsettings.html",
        "title": "Project Settings window",
        "tags": [],
        "description": "",
        "summary": "Describes the Logic Toolkit settings in the Project Settings window.\nHow to open You can open it using one of the following methods.\n Select Edit \u0026gt; Project Settings from the menu to open the Project Settings window. Select Logic Toolkit from the category list in the Project Settings window. Click the \u0026ldquo;⋮\u0026rdquo; button on the toolbar of Logic Editor and select Settings from the menu.  setting    Setting items Explanation Supplement     Enable Graph Open Opens the running graph when the node is stopped due to a breakpoint or exception.",
        "content": "Describes the Logic Toolkit settings in the Project Settings window.\nHow to open You can open it using one of the following methods.\n Select Edit \u0026gt; Project Settings from the menu to open the Project Settings window. Select Logic Toolkit from the category list in the Project Settings window. Click the \u0026ldquo;⋮\u0026rdquo; button on the toolbar of Logic Editor and select Settings from the menu.  setting    Setting items Explanation Supplement     Enable Graph Open Opens the running graph when the node is stopped due to a breakpoint or exception. Save in user settings (UserSettings folder)    "
    },
    {
        "uri": "/manual/scripting.html",
        "title": "Scripting",
        "tags": [],
        "description": "",
        "summary": "Describes how to create scripts available with Logic Toolkit.\n NodeComponent scripts Data flow Variable ConvertNode  ",
        "content": "Describes how to create scripts available with Logic Toolkit.\n NodeComponent scripts Data flow Variable ConvertNode  "
    },
    {
        "uri": "/manual/architecture/objects/taskgraphasset.html",
        "title": "Task Graph Asset",
        "tags": [],
        "description": "",
        "summary": "This is an asset that contains a function graph Task Graph.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Functions \u0026gt; Task Graph Asset from the menu. Enter the name to enter name input mode. Confirm with Enter key  Logic Editor window  Click the \u0026ldquo;+\u0026rdquo; button in the Logic Editor window.",
        "content": "This is an asset that contains a function graph Task Graph.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Functions \u0026gt; Task Graph Asset from the menu. Enter the name to enter name input mode. Confirm with Enter key  Logic Editor window  Click the \u0026ldquo;+\u0026rdquo; button in the Logic Editor window. Select Functions \u0026gt; Task Graph Asset from the menu. The save destination dialog will be displayed. Select the save destination folder, enter the file name, and save.  How to Use  Open the graph you want to use, such as Logic Behavior, Logic Asset, or Function graph, in the [Logic Editor window] (/manual/windows/logiceditor.html). Select Create Node etc. from the right-click menu on the graph to open the node creation menu. Select Actions \u0026gt; Functions \u0026gt; Graph name you want to use etc.\n(The position in the menu varies depending on the node you want to use)  Properties    Properties Description     Edit button Open Logic Editor window    Supplement  Objects in the scene cannot be directly referenced from the graph created with Task Graph Asset.  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/taskcomponent.html",
        "title": "TaskComponent",
        "tags": [],
        "description": "",
        "summary": "A node component that performs continuous processing.\nIt is used for waiting for time to pass, tween processing, waiting for asynchronous processing to complete, etc.\nBehavior when set to node Task Task\nIt starts executing when it becomes active, and transitions to the connection destination port when the TaskComponent completes execution.\nAdditional properties\n   Property name Type Description     Result OutputDataPort\u0026lt;bool\u0026gt; Outputs the execution result in bool type.",
        "content": "A node component that performs continuous processing.\nIt is used for waiting for time to pass, tween processing, waiting for asynchronous processing to complete, etc.\nBehavior when set to node Task Task\nIt starts executing when it becomes active, and transitions to the connection destination port when the TaskComponent completes execution.\nAdditional properties\n   Property name Type Description     Result OutputDataPort\u0026lt;bool\u0026gt; Outputs the execution result in bool type.    State State\nStarts execution when it becomes active, and outputs the result as a signal when the TaskComponent completes execution.\nAdditional properties\n   Property name Type Description     Completed OutputSignalPort Outputs the execution result as a signal.    BehaviorTree BehaviorTree\nMain It starts executing when it becomes active and returns the result to the parent node when the TaskComponent completes execution.\nServices Starts execution when it becomes active.\nAdditional properties\n   Property name Type Description     Repeat InputField\u0026lt;bool\u0026gt; Set whether to repeat after execution is completed.   Status OutputDataPort\u0026lt;TaskStatus\u0026gt; Outputs the execution status.    Signal Evaluation Signal Evaluation\nIt becomes active when the judgment result of the input signal is true, and the result is reflected in the output signal when the TaskComponent completes execution.\nScript generation The script generation function uses TaskComponent for the following member access scripts.\n Tween field values Tween property values Calling awaitable methods  For details, see Script generation.\n"
    },
    {
        "uri": "/manual/scripting/nodecomponents/taskcomponent.html",
        "title": "TaskComponent",
        "tags": [],
        "description": "",
        "summary": "TaskComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Task Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.TaskComponent. Apply System.SerializableAttribute to the type. protected override void OnActivated() is called when activated. protected override void OnDeactivated() is called when it becomes inactive.",
        "content": "TaskComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Task Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.TaskComponent. Apply System.SerializableAttribute to the type. protected override void OnActivated() is called when activated. protected override void OnDeactivated() is called when it becomes inactive. Implement protected override TaskStatus OnExecute() and describe the processing at runtime.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class TaskExample : TaskComponent\r{\rprivate float startTime;\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\rstartTime = Time.time;\r}\r// OnExecute is called when it is executed.\r protected override TaskStatus OnExecute()\r{\r// Return Running, Success, or Failure depending on the task execution status.\r return Time.time - startTime \u0026gt; 1f? TaskStatus.Success : TaskStatus.Running;\r}\r// OnDeactivated is called when it is deactivated.\r protected override void OnDeactivated()\r{\r}\r}\r  This example returns success and exits after 1 second of execution.\nIn addition, a script called Wait For Seconds is included in advance as a similar function.\n"
    },
    {
        "uri": "/manual/localization.html",
        "title": "Editor multilingual support",
        "tags": [],
        "description": "",
        "summary": "Compatible with Unity editor language packs.\nSupported languages  English Japanese (partially)  Introducing language packs  Open the Unity Hub application Select Installs category Click the gear icon for the Unity version you are using Select Add modules from the menu Check the checkbox of the language you want to install from the LANGUAGE PACKS (PREVIEW) field. Click the INSTALL button  How to switch the editor language  Select Edit \u0026gt; Preferences\u0026hellip; from the menu within Unity Select the Languages category Change Editor language.",
        "content": "Compatible with Unity editor language packs.\nSupported languages  English Japanese (partially)  Introducing language packs  Open the Unity Hub application Select Installs category Click the gear icon for the Unity version you are using Select Add modules from the menu Check the checkbox of the language you want to install from the LANGUAGE PACKS (PREVIEW) field. Click the INSTALL button  How to switch the editor language  Select Edit \u0026gt; Preferences\u0026hellip; from the menu within Unity Select the Languages category Change Editor language.  supplement If the display language in the editor does not change, please restart Unity.\n"
    },
    {
        "uri": "/manual/architecture/objects/evaluategraphasset.html",
        "title": "Evaluate Graph Asset",
        "tags": [],
        "description": "",
        "summary": "This is an asset that includes a function graph Evaluate Graph.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Functions \u0026gt; Evaluate Graph Asset from the menu. Enter the name to enter name input mode. Confirm with Enter key  Logic Editor window  Click the \u0026ldquo;+\u0026rdquo; button in the Logic Editor window.",
        "content": "This is an asset that includes a function graph Evaluate Graph.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Functions \u0026gt; Evaluate Graph Asset from the menu. Enter the name to enter name input mode. Confirm with Enter key  Logic Editor window  Click the \u0026ldquo;+\u0026rdquo; button in the Logic Editor window. Select Functions \u0026gt; Evaluate Graph Asset from the menu. The save destination dialog will be displayed. Select the save destination folder, enter the file name, and save.  How to Use  Open the graph you want to use, such as Logic Behavior, Logic Asset, or Function graph, in the [Logic Editor window] (/manual/windows/logiceditor.html). Select Create Node etc. from the right-click menu on the graph to open the node creation menu. Select Actions \u0026gt; Functions \u0026gt; Graph name you want to use etc.\n(The position in the menu varies depending on the node you want to use)  Properties    Properties Description     Edit button Open Logic Editor window    Supplement  Objects in the scene cannot be directly referenced from graphs created with Evaluate Graph Asset.  "
    },
    {
        "uri": "/manual/architecture/nodes/events/eventnode.html",
        "title": "Event",
        "tags": [],
        "description": "",
        "summary": "Event is a node that executes when an event is called by EventComponent.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.   Cancellable InputField\u0026lt;bool\u0026gt; Whether to cancel the running node and rerun it if the event is called again while it is already running    Supported node components  EventComponent Executes the connected node when an event occurs.",
        "content": "Event is a node that executes when an event is called by EventComponent.\nProperties    Property name Type Description     Output port OutputExecutePort Executes the connected node when the event is called.   Cancellable InputField\u0026lt;bool\u0026gt; Whether to cancel the running node and rerun it if the event is called again while it is already running    Supported node components  EventComponent Executes the connected node when an event occurs.  "
    },
    {
        "uri": "/manual/scripting/nodecomponents/eventcomponent.html",
        "title": "EventComponent",
        "tags": [],
        "description": "",
        "summary": "EventComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Event Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.EventComponent. Apply System.SerializableAttribute to the type. protected override void OnActivated() is called when activated.\nIt mainly processes event subscriptions.",
        "content": "EventComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Event Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.EventComponent. Apply System.SerializableAttribute to the type. protected override void OnActivated() is called when activated.\nIt mainly processes event subscriptions. protected override void OnDeactivated() is called when it becomes inactive.\nMainly handles unsubscribing from events. Implement LogicToolkit.IUpdateReceiver as necessary, and use void OnUpdate() to judge the status. Call OnEvent() when determining that the event has been called.  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class EventExample : EventComponent\r{\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\r// Subscribe to some event and call OnEvent() from your callback.\r Application.focusChanged += OnFocusChanged;\r}\rvoid OnFocusChanged(bool focus)\r{\rDebug.Log(focus);\rOnEvent();\r}\r// OnDeactivated is called when it is deactivated.\r protected override void OnDeactivated()\r{\r// Unsubscribe from some event\r Application.focusChanged -= OnFocusChanged;\r}\r}\r  In this example, when the focus of the application is switched, the presence or absence of focus is output to the console and the node is notified that an event has occurred.\nWhen testing on UnityEditor, check by switching the focus by alternately clicking on the Game window and other windows.\nA similar script can be created by selecting Application.focusChanged when generating the script.\n"
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/foreachnode.html",
        "title": "ForEach",
        "tags": [],
        "description": "",
        "summary": "This is a node that executes processing while outputting the elements of IList\u0026lt;T\u0026gt; in order.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Element Type SerializableType Element Type   List InputDataPort\u0026lt;Element Type\u0026gt; List input port   Body OutputExecutePort Executes the destination node during the loop.   Element Element Type Current element value   Completed OutputTransitionPort All elements have been executed or the execution node from Body is [Break]({ Transition occurs when {\u0026lt; relref \u0026ldquo;breaknode.",
        "content": "This is a node that executes processing while outputting the elements of IList\u0026lt;T\u0026gt; in order.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Element Type SerializableType Element Type   List InputDataPort\u0026lt;Element Type\u0026gt; List input port   Body OutputExecutePort Executes the destination node during the loop.   Element Element Type Current element value   Completed OutputTransitionPort All elements have been executed or the execution node from Body is [Break]({ Transition occurs when {\u0026lt; relref \u0026ldquo;breaknode.md\u0026rdquo; \u0026gt;}}) is reached.    Accepting flow termination nodes  Break\nFinishes execution and transitions to Completed. Continue, Exit\nFinishes execution and begins execution of the next element.  "
    },
    {
        "uri": "/manual/architecture/nodes/converts/ilisttoarraynode.html",
        "title": "IListToArray",
        "tags": [],
        "description": "",
        "summary": "Convert IList\u0026lt;T\u0026gt; to T[].\nConversion conditions Conditions are judged in order from the top.\nIt doesn't matter what type the element's type T is.\n   Input type Output type Possibility     IList\u0026lt;T\u0026gt; T[] Possible    Other than the above is not possible\nSupplement If the input data instance is T[], the instance is output as is.",
        "content": "Convert IList\u0026lt;T\u0026gt; to T[].\nConversion conditions Conditions are judged in order from the top.\nIt doesn't matter what type the element's type T is.\n   Input type Output type Possibility     IList\u0026lt;T\u0026gt; T[] Possible    Other than the above is not possible\nSupplement If the input data instance is T[], the instance is output as is.\n"
    },
    {
        "uri": "/manual/architecture/ports/inputsignalport.html",
        "title": "InputSignalPort",
        "tags": [],
        "description": "",
        "summary": "This is an input port for receiving signals from other nodes.\nConnectable wires  SignalWire\nReceives signals from the connected output port.  ",
        "content": "This is an input port for receiving signals from other nodes.\nConnectable wires  SignalWire\nReceives signals from the connected output port.  "
    },
    {
        "uri": "/manual/architecture/nodecomponents.html",
        "title": "Node Component",
        "tags": [],
        "description": "",
        "summary": "Describes the types of node components that perform processing while a node is running.\nBasic node components  EventComponent\nThis is a node component that performs the process of notifying the node that an event has arrived.\nUsed to wait for Unity messages (such as OnCollisionEnter) or input events. ActionComponent\nThis is a node component that performs processing that can be completed in an instant.\nIt is used for calling members, calculating data, etc.",
        "content": "Describes the types of node components that perform processing while a node is running.\nBasic node components  EventComponent\nThis is a node component that performs the process of notifying the node that an event has arrived.\nUsed to wait for Unity messages (such as OnCollisionEnter) or input events. ActionComponent\nThis is a node component that performs processing that can be completed in an instant.\nIt is used for calling members, calculating data, etc. EvaluateComponent\nA node component that performs conditional judgment.\nIt is used to determine state transitions and behavior tree execution. TaskComponent\nA node component that performs continuous processing.\nIt is used for waiting for time to pass, tween processing, waiting for asynchronous processing to complete, etc. ServiceComponent\nA node component that performs processing that is constantly executed without returning results. CompositeComponent\nA component that controls the execution of child nodes of BehaviorTree. Decorator\nThis is a node component that performs the process of determining the execution of BehaviorTree.  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/composites/parallelsequence.html",
        "title": "Parallel Sequence",
        "tags": [],
        "description": "",
        "summary": "Executes child nodes at the same time. Execution ends when any child node returns failure.\nBehavior based on child node results    Results Behavior     Success Wait for other child nodes to finish executing. If all child nodes have finished executing, the Parallel Sequence itself will also return success.   Failure Terminates execution and the Parallel Sequence itself also returns failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results.",
        "content": "Executes child nodes at the same time. Execution ends when any child node returns failure.\nBehavior based on child node results    Results Behavior     Success Wait for other child nodes to finish executing. If all child nodes have finished executing, the Parallel Sequence itself will also return success.   Failure Terminates execution and the Parallel Sequence itself also returns failure.    Properties    Property name Type Description     Children OutputBehaviorTreePort Executes the connected child nodes and receives the execution results. You can connect multiple child nodes. Child nodes start executing from top to bottom.    "
    },
    {
        "uri": "/manual/architecture/nodes/servicenode.html",
        "title": "Service",
        "tags": [],
        "description": "",
        "summary": "A node that becomes active when the node graph starts playing and runs constantly.\nSupported node components  ActionComponent\nExecute the process.\nYou can also set it to be called every frame using the Methods field. TaskComponent\nExecutes the process and outputs the running status. ServiceComponent Starts execution when the node becomes active.  ",
        "content": "A node that becomes active when the node graph starts playing and runs constantly.\nSupported node components  ActionComponent\nExecute the process.\nYou can also set it to be called every frame using the Methods field. TaskComponent\nExecutes the process and outputs the running status. ServiceComponent Starts execution when the node becomes active.  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/servicecomponent.html",
        "title": "ServiceComponent",
        "tags": [],
        "description": "",
        "summary": "A node component that performs processing that is constantly executed without returning results.\nBehavior when set to node State State\nStarts execution when the node becomes active.\nBehaviorTree BehaviorTree\nServices Starts execution when the node becomes active.\nService Service\nStarts execution when the node becomes active.",
        "content": "A node component that performs processing that is constantly executed without returning results.\nBehavior when set to node State State\nStarts execution when the node becomes active.\nBehaviorTree BehaviorTree\nServices Starts execution when the node becomes active.\nService Service\nStarts execution when the node becomes active.\n"
    },
    {
        "uri": "/manual/architecture/objects/blackboardasset.html",
        "title": "Blackboard Asset",
        "tags": [],
        "description": "",
        "summary": "Built-in Blackboard for sharing with DataLink It's an asset.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Blackboard Asset from the menu. Enter the name to enter name input mode. Confirm with Enter key  How to Use  Select the object that you want to refer to Blackboard, such as Logic Behavior or Logic Asset, in the Logic Editor Window.",
        "content": "Built-in Blackboard for sharing with DataLink It's an asset.\nHow to create Project window  Select the folder where you want to save the file. Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Blackboard Asset from the menu. Enter the name to enter name input mode. Confirm with Enter key  How to Use  Select the object that you want to refer to Blackboard, such as Logic Behavior or Logic Asset, in the Logic Editor Window. Select the Blackboard tab in the side panel. Select the Data Link tab within the Blackboard tab. Click the \u0026ldquo;+\u0026rdquo; button in the Data Link list. Configure various settings in the details field and set the Blackboard Asset you want to share in the Blackboard Asset field.  For details, see DataLink.\nProperties For more information, see Blackboard.\nSupplement  Objects in the scene cannot be directly referenced from Blackboard Asset.  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/composites.html",
        "title": "CompositeComponent",
        "tags": [],
        "description": "",
        "summary": "A component that controls the execution of child nodes of BehaviorTree.\nIt is implemented by extending TaskComponent, so it can be used with nodes other than the behavior tree.\nCompositeComponent type  Behavior Tree Execute\nExecutes one child node and returns the child node's result as its own execution result. Selector\nExecutes child nodes in order from top to bottom. Execution ends when any child node returns success. Sequence\nExecutes child nodes in order from top to bottom.",
        "content": "A component that controls the execution of child nodes of BehaviorTree.\nIt is implemented by extending TaskComponent, so it can be used with nodes other than the behavior tree.\nCompositeComponent type  Behavior Tree Execute\nExecutes one child node and returns the child node's result as its own execution result. Selector\nExecutes child nodes in order from top to bottom. Execution ends when any child node returns success. Sequence\nExecutes child nodes in order from top to bottom. Execution ends when any child node returns failure. Parallel Selector\nExecutes child nodes at the same time. Execution ends when any child node returns success. Parallel Sequence\nExecutes child nodes at the same time. Execution ends when any child node returns failure.  Behavior when set to node Task Task\nIt starts executing when it becomes active, and transitions to the connection destination port when the TaskComponent completes execution.\nAdditional properties\n   Property name Type Description     Result OutputDataPort\u0026lt;bool\u0026gt; Outputs the execution result in bool type.    State State\nStarts execution when it becomes active, and outputs a signal when the TaskComponent completes execution.\nAdditional properties\n   Property name Type Description     Completed OutputSignalPort Outputs the execution result as a signal.    BehaviorTree BehaviorTree\nIt starts execution when it becomes active, and returns the result to the parent node when it completes execution.\nSignal Evaluation Signal Evaluation\nIt becomes active when the judgment result of the input signal is true, and the result is reflected in the output signal when the child execution is completed.\n"
    },
    {
        "uri": "/manual/architecture/nodes/events.html",
        "title": "Event nodes",
        "tags": [],
        "description": "",
        "summary": "A group of nodes that wait for and execute events.\nNode types  Start\nCalled when the graph is started. Update\nCalled by the MonoBehaviour's Update message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc. Fixed Update\nCalled by the MonoBehaviour's FixedUpdate message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc.",
        "content": "A group of nodes that wait for and execute events.\nNode types  Start\nCalled when the graph is started. Update\nCalled by the MonoBehaviour's Update message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc. Fixed Update\nCalled by the MonoBehaviour's FixedUpdate message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc. Late Update\nCalled by the MonoBehaviour's LateUpdate message.\nIt stops execution immediately after being called, so it does not wait for the completion of Task nodes, etc. Event\nThis is the node that is executed when the event is called by EventComponent.  "
    },
    {
        "uri": "/manual/architecture/nodes/converts/ilisttolistnode.html",
        "title": "IListToList",
        "tags": [],
        "description": "",
        "summary": "Convert IList\u0026lt;T\u0026gt; to List\u0026lt;T\u0026gt;.\nConversion conditions Conditions are judged in order from the top.\nIt doesn't matter what type the element's type T is.\n   Input type Output type Possibility     IList\u0026lt;T\u0026gt; List\u0026lt;T\u0026gt; Possible    Other than the above is not possible\nSupplement If the input data instance is List\u0026lt;T\u0026gt;, the instance is output as is.",
        "content": "Convert IList\u0026lt;T\u0026gt; to List\u0026lt;T\u0026gt;.\nConversion conditions Conditions are judged in order from the top.\nIt doesn't matter what type the element's type T is.\n   Input type Output type Possibility     IList\u0026lt;T\u0026gt; List\u0026lt;T\u0026gt; Possible    Other than the above is not possible\nSupplement If the input data instance is List\u0026lt;T\u0026gt;, the instance is output as is.\n"
    },
    {
        "uri": "/manual/architecture/ports/outputbehaviortreeport.html",
        "title": "OutputBehaviorTreePort",
        "tags": [],
        "description": "",
        "summary": "This is an output port for executing the connected BehaviorTree.\nConnectable wires  BehaviorTreeWire\nExecute the connected child node.  ",
        "content": "This is an output port for executing the connected BehaviorTree.\nConnectable wires  BehaviorTreeWire\nExecute the connected child node.  "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/parallelnode.html",
        "title": "Parallel",
        "tags": [],
        "description": "",
        "summary": "A node that runs multiple nodes in parallel.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Tasks List of OutputExecutePort Execute all connected nodes simultaneously.   Completed OutputTransitionPort The transition occurs when all connected nodes have finished executing, or when any connected node reaches Break.    Accepting flow termination nodes  Exit",
        "content": "A node that runs multiple nodes in parallel.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Tasks List of OutputExecutePort Execute all connected nodes simultaneously.   Completed OutputTransitionPort The transition occurs when all connected nodes have finished executing, or when any connected node reaches Break.    Accepting flow termination nodes  Exit\nTransition from Completed to the next node when execution from all ports has finished.\nIf any ports remain running, do nothing. Break\nForcefully stop the execution of all other ports and transition from Completed to the next node.  "
    },
    {
        "uri": "/manual/architecture/ports.html",
        "title": "Port",
        "tags": [],
        "description": "",
        "summary": "A port is a terminal for connecting nodes. By connecting output ports and input ports with wires, you can link functions between nodes.\nPort types Execution flow  OutputExecutePort OutputTransitionPort InputExecutePort  Signal  OutputSignalPort InputSignalPort  Behavior Tree  OutputBehaviorTreePort InputBehaviorTreePort  Data flow  OutputDataPort InputDataPort  ",
        "content": "A port is a terminal for connecting nodes. By connecting output ports and input ports with wires, you can link functions between nodes.\nPort types Execution flow  OutputExecutePort OutputTransitionPort InputExecutePort  Signal  OutputSignalPort InputSignalPort  Behavior Tree  OutputBehaviorTreePort InputBehaviorTreePort  Data flow  OutputDataPort InputDataPort  "
    },
    {
        "uri": "/manual/scripting/nodecomponents/servicecomponent.html",
        "title": "ServiceComponent",
        "tags": [],
        "description": "",
        "summary": "ServiceComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Service Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.ServiceComponent. Apply System.SerializableAttribute to the type. protected override void OnActivated() is called when activated. protected override void OnDeactivated() is called when it becomes inactive.",
        "content": "ServiceComponent can be written in a C# script.\nHow to create  Click the \u0026ldquo;+\u0026rdquo; button in the Project window. Select Logic Toolkit \u0026gt; Scripts \u0026gt; Service Component C# Script from the menu. Enter the script name and confirm with Enter.  How to write a script  Create a class that inherits from LogicToolkit.ServiceComponent. Apply System.SerializableAttribute to the type. protected override void OnActivated() is called when activated. protected override void OnDeactivated() is called when it becomes inactive. Implement LogicToolkit.IUpdateReceiver as necessary, and perform update processing for each frame with void OnUpdate().  Code example 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23  using System.Collections;\rusing System.Collections.Generic;\rusing UnityEngine;\rusing LogicToolkit;\r[System.Serializable]\rpublic class ServiceExample : ServiceComponent\r{\rprivate float tempTimeScale;\r// OnActivated is called when activated.\r protected override void OnActivated()\r{\rtempTimeScale = Time.timeScale;\rTime.timeScale = 0f;\r}\r// OnDeactivated is called when it is deactivated.\r protected override void OnDeactivated()\r{\rTime.timeScale = tempTimeScale;\r}\r}\r  In this example, using this script on a State or BehaviorTreeNode will stop the game's time progression while the node is active.\n"
    },
    {
        "uri": "/manual/architecture/nodes/converts/tostringnode.html",
        "title": "ToString",
        "tags": [],
        "description": "",
        "summary": "Outputs the result of executing ToString() on the input value.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     (No conditions) string Possible    Other than the above is not possible",
        "content": "Outputs the result of executing ToString() on the input value.\nConversion conditions Conditions are judged in order from the top.\n   Input type Output type Possibility     (No conditions) string Possible    Other than the above is not possible\n"
    },
    {
        "uri": "/manual/updateguide.html",
        "title": "Update guide",
        "tags": [],
        "description": "",
        "summary": "To update to the latest version, please refer to the guide below.\nHow to check the version you are importing  Select Window \u0026gt; Logic Toolkit \u0026gt; Check for Update from the menu. Check the version in the \u0026ldquo;Logic Toolkit Update Check window\u0026rdquo;.  If there is an update, a notification button will also be displayed on the toolbar of the Logic Editor window.\nUpdate procedure Here's how to update safely:",
        "content": "To update to the latest version, please refer to the guide below.\nHow to check the version you are importing  Select Window \u0026gt; Logic Toolkit \u0026gt; Check for Update from the menu. Check the version in the \u0026ldquo;Logic Toolkit Update Check window\u0026rdquo;.  If there is an update, a notification button will also be displayed on the toolbar of the Logic Editor window.\nUpdate procedure Here's how to update safely:\n Back up your project before updating. If you have an existing scene open, create a new scene from \u0026ldquo;File \u0026gt; New Scene\u0026rdquo; in the menu. Close Logic Toolkit-related windows such as the Logic Editor window. Select Window \u0026gt; Package Manager from the menu. Select the In Project category in the Package Manager window. Select Logic Toolkit from the package list. Click the \u0026ldquo;Remove\u0026rdquo; button in the details column. Click the \u0026ldquo;Yes\u0026rdquo; button in the confirmation dialog. Select the \u0026ldquo;My Assets\u0026rdquo; category. Select Logic Toolkit from the asset list. Click the \u0026ldquo;Download update version number\u0026rdquo; button in the details column. After the download is complete, click the \u0026ldquo;Import version number to project\u0026rdquo; button. In the \u0026ldquo;Import Unity Package\u0026rdquo; window, click the \u0026ldquo;All\u0026rdquo; button to select everything. Click the \u0026ldquo;Import\u0026rdquo; button.  "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/breaknode.html",
        "title": "Break",
        "tags": [],
        "description": "",
        "summary": "A type of flow end node. Breaks out of execution, such as a loop.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    Executing node that accepts  ForInt ForLong ForEach Parallel  ",
        "content": "A type of flow end node. Breaks out of execution, such as a loop.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    Executing node that accepts  ForInt ForLong ForEach Parallel  "
    },
    {
        "uri": "/manual/architecture/nodecomponents/decorator.html",
        "title": "Decorator",
        "tags": [],
        "description": "",
        "summary": "BehaviorTree A node component that can be used for Decorators of nodes.\nDecorator types  EvaluateDecorator\nDecorator that evaluates whether to execute the node. LoopCheckDecorator\nA Decorator that controls whether the node repeats when it completes. ResultChangeDecorator\nDecorator that changes the execution result of a node.  Available node components EvaluateComponent can also be used to evaluate node execution or repeated execution.",
        "content": "BehaviorTree A node component that can be used for Decorators of nodes.\nDecorator types  EvaluateDecorator\nDecorator that evaluates whether to execute the node. LoopCheckDecorator\nA Decorator that controls whether the node repeats when it completes. ResultChangeDecorator\nDecorator that changes the execution result of a node.  Available node components EvaluateComponent can also be used to evaluate node execution or repeated execution.\n"
    },
    {
        "uri": "/manual/scripting/nodecomponents/decorator.html",
        "title": "Decorator",
        "tags": [],
        "description": "",
        "summary": "This section explains how to create various Decorator scripts.\nFor an overview of Decorator, please refer to Decorator in the Architecture page.\n EvaluateDecorator\nDescribes the EvaluateDecorator script. LoopCheckDecorator\nDescribes the LoopCheckDecorator script. ResultChangeDecorator\nDescribes the ResultChangeDecorator script.  ",
        "content": "This section explains how to create various Decorator scripts.\nFor an overview of Decorator, please refer to Decorator in the Architecture page.\n EvaluateDecorator\nDescribes the EvaluateDecorator script. LoopCheckDecorator\nDescribes the LoopCheckDecorator script. ResultChangeDecorator\nDescribes the ResultChangeDecorator script.  "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls.html",
        "title": "Flow control nodes",
        "tags": [],
        "description": "",
        "summary": "A group of nodes that perform branching and repetition of processing.\nNode types  If Branch ForInt ForLong ForEach Parallel Break Complete Continue Exit  ",
        "content": "A group of nodes that perform branching and repetition of processing.\nNode types  If Branch ForInt ForLong ForEach Parallel Break Complete Continue Exit  "
    },
    {
        "uri": "/manual/architecture/ports/inputbehaviortreeport.html",
        "title": "InputBehaviorTreePort",
        "tags": [],
        "description": "",
        "summary": "This is an input port installed in the BehaviorTree that is executed.\nConnectable wires  BehaviorTreeWire\nExecuted by the connecting parent node.  ",
        "content": "This is an input port installed in the BehaviorTree that is executed.\nConnectable wires  BehaviorTreeWire\nExecuted by the connecting parent node.  "
    },
    {
        "uri": "/manual/migration.html",
        "title": "Migration from other assets",
        "tags": [],
        "description": "",
        "summary": "We will introduce migration from other assets.\n Migration from Arbor3  ",
        "content": "We will introduce migration from other assets.\n Migration from Arbor3  "
    },
    {
        "uri": "/manual/architecture/wires.html",
        "title": "Wire",
        "tags": [],
        "description": "",
        "summary": "Wires are connecting lines that connect ports.\nBy connecting output ports and input ports with wires, you can link functions between nodes.\nWire types  ExecuteWire TransitionWire SignalWire BehaviorTreeWire DataWire  ",
        "content": "Wires are connecting lines that connect ports.\nBy connecting output ports and input ports with wires, you can link functions between nodes.\nWire types  ExecuteWire TransitionWire SignalWire BehaviorTreeWire DataWire  "
    },
    {
        "uri": "/manual/scripting/nodecomponents/interfaces.html",
        "title": "About Interfaces",
        "tags": [],
        "description": "",
        "summary": "Introducing the interfaces that can be used for NodeComponent.\n IPauseReceiver\nYou can implement a method to call when the graph is paused. IProgressComponent\nA progress bar can be displayed in the header of NodeComponent.  ",
        "content": "Introducing the interfaces that can be used for NodeComponent.\n IPauseReceiver\nYou can implement a method to call when the graph is paused. IProgressComponent\nA progress bar can be displayed in the header of NodeComponent.  "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/completenode.html",
        "title": "Complete",
        "tags": [],
        "description": "",
        "summary": "A type of flow end node. Completes the execution and returns the results to the executor.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Result InputField\u0026lt;bool\u0026gt; Execution result    Executing node component that accepts  ExecuteTask  ",
        "content": "A type of flow end node. Completes the execution and returns the results to the executor.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire   Result InputField\u0026lt;bool\u0026gt; Execution result    Executing node component that accepts  ExecuteTask  "
    },
    {
        "uri": "/manual/architecture/inputfield.html",
        "title": "InputField",
        "tags": [],
        "description": "",
        "summary": "This field allows you to set a fixed value or receive a value from InputDataPort. Graph View node UI.\nDifferences depending on DataPort connection  If InputDataPort is connected, use the data received from the connected port. If InputDataPort is not connected, use the fixed value you set.  Types InputField\u0026lt;T\u0026gt; A basic InputField.\nGets a fixed value of type T or a value from the input DataPort.\nInputComponent\u0026lt;T\u0026gt; This is an InputField that allows you to select how to obtain the component.",
        "content": "This field allows you to set a fixed value or receive a value from InputDataPort. Graph View node UI.\nDifferences depending on DataPort connection  If InputDataPort is connected, use the data received from the connected port. If InputDataPort is not connected, use the fixed value you set.  Types InputField\u0026lt;T\u0026gt; A basic InputField.\nGets a fixed value of type T or a value from the input DataPort.\nInputComponent\u0026lt;T\u0026gt; This is an InputField that allows you to select how to obtain the component.\nObtain the value according to the selection method below or from the input DataPort.\nAcquisition method    Contents Description     Self Logic Behavior or Logic Player is added to get the T type component from the GameObject   Value Fixed value    InputGameObject This is an InputField that allows you to obtain a GameObject.\nObtain the value according to the selection method below or from the input DataPort.\nAcquisition method    Contents Description     Self Logic Behavior or Logic Player has been added to GameObject   Value Fixed value    "
    },
    {
        "uri": "/manual/architecture/ports/outputdataport.html",
        "title": "OutputDataPort",
        "tags": [],
        "description": "",
        "summary": "This is an output port for passing data values to other nodes.\nConnectable wires  DataWire  Supplement The types that can be passed differ depending on the field.\nOnly input/output ports of types that can be exchanged can be connected to each other.",
        "content": "This is an output port for passing data values to other nodes.\nConnectable wires  DataWire  Supplement The types that can be passed differ depending on the field.\nOnly input/output ports of types that can be exchanged can be connected to each other.\n"
    },
    {
        "uri": "/manual/architecture/nodes/signals.html",
        "title": "Signal nodes",
        "tags": [],
        "description": "",
        "summary": "A group of nodes used to determine conditions for transitioning from State.\nNode types  Signal Evaluation Signal Branch Signal Invert  ",
        "content": "A group of nodes used to determine conditions for transitioning from State.\nNode types  Signal Evaluation Signal Branch Signal Invert  "
    },
    {
        "uri": "/manual/architecture/blackboard.html",
        "title": "Blackboard",
        "tags": [],
        "description": "",
        "summary": "Blackboard manages multiple variables, passing values between graphs and storing temporary values.\nAbility to integrate Blackboard  Logic Controller NodeGraph Blackboard Asset  About the types of variables that can be used Types that Unity supports serialization can be used for variables.\nFor details, see Unity - Manual: Script serialization.\nUI description (A) Toolbar There is an add variable button and a search name field.\n(B) Variable name The type icon and name of the variable type.",
        "content": "Blackboard manages multiple variables, passing values between graphs and storing temporary values.\nAbility to integrate Blackboard  Logic Controller NodeGraph Blackboard Asset  About the types of variables that can be used Types that Unity supports serialization can be used for variables.\nFor details, see Unity - Manual: Script serialization.\nUI description (A) Toolbar There is an add variable button and a search name field.\n(B) Variable name The type icon and name of the variable type.\n(C) Variable value Edit field for variable value.\nMethod of operation Create variable  Click the \u0026ldquo;+\u0026rdquo; button on the toolbar Select Single or List from the variable type dropdown on the type selection menu toolbar.\nIf you select \u0026ldquo;List\u0026rdquo;, you can create a list (variable length array) variable. Select the type from the type selection menu. A variable will be created and you will be in name input mode, so enter the name. Confirm with Enter key.  Delete variable You can delete it using one of the following methods:\n Right-click the variable name and select \u0026ldquo;Delete\u0026rdquo; from the menu Select the variable and press the Delete key  Variable access How to access  Get\nOutputs the value of the variable to OutputDataPort. Set\nStores the value received from InputField into a variable. Event\nReceive an event when the value of a variable changes EventComponent\nWhen an event occurs, output the variable value to OutputDataPort and notify the node that an event has arrived.  Method of operation To access variables from a graph, you need to open the graph whose variables you want to access in Logic Editor.\nTo access it, add a node or node component using the following method.\nSide panel  Select Blackboard tab in side panel. Select the Blackboard type tab. Start dragging variables Drop to Graph View Select the node type from the node creation menu. Once the node is created, you will be in node name input mode, so enter the name. Confirm with Enter key.  Node creation menu  Graph view Space key\nAlternatively, right-click and select \u0026ldquo;Create Node\u0026rdquo; from the menu. Enter \u0026ldquo;Variables\u0026rdquo; in the search field of the node creation menu Select the variables and nodes you want to access. Once the node is created, you will be in node name input mode, so enter the name. Confirm with Enter key.  Add component menu  Click the \u0026ldquo;+\u0026rdquo; button in the node component list such as State node. Enter \u0026ldquo;Variables\u0026rdquo; in the search field of the node component addition menu. Select the variables and node components you want to access.  "
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/continuenode.html",
        "title": "Continue",
        "tags": [],
        "description": "",
        "summary": "A type of flow end node.\nMove to the next element in the loop.\nIf the first node is reached, re-execute from the beginning.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    Executing node that accepts  Event nodes ForInt ForLong ForEach FunctionStart  ",
        "content": "A type of flow end node.\nMove to the next element in the loop.\nIf the first node is reached, re-execute from the beginning.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    Executing node that accepts  Event nodes ForInt ForLong ForEach FunctionStart  "
    },
    {
        "uri": "/manual/architecture/nodes/computes.html",
        "title": "Data calculation nodes",
        "tags": [],
        "description": "",
        "summary": "A group of nodes that calculate data and output the results from the DataPort.\nNode types  Compute\nA node that executes ActionComponent with an output DataPort and outputs the result. Get Variable Compute\nThis node obtains the value of the variable of Blackboard and outputs the data.  ",
        "content": "A group of nodes that calculate data and output the results from the DataPort.\nNode types  Compute\nA node that executes ActionComponent with an output DataPort and outputs the result. Get Variable Compute\nThis node obtains the value of the variable of Blackboard and outputs the data.  "
    },
    {
        "uri": "/manual/architecture/ports/inputdataport.html",
        "title": "InputDataPort",
        "tags": [],
        "description": "",
        "summary": "This is an input port for receiving data values from other nodes.\nConnectable wires  DataWire  Supplement The types that can be received vary depending on the field.\nOnly input/output ports of types that can be exchanged can be connected to each other.",
        "content": "This is an input port for receiving data values from other nodes.\nConnectable wires  DataWire  Supplement The types that can be received vary depending on the field.\nOnly input/output ports of types that can be exchanged can be connected to each other.\n"
    },
    {
        "uri": "/manual/architecture/nodes/converts.html",
        "title": "Data conversion nodes",
        "tags": [],
        "description": "",
        "summary": "A group of nodes for converting data.\nWhen connecting DataPorts of different types, a node that supports type conversion is automatically added.\nCommon properties    Property name Type Description     Input port InputField of the input data type Value of the data before conversion   Output port OutputDataPort of the data type to be output Output the converted data value    Node types  Downcast ExplicitNumericConvert GetComponent GetGameObject IListToArray IListToList ToString  ",
        "content": "A group of nodes for converting data.\nWhen connecting DataPorts of different types, a node that supports type conversion is automatically added.\nCommon properties    Property name Type Description     Input port InputField of the input data type Value of the data before conversion   Output port OutputDataPort of the data type to be output Output the converted data value    Node types  Downcast ExplicitNumericConvert GetComponent GetGameObject IListToArray IListToList ToString  "
    },
    {
        "uri": "/manual/architecture/datalink.html",
        "title": "DataLink",
        "tags": [],
        "description": "",
        "summary": "DataLink is a feature for sharing Blackboard Asset between multiple objects.\nIt is built into Logic Controller and has multiple Logic Behavior and [Logic Asset]( Used to reference variables from the same Blackboard Asset from /manual/architecture/objects/logicasset.html).\nMethod of operation In Logic Editor, you can edit Logic Behavior or Logic Asset  and select Blackboard tab in side panel can be operated on the Data Link tab.\nCreate  It can be created using one of the following methods.",
        "content": "DataLink is a feature for sharing Blackboard Asset between multiple objects.\nIt is built into Logic Controller and has multiple Logic Behavior and [Logic Asset]( Used to reference variables from the same Blackboard Asset from /manual/architecture/objects/logicasset.html).\nMethod of operation In Logic Editor, you can edit Logic Behavior or Logic Asset  and select Blackboard tab in side panel can be operated on the Data Link tab.\nCreate  It can be created using one of the following methods.  Click the \u0026ldquo;+\u0026rdquo; button Click inside the list field and press Ctrl + Shift + N key (Win)/command ⌘ + shift ⇧ + N key (Mac) Right-click inside the list field and select \u0026ldquo;Create\u0026rdquo; from the menu   Enter your name Confirm with Enter key  Selection  Click on DataLink in the list When selected, the details column in the right frame will change accordingly.  Rename  Start name input mode Please use one of the following methods to enter input mode. *Right-click on the Data Link and select \u0026ldquo;Rename\u0026rdquo; from the menu *Click the Data Link to make it active, then click it again  Select Data Link and F2 key (Win)/Enter key (Mac)   Enter your name Confirm with Enter key  Delete You can delete it using one of the following methods:\n Right-click the Data Link in the list and select \u0026ldquo;Delete\u0026rdquo; from the menu Select the Data Link in the list and press the Delete key  Settings    Item Description     Share Type Set sharing conditions for your Blackboard instance.GlobalShare across applications.Once created, it remains until it is terminated.SceneShare only within the same scene.It will be released when the current scene changes.Reference CounterShared only between objects that refer to the same instance.It is released when the object it references no longer exists.   Tag Blackboard tag name to share.   Blackboard Asset Set the Blackboard Asset to be shared.    An instance is generated internally during play and shared between DataLinks that match the above settings.\nBlackboard The current instance of the configured Blackboard Asset is displayed.\nFor details, see Blackboard.\n"
    },
    {
        "uri": "/manual/architecture/nodes/flowcontrolls/exitnode.html",
        "title": "Exit",
        "tags": [],
        "description": "",
        "summary": "A type of flow end node. Terminates execution.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    Executing node that accepts  If ForInt ForLong ForEach Parallel  ",
        "content": "A type of flow end node. Terminates execution.\nProperties    Property name Type Description     Input port InputExecutePort Executed by connecting with ExecuteWire or TransitionWire    Executing node that accepts  If ForInt ForLong ForEach Parallel  "
    },
    {
        "uri": "/manual/scripting/nodecomponents/renametype.html",
        "title": "Rename Type",
        "tags": [],
        "description": "",
        "summary": "This section describes renaming the NodeComponent type.\nNodeComponent etc. are designed to be serialized using Unity's SerializeReference.\nSerializeReference is a function that internally stores assembly names, namespaces, and type names, and deserializes based on that information. Because it is referenced by various names, there is a problem that when the name is changed, it cannot be deserialized and the reference becomes disconnected.\nTo avoid data references being broken, you can apply MovedFromAttribute or edit the YAML file directly.",
        "content": "This section describes renaming the NodeComponent type.\nNodeComponent etc. are designed to be serialized using Unity's SerializeReference.\nSerializeReference is a function that internally stores assembly names, namespaces, and type names, and deserializes based on that information. Because it is referenced by various names, there is a problem that when the name is changed, it cannot be deserialized and the reference becomes disconnected.\nTo avoid data references being broken, you can apply MovedFromAttribute or edit the YAML file directly.\nMovedFromAttribute If you change the assembly (asmdef), namespace, or type name, you can notify Unity's serialization function of the type name change by applying MovedFromAttribute to the type.\nCode example 1 2 3 4 5 6 7 8 9 10 11 12  using UnityEngine;\rusing UnityEngine.Scripting.APIUpdating; // Written to use MovedFromAttribute\rusing LogicToolkit;\rnamespace NewNamespace\r{\r[MovedFrom(false, \u0026#34;OldNamespace\u0026#34;, \u0026#34;OldAssembly\u0026#34;, \u0026#34;OldType\u0026#34;)]\rpublic class NewType : ActionComponent\r{\r// Contents\r }\r}\r  Migration process When applying MovedFromAttribute, Unity will automatically perform the migration process if the type is not found when loading data.\nHowever, please note that the changes will not be reflected in the file, so you will need to save it again to save the migrated data.\nIf you want to migrate multiple files at once, please re-serialize the files.\n Be sure to back up your data. Right-click the file or folder you want to migrate from the Project window. Select Logic Toolkit \u0026gt; Force Reserialize from the menu.  This will re-serialize the selected file or all files in the selected folder.\nAs of Unity 2023.2, it is not supported when the generic type or the type used for the generic parameter is changed. See Direct file editing below.\nEdit file If MovedFromAttribute does not work, or if you want to change the assembly or namespace all at once, you can migrate by directly changing the YAML file.　**Please be sure to back up your data before proceeding as editing errors may result in data corruption. **\nSetting Asset Serialization Mode To save scene files etc. in YAML format, you need to configure Project Settings.\n Select Edit \u0026gt; Project Settings from the menu. Select \u0026ldquo;Editor\u0026rdquo; category Set \u0026ldquo;Mode\u0026rdquo; of \u0026ldquo;Asset Serialization\u0026rdquo; to \u0026ldquo;Force Text\u0026rdquo;.  There is no particular problem if it was originally \u0026ldquo;Force Text\u0026rdquo;. If it is other than \u0026ldquo;Force Text\u0026rdquo;, you will need to save the target file again.    Edit YAML file  Open the file you want to change in a text editor. Find references such as:  1 2 3 4 5 6 7  references:\rversion: 2\rRefIds:\r- rid: 2053174280601206785\rtype: {class: OldType, ns: OldNamespace, asm: OldAssembly}\r data:\r...\r  Change to correct information  5  type: {class: NewType, ns: NewNamespace, asm: NewAssembly}\r  If you are not sure how to write the correct information, please create a separate scene that uses the target NodeComponent and check the saved contents.\n"
    },
    {
        "uri": "/manual/architecture/nodes/functions.html",
        "title": "Function graph nodes",
        "tags": [],
        "description": "",
        "summary": "A group of nodes that can be used in Function Graph.\nNode types  Function Start Function Return Function Cancel  ",
        "content": "A group of nodes that can be used in Function Graph.\nNode types  Function Start Function Return Function Cancel  "
    },
    {
        "uri": "/manual/architecture/nodes/organizes.html",
        "title": "Graph organizing nodes",
        "tags": [],
        "description": "",
        "summary": "A group of nodes for organizing the graph.\nNode types  Group Comment Reroute  ",
        "content": "A group of nodes for organizing the graph.\nNode types  Group Comment Reroute  "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Enums/AbortFlags.html",
        "title": "AbortFlags",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit.BehaviorTrees\nDescription Abort flags\nProperties    Property Name Description     Self Abort own node   LowerPriority Aborts a node with a lower priority than the own node, interrupts it, and executes it.    ",
        "content": "Enum in LogicToolkit.BehaviorTrees\nDescription Abort flags\nProperties    Property Name Description     Self Abort own node   LowerPriority Aborts a node with a lower priority than the own node, interrupts it, and executes it.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActionComponent.html",
        "title": "ActionComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: NodeComponent\nDescription A component that performs a process that completes execution in an instant.\nMethods    Method Name Description     OnAction Perform a process that can be completed in an instant    Inherited Members Properties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: NodeComponent\nDescription A component that performs a process that completes execution in an instant.\nMethods    Method Name Description     OnAction Perform a process that can be completed in an instant    Inherited Members Properties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableComponent.html",
        "title": "ActivatableComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: NodeComponent\nDescription Components that switch between active states\nProperties    Property Name Description     IsActive Active or not    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    Inherited Members Properties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: NodeComponent\nDescription Components that switch between active states\nProperties    Property Name Description     IsActive Active or not    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    Inherited Members Properties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableNode.html",
        "title": "ActivatableNode",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Node\nDescription Node whose active state changes\nProperties    Property Name Description     IsActive Active or not    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    Inherited Members Properties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Node\nDescription Node whose active state changes\nProperties    Property Name Description     IsActive Active or not    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    Inherited Members Properties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Enums/SignalExpiration/ActiveNode.html",
        "title": "ActiveNode",
        "tags": [],
        "description": "",
        "summary": "Description Valid while node is active",
        "content": "Description Valid while node is active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/M-Add.html",
        "title": "Add",
        "tags": [],
        "description": "",
        "summary": "Add(VisualElement, FieldPlacement, int) public void Add(VisualElement element, FieldPlacement placement, int order) ;\r\r\rDescription Add UI elements\nParameters    Parameter Name Description     element UI element to add   placement Placement of added field   order Order of fields to add    ",
        "content": "Add(VisualElement, FieldPlacement, int) public void Add(VisualElement element, FieldPlacement placement, int order) ;\r\r\rDescription Add UI elements\nParameters    Parameter Name Description     element UI element to add   placement Placement of added field   order Order of fields to add    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-AddElement.html",
        "title": "AddElement",
        "tags": [],
        "description": "",
        "summary": "AddElement(IValueGetter, IValueGetter) public bool AddElement(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Add element\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element    Returns Returns true if the element is added. otherwise returns false",
        "content": "AddElement(IValueGetter, IValueGetter) public bool AddElement(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Add element\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element    Returns Returns true if the element is added. otherwise returns false\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/M-AddField.html",
        "title": "AddField",
        "tags": [],
        "description": "",
        "summary": "AddField(SerializedProperty, VisualElement) public void AddField(SerializedProperty property, VisualElement field) ;\r\r\rDescription Add property field\nParameters    Parameter Name Description     property Property   field UI element to add    ",
        "content": "AddField(SerializedProperty, VisualElement) public void AddField(SerializedProperty property, VisualElement field) ;\r\r\rDescription Add property field\nParameters    Parameter Name Description     property Property   field UI element to add    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/M-AddIgnoreProperty.html",
        "title": "AddIgnoreProperty",
        "tags": [],
        "description": "",
        "summary": "AddIgnoreProperty(string) protected void AddIgnoreProperty(string propertyPath) ;\r\r\rDescription Add properties to ignore\nParameters    Parameter Name Description     propertyPath Property path    ",
        "content": "AddIgnoreProperty(string) protected void AddIgnoreProperty(string propertyPath) ;\r\r\rDescription Add properties to ignore\nParameters    Parameter Name Description     propertyPath Property path    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenu/M-AddItem.html",
        "title": "AddItem",
        "tags": [],
        "description": "",
        "summary": "AddItem\u0026lt;T\u0026gt;(string, Type) public T AddItem\u0026lt;T\u0026gt;(string menuName, Type localizationTargetType) ;\r\r\rDescription Add menu item\nType Parameters    Type Parameter Name Description Type Constraints     T Menu item type AdvancedMenuItemnew()    Parameters    Parameter Name Description     menuName Menu name   localizationTargetType Target type to be localized    Returns Added menu item\nAddItem\u0026lt;T\u0026gt;(string, string) public T AddItem\u0026lt;T\u0026gt;(string menuName, string localizationGroupName) ;\r\r\rDescription Add menu item",
        "content": "AddItem\u0026lt;T\u0026gt;(string, Type) public T AddItem\u0026lt;T\u0026gt;(string menuName, Type localizationTargetType) ;\r\r\rDescription Add menu item\nType Parameters    Type Parameter Name Description Type Constraints     T Menu item type AdvancedMenuItemnew()    Parameters    Parameter Name Description     menuName Menu name   localizationTargetType Target type to be localized    Returns Added menu item\nAddItem\u0026lt;T\u0026gt;(string, string) public T AddItem\u0026lt;T\u0026gt;(string menuName, string localizationGroupName) ;\r\r\rDescription Add menu item\nType Parameters    Type Parameter Name Description Type Constraints     T Menu item type AdvancedMenuItemnew()    Parameters    Parameter Name Description     menuName Menu name   localizationGroupName Localization group name    Returns Added menu item\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/ComponentMenuCreator/M-AddMenuItem.html",
        "title": "AddMenuItem",
        "tags": [],
        "description": "",
        "summary": "AddMenuItem(string, ITypeMenuContext) protected AdvancedMenuItem AddMenuItem(string menuName, ITypeMenuContext context) ;\r\r\rDescription Parameters    Parameter Name Description     menuName Menu name   context Menu item context    Returns Added menu item",
        "content": "AddMenuItem(string, ITypeMenuContext) protected AdvancedMenuItem AddMenuItem(string menuName, ITypeMenuContext context) ;\r\r\rDescription Parameters    Parameter Name Description     menuName Menu name   context Menu item context    Returns Added menu item\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator/M-AddMenus.html",
        "title": "AddMenus",
        "tags": [],
        "description": "",
        "summary": "AddMenus() protected void AddMenus() ;\r\r\rDescription Called when adding a menu item.",
        "content": "AddMenus() protected void AddMenus() ;\r\r\rDescription Called when adding a menu item.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/M-AddPropertyField.html",
        "title": "AddPropertyField",
        "tags": [],
        "description": "",
        "summary": "AddPropertyField(SerializedProperty, bool) public void AddPropertyField(SerializedProperty property, bool bindProperty) ;\r\r\rDescription Add PropertyField\nParameters    Parameter Name Description     property Property   bindProperty Whether to BindProperty    ",
        "content": "AddPropertyField(SerializedProperty, bool) public void AddPropertyField(SerializedProperty property, bool bindProperty) ;\r\r\rDescription Add PropertyField\nParameters    Parameter Name Description     property Property   bindProperty Whether to BindProperty    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/M-AddPropertyFields.html",
        "title": "AddPropertyFields",
        "tags": [],
        "description": "",
        "summary": "AddPropertyFields(SerializedProperty, bool, string[]) public void AddPropertyFields(SerializedProperty property, bool bindProperty, string[] ignorePaths) ;\r\r\rDescription Add child element of property\nParameters    Parameter Name Description     property Property   bindProperty Whether to BindProperty   ignorePaths Paths of properties to ignore    ",
        "content": "AddPropertyFields(SerializedProperty, bool, string[]) public void AddPropertyFields(SerializedProperty property, bool bindProperty, string[] ignorePaths) ;\r\r\rDescription Add child element of property\nParameters    Parameter Name Description     property Property   bindProperty Whether to BindProperty   ignorePaths Paths of properties to ignore    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenu.html",
        "title": "AdvancedMenu",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Advanced Menu\nMethods    Method Name Description     AddItem Add menu item    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Advanced Menu\nMethods    Method Name Description     AddItem Add menu item    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem.html",
        "title": "AdvancedMenuItem",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nImplements interfaces: System.IComparable\u0026lt;AdvancedMenuItem\u0026gt;\nDescription Items in AdvancedMenu\nFields    Field Name Description     HelpUrl URL of page opened from help button   Keywords Search keyword   Tooltip Tooltip   TypeName Type name   TypeStyleNames Type style name    Methods    Method Name Description     OnBindItem Called when an item is bound to a VisualElement   OnUnbindItem Called when the binding to VisualElement is released    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nImplements interfaces: System.IComparable\u0026lt;AdvancedMenuItem\u0026gt;\nDescription Items in AdvancedMenu\nFields    Field Name Description     HelpUrl URL of page opened from help button   Keywords Search keyword   Tooltip Tooltip   TypeName Type name   TypeStyleNames Type style name    Methods    Method Name Description     OnBindItem Called when an item is bound to a VisualElement   OnUnbindItem Called when the binding to VisualElement is released    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/AllowedTypesAttribute.html",
        "title": "AllowedTypesAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set the types that are allowed to be used.\nConstructors     Description     AllowedTypesAttribute Set the types that are allowed to be used.    Fields    Field Name Description     Types Types that are allowed to be used    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set the types that are allowed to be used.\nConstructors     Description     AllowedTypesAttribute Set the types that are allowed to be used.    Fields    Field Name Description     Types Types that are allowed to be used    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/AllowedTypesAttribute/AllowedTypesAttribute-ctor.html",
        "title": "AllowedTypesAttribute",
        "tags": [],
        "description": "",
        "summary": "AllowedTypesAttribute(Type[]) public AllowedTypesAttribute(Type[] types) ;\r\r\rDescription Set the types that are allowed to be used.\nParameters    Parameter Name Description     types Types that are allowed to be used    ",
        "content": "AllowedTypesAttribute(Type[]) public AllowedTypesAttribute(Type[] types) ;\r\r\rDescription Set the types that are allowed to be used.\nParameters    Parameter Name Description     types Types that are allowed to be used    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/RecomputeMode/Always.html",
        "title": "Always",
        "tags": [],
        "description": "",
        "summary": "Description Always recompute",
        "content": "Description Always recompute\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/FS-ArrowUssClassName.html",
        "title": "ArrowUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string ArrowUssClassName ;\r\r\rDescription USS class name of arrow indicators in elements of this type.",
        "content": "public static string ArrowUssClassName ;\r\r\rDescription USS class name of arrow indicators in elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeField/F-AssemblyFilters.html",
        "title": "AssemblyFilters",
        "tags": [],
        "description": "",
        "summary": "public AssemblySources AssemblyFilters ;\r\r\rDescription Assembly type filters",
        "content": "public AssemblySources AssemblyFilters ;\r\r\rDescription Assembly type filters\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeProperty/P-AssemblyName.html",
        "title": "AssemblyName",
        "tags": [],
        "description": "",
        "summary": "public string AssemblyName ;\r\r\rDescription Assembly name",
        "content": "public string AssemblyName ;\r\r\rDescription Assembly name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/AssemblySources.html",
        "title": "AssemblySources",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit.Editors\nDescription Assembly type flags\nProperties    Property Name Description     None None   Player Player   Package Package   Precompiled Precompiled   UnityEngine UnityEngine   SystemAssembly System    ",
        "content": "Enum in LogicToolkit.Editors\nDescription Assembly type flags\nProperties    Property Name Description     None None   Player Player   Package Package   Precompiled Precompiled   UnityEngine UnityEngine   SystemAssembly System    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayer/P-Asset.html",
        "title": "Asset",
        "tags": [],
        "description": "",
        "summary": "public LogicAsset Asset ;\r\r\rDescription Reference to LogicAsset",
        "content": "public LogicAsset Asset ;\r\r\rDescription Reference to LogicAsset\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AssetInfo.html",
        "title": "AssetInfo",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Asset information\nStatic Fields    Field Name Description     Copyright Copyright   DisplayProductName Product display name   ProductName Product name   Publisher Publisher name   Version Version    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Asset information\nStatic Fields    Field Name Description     Copyright Copyright   DisplayProductName Product display name   ProductName Product name   Publisher Publisher name   Version Version    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/AssetObject.html",
        "title": "AssetObject",
        "tags": [],
        "description": "",
        "summary": "Description Asset objects (Unity objects other than scene objects)",
        "content": "Description Asset objects (Unity objects other than scene objects)\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AsyncOperationComponent-TAsyncOperation-.html",
        "title": "AsyncOperationComponent&lt;TAsyncOperation&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: TaskComponent\nImplements interfaces: IProgressComponent\nDescription Component that waits for AsyncOperation to complete\nType Parameters    Type Parameter Name Description Type Constraints     TAsyncOperation Type of AsyncOperation AsyncOperation    Methods    Method Name Description     Begin Start processing   OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   OnExecute Execute processing.",
        "content": "\r\rClass in LogicToolkit / Inherits from: TaskComponent\nImplements interfaces: IProgressComponent\nDescription Component that waits for AsyncOperation to complete\nType Parameters    Type Parameter Name Description Type Constraints     TAsyncOperation Type of AsyncOperation AsyncOperation    Methods    Method Name Description     Begin Start processing   OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   OnExecute Execute processing.    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Attribute.html",
        "title": "Attribute",
        "tags": [],
        "description": "",
        "summary": "Description Attribute type",
        "content": "Description Attribute type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/ConstantPropertyDrawer/P-Attribute.html",
        "title": "Attribute",
        "tags": [],
        "description": "",
        "summary": "protected ConstantPropertyAttribute Attribute ;\r\r\rDescription Constant property attributes",
        "content": "protected ConstantPropertyAttribute Attribute ;\r\r\rDescription Constant property attributes\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BaseFieldExt-TValueType-/BaseFieldExt-ctor.html",
        "title": "BaseFieldExt",
        "tags": [],
        "description": "",
        "summary": "BaseFieldExt() public BaseFieldExt() ;\r\r\rDescription Constructor\nBaseFieldExt(string) public BaseFieldExt(string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     label Label name    ",
        "content": "BaseFieldExt() public BaseFieldExt() ;\r\r\rDescription Constructor\nBaseFieldExt(string) public BaseFieldExt(string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     label Label name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BaseFieldExt-TValueType-.html",
        "title": "BaseFieldExt&lt;TValueType&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: UnityEngine.UIElements.BaseField\u0026lt;TValueType\u0026gt;\nDescription A class that extends BaseField\u0026lt;TValueType\u0026gt;\nType Parameters    Type Parameter Name Description Type Constraints     TValueType Value type     Constructors     Description     BaseFieldExt Constructor    Properties    Property Name Description     Label Label name   VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: UnityEngine.UIElements.BaseField\u0026lt;TValueType\u0026gt;\nDescription A class that extends BaseField\u0026lt;TValueType\u0026gt;\nType Parameters    Type Parameter Name Description Type Constraints     TValueType Value type     Constructors     Description     BaseFieldExt Constructor    Properties    Property Name Description     Label Label name   VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/BasePopupFieldExt-ctor.html",
        "title": "BasePopupFieldExt",
        "tags": [],
        "description": "",
        "summary": "BasePopupFieldExt() public BasePopupFieldExt() ;\r\r\rDescription Constructor\nBasePopupFieldExt(string) public BasePopupFieldExt(string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     label Label name    ",
        "content": "BasePopupFieldExt() public BasePopupFieldExt() ;\r\r\rDescription Constructor\nBasePopupFieldExt(string) public BasePopupFieldExt(string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     label Label name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-.html",
        "title": "BasePopupFieldExt&lt;TValueType&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit.Editors / Inherits from: BaseFieldExt\u0026lt;TValueType\u0026gt;\nDescription Base class for popup field UI elements\nType Parameters    Type Parameter Name Description Type Constraints     TValueType Value type     Constructors     Description     BasePopupFieldExt Constructor    Methods    Method Name Description     SetValueWithoutNotify Allow changing value without triggering any change event.",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: BaseFieldExt\u0026lt;TValueType\u0026gt;\nDescription Base class for popup field UI elements\nType Parameters    Type Parameter Name Description Type Constraints     TValueType Value type     Constructors     Description     BasePopupFieldExt Constructor    Methods    Method Name Description     SetValueWithoutNotify Allow changing value without triggering any change event.   ShowMenu Show menu    Static Fields    Field Name Description     ArrowUssClassName USS class name of arrow indicators in elements of this type.   IconUssClassName USS class name of icon elements in elements of this type.   InputUssClassName USS class name of input elements in elements of this type.   LabelUssClassName USS class name of labels in elements of this type.   TextUssClassName USS class name of text elements in elements of this type.   UssClassName USS class name of elements of this type.    Inherited Members Properties    Property Name Description     Label Label name   VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeField/P-BaseType.html",
        "title": "BaseType",
        "tags": [],
        "description": "",
        "summary": "public Type BaseType ;\r\r\rDescription Base type",
        "content": "public Type BaseType ;\r\r\rDescription Base type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AsyncOperationComponent-TAsyncOperation-/M-Begin.html",
        "title": "Begin",
        "tags": [],
        "description": "",
        "summary": "Begin() protected TAsyncOperation Begin() ;\r\r\rDescription Start processing\nReturns Return AsyncOperation",
        "content": "Begin() protected TAsyncOperation Begin() ;\r\r\rDescription Start processing\nReturns Return AsyncOperation\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Blackboard.html",
        "title": "Blackboard",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Blackboard to manage Variable\nProperties    Property Name Description     VariablesCount Number of variables    Methods    Method Name Description     GetVariableAt Get the Variable of the index element.   TryGetVariable Get Variable of id.    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Blackboard to manage Variable\nProperties    Property Name Description     VariablesCount Number of variables    Methods    Method Name Description     GetVariableAt Get the Variable of the index element.   TryGetVariable Get Variable of id.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardAsset/P-Blackboard.html",
        "title": "Blackboard",
        "tags": [],
        "description": "",
        "summary": "public Blackboard Blackboard ;\r\r\rDescription Connotation BlackboardAsset.Blackboard",
        "content": "public Blackboard Blackboard ;\r\r\rDescription Connotation BlackboardAsset.Blackboard\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLinkReference/P-Blackboard.html",
        "title": "Blackboard",
        "tags": [],
        "description": "",
        "summary": "public Blackboard Blackboard ;\r\r\rDescription BlackboardDataLinkReference.Blackboard instance",
        "content": "public Blackboard Blackboard ;\r\r\rDescription BlackboardDataLinkReference.Blackboard instance\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicController/P-Blackboard.html",
        "title": "Blackboard",
        "tags": [],
        "description": "",
        "summary": "public Blackboard Blackboard ;\r\r\rDescription Root blackboard",
        "content": "public Blackboard Blackboard ;\r\r\rDescription Root blackboard\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-Blackboard.html",
        "title": "Blackboard",
        "tags": [],
        "description": "",
        "summary": "public Blackboard Blackboard ;\r\r\rDescription Local blackboard linked to node graph",
        "content": "public Blackboard Blackboard ;\r\r\rDescription Local blackboard linked to node graph\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardAsset.html",
        "title": "BlackboardAsset",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: UnityEngine.ScriptableObject\nDescription Asset containing BlackboardAsset.Blackboard.\nMainly used for referencing from BlackboardDataLinkReference and sharing as a data link.\nProperties    Property Name Description     Blackboard Connotation BlackboardAsset.Blackboard    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: UnityEngine.ScriptableObject\nDescription Asset containing BlackboardAsset.Blackboard.\nMainly used for referencing from BlackboardDataLinkReference and sharing as a data link.\nProperties    Property Name Description     Blackboard Connotation BlackboardAsset.Blackboard    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLinkReference/P-BlackboardAsset.html",
        "title": "BlackboardAsset",
        "tags": [],
        "description": "",
        "summary": "public BlackboardAsset BlackboardAsset ;\r\r\rDescription BlackboardDataLinkReference.BlackboardAsset to reference",
        "content": "public BlackboardAsset BlackboardAsset ;\r\r\rDescription BlackboardDataLinkReference.BlackboardAsset to reference\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLink.html",
        "title": "BlackboardDataLink",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Datalinks that share Blackboard between objects\nProperties    Property Name Description     Count Number of BlackboardDataLinkReference   this[int] Returns the BlackboardDataLinkReference stored in index.    Methods    Method Name Description     TryGet Get BlackboardDataLinkReference by specifying id.    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Datalinks that share Blackboard between objects\nProperties    Property Name Description     Count Number of BlackboardDataLinkReference   this[int] Returns the BlackboardDataLinkReference stored in index.    Methods    Method Name Description     TryGet Get BlackboardDataLinkReference by specifying id.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicController/P-BlackboardDataLink.html",
        "title": "BlackboardDataLink",
        "tags": [],
        "description": "",
        "summary": "public BlackboardDataLink BlackboardDataLink ;\r\r\rDescription Blackboard data link",
        "content": "public BlackboardDataLink BlackboardDataLink ;\r\r\rDescription Blackboard data link\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLinkReference.html",
        "title": "BlackboardDataLinkReference",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Data link reference information for BlackboardDataLinkReference.Blackboard\nProperties    Property Name Description     Blackboard BlackboardDataLinkReference.Blackboard instance   BlackboardAsset BlackboardDataLinkReference.BlackboardAsset to reference   Id ID   Name Name   ShareType Share type   Tag Tag    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Data link reference information for BlackboardDataLinkReference.Blackboard\nProperties    Property Name Description     Blackboard BlackboardDataLinkReference.Blackboard instance   BlackboardAsset BlackboardDataLinkReference.BlackboardAsset to reference   Id ID   Name Name   ShareType Share type   Tag Tag    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardDataLinkShareType.html",
        "title": "BlackboardDataLinkShareType",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription How to share the Blackboard instance referenced from BlackboardDataLinkReference\nProperties    Property Name Description     Global Share globally. Instances are never released and are always shared until the application terminates.   Scene Share within a scene. Instances are released when a scene is unloaded, and data is not inherited across scenes.   ReferenceCounter Shared using reference counter method. Released when there are no more references to the same instance.",
        "content": "Enum in LogicToolkit\nDescription How to share the Blackboard instance referenced from BlackboardDataLinkReference\nProperties    Property Name Description     Global Share globally. Instances are never released and are always shared until the application terminates.   Scene Share within a scene. Instances are released when a scene is unloaded, and data is not inherited across scenes.   ReferenceCounter Shared using reference counter method. Released when there are no more references to the same instance.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardSource.html",
        "title": "BlackboardSource",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Reference source of Blackboard\nProperties    Property Name Description     Root Root   Local Local   DataLink Data Link    ",
        "content": "Enum in LogicToolkit\nDescription Reference source of Blackboard\nProperties    Property Name Description     Root Root   Local Local   DataLink Data Link    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/FieldPlacement/Bottom.html",
        "title": "Bottom",
        "tags": [],
        "description": "",
        "summary": "Description Bottom side",
        "content": "Description Bottom side\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/FS-BottomViewUssClassName.html",
        "title": "BottomViewUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string BottomViewUssClassName ;\r\r\rDescription Bottom view USS class name",
        "content": "public static string BottomViewUssClassName ;\r\r\rDescription Bottom view USS class name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BreakNode.html",
        "title": "BreakNode",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to exit from the loop\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.",
        "content": "\r\rClass in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to exit from the loop\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/M-BuildFields.html",
        "title": "BuildFields",
        "tags": [],
        "description": "",
        "summary": "BuildFields() public void BuildFields() ;\r\r\rDescription Build the field",
        "content": "BuildFields() public void BuildFields() ;\r\r\rDescription Build the field\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ByteLerp.html",
        "title": "ByteLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;byte\u0026gt;\nDescription Linear interpolation of type byte\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;byte\u0026gt;\nDescription Linear interpolation of type byte\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/CharLerp.html",
        "title": "CharLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;char\u0026gt;\nDescription Linear interpolation of type char\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;char\u0026gt;\nDescription Linear interpolation of type char\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Class.html",
        "title": "Class",
        "tags": [],
        "description": "",
        "summary": "Description Class",
        "content": "Description Class\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-Clear.html",
        "title": "Clear",
        "tags": [],
        "description": "",
        "summary": "Clear(IValueGetter) public void Clear(IValueGetter listGetter) ;\r\r\rDescription Clear the list elements\nParameters    Parameter Name Description     listGetter Instance to get list    ",
        "content": "Clear(IValueGetter) public void Clear(IValueGetter listGetter) ;\r\r\rDescription Clear the list elements\nParameters    Parameter Name Description     listGetter Instance to get list    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ColorLerp.html",
        "title": "ColorLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Color\u0026gt;\nDescription Linear interpolation of type Color\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Color\u0026gt;\nDescription Linear interpolation of type Color\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantGradientUsageAttribute/F-ColorSpace.html",
        "title": "ColorSpace",
        "tags": [],
        "description": "",
        "summary": "public ColorSpace ColorSpace ;\r\r\rDescription Color space used in Gradient",
        "content": "public ColorSpace ColorSpace ;\r\r\rDescription Color space used in Gradient\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/CompareUtility/MS-Compare.html",
        "title": "Compare",
        "tags": [],
        "description": "",
        "summary": "Compare\u0026lt;T\u0026gt;(T, T, ComparisonOp) public static bool Compare\u0026lt;T\u0026gt;(T a, T b, ComparisonOp comparisonOp) ;\r\r\rDescription Compare values\nType Parameters    Type Parameter Name Description Type Constraints     T Type of value to compare IComparable\u0026lt;T\u0026gt;    Parameters    Parameter Name Description     a Value on left side to compare   b Right-hand value to compare   comparisonOp Comparison operator    Returns Comparison result",
        "content": "Compare\u0026lt;T\u0026gt;(T, T, ComparisonOp) public static bool Compare\u0026lt;T\u0026gt;(T a, T b, ComparisonOp comparisonOp) ;\r\r\rDescription Compare values\nType Parameters    Type Parameter Name Description Type Constraints     T Type of value to compare IComparable\u0026lt;T\u0026gt;    Parameters    Parameter Name Description     a Value on left side to compare   b Right-hand value to compare   comparisonOp Comparison operator    Returns Comparison result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/CompareUtility.html",
        "title": "CompareUtility",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Utility class for value comparisons\nStatic Methods    Method Name Description     Compare Compare values    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Utility class for value comparisons\nStatic Methods    Method Name Description     Compare Compare values    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/ComparisonOp.html",
        "title": "ComparisonOp",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Comparison operator\nProperties    Property Name Description     Equals Equals   NotEquals Not Equals   GreaterThan Greater than   GreaterThanOrEqual Greater than or equal   LessThan Less than   LessThanOrEqual Less than or equal    ",
        "content": "Enum in LogicToolkit\nDescription Comparison operator\nProperties    Property Name Description     Equals Equals   NotEquals Not Equals   GreaterThan Greater than   GreaterThanOrEqual Greater than or equal   LessThan Less than   LessThanOrEqual Less than or equal    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/CompleteNode.html",
        "title": "CompleteNode",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to complete the task\nProperties    Property Name Description     Result Result    Inherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.",
        "content": "\r\rClass in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to complete the task\nProperties    Property Name Description     Result Result    Inherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/RecomputeMode/Component.html",
        "title": "Component",
        "tags": [],
        "description": "",
        "summary": "Description Recompute when execution components are different",
        "content": "Description Recompute when execution components are different\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ComponentConstantContainer-T-/ComponentConstantContainer-ctor.html",
        "title": "ComponentConstantContainer",
        "tags": [],
        "description": "",
        "summary": "ComponentConstantContainer() public ComponentConstantContainer() ;\r\r\rDescription Container for constants of type Component\nComponentConstantContainer(T) public ComponentConstantContainer(T value) ;\r\r\rDescription Container for constants of type Component\nParameters    Parameter Name Description     value Constant value    ",
        "content": "ComponentConstantContainer() public ComponentConstantContainer() ;\r\r\rDescription Container for constants of type Component\nComponentConstantContainer(T) public ComponentConstantContainer(T value) ;\r\r\rDescription Container for constants of type Component\nParameters    Parameter Name Description     value Constant value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ComponentConstantContainer-T-.html",
        "title": "ComponentConstantContainer&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ConstantContainer\u0026lt;T\u0026gt;\nDescription Container for constants of type Component\nType Parameters    Type Parameter Name Description Type Constraints     T Component type Component    Constructors     Description     ComponentConstantContainer Container for constants of type Component    Properties    Property Name Description     Value Constant value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ConstantContainer\u0026lt;T\u0026gt;\nDescription Container for constants of type Component\nType Parameters    Type Parameter Name Description Type Constraints     T Component type Component    Constructors     Description     ComponentConstantContainer Container for constants of type Component    Properties    Property Name Description     Value Constant value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/ComponentMenuCreator.html",
        "title": "ComponentMenuCreator",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit.Editors / Inherits from: TypeMenuCreator Description Class that creates items for the node component selection menu Methods Method Name Description AddMenuItem Inherited Members Properties Property Name Description Connectable Whether connection is possible FieldAssignor Data to assign to field GraphEditor Graph Editor Menu Menu Type Target type Methods Method Name Description AddMenus Called when adding a menu item. IsAcceptableAssignor フィールドの割り当て",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: TypeMenuCreator\nDescription Class that creates items for the node component selection menu\nMethods    Method Name Description     AddMenuItem     Inherited Members Properties    Property Name Description     Connectable Whether connection is possible   FieldAssignor Data to assign to field   GraphEditor Graph Editor   Menu Menu   Type Target type    Methods    Method Name Description     AddMenus Called when adding a menu item.   IsAcceptableAssignor フィールドの割り当てを許可できるかを判定する    "
    },
    {
        "uri": "/manual/architecture/nodes/computes/computenode.html",
        "title": "Compute",
        "tags": [],
        "description": "",
        "summary": "Compute is a node that executes ActionComponent with an output DataPort and outputs the result.\nProcesses and returns the result when the output port's connected node attempts to obtain a value.\nBy setting the recalculation mode, you can reduce the number of processing times and reduce the load.\nProperties    Property name Type Description     Recompute Mode(drop-down on the right side of the node header) RecomputeMode Setting the recompute mode.",
        "content": "Compute is a node that executes ActionComponent with an output DataPort and outputs the result.\nProcesses and returns the result when the output port's connected node attempts to obtain a value.\nBy setting the recalculation mode, you can reduce the number of processing times and reduce the load.\nProperties    Property name Type Description     Recompute Mode(drop-down on the right side of the node header) RecomputeMode Setting the recompute mode. DirtyRecalculate when the data received by the input port has been updatedFramePreviously calculated frame and current frame Recalculate if different NodeRecalculate if the destination node of the output port is differentComponentOutput port Recalculate when the connected node component is differentAlwaysAlways recalculate    Supported node components  ActionComponent Processing is executed when data output is required.\nOnly ActionComponents with output DataPorts can be used. EvaluateComponent Processing is executed when data output is required.\nOutputs the result in bool type.  "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ComputeNodeBase.html",
        "title": "ComputeNodeBase",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Node\nDescription Base class for compute nodes\nMethods    Method Name Description     OnAfterDeserialize Called after deserialization   OnBeforeSerialize Called before serialization    Inherited Members Properties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Node\nDescription Base class for compute nodes\nMethods    Method Name Description     OnAfterDeserialize Called after deserialization   OnBeforeSerialize Called before serialization    Inherited Members Properties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BaseFieldExt-TValueType-/M-ConfigureField.html",
        "title": "ConfigureField",
        "tags": [],
        "description": "",
        "summary": "ConfigureField(string, SerializedProperty) public void ConfigureField(string label, SerializedProperty property) ;\r\r\rDescription Configure fields\nParameters    Parameter Name Description     label Label name   property Property    ",
        "content": "ConfigureField(string, SerializedProperty) public void ConfigureField(string label, SerializedProperty property) ;\r\r\rDescription Configure fields\nParameters    Parameter Name Description     label Label name   property Property    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IConnectPortToComponentContext/M-Connect.html",
        "title": "Connect",
        "tags": [],
        "description": "",
        "summary": "Connect(NodeEditor, SerializedProperty, PortFieldAssignor) public bool Connect(NodeEditor nodeEditor, SerializedProperty componentProperty, PortFieldAssignor portFieldAssignor) ;\r\r\rDescription Connect to the port being dragged when the node component is created\nParameters    Parameter Name Description     nodeEditor Node Editor   componentProperty NodeComponent property   portFieldAssignor Port assignment    Returns Returns true if connected. If not, return false.",
        "content": "Connect(NodeEditor, SerializedProperty, PortFieldAssignor) public bool Connect(NodeEditor nodeEditor, SerializedProperty componentProperty, PortFieldAssignor portFieldAssignor) ;\r\r\rDescription Connect to the port being dragged when the node component is created\nParameters    Parameter Name Description     nodeEditor Node Editor   componentProperty NodeComponent property   portFieldAssignor Port assignment    Returns Returns true if connected. If not, return false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator/P-Connectable.html",
        "title": "Connectable",
        "tags": [],
        "description": "",
        "summary": "public bool Connectable ;\r\r\rDescription Whether connection is possible",
        "content": "public bool Connectable ;\r\r\rDescription Whether connection is possible\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-ConnectableWireTypes.html",
        "title": "ConnectableWireTypes",
        "tags": [],
        "description": "",
        "summary": "public Type[] ConnectableWireTypes ;\r\r\rDescription Connectable wire types",
        "content": "public Type[] ConnectableWireTypes ;\r\r\rDescription Connectable wire types\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputPort/P-ConnectedWiresCount.html",
        "title": "ConnectedWiresCount",
        "tags": [],
        "description": "",
        "summary": "public int ConnectedWiresCount ;\r\r\rDescription Number of connected wires",
        "content": "public int ConnectedWiresCount ;\r\r\rDescription Number of connected wires\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IOutputPort/P-ConnectedWiresCount.html",
        "title": "ConnectedWiresCount",
        "tags": [],
        "description": "",
        "summary": "public int ConnectedWiresCount ;\r\r\rDescription Number of connected wires",
        "content": "public int ConnectedWiresCount ;\r\r\rDescription Number of connected wires\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Port/P-ConnectedWiresCount.html",
        "title": "ConnectedWiresCount",
        "tags": [],
        "description": "",
        "summary": "public int ConnectedWiresCount ;\r\r\rDescription Number of connected wires",
        "content": "public int ConnectedWiresCount ;\r\r\rDescription Number of connected wires\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-ConnectorPortType.html",
        "title": "ConnectorPortType",
        "tags": [],
        "description": "",
        "summary": "public PortType ConnectorPortType ;\r\r\rDescription Type of port to connect",
        "content": "public PortType ConnectorPortType ;\r\r\rDescription Type of port to connect\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantColorUsageAttribute.html",
        "title": "ConstantColorUsageAttribute",
        "tags": [],
        "description": "",
        "summary": "Attribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.\nConstructors     Description     ConstantColorUsageAttribute Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.    Fields    Field Name Description     Hdr If set to true the Color is treated as a HDR color.",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.\nConstructors     Description     ConstantColorUsageAttribute Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.    Fields    Field Name Description     Hdr If set to true the Color is treated as a HDR color.   ShowAlpha If set to true, the alpha value will be displayed.    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantColorUsageAttribute/ConstantColorUsageAttribute-ctor.html",
        "title": "ConstantColorUsageAttribute",
        "tags": [],
        "description": "",
        "summary": "ConstantColorUsageAttribute(bool) public ConstantColorUsageAttribute(bool showAlpha) ;\r\r\rDescription Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.\nParameters    Parameter Name Description     showAlpha If set to true, the alpha value will be displayed.    ConstantColorUsageAttribute(bool, bool) public ConstantColorUsageAttribute(bool showAlpha, bool hdr) ;\r\r\rDescription Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.",
        "content": "ConstantColorUsageAttribute(bool) public ConstantColorUsageAttribute(bool showAlpha) ;\r\r\rDescription Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.\nParameters    Parameter Name Description     showAlpha If set to true, the alpha value will be displayed.    ConstantColorUsageAttribute(bool, bool) public ConstantColorUsageAttribute(bool showAlpha, bool hdr) ;\r\r\rDescription Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.\nParameters    Parameter Name Description     showAlpha If set to true, the alpha value will be displayed.   hdr If set to true the Color is treated as a HDR color.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ConstantContainer-T-/ConstantContainer-ctor.html",
        "title": "ConstantContainer",
        "tags": [],
        "description": "",
        "summary": "ConstantContainer() public ConstantContainer() ;\r\r\rDescription Constructor\nConstantContainer(T) public ConstantContainer(T value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    ",
        "content": "ConstantContainer() public ConstantContainer() ;\r\r\rDescription Constructor\nConstantContainer(T) public ConstantContainer(T value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ConstantContainer-T-.html",
        "title": "ConstantContainer&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Constant container\nType Parameters    Type Parameter Name Description Type Constraints     T Constant type     Constructors     Description     ConstantContainer Constructor    Properties    Property Name Description     Value Constant value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Constant container\nType Parameters    Type Parameter Name Description Type Constraints     T Constant type     Constructors     Description     ConstantContainer Constructor    Properties    Property Name Description     Value Constant value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantDelayedAttribute.html",
        "title": "ConstantDelayedAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attribute that delays the finalization of constant changes.\nIf this attribute is applied, constant changes will not be committed until the user presses the enter key or takes focus from the field.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;, InputField\u0026lt;string\u0026gt;.\nInherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attribute that delays the finalization of constant changes.\nIf this attribute is applied, constant changes will not be committed until the user presses the enter key or takes focus from the field.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;, InputField\u0026lt;string\u0026gt;.\nInherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantGradientUsageAttribute.html",
        "title": "ConstantGradientUsageAttribute",
        "tags": [],
        "description": "",
        "summary": "Attribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.\nConstructors     Description     ConstantGradientUsageAttribute Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.    Fields    Field Name Description     ColorSpace Color space used in Gradient   Hdr If set to true the Color is treated as a HDR color.",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.\nConstructors     Description     ConstantGradientUsageAttribute Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.    Fields    Field Name Description     ColorSpace Color space used in Gradient   Hdr If set to true the Color is treated as a HDR color.    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantGradientUsageAttribute/ConstantGradientUsageAttribute-ctor.html",
        "title": "ConstantGradientUsageAttribute",
        "tags": [],
        "description": "",
        "summary": "ConstantGradientUsageAttribute(bool) public ConstantGradientUsageAttribute(bool hdr) ;\r\r\rDescription Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.\nParameters    Parameter Name Description     hdr If set to true the Color is treated as a HDR color.    ConstantGradientUsageAttribute(bool, ColorSpace) public ConstantGradientUsageAttribute(bool hdr, ColorSpace colorSpace) ;\r\r\rDescription Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.",
        "content": "ConstantGradientUsageAttribute(bool) public ConstantGradientUsageAttribute(bool hdr) ;\r\r\rDescription Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.\nParameters    Parameter Name Description     hdr If set to true the Color is treated as a HDR color.    ConstantGradientUsageAttribute(bool, ColorSpace) public ConstantGradientUsageAttribute(bool hdr, ColorSpace colorSpace) ;\r\r\rDescription Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.\nParameters    Parameter Name Description     hdr If set to true the Color is treated as a HDR color.   colorSpace Color space used in Gradient    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantMinAttribute.html",
        "title": "ConstantMinAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nConstructors     Description     ConstantMinAttribute Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.    Fields    Field Name Description     Min Minimum value allowed    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nConstructors     Description     ConstantMinAttribute Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.    Fields    Field Name Description     Min Minimum value allowed    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantMinAttribute/ConstantMinAttribute-ctor.html",
        "title": "ConstantMinAttribute",
        "tags": [],
        "description": "",
        "summary": "ConstantMinAttribute(float) public ConstantMinAttribute(float min) ;\r\r\rDescription Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nParameters    Parameter Name Description     min Minimum value allowed    ",
        "content": "ConstantMinAttribute(float) public ConstantMinAttribute(float min) ;\r\r\rDescription Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nParameters    Parameter Name Description     min Minimum value allowed    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantPropertyAttribute.html",
        "title": "ConstantPropertyAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription The base type of an attribute that, when applied to a field in InputField\u0026lt;T\u0026gt;, sets the configuration of a field of constant values.\nProperties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription The base type of an attribute that, when applied to a field in InputField\u0026lt;T\u0026gt;, sets the configuration of a field of constant values.\nProperties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/ConstantPropertyDrawer.html",
        "title": "ConstantPropertyDrawer",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription A base type that extends the representation of constant fields in InputField\u0026lt;T\u0026gt;\nProperties    Property Name Description     Attribute Constant property attributes   FieldInfo FieldInfo for constant fields   ParentFieldInfo FieldInfo for a field of type InputField    Methods    Method Name Description     CreateElement Create UI elements    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription A base type that extends the representation of constant fields in InputField\u0026lt;T\u0026gt;\nProperties    Property Name Description     Attribute Constant property attributes   FieldInfo FieldInfo for constant fields   ParentFieldInfo FieldInfo for a field of type InputField    Methods    Method Name Description     CreateElement Create UI elements    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantRangeAttribute.html",
        "title": "ConstantRangeAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nConstructors     Description     ConstantRangeAttribute Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.    Fields    Field Name Description     Max Maximum value   Min Minimum value    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nConstructors     Description     ConstantRangeAttribute Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.    Fields    Field Name Description     Max Maximum value   Min Minimum value    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantRangeAttribute/ConstantRangeAttribute-ctor.html",
        "title": "ConstantRangeAttribute",
        "tags": [],
        "description": "",
        "summary": "ConstantRangeAttribute(float, float) public ConstantRangeAttribute(float min, float max) ;\r\r\rDescription Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nParameters    Parameter Name Description     min Minimum value   max Maximum value    ",
        "content": "ConstantRangeAttribute(float, float) public ConstantRangeAttribute(float min, float max) ;\r\r\rDescription Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.\nParameters    Parameter Name Description     min Minimum value   max Maximum value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantTextAreaAttribute.html",
        "title": "ConstantTextAreaAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.\nConstructors     Description     ConstantTextAreaAttribute An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.    Fields    Field Name Description     MaxLines Maximum number of lines   MinLines Minimum number of lines    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: ConstantPropertyAttribute\nDescription An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.\nConstructors     Description     ConstantTextAreaAttribute An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.    Fields    Field Name Description     MaxLines Maximum number of lines   MinLines Minimum number of lines    Inherited Members Properties    Property Name Description     Order Specify the order in which multiple ConstantPropertyAttribute are drawn    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantTextAreaAttribute/ConstantTextAreaAttribute-ctor.html",
        "title": "ConstantTextAreaAttribute",
        "tags": [],
        "description": "",
        "summary": "ConstantTextAreaAttribute() public ConstantTextAreaAttribute() ;\r\r\rDescription An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.\nConstantTextAreaAttribute(int, int) public ConstantTextAreaAttribute(int minLines, int maxLines) ;\r\r\rDescription An attribute that allows you to edit multi-line strings.Can be applied to fields in InputField\u0026lt;string\u0026gt;.\nParameters    Parameter Name Description     minLines Minimum number of lines   maxLines Maximum number of lines    ",
        "content": "ConstantTextAreaAttribute() public ConstantTextAreaAttribute() ;\r\r\rDescription An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.\nConstantTextAreaAttribute(int, int) public ConstantTextAreaAttribute(int minLines, int maxLines) ;\r\r\rDescription An attribute that allows you to edit multi-line strings.Can be applied to fields in InputField\u0026lt;string\u0026gt;.\nParameters    Parameter Name Description     minLines Minimum number of lines   maxLines Maximum number of lines    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-Contains.html",
        "title": "Contains",
        "tags": [],
        "description": "",
        "summary": "Contains(IValueGetter, IValueGetter) public bool Contains(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Determine if the element is included\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element value    Returns Returns true if the element is included. Otherwise returns false.",
        "content": "Contains(IValueGetter, IValueGetter) public bool Contains(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Determine if the element is included\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element value    Returns Returns true if the element is included. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ContinueNode.html",
        "title": "ContinueNode",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to transition to next loop\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.",
        "content": "\r\rClass in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to transition to next loop\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ConvertNode/M-Convert.html",
        "title": "Convert",
        "tags": [],
        "description": "",
        "summary": "Convert(IInputDataPort, IOutputDataPort) protected void Convert(IInputDataPort input, IOutputDataPort output) ;\r\r\rDescription Convert data types\nParameters    Parameter Name Description     input Input data port   output Output data port    ",
        "content": "Convert(IInputDataPort, IOutputDataPort) protected void Convert(IInputDataPort input, IOutputDataPort output) ;\r\r\rDescription Convert data types\nParameters    Parameter Name Description     input Input data port   output Output data port    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ConvertNode.html",
        "title": "ConvertNode",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ComputeNodeBase\nDescription Node that converts data type\nMethods    Method Name Description     Convert Convert data types    Inherited Members Properties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnAfterDeserialize Called after deserialization   OnBeforeSerialize Called before serialization    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ComputeNodeBase\nDescription Node that converts data type\nMethods    Method Name Description     Convert Convert data types    Inherited Members Properties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnAfterDeserialize Called after deserialization   OnBeforeSerialize Called before serialization    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortFieldAssignor/P-ConvertNodePos.html",
        "title": "ConvertNodePos",
        "tags": [],
        "description": "",
        "summary": "public Vector2 ConvertNodePos ;\r\r\rDescription Transform node position",
        "content": "public Vector2 ConvertNodePos ;\r\r\rDescription Transform node position\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AssetInfo/FS-Copyright.html",
        "title": "Copyright",
        "tags": [],
        "description": "",
        "summary": "public static string Copyright ;\r\r\rDescription Copyright",
        "content": "public static string Copyright ;\r\r\rDescription Copyright\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-Count.html",
        "title": "Count",
        "tags": [],
        "description": "",
        "summary": "Count(IValueGetter) public int Count(IValueGetter listGetter) ;\r\r\rDescription Count the number of elements in the list.\nParameters    Parameter Name Description     listGetter Instance to get list    Returns Number of elements in list",
        "content": "Count(IValueGetter) public int Count(IValueGetter listGetter) ;\r\r\rDescription Count the number of elements in the list.\nParameters    Parameter Name Description     listGetter Instance to get list    Returns Number of elements in list\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLink/P-Count.html",
        "title": "Count",
        "tags": [],
        "description": "",
        "summary": "public int Count ;\r\r\rDescription Number of BlackboardDataLinkReference",
        "content": "public int Count ;\r\r\rDescription Number of BlackboardDataLinkReference\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/GraphEditor/M-CreateConvertNodeIfNesessaryAndConnectWire.html",
        "title": "CreateConvertNodeIfNesessaryAndConnectWire",
        "tags": [],
        "description": "",
        "summary": "CreateConvertNodeIfNesessaryAndConnectWire(PortConnector, PortConnector, Vector2) public void CreateConvertNodeIfNesessaryAndConnectWire(PortConnector outputPortConnector, PortConnector inputPortConnector, Vector2 convertNodePos) ;\r\r\rDescription Create data convert nodes and connect ports as needed\nParameters    Parameter Name Description     outputPortConnector Output port connection data   inputPortConnector Input port connection data   convertNodePos Position to create convert node    ",
        "content": "CreateConvertNodeIfNesessaryAndConnectWire(PortConnector, PortConnector, Vector2) public void CreateConvertNodeIfNesessaryAndConnectWire(PortConnector outputPortConnector, PortConnector inputPortConnector, Vector2 convertNodePos) ;\r\r\rDescription Create data convert nodes and connect ports as needed\nParameters    Parameter Name Description     outputPortConnector Output port connection data   inputPortConnector Input port connection data   convertNodePos Position to create convert node    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/ConstantPropertyDrawer/M-CreateElement.html",
        "title": "CreateElement",
        "tags": [],
        "description": "",
        "summary": "CreateElement(SerializedProperty, string, string) public VisualElement CreateElement(SerializedProperty property, string label, string tooltip) ;\r\r\rDescription Create UI elements\nParameters    Parameter Name Description     property Property   label Label name   tooltip Tooltip    Returns Returns the created UI element.",
        "content": "CreateElement(SerializedProperty, string, string) public VisualElement CreateElement(SerializedProperty property, string label, string tooltip) ;\r\r\rDescription Create UI elements\nParameters    Parameter Name Description     property Property   label Label name   tooltip Tooltip    Returns Returns the created UI element.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/InputFieldElementUtility/MS-CreateElement.html",
        "title": "CreateElement",
        "tags": [],
        "description": "",
        "summary": "CreateElement(SerializedProperty, Type, string) public static InputFieldElementBase CreateElement(SerializedProperty property, Type inputType, string label) ;\r\r\rDescription Create UI element for InputField\nParameters    Parameter Name Description     property Property   inputType Input field type   label Label name    Returns UI element of created InputField",
        "content": "CreateElement(SerializedProperty, Type, string) public static InputFieldElementBase CreateElement(SerializedProperty property, Type inputType, string label) ;\r\r\rDescription Create UI element for InputField\nParameters    Parameter Name Description     property Property   inputType Input field type   label Label name    Returns UI element of created InputField\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/M-CreateElement.html",
        "title": "CreateElement",
        "tags": [],
        "description": "",
        "summary": "CreateElement() public VisualElement CreateElement() ;\r\r\rDescription Create UI elements\nReturns Created UI element",
        "content": "CreateElement() public VisualElement CreateElement() ;\r\r\rDescription Create UI elements\nReturns Created UI element\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ProgressPlayer/P-CurrentProgress.html",
        "title": "CurrentProgress",
        "tags": [],
        "description": "",
        "summary": "public float CurrentProgress ;\r\r\rDescription Current progress",
        "content": "public float CurrentProgress ;\r\r\rDescription Current progress\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomAttribute.html",
        "title": "CustomAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit.Editors / Inherits from: System.Attribute\nDescription Basic type of attributes for editor extension\nConstructors     Description     CustomAttribute Constructor    Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    ",
        "content": "\r\rAttribute in LogicToolkit.Editors / Inherits from: System.Attribute\nDescription Basic type of attributes for editor extension\nConstructors     Description     CustomAttribute Constructor    Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomAttribute/CustomAttribute-ctor.html",
        "title": "CustomAttribute",
        "tags": [],
        "description": "",
        "summary": "CustomAttribute(Type) public CustomAttribute(Type inspectedType) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     inspectedType Target type    CustomAttribute(Type, bool) public CustomAttribute(Type inspectedType, bool useForChildren) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use for derived classes as well    ",
        "content": "CustomAttribute(Type) public CustomAttribute(Type inspectedType) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     inspectedType Target type    CustomAttribute(Type, bool) public CustomAttribute(Type inspectedType, bool useForChildren) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use for derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomNodeComponentEditor.html",
        "title": "CustomNodeComponentEditor",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit.Editors / Inherits from: CustomAttribute\nDescription Attributes that extend the editor of NodeComponent by applying them to NodeComponentEditor\nConstructors     Description     CustomNodeComponentEditor Extend the editor for NodeComponent    Inherited Members Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    ",
        "content": "\r\rAttribute in LogicToolkit.Editors / Inherits from: CustomAttribute\nDescription Attributes that extend the editor of NodeComponent by applying them to NodeComponentEditor\nConstructors     Description     CustomNodeComponentEditor Extend the editor for NodeComponent    Inherited Members Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomNodeComponentEditor/CustomNodeComponentEditor-ctor.html",
        "title": "CustomNodeComponentEditor",
        "tags": [],
        "description": "",
        "summary": "CustomNodeComponentEditor(Type) public CustomNodeComponentEditor(Type inspectedType) ;\r\r\rDescription Extend the editor for NodeComponent\nParameters    Parameter Name Description     inspectedType Target type    CustomNodeComponentEditor(Type, bool) public CustomNodeComponentEditor(Type inspectedType, bool useForChildren) ;\r\r\rDescription Extend the editor for NodeComponent\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use for derived classes as well    ",
        "content": "CustomNodeComponentEditor(Type) public CustomNodeComponentEditor(Type inspectedType) ;\r\r\rDescription Extend the editor for NodeComponent\nParameters    Parameter Name Description     inspectedType Target type    CustomNodeComponentEditor(Type, bool) public CustomNodeComponentEditor(Type inspectedType, bool useForChildren) ;\r\r\rDescription Extend the editor for NodeComponent\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use for derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomNodeEditor.html",
        "title": "CustomNodeEditor",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit.Editors / Inherits from: CustomAttribute\nDescription Attributes that extend the editor of Node by applying them to NodeEditor\nConstructors     Description     CustomNodeEditor Extend the editor for Node    Inherited Members Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    ",
        "content": "\r\rAttribute in LogicToolkit.Editors / Inherits from: CustomAttribute\nDescription Attributes that extend the editor of Node by applying them to NodeEditor\nConstructors     Description     CustomNodeEditor Extend the editor for Node    Inherited Members Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomNodeEditor/CustomNodeEditor-ctor.html",
        "title": "CustomNodeEditor",
        "tags": [],
        "description": "",
        "summary": "CustomNodeEditor(Type) public CustomNodeEditor(Type inspectedType) ;\r\r\rDescription Extend the editor for Node\nParameters    Parameter Name Description     inspectedType Target type    CustomNodeEditor(Type, bool) public CustomNodeEditor(Type inspectedType, bool useForChildren) ;\r\r\rDescription Extend the editor for Node\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use for derived classes as well    ",
        "content": "CustomNodeEditor(Type) public CustomNodeEditor(Type inspectedType) ;\r\r\rDescription Extend the editor for Node\nParameters    Parameter Name Description     inspectedType Target type    CustomNodeEditor(Type, bool) public CustomNodeEditor(Type inspectedType, bool useForChildren) ;\r\r\rDescription Extend the editor for Node\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use for derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomTypeMenuCreator.html",
        "title": "CustomTypeMenuCreator",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit.Editors / Inherits from: CustomAttribute\nDescription Attribute that extends the script selection menu by applying it to TypeMenuCreator.\nConstructors     Description     CustomTypeMenuCreator Extend the script selection menu    Inherited Members Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    ",
        "content": "\r\rAttribute in LogicToolkit.Editors / Inherits from: CustomAttribute\nDescription Attribute that extends the script selection menu by applying it to TypeMenuCreator.\nConstructors     Description     CustomTypeMenuCreator Extend the script selection menu    Inherited Members Fields    Field Name Description     InspectedType Target type   UseForChildren Whether to use for derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomTypeMenuCreator/CustomTypeMenuCreator-ctor.html",
        "title": "CustomTypeMenuCreator",
        "tags": [],
        "description": "",
        "summary": "CustomTypeMenuCreator(Type) public CustomTypeMenuCreator(Type inspectedType) ;\r\r\rDescription Extend the script selection menu\nParameters    Parameter Name Description     inspectedType Target type    CustomTypeMenuCreator(Type, bool) public CustomTypeMenuCreator(Type inspectedType, bool useForChildren) ;\r\r\rDescription Extend the script selection menu\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use it in derived classes as well    ",
        "content": "CustomTypeMenuCreator(Type) public CustomTypeMenuCreator(Type inspectedType) ;\r\r\rDescription Extend the script selection menu\nParameters    Parameter Name Description     inspectedType Target type    CustomTypeMenuCreator(Type, bool) public CustomTypeMenuCreator(Type inspectedType, bool useForChildren) ;\r\r\rDescription Extend the script selection menu\nParameters    Parameter Name Description     inspectedType Target type   useForChildren Whether to use it in derived classes as well    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardSource/DataLink.html",
        "title": "DataLink",
        "tags": [],
        "description": "",
        "summary": "Description Data Link",
        "content": "Description Data Link\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/DataPort.html",
        "title": "DataPort",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Port\nDescription Data port\nInherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Port\nDescription Data port\nInherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/DataPort-T-.html",
        "title": "DataPort&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: DataPort\nDescription Generic type data port\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: DataPort\nDescription Generic type data port\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/DataPortWithType.html",
        "title": "DataPortWithType",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: DataPort\nDescription Typeable data port\nProperties    Property Name Description     Type Data type    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: DataPort\nDescription Typeable data port\nProperties    Property Name Description     Type Data type    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IDataPortConnector/P-DataType.html",
        "title": "DataType",
        "tags": [],
        "description": "",
        "summary": "public Type DataType ;\r\r\rDescription Data type",
        "content": "public Type DataType ;\r\r\rDescription Data type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/Decorator.html",
        "title": "Decorator",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: ActivatableComponent\nDescription Basic type of Decorator used for BehaviorTree nodes\nInherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: ActivatableComponent\nDescription Basic type of Decorator used for BehaviorTree nodes\nInherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/DefaultRecomputeModeAttribute.html",
        "title": "DefaultRecomputeModeAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that sets the default recomputation mode\nConstructors     Description     DefaultRecomputeModeAttribute Attribute that sets the default recomputation mode    Fields    Field Name Description     RecomputeMode Recomputation mode    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that sets the default recomputation mode\nConstructors     Description     DefaultRecomputeModeAttribute Attribute that sets the default recomputation mode    Fields    Field Name Description     RecomputeMode Recomputation mode    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/DefaultRecomputeModeAttribute/DefaultRecomputeModeAttribute-ctor.html",
        "title": "DefaultRecomputeModeAttribute",
        "tags": [],
        "description": "",
        "summary": "DefaultRecomputeModeAttribute(RecomputeMode) public DefaultRecomputeModeAttribute(RecomputeMode recomputeMode) ;\r\r\rDescription Attribute that sets the default recomputation mode\nParameters    Parameter Name Description     recomputeMode Recomputation mode    ",
        "content": "DefaultRecomputeModeAttribute(RecomputeMode) public DefaultRecomputeModeAttribute(RecomputeMode recomputeMode) ;\r\r\rDescription Attribute that sets the default recomputation mode\nParameters    Parameter Name Description     recomputeMode Recomputation mode    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Delegate.html",
        "title": "Delegate",
        "tags": [],
        "description": "",
        "summary": "Description Delegate type",
        "content": "Description Delegate type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputPort/M-DeleteWireIds.html",
        "title": "DeleteWireIds",
        "tags": [],
        "description": "",
        "summary": "DeleteWireIds(List\u0026lt;long\u0026gt;) public void DeleteWireIds(List\u0026lt;long\u0026gt; wireIds) ;\r\r\rDescription Remove wire connections\nParameters    Parameter Name Description     wireIds ID list of wires to delete    ",
        "content": "DeleteWireIds(List\u0026lt;long\u0026gt;) public void DeleteWireIds(List\u0026lt;long\u0026gt; wireIds) ;\r\r\rDescription Remove wire connections\nParameters    Parameter Name Description     wireIds ID list of wires to delete    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IOutputPort/M-DeleteWireIds.html",
        "title": "DeleteWireIds",
        "tags": [],
        "description": "",
        "summary": "DeleteWireIds(List\u0026lt;long\u0026gt;) public void DeleteWireIds(List\u0026lt;long\u0026gt; wireIds) ;\r\r\rDescription Remove wire connections\nParameters    Parameter Name Description     wireIds ID list of wires to delete    ",
        "content": "DeleteWireIds(List\u0026lt;long\u0026gt;) public void DeleteWireIds(List\u0026lt;long\u0026gt; wireIds) ;\r\r\rDescription Remove wire connections\nParameters    Parameter Name Description     wireIds ID list of wires to delete    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Port/M-DeleteWireIds.html",
        "title": "DeleteWireIds",
        "tags": [],
        "description": "",
        "summary": "DeleteWireIds(List\u0026lt;long\u0026gt;) public void DeleteWireIds(List\u0026lt;long\u0026gt; wireIds) ;\r\r\rDescription Remove wire connections\nParameters    Parameter Name Description     wireIds ID list of wires to delete    ",
        "content": "DeleteWireIds(List\u0026lt;long\u0026gt;) public void DeleteWireIds(List\u0026lt;long\u0026gt; wireIds) ;\r\r\rDescription Remove wire connections\nParameters    Parameter Name Description     wireIds ID list of wires to delete    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-Description.html",
        "title": "Description",
        "tags": [],
        "description": "",
        "summary": "public string Description ;\r\r\rDescription Description",
        "content": "public string Description ;\r\r\rDescription Description\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/RecomputeMode/Dirty.html",
        "title": "Dirty",
        "tags": [],
        "description": "",
        "summary": "Description Recompute when input values change",
        "content": "Description Recompute when input values change\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/DisallowedTypesAttribute.html",
        "title": "DisallowedTypesAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set types that are not allowed to be used.\nConstructors     Description     DisallowedTypesAttribute Set types that are not allowed to be used.    Fields    Field Name Description     Types Types that are not allowed to be used    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set types that are not allowed to be used.\nConstructors     Description     DisallowedTypesAttribute Set types that are not allowed to be used.    Fields    Field Name Description     Types Types that are not allowed to be used    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/DisallowedTypesAttribute/DisallowedTypesAttribute-ctor.html",
        "title": "DisallowedTypesAttribute",
        "tags": [],
        "description": "",
        "summary": "DisallowedTypesAttribute(Type[]) public DisallowedTypesAttribute(Type[] types) ;\r\r\rDescription Set types that are not allowed to be used.\nParameters    Parameter Name Description     types Types that are not allowed to be used    ",
        "content": "DisallowedTypesAttribute(Type[]) public DisallowedTypesAttribute(Type[] types) ;\r\r\rDescription Set types that are not allowed to be used.\nParameters    Parameter Name Description     types Types that are not allowed to be used    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/InputFieldElementBase/M-Disconnect.html",
        "title": "Disconnect",
        "tags": [],
        "description": "",
        "summary": "Disconnect() public void Disconnect() ;\r\r\rDescription Disconnect a port",
        "content": "Disconnect() public void Disconnect() ;\r\r\rDescription Disconnect a port\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/M-Disconnect.html",
        "title": "Disconnect",
        "tags": [],
        "description": "",
        "summary": "Disconnect() public void Disconnect() ;\r\r\rDescription Disconnect",
        "content": "Disconnect() public void Disconnect() ;\r\r\rDescription Disconnect\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-DisplayName.html",
        "title": "DisplayName",
        "tags": [],
        "description": "",
        "summary": "public string DisplayName ;\r\r\rDescription Display name",
        "content": "public string DisplayName ;\r\r\rDescription Display name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-DisplayName.html",
        "title": "DisplayName",
        "tags": [],
        "description": "",
        "summary": "public string DisplayName ;\r\r\rDescription Display name",
        "content": "public string DisplayName ;\r\r\rDescription Display name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AssetInfo/FS-DisplayProductName.html",
        "title": "DisplayProductName",
        "tags": [],
        "description": "",
        "summary": "public static string DisplayProductName ;\r\r\rDescription Product display name",
        "content": "public static string DisplayProductName ;\r\r\rDescription Product display name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/DontUseComputeAttribute.html",
        "title": "DontUseComputeAttribute",
        "tags": [],
        "description": "",
        "summary": "Attribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attributes prohibited from use on Compute nodes",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attributes prohibited from use on Compute nodes\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/DoubleLerp.html",
        "title": "DoubleLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;double\u0026gt;\nDescription Linear interpolation of type double\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;double\u0026gt;\nDescription Linear interpolation of type double\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IEasingFunction/M-Ease.html",
        "title": "Ease",
        "tags": [],
        "description": "",
        "summary": "Ease(float) public float Ease(float t) ;\r\r\rDescription Perform easing processing\nParameters    Parameter Name Description     t Progress    Returns Easing result",
        "content": "Ease(float) public float Ease(float t) ;\r\r\rDescription Perform easing processing\nParameters    Parameter Name Description     t Progress    Returns Easing result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EaseBase/M-Ease.html",
        "title": "Ease",
        "tags": [],
        "description": "",
        "summary": "Ease(float) public float Ease(float t) ;\r\r\rDescription Perform easing processing\nParameters    Parameter Name Description     t Progress    Returns Easing result",
        "content": "Ease(float) public float Ease(float t) ;\r\r\rDescription Perform easing processing\nParameters    Parameter Name Description     t Progress    Returns Easing result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EaseBase.html",
        "title": "EaseBase",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nImplements interfaces: IEasingFunction\nDescription Basic type for easing\nMethods    Method Name Description     Ease Perform easing processing   EaseIn Perform easing processing on the input side   EaseInOut Perform easing processing on both input and output sides   EaseOut Perform easing processing on the output side    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nImplements interfaces: IEasingFunction\nDescription Basic type for easing\nMethods    Method Name Description     Ease Perform easing processing   EaseIn Perform easing processing on the input side   EaseInOut Perform easing processing on both input and output sides   EaseOut Perform easing processing on the output side    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EaseBase/M-EaseIn.html",
        "title": "EaseIn",
        "tags": [],
        "description": "",
        "summary": "EaseIn(float) protected float EaseIn(float t) ;\r\r\rDescription Perform easing processing on the input side\nParameters    Parameter Name Description     t Progress    Returns Easing result",
        "content": "EaseIn(float) protected float EaseIn(float t) ;\r\r\rDescription Perform easing processing on the input side\nParameters    Parameter Name Description     t Progress    Returns Easing result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EaseBase/M-EaseInOut.html",
        "title": "EaseInOut",
        "tags": [],
        "description": "",
        "summary": "EaseInOut(float) protected float EaseInOut(float t) ;\r\r\rDescription Perform easing processing on both input and output sides\nParameters    Parameter Name Description     t Progress    Returns Easing result",
        "content": "EaseInOut(float) protected float EaseInOut(float t) ;\r\r\rDescription Perform easing processing on both input and output sides\nParameters    Parameter Name Description     t Progress    Returns Easing result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EaseBase/M-EaseOut.html",
        "title": "EaseOut",
        "tags": [],
        "description": "",
        "summary": "EaseOut(float) protected float EaseOut(float t) ;\r\r\rDescription Perform easing processing on the output side\nParameters    Parameter Name Description     t Progress    Returns Easing result",
        "content": "EaseOut(float) protected float EaseOut(float t) ;\r\r\rDescription Perform easing processing on the output side\nParameters    Parameter Name Description     t Progress    Returns Easing result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/EasingMode.html",
        "title": "EasingMode",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Easing Mode\nProperties    Property Name Description     In Input side   Out Output side   InOut Both input and output sides    ",
        "content": "Enum in LogicToolkit\nDescription Easing Mode\nProperties    Property Name Description     In Input side   Out Output side   InOut Both input and output sides    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId/PS-Empty.html",
        "title": "Empty",
        "tags": [],
        "description": "",
        "summary": "public static UniqueId Empty ;\r\r\rDescription Return empty ID",
        "content": "public static UniqueId Empty ;\r\r\rDescription Return empty ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Enum.html",
        "title": "Enum",
        "tags": [],
        "description": "",
        "summary": "Description Enum",
        "content": "Description Enum\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/ComparisonOp/Equals.html",
        "title": "Equals",
        "tags": [],
        "description": "",
        "summary": "Description Equals",
        "content": "Description Equals\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType/M-Equals.html",
        "title": "Equals",
        "tags": [],
        "description": "",
        "summary": "Equals(object) public bool Equals(object obj) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     obj Object to check for equality    Returns Equal or not\nEquals(SerializableType) public bool Equals(SerializableType other) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     other Target to determine equality    Returns Equal or not",
        "content": "Equals(object) public bool Equals(object obj) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     obj Object to check for equality    Returns Equal or not\nEquals(SerializableType) public bool Equals(SerializableType other) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     other Target to determine equality    Returns Equal or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId/M-Equals.html",
        "title": "Equals",
        "tags": [],
        "description": "",
        "summary": "Equals(UniqueId) public bool Equals(UniqueId other) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     other Target to determine equality    Returns Equal or not\nEquals(object) public bool Equals(object obj) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     obj Object to check for equality    Returns Equal or not",
        "content": "Equals(UniqueId) public bool Equals(UniqueId other) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     other Target to determine equality    Returns Equal or not\nEquals(object) public bool Equals(object obj) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     obj Object to check for equality    Returns Equal or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EvaluateComponent.html",
        "title": "EvaluateComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: NodeComponent\nDescription Component to be evaluated\nMethods    Method Name Description     OnEvaluate Perform an evaluation    Inherited Members Properties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: NodeComponent\nDescription Component to be evaluated\nMethods    Method Name Description     OnEvaluate Perform an evaluation    Inherited Members Properties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/EvaluateDecorator.html",
        "title": "EvaluateDecorator",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: Decorator\nDescription Decorator that evaluates the execution of BehaviorTree nodes\nMethods    Method Name Description     OnEnterEvaluation Called when a node enters the evaluation target   OnEvaluate Called when performing an evaluation   OnLeaveEvaluation Called when a node leaves the evaluation target    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: Decorator\nDescription Decorator that evaluates the execution of BehaviorTree nodes\nMethods    Method Name Description     OnEnterEvaluation Called when a node enters the evaluation target   OnEvaluate Called when performing an evaluation   OnLeaveEvaluation Called when a node leaves the evaluation target    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Enums/SignalExpiration/Evaluating.html",
        "title": "Evaluating",
        "tags": [],
        "description": "",
        "summary": "Description Valid while being evaluated",
        "content": "Description Valid while being evaluated\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/Event.html",
        "title": "Event",
        "tags": [],
        "description": "",
        "summary": "Description Event",
        "content": "Description Event\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EventComponent.html",
        "title": "EventComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ActivatableComponent\nDescription Component that listens for events\nMethods    Method Name Description     OnEvent Call when an event occurs    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ActivatableComponent\nDescription Component that listens for events\nMethods    Method Name Description     OnEvent Call when an event occurs    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ExecuteNode.html",
        "title": "ExecuteNode",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ActivatableNode\nDescription Execution node\nMethods    Method Name Description     Transition Transition execution nodes.    Inherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ActivatableNode\nDescription Execution node\nMethods    Method Name Description     Transition Transition execution nodes.    Inherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ExitNode.html",
        "title": "ExitNode",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to end node execution\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.",
        "content": "\r\rClass in LogicToolkit / Inherits from: FlowExitNode\nDescription Flow end node to end node execution\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Types/OutputSignalPort/P-Expiration.html",
        "title": "Expiration",
        "tags": [],
        "description": "",
        "summary": "public SignalExpiration Expiration ;\r\r\rDescription Signal expiration time",
        "content": "public SignalExpiration Expiration ;\r\r\rDescription Signal expiration time\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TaskStatus/Failure.html",
        "title": "Failure",
        "tags": [],
        "description": "",
        "summary": "Description Failure",
        "content": "Description Failure\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/Field.html",
        "title": "Field",
        "tags": [],
        "description": "",
        "summary": "Description Field",
        "content": "Description Field\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/FieldAssignor.html",
        "title": "FieldAssignor",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit.Editors / Inherits from: object\nDescription Class for assigning values to fields when a node or node component is created",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Class for assigning values to fields when a node or node component is created\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator/P-FieldAssignor.html",
        "title": "FieldAssignor",
        "tags": [],
        "description": "",
        "summary": "public FieldAssignor FieldAssignor ;\r\r\rDescription Data to assign to field",
        "content": "public FieldAssignor FieldAssignor ;\r\r\rDescription Data to assign to field\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/ConstantPropertyDrawer/P-FieldInfo.html",
        "title": "FieldInfo",
        "tags": [],
        "description": "",
        "summary": "protected FieldInfo FieldInfo ;\r\r\rDescription FieldInfo for constant fields",
        "content": "protected FieldInfo FieldInfo ;\r\r\rDescription FieldInfo for constant fields\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-FieldInfo.html",
        "title": "FieldInfo",
        "tags": [],
        "description": "",
        "summary": "public FieldInfo FieldInfo ;\r\r\rDescription Field info",
        "content": "public FieldInfo FieldInfo ;\r\r\rDescription Field info\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FieldOrderAttribute.html",
        "title": "FieldOrderAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.\nConstructors     Description     FieldOrderAttribute Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.    Fields    Field Name Description     Order Display order    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.\nConstructors     Description     FieldOrderAttribute Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.    Fields    Field Name Description     Order Display order    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FieldOrderAttribute/FieldOrderAttribute-ctor.html",
        "title": "FieldOrderAttribute",
        "tags": [],
        "description": "",
        "summary": "FieldOrderAttribute(int) public FieldOrderAttribute(int order) ;\r\r\rDescription Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.\nParameters    Parameter Name Description     order Display order    ",
        "content": "FieldOrderAttribute(int) public FieldOrderAttribute(int order) ;\r\r\rDescription Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.\nParameters    Parameter Name Description     order Display order    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/FieldPlacement.html",
        "title": "FieldPlacement",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Placement of fields\nProperties    Property Name Description     Left Left side   Right Right side   Top Top side   Bottom Bottom side    ",
        "content": "Enum in LogicToolkit\nDescription Placement of fields\nProperties    Property Name Description     Left Left side   Right Right side   Top Top side   Bottom Bottom side    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FieldPlacementAttribute.html",
        "title": "FieldPlacementAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.\nConstructors     Description     FieldPlacementAttribute Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.    Fields    Field Name Description     Placement Placement of fields    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.\nConstructors     Description     FieldPlacementAttribute Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.    Fields    Field Name Description     Placement Placement of fields    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FieldPlacementAttribute/FieldPlacementAttribute-ctor.html",
        "title": "FieldPlacementAttribute",
        "tags": [],
        "description": "",
        "summary": "FieldPlacementAttribute(FieldPlacement) public FieldPlacementAttribute(FieldPlacement placement) ;\r\r\rDescription Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.\nParameters    Parameter Name Description     placement Placement of fields    ",
        "content": "FieldPlacementAttribute(FieldPlacement) public FieldPlacementAttribute(FieldPlacement placement) ;\r\r\rDescription Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.\nParameters    Parameter Name Description     placement Placement of fields    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-FieldType.html",
        "title": "FieldType",
        "tags": [],
        "description": "",
        "summary": "public Type FieldType ;\r\r\rDescription Field type",
        "content": "public Type FieldType ;\r\r\rDescription Field type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TimerType/Fixed.html",
        "title": "Fixed",
        "tags": [],
        "description": "",
        "summary": "Description Use Time.fixedTime.",
        "content": "Description Use Time.fixedTime.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FixedRecomputeModeAttribute.html",
        "title": "FixedRecomputeModeAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute to fix recompute mode\nConstructors     Description     FixedRecomputeModeAttribute Attribute to fix recompute mode    Fields    Field Name Description     RecomputeMode Recomputation mode    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute to fix recompute mode\nConstructors     Description     FixedRecomputeModeAttribute Attribute to fix recompute mode    Fields    Field Name Description     RecomputeMode Recomputation mode    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FixedRecomputeModeAttribute/FixedRecomputeModeAttribute-ctor.html",
        "title": "FixedRecomputeModeAttribute",
        "tags": [],
        "description": "",
        "summary": "FixedRecomputeModeAttribute(RecomputeMode) public FixedRecomputeModeAttribute(RecomputeMode recomputeMode) ;\r\r\rDescription Attribute to fix recompute mode\nParameters    Parameter Name Description     recomputeMode Recomputation mode    ",
        "content": "FixedRecomputeModeAttribute(RecomputeMode) public FixedRecomputeModeAttribute(RecomputeMode recomputeMode) ;\r\r\rDescription Attribute to fix recompute mode\nParameters    Parameter Name Description     recomputeMode Recomputation mode    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-FixedTitle.html",
        "title": "FixedTitle",
        "tags": [],
        "description": "",
        "summary": "public string FixedTitle ;\r\r\rDescription Fixed title name",
        "content": "public string FixedTitle ;\r\r\rDescription Fixed title name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FixedTitleNameAttribute.html",
        "title": "FixedTitleNameAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.\nConstructors     Description     FixedTitleNameAttribute Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.    Fields    Field Name Description     Title Title name    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.\nConstructors     Description     FixedTitleNameAttribute Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.    Fields    Field Name Description     Title Title name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FixedTitleNameAttribute/FixedTitleNameAttribute-ctor.html",
        "title": "FixedTitleNameAttribute",
        "tags": [],
        "description": "",
        "summary": "FixedTitleNameAttribute(string) public FixedTitleNameAttribute(string title) ;\r\r\rDescription Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.\nParameters    Parameter Name Description     title Title name    ",
        "content": "FixedTitleNameAttribute(string) public FixedTitleNameAttribute(string title) ;\r\r\rDescription Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.\nParameters    Parameter Name Description     title Title name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TimerType/FixedUnscaled.html",
        "title": "FixedUnscaled",
        "tags": [],
        "description": "",
        "summary": "Description Use Time.fixedUnscaledTime.",
        "content": "Description Use Time.fixedUnscaledTime.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/FloatLerp.html",
        "title": "FloatLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;float\u0026gt;\nDescription Linear interpolation of type float\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;float\u0026gt;\nDescription Linear interpolation of type float\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/FlowExitNode.html",
        "title": "FlowExitNode",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: ExecuteNode\nDescription Basic type of flow end node\nMethods    Method Name Description     OnActivated Called when it becomes active    Inherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.",
        "content": "\r\rClass in LogicToolkit / Inherits from: ExecuteNode\nDescription Basic type of flow end node\nMethods    Method Name Description     OnActivated Called when it becomes active    Inherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnDeactivated Called when it becomes inactive   Transition Transition execution nodes.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/RecomputeMode/Frame.html",
        "title": "Frame",
        "tags": [],
        "description": "",
        "summary": "Description Recompute when update frames are different",
        "content": "Description Recompute when update frames are different\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicController/P-FunctionGraphCount.html",
        "title": "FunctionGraphCount",
        "tags": [],
        "description": "",
        "summary": "public int FunctionGraphCount ;\r\r\rDescription Number of function graphs",
        "content": "public int FunctionGraphCount ;\r\r\rDescription Number of function graphs\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/GameObjectConstantContainer.html",
        "title": "GameObjectConstantContainer",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ConstantContainer\u0026lt;UnityEngine.GameObject\u0026gt;\nDescription Container for constants of type GameObject\nConstructors     Description     GameObjectConstantContainer Container for constants of type GameObject    Properties    Property Name Description     Value Constant value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ConstantContainer\u0026lt;UnityEngine.GameObject\u0026gt;\nDescription Container for constants of type GameObject\nConstructors     Description     GameObjectConstantContainer Container for constants of type GameObject    Properties    Property Name Description     Value Constant value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/GameObjectConstantContainer/GameObjectConstantContainer-ctor.html",
        "title": "GameObjectConstantContainer",
        "tags": [],
        "description": "",
        "summary": "GameObjectConstantContainer() public GameObjectConstantContainer() ;\r\r\rDescription Container for constants of type GameObject\nGameObjectConstantContainer(GameObject) public GameObjectConstantContainer(GameObject value) ;\r\r\rDescription Container for constants of type GameObject\nParameters    Parameter Name Description     value Constant value    ",
        "content": "GameObjectConstantContainer() public GameObjectConstantContainer() ;\r\r\rDescription Container for constants of type GameObject\nGameObjectConstantContainer(GameObject) public GameObjectConstantContainer(GameObject value) ;\r\r\rDescription Container for constants of type GameObject\nParameters    Parameter Name Description     value Constant value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/MS-Get.html",
        "title": "Get",
        "tags": [],
        "description": "",
        "summary": "Get(SerializedProperty, out PortConnector) public static PooledObject\u0026lt;PortConnector\u0026gt; Get(SerializedProperty property, out PortConnector portConnector) ;\r\r\rDescription Get PortConnector\nParameters    Parameter Name Description     property Property   portConnector Port connector    Returns Pool object. Return it to the pool when it exits the scope by using it in the using statement.",
        "content": "Get(SerializedProperty, out PortConnector) public static PooledObject\u0026lt;PortConnector\u0026gt; Get(SerializedProperty property, out PortConnector portConnector) ;\r\r\rDescription Get PortConnector\nParameters    Parameter Name Description     property Property   portConnector Port connector    Returns Pool object. Return it to the pool when it exits the scope by using it in the using statement.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/MS-Get.html",
        "title": "Get",
        "tags": [],
        "description": "",
        "summary": "Get(Type) public static TypeMenuInfo Get(Type type) ;\r\r\rDescription Get type menu infomation\nParameters    Parameter Name Description     type Type    Returns Type menu infomation",
        "content": "Get(Type) public static TypeMenuInfo Get(Type type) ;\r\r\rDescription Get type menu infomation\nParameters    Parameter Name Description     type Type    Returns Type menu infomation\n"
    },
    {
        "uri": "/manual/architecture/nodes/computes/getvariablecomputenode.html",
        "title": "Get Variable Compute",
        "tags": [],
        "description": "",
        "summary": "Get Variable Compute is a node that gets the value of the variable of Blackboard and outputs the data.\nProperties    Property name Type Description     Output Port OutputDataPort Blackboard outputs the value of the variable    ",
        "content": "Get Variable Compute is a node that gets the value of the variable of Blackboard and outputs the data.\nProperties    Property name Type Description     Output Port OutputDataPort Blackboard outputs the value of the variable    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TypeUtility/MS-GetArrayOrListElementType.html",
        "title": "GetArrayOrListElementType",
        "tags": [],
        "description": "",
        "summary": "GetArrayOrListElementType(Type) public static Type GetArrayOrListElementType(Type type) ;\r\r\rDescription Get the type of element of array or IList\u0026lt;T\u0026gt;\nParameters    Parameter Name Description     type Type of array or IList\u0026lt;T\u0026gt;    Returns Element type",
        "content": "GetArrayOrListElementType(Type) public static Type GetArrayOrListElementType(Type type) ;\r\r\rDescription Get the type of element of array or IList\u0026lt;T\u0026gt;\nParameters    Parameter Name Description     type Type of array or IList\u0026lt;T\u0026gt;    Returns Element type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputPort/M-GetConnectedWireAt.html",
        "title": "GetConnectedWireAt",
        "tags": [],
        "description": "",
        "summary": "GetConnectedWireAt(int) public Wire GetConnectedWireAt(int index) ;\r\r\rDescription Get connected wire\nParameters    Parameter Name Description     index Index    Returns Connected wire",
        "content": "GetConnectedWireAt(int) public Wire GetConnectedWireAt(int index) ;\r\r\rDescription Get connected wire\nParameters    Parameter Name Description     index Index    Returns Connected wire\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IOutputPort/M-GetConnectedWireAt.html",
        "title": "GetConnectedWireAt",
        "tags": [],
        "description": "",
        "summary": "GetConnectedWireAt(int) public Wire GetConnectedWireAt(int index) ;\r\r\rDescription Get connected wire\nParameters    Parameter Name Description     index Index    Returns Connected wire",
        "content": "GetConnectedWireAt(int) public Wire GetConnectedWireAt(int index) ;\r\r\rDescription Get connected wire\nParameters    Parameter Name Description     index Index    Returns Connected wire\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Port/M-GetConnectedWireAt.html",
        "title": "GetConnectedWireAt",
        "tags": [],
        "description": "",
        "summary": "GetConnectedWireAt(int) public Wire GetConnectedWireAt(int index) ;\r\r\rDescription Get connected wire\nParameters    Parameter Name Description     index Index    Returns Connected wire",
        "content": "GetConnectedWireAt(int) public Wire GetConnectedWireAt(int index) ;\r\r\rDescription Get connected wire\nParameters    Parameter Name Description     index Index    Returns Connected wire\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputPort/M-GetConnectedWireIdAt.html",
        "title": "GetConnectedWireIdAt",
        "tags": [],
        "description": "",
        "summary": "GetConnectedWireIdAt(int) public long GetConnectedWireIdAt(int index) ;\r\r\rDescription Get connected wire ID\nParameters    Parameter Name Description     index Index    Returns Connected wire ID",
        "content": "GetConnectedWireIdAt(int) public long GetConnectedWireIdAt(int index) ;\r\r\rDescription Get connected wire ID\nParameters    Parameter Name Description     index Index    Returns Connected wire ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IOutputPort/M-GetConnectedWireIdAt.html",
        "title": "GetConnectedWireIdAt",
        "tags": [],
        "description": "",
        "summary": "GetConnectedWireIdAt(int) public long GetConnectedWireIdAt(int index) ;\r\r\rDescription Get connected wire ID\nParameters    Parameter Name Description     index Index    Returns Connected wire ID",
        "content": "GetConnectedWireIdAt(int) public long GetConnectedWireIdAt(int index) ;\r\r\rDescription Get connected wire ID\nParameters    Parameter Name Description     index Index    Returns Connected wire ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Port/M-GetConnectedWireIdAt.html",
        "title": "GetConnectedWireIdAt",
        "tags": [],
        "description": "",
        "summary": "GetConnectedWireIdAt(int) public long GetConnectedWireIdAt(int index) ;\r\r\rDescription Get connected wire ID\nParameters    Parameter Name Description     index Index    Returns Connected wire ID",
        "content": "GetConnectedWireIdAt(int) public long GetConnectedWireIdAt(int index) ;\r\r\rDescription Get connected wire ID\nParameters    Parameter Name Description     index Index    Returns Connected wire ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-GetElement.html",
        "title": "GetElement",
        "tags": [],
        "description": "",
        "summary": "GetElement(IValueGetter, int, IValueSetter) public bool GetElement(IValueGetter listGetter, int index, IValueSetter elementSetter) ;\r\r\rDescription Get the element\nParameters    Parameter Name Description     listGetter Instance to get list   index Element index   elementSetter Instance to set element value    Returns Returns true if the element is get. Otherwise returns false.",
        "content": "GetElement(IValueGetter, int, IValueSetter) public bool GetElement(IValueGetter listGetter, int index, IValueSetter elementSetter) ;\r\r\rDescription Get the element\nParameters    Parameter Name Description     listGetter Instance to get list   index Element index   elementSetter Instance to set element value    Returns Returns true if the element is get. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponent-TTarget-TInputField-T-/M-GetFromValue.html",
        "title": "GetFromValue",
        "tags": [],
        "description": "",
        "summary": "GetFromValue(TTarget) protected T GetFromValue(TTarget target) ;\r\r\rDescription Get starting value\nParameters    Parameter Name Description     target Target    Returns Starting value\nGetFromValue() protected T GetFromValue() ;\r\r\rDescription Get starting value\nReturns Starting value",
        "content": "GetFromValue(TTarget) protected T GetFromValue(TTarget target) ;\r\r\rDescription Get starting value\nParameters    Parameter Name Description     target Target    Returns Starting value\nGetFromValue() protected T GetFromValue() ;\r\r\rDescription Get starting value\nReturns Starting value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponentBase-T-/M-GetFromValue.html",
        "title": "GetFromValue",
        "tags": [],
        "description": "",
        "summary": "GetFromValue() protected T GetFromValue() ;\r\r\rDescription Get starting value\nReturns Starting value",
        "content": "GetFromValue() protected T GetFromValue() ;\r\r\rDescription Get starting value\nReturns Starting value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicController/M-GetFunctionGraphAt.html",
        "title": "GetFunctionGraphAt",
        "tags": [],
        "description": "",
        "summary": "GetFunctionGraphAt(int) public NodeGraph GetFunctionGraphAt(int index) ;\r\r\rDescription Get the function graph.\nParameters    Parameter Name Description     index Index    Returns Function graph",
        "content": "GetFunctionGraphAt(int) public NodeGraph GetFunctionGraphAt(int index) ;\r\r\rDescription Get the function graph.\nParameters    Parameter Name Description     index Index    Returns Function graph\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType/M-GetHashCode.html",
        "title": "GetHashCode",
        "tags": [],
        "description": "",
        "summary": "GetHashCode() public int GetHashCode() ;\r\r\rDescription Get the hash code.\nReturns Hash code",
        "content": "GetHashCode() public int GetHashCode() ;\r\r\rDescription Get the hash code.\nReturns Hash code\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId/M-GetHashCode.html",
        "title": "GetHashCode",
        "tags": [],
        "description": "",
        "summary": "GetHashCode() public int GetHashCode() ;\r\r\rDescription Get the hash code.\nReturns Hash code",
        "content": "GetHashCode() public int GetHashCode() ;\r\r\rDescription Get the hash code.\nReturns Hash code\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputFieldUtility/MS-GetInputFieldType.html",
        "title": "GetInputFieldType",
        "tags": [],
        "description": "",
        "summary": "GetInputFieldType(Type) public static Type GetInputFieldType(Type valueType) ;\r\r\rDescription Get input field type from value type\nParameters    Parameter Name Description     valueType Value type    Returns Input field type",
        "content": "GetInputFieldType(Type) public static Type GetInputFieldType(Type valueType) ;\r\r\rDescription Get input field type from value type\nParameters    Parameter Name Description     valueType Value type    Returns Input field type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ListAccessorUtility/MS-GetListAccessor.html",
        "title": "GetListAccessor",
        "tags": [],
        "description": "",
        "summary": "GetListAccessor(Type) public static IListAccessor GetListAccessor(Type elementType) ;\r\r\rDescription Get IListAccessor\nParameters    Parameter Name Description     elementType Element type    Returns Return IListAccessor",
        "content": "GetListAccessor(Type) public static IListAccessor GetListAccessor(Type elementType) ;\r\r\rDescription Get IListAccessor\nParameters    Parameter Name Description     elementType Element type    Returns Return IListAccessor\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-GetNodeAt.html",
        "title": "GetNodeAt",
        "tags": [],
        "description": "",
        "summary": "GetNodeAt(int) public Node GetNodeAt(int index) ;\r\r\rDescription Get index nodedata\nParameters    Parameter Name Description     index Index    Returns Node",
        "content": "GetNodeAt(int) public Node GetNodeAt(int index) ;\r\r\rDescription Get index nodedata\nParameters    Parameter Name Description     index Index    Returns Node\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-GetObject.html",
        "title": "GetObject",
        "tags": [],
        "description": "",
        "summary": "GetObject() protected object GetObject() ;\r\r\rDescription Get the value as object type.\nReturns Value",
        "content": "GetObject() protected object GetObject() ;\r\r\rDescription Get the value as object type.\nReturns Value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableBase-T-/M-GetObject.html",
        "title": "GetObject",
        "tags": [],
        "description": "",
        "summary": "GetObject() protected object GetObject() ;\r\r\rDescription Get the value as object type.\nReturns Value",
        "content": "GetObject() protected object GetObject() ;\r\r\rDescription Get the value as object type.\nReturns Value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/M-GetSearchableTypes.html",
        "title": "GetSearchableTypes",
        "tags": [],
        "description": "",
        "summary": "GetSearchableTypes(HashSet\u0026lt;Type\u0026gt;) public void GetSearchableTypes(HashSet\u0026lt;Type\u0026gt; searchTypes) ;\r\r\rDescription Parameters    Parameter Name Description     searchTypes Hashset of the type to search for    ",
        "content": "GetSearchableTypes(HashSet\u0026lt;Type\u0026gt;) public void GetSearchableTypes(HashSet\u0026lt;Type\u0026gt; searchTypes) ;\r\r\rDescription Parameters    Parameter Name Description     searchTypes Hashset of the type to search for    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-GetString.html",
        "title": "GetString",
        "tags": [],
        "description": "",
        "summary": "GetString() protected string GetString() ;\r\r\rDescription Get the value as a string.\nReturns Value string",
        "content": "GetString() protected string GetString() ;\r\r\rDescription Get the value as a string.\nReturns Value string\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableBase-T-/M-GetString.html",
        "title": "GetString",
        "tags": [],
        "description": "",
        "summary": "GetString() protected string GetString() ;\r\r\rDescription Get the value as a string.\nReturns Value string",
        "content": "GetString() protected string GetString() ;\r\r\rDescription Get the value as a string.\nReturns Value string\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueGetter-T-/M-GetValue.html",
        "title": "GetValue",
        "tags": [],
        "description": "",
        "summary": "GetValue() public T GetValue() ;\r\r\rDescription Get value\nReturns value",
        "content": "GetValue() public T GetValue() ;\r\r\rDescription Get value\nReturns value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputDataPort-T-/M-GetValue.html",
        "title": "GetValue",
        "tags": [],
        "description": "",
        "summary": "GetValue() public T GetValue() ;\r\r\rDescription Get value\nReturns Obtained value. If the acquisition is not successful, default(T) is returned.",
        "content": "GetValue() public T GetValue() ;\r\r\rDescription Get value\nReturns Obtained value. If the acquisition is not successful, default(T) is returned.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/RefArgument-T-TInputField-/M-GetValue.html",
        "title": "GetValue",
        "tags": [],
        "description": "",
        "summary": "GetValue() public T GetValue() ;\r\r\rDescription Get the value\nReturns Obtained value",
        "content": "GetValue() public T GetValue() ;\r\r\rDescription Get the value\nReturns Obtained value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueContainer-T-/M-GetValue.html",
        "title": "GetValue",
        "tags": [],
        "description": "",
        "summary": "GetValue() public T GetValue() ;\r\r\rDescription Get value\nReturns value",
        "content": "GetValue() public T GetValue() ;\r\r\rDescription Get value\nReturns value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable-T-/M-GetValue.html",
        "title": "GetValue",
        "tags": [],
        "description": "",
        "summary": "GetValue() public T GetValue() ;\r\r\rDescription Get the value.\nReturns Value",
        "content": "GetValue() public T GetValue() ;\r\r\rDescription Get the value.\nReturns Value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableBase-T-/M-GetValue.html",
        "title": "GetValue",
        "tags": [],
        "description": "",
        "summary": "GetValue() public T GetValue() ;\r\r\rDescription Get the value.\nReturns Value",
        "content": "GetValue() public T GetValue() ;\r\r\rDescription Get the value.\nReturns Value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableList-T-/M-GetValue.html",
        "title": "GetValue",
        "tags": [],
        "description": "",
        "summary": "GetValue() public IList\u0026lt;T\u0026gt; GetValue() ;\r\r\rDescription Get the value.\nReturns Value",
        "content": "GetValue() public IList\u0026lt;T\u0026gt; GetValue() ;\r\r\rDescription Get the value.\nReturns Value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueGetter/M-GetValueObject.html",
        "title": "GetValueObject",
        "tags": [],
        "description": "",
        "summary": "GetValueObject() public object GetValueObject() ;\r\r\rDescription Get value\nReturns value",
        "content": "GetValueObject() public object GetValueObject() ;\r\r\rDescription Get value\nReturns value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueGetter/M-GetValueString.html",
        "title": "GetValueString",
        "tags": [],
        "description": "",
        "summary": "GetValueString() public string GetValueString() ;\r\r\rDescription Get value string\nReturns Value string",
        "content": "GetValueString() public string GetValueString() ;\r\r\rDescription Get value string\nReturns Value string\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueGetter/M-GetValueType.html",
        "title": "GetValueType",
        "tags": [],
        "description": "",
        "summary": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get value type\nReturns Value type",
        "content": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get value type\nReturns Value type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter/M-GetValueType.html",
        "title": "GetValueType",
        "tags": [],
        "description": "",
        "summary": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get value type\nReturns Value type",
        "content": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get value type\nReturns Value type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-GetValueType.html",
        "title": "GetValueType",
        "tags": [],
        "description": "",
        "summary": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get the type of a value.\nReturns Value type",
        "content": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get the type of a value.\nReturns Value type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableBase-T-/M-GetValueType.html",
        "title": "GetValueType",
        "tags": [],
        "description": "",
        "summary": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get the type of a value.\nReturns Value type",
        "content": "GetValueType() public Type GetValueType() ;\r\r\rDescription Get the type of a value.\nReturns Value type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Blackboard/M-GetVariableAt.html",
        "title": "GetVariableAt",
        "tags": [],
        "description": "",
        "summary": "GetVariableAt(int) public Variable GetVariableAt(int index) ;\r\r\rDescription Get the Variable of the index element.\nParameters    Parameter Name Description     index Index    Returns Variable of the index element.",
        "content": "GetVariableAt(int) public Variable GetVariableAt(int index) ;\r\r\rDescription Get the Variable of the index element.\nParameters    Parameter Name Description     index Index    Returns Variable of the index element.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardDataLinkShareType/Global.html",
        "title": "Global",
        "tags": [],
        "description": "",
        "summary": "Description Share globally. Instances are never released and are always shared until the application terminates.",
        "content": "Description Share globally. Instances are never released and are always shared until the application terminates.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/GraphEditor.html",
        "title": "GraphEditor",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Class for editing graphs\nMethods    Method Name Description     CreateConvertNodeIfNesessaryAndConnectWire Create data convert nodes and connect ports as needed   TryGetNodeEditor Get node editor    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Class for editing graphs\nMethods    Method Name Description     CreateConvertNodeIfNesessaryAndConnectWire Create data convert nodes and connect ports as needed   TryGetNodeEditor Get node editor    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-GraphEditor.html",
        "title": "GraphEditor",
        "tags": [],
        "description": "",
        "summary": "public GraphEditor GraphEditor ;\r\r\rDescription Graph editor",
        "content": "public GraphEditor GraphEditor ;\r\r\rDescription Graph editor\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortFieldAssignor/P-GraphEditor.html",
        "title": "GraphEditor",
        "tags": [],
        "description": "",
        "summary": "public GraphEditor GraphEditor ;\r\r\rDescription Graph Editor",
        "content": "public GraphEditor GraphEditor ;\r\r\rDescription Graph Editor\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator/P-GraphEditor.html",
        "title": "GraphEditor",
        "tags": [],
        "description": "",
        "summary": "public GraphEditor GraphEditor ;\r\r\rDescription Graph Editor",
        "content": "public GraphEditor GraphEditor ;\r\r\rDescription Graph Editor\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/ComparisonOp/GreaterThan.html",
        "title": "GreaterThan",
        "tags": [],
        "description": "",
        "summary": "Description Greater than",
        "content": "Description Greater than\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/ComparisonOp/GreaterThanOrEqual.html",
        "title": "GreaterThanOrEqual",
        "tags": [],
        "description": "",
        "summary": "Description Greater than or equal",
        "content": "Description Greater than or equal\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-HasDisplayNameAttr.html",
        "title": "HasDisplayNameAttr",
        "tags": [],
        "description": "",
        "summary": "public bool HasDisplayNameAttr ;\r\r\rDescription Does it have DisplayNameAttribute?",
        "content": "public bool HasDisplayNameAttr ;\r\r\rDescription Does it have DisplayNameAttribute?\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-HasMenuNameAttr.html",
        "title": "HasMenuNameAttr",
        "tags": [],
        "description": "",
        "summary": "public bool HasMenuNameAttr ;\r\r\rDescription Does it have MenuNameAttribute?",
        "content": "public bool HasMenuNameAttr ;\r\r\rDescription Does it have MenuNameAttribute?\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IOutputDataPort/P-HasValue.html",
        "title": "HasValue",
        "tags": [],
        "description": "",
        "summary": "public bool HasValue ;\r\r\rDescription Whether the output data port has a value",
        "content": "public bool HasValue ;\r\r\rDescription Whether the output data port has a value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPort-T-/P-HasValue.html",
        "title": "HasValue",
        "tags": [],
        "description": "",
        "summary": "public bool HasValue ;\r\r\rDescription Whether the output data port has a value",
        "content": "public bool HasValue ;\r\r\rDescription Whether the output data port has a value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType/P-HasValue.html",
        "title": "HasValue",
        "tags": [],
        "description": "",
        "summary": "public bool HasValue ;\r\r\rDescription Whether the output data port has a value",
        "content": "public bool HasValue ;\r\r\rDescription Whether the output data port has a value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantColorUsageAttribute/F-Hdr.html",
        "title": "Hdr",
        "tags": [],
        "description": "",
        "summary": "public bool Hdr ;\r\r\rDescription If set to true the Color is treated as a HDR color.",
        "content": "public bool Hdr ;\r\r\rDescription If set to true the Color is treated as a HDR color.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantGradientUsageAttribute/F-Hdr.html",
        "title": "Hdr",
        "tags": [],
        "description": "",
        "summary": "public bool Hdr ;\r\r\rDescription If set to true the Color is treated as a HDR color.",
        "content": "public bool Hdr ;\r\r\rDescription If set to true the Color is treated as a HDR color.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem/F-HelpUrl.html",
        "title": "HelpUrl",
        "tags": [],
        "description": "",
        "summary": "public string HelpUrl ;\r\r\rDescription URL of page opened from help button",
        "content": "public string HelpUrl ;\r\r\rDescription URL of page opened from help button\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-HelpUrl.html",
        "title": "HelpUrl",
        "tags": [],
        "description": "",
        "summary": "public string HelpUrl ;\r\r\rDescription Help URL",
        "content": "public string HelpUrl ;\r\r\rDescription Help URL\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/HideInTypePopupAttribute.html",
        "title": "HideInTypePopupAttribute",
        "tags": [],
        "description": "",
        "summary": "Attribute in LogicToolkit / Inherits from: System.Attribute\nDescription Hides types to which this attribute is applied from the type selection window.",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Hides types to which this attribute is applied from the type selection window.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/HideInVariableMenuAttribute.html",
        "title": "HideInVariableMenuAttribute",
        "tags": [],
        "description": "",
        "summary": "Attribute in LogicToolkit / Inherits from: System.Attribute\nDescription Hide types to which this attribute is applied from the Variable addition menu.",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Hide types to which this attribute is applied from the Variable addition menu.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/HideResultFieldAttribute.html",
        "title": "HideResultFieldAttribute",
        "tags": [],
        "description": "",
        "summary": "Attribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that hides the Result field that outputs the execution results of TaskComponent. Mainly used for processing that always completes successfully.",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Attribute that hides the Result field that outputs the execution results of TaskComponent. Mainly used for processing that always completes successfully.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/HideTypeInVariableMenuAttribute.html",
        "title": "HideTypeInVariableMenuAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Applying this attribute to an assembly hides the specified type from the Add Variable menu.\nConstructors     Description     HideTypeInVariableMenuAttribute Applying this attribute to an assembly hides the specified type from the Add Variable menu.    Fields    Field Name Description     Type Target type    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Applying this attribute to an assembly hides the specified type from the Add Variable menu.\nConstructors     Description     HideTypeInVariableMenuAttribute Applying this attribute to an assembly hides the specified type from the Add Variable menu.    Fields    Field Name Description     Type Target type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/HideTypeInVariableMenuAttribute/HideTypeInVariableMenuAttribute-ctor.html",
        "title": "HideTypeInVariableMenuAttribute",
        "tags": [],
        "description": "",
        "summary": "HideTypeInVariableMenuAttribute(Type) public HideTypeInVariableMenuAttribute(Type type) ;\r\r\rDescription Applying this attribute to an assembly hides the specified type from the Add Variable menu.\nParameters    Parameter Name Description     type Target type    ",
        "content": "HideTypeInVariableMenuAttribute(Type) public HideTypeInVariableMenuAttribute(Type type) ;\r\r\rDescription Applying this attribute to an assembly hides the specified type from the Add Variable menu.\nParameters    Parameter Name Description     type Target type    "
    },
    {
        "uri": "/",
        "title": "Home",
        "tags": [],
        "description": "",
        "summary": "This is the official documentation for Unity assets Logic Toolkit.\nIf you are using Logic Toolkit for the first time, please see Manual: Getting Started.\nAbout the document The Unity environment used in this document is as follows.\n   Item Contents     Unity version Unity 2023.2   Theme Dark   Language English   Rendering Pipeline Built-in   Shortcut key settings Default    Please note that the user environment may differ depending on the Unity version, settings, and window layout.",
        "content": "This is the official documentation for Unity assets Logic Toolkit.\nIf you are using Logic Toolkit for the first time, please see Manual: Getting Started.\nAbout the document The Unity environment used in this document is as follows.\n   Item Contents     Unity version Unity 2023.2   Theme Dark   Language English   Rendering Pipeline Built-in   Shortcut key settings Default    Please note that the user environment may differ depending on the Unity version, settings, and window layout.\nDocumentation  Manual\nLearn the main uses of Logic Toolkit. Script Reference\nReference for scripts available in Logic Toolkit.  Other sources of information  Tutorial\nIn preparation Forum\nYou can post usage questions and bug reports.  "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Interfaces/IAbortReceiver.html",
        "title": "IAbortReceiver",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit.BehaviorTrees\nDescription Receive execution abort of BehaviorTree node. By implementing it in the main component or Decorator, the IAbortReceiver.OnAbort() method will be called when execution is aborted.\nMethods    Method Name Description     OnAbort Called when a node aborts execution    ",
        "content": "\r\rInterface in LogicToolkit.BehaviorTrees\nDescription Receive execution abort of BehaviorTree node. By implementing it in the main component or Decorator, the IAbortReceiver.OnAbort() method will be called when execution is aborted.\nMethods    Method Name Description     OnAbort Called when a node aborts execution    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IBindItem.html",
        "title": "IBindItem",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit.Editors\nDescription Interface received when binding item to VisualElement\nMethods    Method Name Description     OnBindItem Called when an item is bound to a VisualElement   OnUnbindItem Called when the binding to VisualElement is released    ",
        "content": "\r\rInterface in LogicToolkit.Editors\nDescription Interface received when binding item to VisualElement\nMethods    Method Name Description     OnBindItem Called when an item is bound to a VisualElement   OnUnbindItem Called when the binding to VisualElement is released    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/ICheckRecompute.html",
        "title": "ICheckRecompute",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface to determine whether recomputation is necessary\nBy implementing it in ActionComponent, you can determine whether to perform recomputation when using it with a Compute node.\nMethods    Method Name Description     OnCheckRecompute Determine whether recomputation is necessary.    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface to determine whether recomputation is necessary\nBy implementing it in ActionComponent, you can determine whether to perform recomputation when using it with a Compute node.\nMethods    Method Name Description     OnCheckRecompute Determine whether recomputation is necessary.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IConnectPortToComponentContext.html",
        "title": "IConnectPortToComponentContext",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit.Editors\nDescription The interface that connects to the port being dragged when the node component is created.\nMethods    Method Name Description     Connect Connect to the port being dragged when the node component is created    ",
        "content": "\r\rInterface in LogicToolkit.Editors\nDescription The interface that connects to the port being dragged when the node component is created.\nMethods    Method Name Description     Connect Connect to the port being dragged when the node component is created    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/FS-IconUssClassName.html",
        "title": "IconUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string IconUssClassName ;\r\r\rDescription USS class name of icon elements in elements of this type.",
        "content": "public static string IconUssClassName ;\r\r\rDescription USS class name of icon elements in elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-Id.html",
        "title": "Id",
        "tags": [],
        "description": "",
        "summary": "public long Id ;\r\r\rDescription Node ID",
        "content": "public long Id ;\r\r\rDescription Node ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLinkReference/P-Id.html",
        "title": "Id",
        "tags": [],
        "description": "",
        "summary": "public UniqueId Id ;\r\r\rDescription ID",
        "content": "public UniqueId Id ;\r\r\rDescription ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Node/P-Id.html",
        "title": "Id",
        "tags": [],
        "description": "",
        "summary": "public long Id ;\r\r\rDescription Node ID",
        "content": "public long Id ;\r\r\rDescription Node ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-Id.html",
        "title": "Id",
        "tags": [],
        "description": "",
        "summary": "public long Id ;\r\r\rDescription Node graph ID",
        "content": "public long Id ;\r\r\rDescription Node graph ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/P-Id.html",
        "title": "Id",
        "tags": [],
        "description": "",
        "summary": "public long Id ;\r\r\rDescription ID",
        "content": "public long Id ;\r\r\rDescription ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Wire/P-Id.html",
        "title": "Id",
        "tags": [],
        "description": "",
        "summary": "public long Id ;\r\r\rDescription Wire ID",
        "content": "public long Id ;\r\r\rDescription Wire ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IDataPortConnector.html",
        "title": "IDataPortConnector",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit.Editors\nDescription Interface that defines data port connections\nProperties    Property Name Description     DataType Data type    Methods    Method Name Description     UpdateDataType Update data type    ",
        "content": "\r\rInterface in LogicToolkit.Editors\nDescription Interface that defines data port connections\nProperties    Property Name Description     DataType Data type    Methods    Method Name Description     UpdateDataType Update data type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IEasingFunction.html",
        "title": "IEasingFunction",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface that defines easing functions\nMethods    Method Name Description     Ease Perform easing processing    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface that defines easing functions\nMethods    Method Name Description     Ease Perform easing processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/IgnoreGeneratorAttribute.html",
        "title": "IgnoreGeneratorAttribute",
        "tags": [],
        "description": "",
        "summary": "Attribute in LogicToolkit / Inherits from: System.Attribute\nDescription Mark to exclude from script generation",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Mark to exclude from script generation\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputDataPort.html",
        "title": "IInputDataPort",
        "tags": [],
        "description": "",
        "summary": "Interface in LogicToolkit\nImplements interfaces: IInputDataPortBase, IValueGetter\nDescription Input data port interface",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IInputDataPortBase, IValueGetter\nDescription Input data port interface\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputDataPortBase.html",
        "title": "IInputDataPortBase",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nImplements interfaces: IInputPort\nDescription Input data port basic interface\nMethods    Method Name Description     ValueChanged Communicate value changes.    ",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IInputPort\nDescription Input data port basic interface\nMethods    Method Name Description     ValueChanged Communicate value changes.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputPort.html",
        "title": "IInputPort",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface that defines the input port\nProperties    Property Name Description     ConnectedWiresCount Number of connected wires    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface that defines the input port\nProperties    Property Name Description     ConnectedWiresCount Number of connected wires    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor.html",
        "title": "IListAccessor",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface that defines list access\nMethods    Method Name Description     AddElement Add element   Clear Clear the list elements   Contains Determine if the element is included   Count Count the number of elements in the list.   GetElement Get the element   IndexOf Get the index of the element.   InsertElement insert element   RemoveAt Delete the element at index   RemoveElement Delete the element   SetElement Set the element   ToArray Convert list to array   ToList Convert list to List\u0026lt;T\u0026gt;    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface that defines list access\nMethods    Method Name Description     AddElement Add element   Clear Clear the list elements   Contains Determine if the element is included   Count Count the number of elements in the list.   GetElement Get the element   IndexOf Get the index of the element.   InsertElement insert element   RemoveAt Delete the element at index   RemoveElement Delete the element   SetElement Set the element   ToArray Convert list to array   ToList Convert list to List\u0026lt;T\u0026gt;    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/EasingMode/In.html",
        "title": "In",
        "tags": [],
        "description": "",
        "summary": "Description Input side",
        "content": "Description Input side\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ScriptGeneratedAttribute/F-Index.html",
        "title": "Index",
        "tags": [],
        "description": "",
        "summary": "public int Index ;\r\r\rDescription Generation information index",
        "content": "public int Index ;\r\r\rDescription Generation information index\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-IndexOf.html",
        "title": "IndexOf",
        "tags": [],
        "description": "",
        "summary": "IndexOf(IValueGetter, IValueGetter) public int IndexOf(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Get the index of the element.\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element value    Returns Returns the found index. . Returns -1 if not found.",
        "content": "IndexOf(IValueGetter, IValueGetter) public int IndexOf(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Get the index of the element.\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element value    Returns Returns the found index. . Returns -1 if not found.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Enums/SignalExpiration/Infinite.html",
        "title": "Infinite",
        "tags": [],
        "description": "",
        "summary": "Description Infinite",
        "content": "Description Infinite\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/EasingMode/InOut.html",
        "title": "InOut",
        "tags": [],
        "description": "",
        "summary": "Description Both input and output sides",
        "content": "Description Both input and output sides\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/PortType/Input.html",
        "title": "Input",
        "tags": [],
        "description": "",
        "summary": "Description Input port",
        "content": "Description Input port\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputComponent-T-/InputComponent-ctor.html",
        "title": "InputComponent",
        "tags": [],
        "description": "",
        "summary": "InputComponent() public InputComponent() ;\r\r\rDescription Constructor\nInputComponent(T) public InputComponent(T value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    ",
        "content": "InputComponent() public InputComponent() ;\r\r\rDescription Constructor\nInputComponent(T) public InputComponent(T value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputComponent-T-.html",
        "title": "InputComponent&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: InputField\u0026lt;T, ComponentConstantContainer\u0026lt;T\u0026gt;\u0026gt;\nDescription Input field of type Component\nType Parameters    Type Parameter Name Description Type Constraints     T Component type Component    Constructors     Description     InputComponent Constructor    Inherited Members Properties    Property Name Description     Value Get value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputField\u0026lt;T, ComponentConstantContainer\u0026lt;T\u0026gt;\u0026gt;\nDescription Input field of type Component\nType Parameters    Type Parameter Name Description Type Constraints     T Component type Component    Constructors     Description     InputComponent Constructor    Inherited Members Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputDataPort-T-.html",
        "title": "InputDataPort&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: DataPort\u0026lt;T\u0026gt;\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;, IInputDataPort\nDescription Generic type input data port\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Methods    Method Name Description     GetValue Get value   TryGetValue Get value    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: DataPort\u0026lt;T\u0026gt;\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;, IInputDataPort\nDescription Generic type input data port\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Methods    Method Name Description     GetValue Get value   TryGetValue Get value    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputDataPortWithType.html",
        "title": "InputDataPortWithType",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: DataPortWithType\nImplements interfaces: IValueTryGetter, IInputDataPort\nDescription Typeable input data port\nMethods    Method Name Description     TryGetValue Get value    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port   Type Data type    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: DataPortWithType\nImplements interfaces: IValueTryGetter, IInputDataPort\nDescription Typeable input data port\nMethods    Method Name Description     TryGetValue Get value    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port   Type Data type    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputField-T-/InputField-ctor.html",
        "title": "InputField",
        "tags": [],
        "description": "",
        "summary": "InputField() public InputField() ;\r\r\rDescription Constructor\nInputField(T) public InputField(T value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    ",
        "content": "InputField() public InputField() ;\r\r\rDescription Constructor\nInputField(T) public InputField(T value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputField-TValue-TContainer-/InputField-ctor.html",
        "title": "InputField",
        "tags": [],
        "description": "",
        "summary": "InputField() public InputField() ;\r\r\rDescription Constructor\nInputField(TContainer) public InputField(TContainer container) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     container Initial value    ",
        "content": "InputField() public InputField() ;\r\r\rDescription Constructor\nInputField(TContainer) public InputField(TContainer container) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     container Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputField-T-.html",
        "title": "InputField&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;T\u0026gt;\nDescription Generic type input field\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Constructors     Description     InputField Constructor    Inherited Members Properties    Property Name Description     Value Get value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;T\u0026gt;\nDescription Generic type input field\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Constructors     Description     InputField Constructor    Inherited Members Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputField-TValue-TContainer-.html",
        "title": "InputField&lt;TValue, TContainer&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: InputFieldBase\u0026lt;TValue\u0026gt; Description Input field that can have a constant ConstantContainer\u0026lt;T\u0026gt; Type Parameters Type Parameter Name Description Type Constraints TValue Data type TContainer ConstantContainer\u0026lt;T\u0026gt;の型 ConstantContainer\u0026lt;TValue\u0026gt; Constructors Description InputField Constructor Inherited Members Properties Property Name Description Value Get value",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;TValue\u0026gt;\nDescription Input field that can have a constant ConstantContainer\u0026lt;T\u0026gt;\nType Parameters    Type Parameter Name Description Type Constraints     TValue Data type    TContainer ConstantContainer\u0026lt;T\u0026gt;の型 ConstantContainer\u0026lt;TValue\u0026gt;    Constructors     Description     InputField Constructor    Inherited Members Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputFieldBase.html",
        "title": "InputFieldBase",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: object\nImplements interfaces: IValueGetter\nDescription Basic type of input field",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nImplements interfaces: IValueGetter\nDescription Basic type of input field\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputFieldBase-T-.html",
        "title": "InputFieldBase&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;\nDescription Base type of input field of generic type\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Properties    Property Name Description     Value Get value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;\nDescription Base type of input field of generic type\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/InputFieldElementBase.html",
        "title": "InputFieldElementBase",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: BaseFieldExt\u0026lt;InputFieldBase\u0026gt;\nDescription Basic type of UI element for InputField\nProperties    Property Name Description     Label Label name   PortField Port UI elements    Methods    Method Name Description     Disconnect Disconnect a port   OnConnectionChanged Called when the port connection changes    Inherited Members Properties    Property Name Description     VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: BaseFieldExt\u0026lt;InputFieldBase\u0026gt;\nDescription Basic type of UI element for InputField\nProperties    Property Name Description     Label Label name   PortField Port UI elements    Methods    Method Name Description     Disconnect Disconnect a port   OnConnectionChanged Called when the port connection changes    Inherited Members Properties    Property Name Description     VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/InputFieldElementUtility.html",
        "title": "InputFieldElementUtility",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Utility class for InputFieldElement\nStatic Methods    Method Name Description     CreateElement Create UI element for InputField    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Utility class for InputFieldElement\nStatic Methods    Method Name Description     CreateElement Create UI element for InputField    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputFieldUtility.html",
        "title": "InputFieldUtility",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Input field utility class\nStatic Methods    Method Name Description     GetInputFieldType Get input field type from value type    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Input field utility class\nStatic Methods    Method Name Description     GetInputFieldType Get input field type from value type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputGameObject.html",
        "title": "InputGameObject",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: InputField\u0026lt;UnityEngine.GameObject, GameObjectConstantContainer\u0026gt;\nDescription Input field of type GameObject\nConstructors     Description     InputGameObject Constructor    Inherited Members Properties    Property Name Description     Value Get value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputField\u0026lt;UnityEngine.GameObject, GameObjectConstantContainer\u0026gt;\nDescription Input field of type GameObject\nConstructors     Description     InputGameObject Constructor    Inherited Members Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputGameObject/InputGameObject-ctor.html",
        "title": "InputGameObject",
        "tags": [],
        "description": "",
        "summary": "InputGameObject() public InputGameObject() ;\r\r\rDescription Constructor\nInputGameObject(GameObject) public InputGameObject(GameObject value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    ",
        "content": "InputGameObject() public InputGameObject() ;\r\r\rDescription Constructor\nInputGameObject(GameObject) public InputGameObject(GameObject value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputList-T-/InputList-ctor.html",
        "title": "InputList",
        "tags": [],
        "description": "",
        "summary": "InputList() public InputList() ;\r\r\rDescription Constructor\nInputList(IList\u0026lt;T\u0026gt;) public InputList(IList\u0026lt;T\u0026gt; values) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     values Initial value    ",
        "content": "InputList() public InputList() ;\r\r\rDescription Constructor\nInputList(IList\u0026lt;T\u0026gt;) public InputList(IList\u0026lt;T\u0026gt; values) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     values Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputList-T-.html",
        "title": "InputList&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;System.Collections.Generic.IList\u0026lt;T\u0026gt;\u0026gt;\nDescription Input field of type IList\u0026lt;T\u0026gt;\nType Parameters    Type Parameter Name Description Type Constraints     T Element type     Constructors     Description     InputList Constructor    Inherited Members Properties    Property Name Description     Value Get value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;System.Collections.Generic.IList\u0026lt;T\u0026gt;\u0026gt;\nDescription Input field of type IList\u0026lt;T\u0026gt;\nType Parameters    Type Parameter Name Description Type Constraints     T Element type     Constructors     Description     InputList Constructor    Inherited Members Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Wire/P-InputPort.html",
        "title": "InputPort",
        "tags": [],
        "description": "",
        "summary": "public IInputPort InputPort ;\r\r\rDescription Input port",
        "content": "public IInputPort InputPort ;\r\r\rDescription Input port\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputQuaternion.html",
        "title": "InputQuaternion",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;UnityEngine.Quaternion\u0026gt;\nDescription Input field for Quaternion.\nFixed values can be set in Euler angles.\nConstructors     Description     InputQuaternion Constructor    Inherited Members Properties    Property Name Description     Value Get value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;UnityEngine.Quaternion\u0026gt;\nDescription Input field for Quaternion.\nFixed values can be set in Euler angles.\nConstructors     Description     InputQuaternion Constructor    Inherited Members Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputQuaternion/InputQuaternion-ctor.html",
        "title": "InputQuaternion",
        "tags": [],
        "description": "",
        "summary": "InputQuaternion() public InputQuaternion() ;\r\r\rDescription Constructor\nInputQuaternion(Vector3) public InputQuaternion(Vector3 euler) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     euler Initial value    ",
        "content": "InputQuaternion() public InputQuaternion() ;\r\r\rDescription Constructor\nInputQuaternion(Vector3) public InputQuaternion(Vector3 euler) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     euler Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputSystemType.html",
        "title": "InputSystemType",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;System.Type\u0026gt;\nDescription Input field of type Type\nConstructors     Description     InputSystemType Constructor    Inherited Members Properties    Property Name Description     Value Get value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: InputFieldBase\u0026lt;System.Type\u0026gt;\nDescription Input field of type Type\nConstructors     Description     InputSystemType Constructor    Inherited Members Properties    Property Name Description     Value Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputSystemType/InputSystemType-ctor.html",
        "title": "InputSystemType",
        "tags": [],
        "description": "",
        "summary": "InputSystemType() public InputSystemType() ;\r\r\rDescription Constructor\nInputSystemType(Type) public InputSystemType(Type value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    ",
        "content": "InputSystemType() public InputSystemType() ;\r\r\rDescription Constructor\nInputSystemType(Type) public InputSystemType(Type value) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     value Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/FS-InputUssClassName.html",
        "title": "InputUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string InputUssClassName ;\r\r\rDescription USS class name of input elements in elements of this type.",
        "content": "public static string InputUssClassName ;\r\r\rDescription USS class name of input elements in elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-InsertElement.html",
        "title": "InsertElement",
        "tags": [],
        "description": "",
        "summary": "InsertElement(IValueGetter, int, IValueGetter) public bool InsertElement(IValueGetter listGetter, int index, IValueGetter elementGetter) ;\r\r\rDescription insert element\nParameters    Parameter Name Description     listGetter Instance to get list   index Index to insert   elementGetter Instance to get element value    Returns Returns true if the element is inserted. Otherwise returns false.",
        "content": "InsertElement(IValueGetter, int, IValueGetter) public bool InsertElement(IValueGetter listGetter, int index, IValueGetter elementGetter) ;\r\r\rDescription insert element\nParameters    Parameter Name Description     listGetter Instance to get list   index Index to insert   elementGetter Instance to get element value    Returns Returns true if the element is inserted. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomAttribute/F-InspectedType.html",
        "title": "InspectedType",
        "tags": [],
        "description": "",
        "summary": "public Type InspectedType ;\r\r\rDescription Target type",
        "content": "public Type InspectedType ;\r\r\rDescription Target type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Interface.html",
        "title": "Interface",
        "tags": [],
        "description": "",
        "summary": "Description Interface",
        "content": "Description Interface\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ByteLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(byte, byte, float) public byte Interpolate(byte from, byte to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(byte, byte, float) public byte Interpolate(byte from, byte to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/CharLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(char, char, float) public char Interpolate(char from, char to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(char, char, float) public char Interpolate(char from, char to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ColorLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Color, Color, float) public Color Interpolate(Color from, Color to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Color, Color, float) public Color Interpolate(Color from, Color to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/DoubleLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(double, double, float) public double Interpolate(double from, double to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(double, double, float) public double Interpolate(double from, double to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/FloatLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(float, float, float) public float Interpolate(float from, float to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(float, float, float) public float Interpolate(float from, float to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Interpolator-T-/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(T, T, float) public T Interpolate(T from, T to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(T, T, float) public T Interpolate(T from, T to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/IntLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(int, int, float) public int Interpolate(int from, int to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(int, int, float) public int Interpolate(int from, int to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LongLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(long, long, float) public long Interpolate(long from, long to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(long, long, float) public long Interpolate(long from, long to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/QuaternionLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Quaternion, Quaternion, float) public Quaternion Interpolate(Quaternion from, Quaternion to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Quaternion, Quaternion, float) public Quaternion Interpolate(Quaternion from, Quaternion to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/QuaternionSlerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Quaternion, Quaternion, float) public Quaternion Interpolate(Quaternion from, Quaternion to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Quaternion, Quaternion, float) public Quaternion Interpolate(Quaternion from, Quaternion to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SByteLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(sbyte, sbyte, float) public sbyte Interpolate(sbyte from, sbyte to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(sbyte, sbyte, float) public sbyte Interpolate(sbyte from, sbyte to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ShortLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(short, short, float) public short Interpolate(short from, short to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(short, short, float) public short Interpolate(short from, short to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UIntLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(uint, uint, float) public uint Interpolate(uint from, uint to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(uint, uint, float) public uint Interpolate(uint from, uint to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ULongLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(ulong, ulong, float) public ulong Interpolate(ulong from, ulong to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(ulong, ulong, float) public ulong Interpolate(ulong from, ulong to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UShortLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(ushort, ushort, float) public ushort Interpolate(ushort from, ushort to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(ushort, ushort, float) public ushort Interpolate(ushort from, ushort to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector2IntLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Vector2Int, Vector2Int, float) public Vector2Int Interpolate(Vector2Int from, Vector2Int to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Vector2Int, Vector2Int, float) public Vector2Int Interpolate(Vector2Int from, Vector2Int to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector2Lerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Vector2, Vector2, float) public Vector2 Interpolate(Vector2 from, Vector2 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Vector2, Vector2, float) public Vector2 Interpolate(Vector2 from, Vector2 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector3IntLerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Vector3Int, Vector3Int, float) public Vector3Int Interpolate(Vector3Int from, Vector3Int to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Vector3Int, Vector3Int, float) public Vector3Int Interpolate(Vector3Int from, Vector3Int to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector3Lerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Vector3, Vector3, float) public Vector3 Interpolate(Vector3 from, Vector3 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Vector3, Vector3, float) public Vector3 Interpolate(Vector3 from, Vector3 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector3Slerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Vector3, Vector3, float) public Vector3 Interpolate(Vector3 from, Vector3 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Vector3, Vector3, float) public Vector3 Interpolate(Vector3 from, Vector3 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector4Lerp/M-Interpolate.html",
        "title": "Interpolate",
        "tags": [],
        "description": "",
        "summary": "Interpolate(Vector4, Vector4, float) public Vector4 Interpolate(Vector4 from, Vector4 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result",
        "content": "Interpolate(Vector4, Vector4, float) public Vector4 Interpolate(Vector4 from, Vector4 to, float t) ;\r\r\rDescription Perform interpolation processing\nParameters    Parameter Name Description     from Original value   to Target value   t Progress    Returns Interpolation result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Interpolator-T-.html",
        "title": "Interpolator&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type for interpolation processing\nType Parameters    Type Parameter Name Description Type Constraints     T Type of value to be interpolated     Methods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type for interpolation processing\nType Parameters    Type Parameter Name Description Type Constraints     T Type of value to be interpolated     Methods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/IntLerp.html",
        "title": "IntLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;int\u0026gt;\nDescription Linear interpolation of type int\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;int\u0026gt;\nDescription Linear interpolation of type int\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IOutputDataPort.html",
        "title": "IOutputDataPort",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueSetter, IOutputPort\nDescription Output data port basic interface\nProperties    Property Name Description     HasValue Whether the output data port has a value    ",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueSetter, IOutputPort\nDescription Output data port basic interface\nProperties    Property Name Description     HasValue Whether the output data port has a value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IOutputPort.html",
        "title": "IOutputPort",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface that defines the output port\nProperties    Property Name Description     ConnectedWiresCount Number of connected wires    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface that defines the output port\nProperties    Property Name Description     ConnectedWiresCount Number of connected wires    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IPauseReceiver.html",
        "title": "IPauseReceiver",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface to receive graph pauses\nMethods    Method Name Description     OnPause Called when the graph is paused/resumed    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface to receive graph pauses\nMethods    Method Name Description     OnPause Called when the graph is paused/resumed    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IProgressComponent.html",
        "title": "IProgressComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface for displaying progress bar on NodeComponent\nProperties    Property Name Description     ProgressPlayer Return progress player    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface for displaying progress bar on NodeComponent\nProperties    Property Name Description     ProgressPlayer Return progress player    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator/M-IsAcceptableAssignor.html",
        "title": "IsAcceptableAssignor",
        "tags": [],
        "description": "",
        "summary": "IsAcceptableAssignor(FieldAssignor) public bool IsAcceptableAssignor(FieldAssignor fieldAssignor) ; Description フィールドの割り当てを許可できるかを判定する Parameters Parameter Name Description fieldAssignor フィールドに割り当てるデータ Returns フィールドの割り当てを許可できるかどうか",
        "content": "IsAcceptableAssignor(FieldAssignor) public bool IsAcceptableAssignor(FieldAssignor fieldAssignor) ;\r\r\rDescription フィールドの割り当てを許可できるかを判定する\nParameters    Parameter Name Description     fieldAssignor フィールドに割り当てるデータ    Returns フィールドの割り当てを許可できるかどうか\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableComponent/P-IsActive.html",
        "title": "IsActive",
        "tags": [],
        "description": "",
        "summary": "public bool IsActive ;\r\r\rDescription Active or not",
        "content": "public bool IsActive ;\r\r\rDescription Active or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableNode/P-IsActive.html",
        "title": "IsActive",
        "tags": [],
        "description": "",
        "summary": "public bool IsActive ;\r\r\rDescription Active or not",
        "content": "public bool IsActive ;\r\r\rDescription Active or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ProgressPlayer/P-IsActive.html",
        "title": "IsActive",
        "tags": [],
        "description": "",
        "summary": "public bool IsActive ;\r\r\rDescription Active or not",
        "content": "public bool IsActive ;\r\r\rDescription Active or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter/M-IsAssignableFrom.html",
        "title": "IsAssignableFrom",
        "tags": [],
        "description": "",
        "summary": "IsAssignableFrom(Type) public bool IsAssignableFrom(Type type) ;\r\r\rDescription Determine if the type is assignable\nParameters    Parameter Name Description     type Target type    Returns Returns true if assignable. otherwise returns false",
        "content": "IsAssignableFrom(Type) public bool IsAssignableFrom(Type type) ;\r\r\rDescription Determine if the type is assignable\nParameters    Parameter Name Description     type Target type    Returns Returns true if assignable. otherwise returns false\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/M-IsConnectable.html",
        "title": "IsConnectable",
        "tags": [],
        "description": "",
        "summary": "IsConnectable(GraphEditor, NodeEditor, NodeEditor, PortConnector, PortType) public bool IsConnectable(GraphEditor graphEditor, NodeEditor ownerNodeEditor, NodeEditor targetNodeEditor, PortConnector portConnector, PortType portType) ;\r\r\rDescription Determine whether connection is possible.\nParameters    Parameter Name Description     graphEditor Graph editor   ownerNodeEditor Owner node editor   targetNodeEditor Target node editor   portConnector Target port connector   portType Type of port to connect    Returns Returns true if connection is possible.",
        "content": "IsConnectable(GraphEditor, NodeEditor, NodeEditor, PortConnector, PortType) public bool IsConnectable(GraphEditor graphEditor, NodeEditor ownerNodeEditor, NodeEditor targetNodeEditor, PortConnector portConnector, PortType portType) ;\r\r\rDescription Determine whether connection is possible.\nParameters    Parameter Name Description     graphEditor Graph editor   ownerNodeEditor Owner node editor   targetNodeEditor Target node editor   portConnector Target port connector   portType Type of port to connect    Returns Returns true if connection is possible. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TypeUtility/MS-IsImplementedTo.html",
        "title": "IsImplementedTo",
        "tags": [],
        "description": "",
        "summary": "IsImplementedTo(Type, Type) public static bool IsImplementedTo(Type baseType, Type type) ;\r\r\rDescription Determine whether baseType is implemented\nParameters    Parameter Name Description     baseType Base type   type Target type    Returns Returns true if implemented. Otherwise returns false.",
        "content": "IsImplementedTo(Type, Type) public static bool IsImplementedTo(Type baseType, Type type) ;\r\r\rDescription Determine whether baseType is implemented\nParameters    Parameter Name Description     baseType Base type   type Target type    Returns Returns true if implemented. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/ITypeMenuContext.html",
        "title": "ITypeMenuContext",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit.Editors\nDescription Interface called when creating a node component from the type selection menu\nMethods    Method Name Description     OnCreated Called when a node component is created    ",
        "content": "\r\rInterface in LogicToolkit.Editors\nDescription Interface called when creating a node component from the type selection menu\nMethods    Method Name Description     OnCreated Called when a node component is created    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IUpdateReceiver.html",
        "title": "IUpdateReceiver",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface that receives update calls\nMethods    Method Name Description     OnUpdate Called when updating    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface that receives update calls\nMethods    Method Name Description     OnUpdate Called when updating    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueContainer.html",
        "title": "IValueContainer",
        "tags": [],
        "description": "",
        "summary": "Interface in LogicToolkit\nImplements interfaces: IValueSetter, IValueGetter\nDescription Interface that defines a container for values",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueSetter, IValueGetter\nDescription Interface that defines a container for values\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueContainer-T-.html",
        "title": "IValueContainer&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;, IValueSetter\u0026lt;T\u0026gt;, IValueContainer\nDescription Generic type interface that defines a container for values\nType Parameters    Type Parameter Name Description Type Constraints     T value type     ",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;, IValueSetter\u0026lt;T\u0026gt;, IValueContainer\nDescription Generic type interface that defines a container for values\nType Parameters    Type Parameter Name Description Type Constraints     T value type     "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueGetter.html",
        "title": "IValueGetter",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface that defines the types whose values can be retrieved\nMethods    Method Name Description     GetValueObject Get value   GetValueString Get value string   GetValueType Get value type    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface that defines the types whose values can be retrieved\nMethods    Method Name Description     GetValueObject Get value   GetValueString Get value string   GetValueType Get value type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueGetter-T-.html",
        "title": "IValueGetter&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueGetter\nDescription Generic type interface that defines types whose values can be retrieved\nType Parameters    Type Parameter Name Description Type Constraints     T Value type     Methods    Method Name Description     GetValue Get value    ",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueGetter\nDescription Generic type interface that defines types whose values can be retrieved\nType Parameters    Type Parameter Name Description Type Constraints     T Value type     Methods    Method Name Description     GetValue Get value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter.html",
        "title": "IValueSetter",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nDescription Interface that defines a type whose value can be set\nMethods    Method Name Description     GetValueType Get value type   IsAssignableFrom Determine if the type is assignable   SetDefault Set default values   SetValue Set the value   SetValueObject Set the value    ",
        "content": "\r\rInterface in LogicToolkit\nDescription Interface that defines a type whose value can be set\nMethods    Method Name Description     GetValueType Get value type   IsAssignableFrom Determine if the type is assignable   SetDefault Set default values   SetValue Set the value   SetValueObject Set the value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter-T-.html",
        "title": "IValueSetter&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueSetter\nDescription Generic type interface that defines a settable type\nType Parameters    Type Parameter Name Description Type Constraints     T Value type     Methods    Method Name Description     SetValue Set the value    ",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueSetter\nDescription Generic type interface that defines a settable type\nType Parameters    Type Parameter Name Description Type Constraints     T Value type     Methods    Method Name Description     SetValue Set the value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueTryGetter.html",
        "title": "IValueTryGetter",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueGetter\nDescription Interface that defines the type whose value is attempted to be retrieved\nMethods    Method Name Description     TryGetValue Attempt to get the value    ",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueGetter\nDescription Interface that defines the type whose value is attempted to be retrieved\nMethods    Method Name Description     TryGetValue Attempt to get the value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueTrySetter.html",
        "title": "IValueTrySetter",
        "tags": [],
        "description": "",
        "summary": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueSetter\nDescription Interface that defines the type that attempts to set the value.\nMethods    Method Name Description     TrySetValue Attempt to set the value    ",
        "content": "\r\rInterface in LogicToolkit\nImplements interfaces: IValueSetter\nDescription Interface that defines the type that attempts to set the value.\nMethods    Method Name Description     TrySetValue Attempt to set the value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem/F-Keywords.html",
        "title": "Keywords",
        "tags": [],
        "description": "",
        "summary": "public string[] Keywords ;\r\r\rDescription Search keyword",
        "content": "public string[] Keywords ;\r\r\rDescription Search keyword\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-Keywords.html",
        "title": "Keywords",
        "tags": [],
        "description": "",
        "summary": "public string[] Keywords ;\r\r\rDescription Keywords",
        "content": "public string[] Keywords ;\r\r\rDescription Keywords\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MenuKeywordsAttribute/F-Keywords.html",
        "title": "Keywords",
        "tags": [],
        "description": "",
        "summary": "public string[] Keywords ;\r\r\rDescription Keywords",
        "content": "public string[] Keywords ;\r\r\rDescription Keywords\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MemberIconAttribute/F-Kind.html",
        "title": "Kind",
        "tags": [],
        "description": "",
        "summary": "public MemberIconKind Kind ;\r\r\rDescription Member icon kind",
        "content": "public MemberIconKind Kind ;\r\r\rDescription Member icon kind\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BaseFieldExt-TValueType-/P-Label.html",
        "title": "Label",
        "tags": [],
        "description": "",
        "summary": "public string Label ;\r\r\rDescription Label name",
        "content": "public string Label ;\r\r\rDescription Label name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/InputFieldElementBase/P-Label.html",
        "title": "Label",
        "tags": [],
        "description": "",
        "summary": "public string Label ;\r\r\rDescription Label name",
        "content": "public string Label ;\r\r\rDescription Label name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/FS-LabelExpandUssClassName.html",
        "title": "LabelExpandUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string LabelExpandUssClassName ;\r\r\rDescription The USS class name of the expansion to give to labels within elements of this type.",
        "content": "public static string LabelExpandUssClassName ;\r\r\rDescription The USS class name of the expansion to give to labels within elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/FS-LabelUssClassName.html",
        "title": "LabelUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string LabelUssClassName ;\r\r\rDescription USS class name of labels in elements of this type.",
        "content": "public static string LabelUssClassName ;\r\r\rDescription USS class name of labels in elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/FS-LabelUssClassName.html",
        "title": "LabelUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string LabelUssClassName ;\r\r\rDescription USS class name of labels in elements of this type.",
        "content": "public static string LabelUssClassName ;\r\r\rDescription USS class name of labels in elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/FieldPlacement/Left.html",
        "title": "Left",
        "tags": [],
        "description": "",
        "summary": "Description Left side",
        "content": "Description Left side\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/FS-LeftViewUssClassName.html",
        "title": "LeftViewUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string LeftViewUssClassName ;\r\r\rDescription Left view USS class name",
        "content": "public static string LeftViewUssClassName ;\r\r\rDescription Left view USS class name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/ComparisonOp/LessThan.html",
        "title": "LessThan",
        "tags": [],
        "description": "",
        "summary": "Description Less than",
        "content": "Description Less than\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/ComparisonOp/LessThanOrEqual.html",
        "title": "LessThanOrEqual",
        "tags": [],
        "description": "",
        "summary": "Description Less than or equal",
        "content": "Description Less than or equal\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ListAccessorUtility.html",
        "title": "ListAccessorUtility",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription ListAccessor utility class\nStatic Methods    Method Name Description     GetListAccessor Get IListAccessor    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription ListAccessor utility class\nStatic Methods    Method Name Description     GetListAccessor Get IListAccessor    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardSource/Local.html",
        "title": "Local",
        "tags": [],
        "description": "",
        "summary": "Description Local",
        "content": "Description Local\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicAsset.html",
        "title": "LogicAsset",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: UnityEngine.ScriptableObject\nDescription Assets that handle LogicAsset.LogicController\nProperties    Property Name Description     LogicController LogicController    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: UnityEngine.ScriptableObject\nDescription Assets that handle LogicAsset.LogicController\nProperties    Property Name Description     LogicController LogicController    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicBehavior.html",
        "title": "LogicBehavior",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: LogicPlayerBase\nDescription A component for internally holding and playing LogicBehavior.LogicController\nProperties    Property Name Description     LogicController Returns the instance of LogicPlayerBase.LogicController that is playing    Inherited Members Properties    Property Name Description     PlayState Play status    Methods    Method Name Description     Pause Pause.",
        "content": "\r\rClass in LogicToolkit / Inherits from: LogicPlayerBase\nDescription A component for internally holding and playing LogicBehavior.LogicController\nProperties    Property Name Description     LogicController Returns the instance of LogicPlayerBase.LogicController that is playing    Inherited Members Properties    Property Name Description     PlayState Play status    Methods    Method Name Description     Pause Pause.   Play Start playing   Resume Resume.   Stop Stop playback.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicAsset/P-LogicController.html",
        "title": "LogicController",
        "tags": [],
        "description": "",
        "summary": "public LogicController LogicController ;\r\r\rDescription LogicController",
        "content": "public LogicController LogicController ;\r\r\rDescription LogicController\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicBehavior/P-LogicController.html",
        "title": "LogicController",
        "tags": [],
        "description": "",
        "summary": "public LogicController LogicController ;\r\r\rDescription Returns the instance of LogicPlayerBase.LogicController that is playing",
        "content": "public LogicController LogicController ;\r\r\rDescription Returns the instance of LogicPlayerBase.LogicController that is playing\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicController.html",
        "title": "LogicController",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: object\nDescription Main classes that control logic\nProperties    Property Name Description     Blackboard Root blackboard   BlackboardDataLink Blackboard data link   FunctionGraphCount Number of function graphs   MainGraph Main graph    Methods    Method Name Description     GetFunctionGraphAt Get the function graph.   TryGetFunctionGraph Get the function graph.",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Main classes that control logic\nProperties    Property Name Description     Blackboard Root blackboard   BlackboardDataLink Blackboard data link   FunctionGraphCount Number of function graphs   MainGraph Main graph    Methods    Method Name Description     GetFunctionGraphAt Get the function graph.   TryGetFunctionGraph Get the function graph.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayer/P-LogicController.html",
        "title": "LogicController",
        "tags": [],
        "description": "",
        "summary": "public LogicController LogicController ;\r\r\rDescription Returns the instance of LogicPlayerBase.LogicController that is playing",
        "content": "public LogicController LogicController ;\r\r\rDescription Returns the instance of LogicPlayerBase.LogicController that is playing\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayerBase/P-LogicController.html",
        "title": "LogicController",
        "tags": [],
        "description": "",
        "summary": "public LogicController LogicController ;\r\r\rDescription Returns the instance of LogicPlayerBase.LogicController that is playing",
        "content": "public LogicController LogicController ;\r\r\rDescription Returns the instance of LogicPlayerBase.LogicController that is playing\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-LogicController.html",
        "title": "LogicController",
        "tags": [],
        "description": "",
        "summary": "public LogicController LogicController ;\r\r\rDescription NodeGraph.LogicController that controls this node graph",
        "content": "public LogicController LogicController ;\r\r\rDescription NodeGraph.LogicController that controls this node graph\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayer.html",
        "title": "LogicPlayer",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: LogicPlayerBase\nDescription Component that references and plays LogicAsset\nProperties    Property Name Description     Asset Reference to LogicAsset   LogicController Returns the instance of LogicPlayerBase.LogicController that is playing    Inherited Members Properties    Property Name Description     PlayState Play status    Methods    Method Name Description     Pause Pause.",
        "content": "\r\rClass in LogicToolkit / Inherits from: LogicPlayerBase\nDescription Component that references and plays LogicAsset\nProperties    Property Name Description     Asset Reference to LogicAsset   LogicController Returns the instance of LogicPlayerBase.LogicController that is playing    Inherited Members Properties    Property Name Description     PlayState Play status    Methods    Method Name Description     Pause Pause.   Play Start playing   Resume Resume.   Stop Stop playback.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayerBase.html",
        "title": "LogicPlayerBase",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: UnityEngine.MonoBehaviour\nDescription Basic type of component that plays LogicPlayerBase.LogicController\nProperties    Property Name Description     LogicController Returns the instance of LogicPlayerBase.LogicController that is playing   PlayState Play status    Methods    Method Name Description     Pause Pause.   Play Start playing   Resume Resume.   Stop Stop playback.",
        "content": "\r\rClass in LogicToolkit / Inherits from: UnityEngine.MonoBehaviour\nDescription Basic type of component that plays LogicPlayerBase.LogicController\nProperties    Property Name Description     LogicController Returns the instance of LogicPlayerBase.LogicController that is playing   PlayState Play status    Methods    Method Name Description     Pause Pause.   Play Start playing   Resume Resume.   Stop Stop playback.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.html",
        "title": "LogicToolkit",
        "tags": [],
        "description": "",
        "summary": "Types    Type Name Description     AssetInfo Asset information   Blackboard Blackboard to manage Variable   BlackboardAsset Asset containing BlackboardAsset.Blackboard.\nMainly used for referencing from BlackboardDataLinkReference and sharing as a data link.   BlackboardDataLink Datalinks that share Blackboard between objects   BlackboardDataLinkReference Data link reference information for BlackboardDataLinkReference.Blackboard   Variable Variables stored in Blackboard   VariableBase\u0026lt;T\u0026gt; Generic basic type of variables stored in Blackboard   Variable\u0026lt;T\u0026gt; Generic type of variables stored in Blackboard   VariableList\u0026lt;T\u0026gt; List type variable stored in Blackboard   VariableReference Reference to VariableReference.",
        "content": "Types    Type Name Description     AssetInfo Asset information   Blackboard Blackboard to manage Variable   BlackboardAsset Asset containing BlackboardAsset.Blackboard.\nMainly used for referencing from BlackboardDataLinkReference and sharing as a data link.   BlackboardDataLink Datalinks that share Blackboard between objects   BlackboardDataLinkReference Data link reference information for BlackboardDataLinkReference.Blackboard   Variable Variables stored in Blackboard   VariableBase\u0026lt;T\u0026gt; Generic basic type of variables stored in Blackboard   Variable\u0026lt;T\u0026gt; Generic type of variables stored in Blackboard   VariableList\u0026lt;T\u0026gt; List type variable stored in Blackboard   VariableReference Reference to VariableReference.Variable   ConstantContainer\u0026lt;T\u0026gt; Constant container   GameObjectConstantContainer Container for constants of type GameObject   ComponentConstantContainer\u0026lt;T\u0026gt; Container for constants of type Component   InputFieldBase Basic type of input field   InputFieldBase\u0026lt;T\u0026gt; Base type of input field of generic type   InputQuaternion Input field for Quaternion.\nFixed values can be set in Euler angles.   InputField\u0026lt;TValue, TContainer\u0026gt; Input field that can have a constant ConstantContainer\u0026lt;T\u0026gt;   InputField\u0026lt;T\u0026gt; Generic type input field   InputList\u0026lt;T\u0026gt; Input field of type IList\u0026lt;T\u0026gt;   InputGameObject Input field of type GameObject   InputComponent\u0026lt;T\u0026gt; Input field of type Component   InputSystemType Input field of type Type   InputFieldUtility Input field utility class   ComputeNodeBase Base class for compute nodes   ConvertNode Node that converts data type   DataPort Data port   DataPort\u0026lt;T\u0026gt; Generic type data port   DataPortWithType Typeable data port   InputDataPort\u0026lt;T\u0026gt; Generic type input data port   InputDataPortWithType Typeable input data port   OutputDataPort\u0026lt;T\u0026gt; Generic type output data port   OutputDataPortWithType Typeable output data port   LogicController Main classes that control logic   ActionComponent A component that performs a process that completes execution in an instant.   ActivatableComponent Components that switch between active states   EvaluateComponent Component to be evaluated   EventComponent Component that listens for events   NodeComponent Basic type of component for adding to nodes   ServiceComponent Components that perform resident processing   AsyncOperationComponent\u0026lt;TAsyncOperation\u0026gt; Component that waits for AsyncOperation to complete   TaskComponent Components that perform operations that take a long time to complete   WaitForSeconds Component that waits for a specified number of seconds to elapse   TweenComponent\u0026lt;TTarget, TInputField, T\u0026gt; A component that performs tween animation of parameters by specifying the target.   TweenComponentBase\u0026lt;T\u0026gt; Basic type of component that performs tweened animation of parameters   NodeGraph Basic type of node graph   ActivatableNode Node whose active state changes   ExecuteNode Execution node   BreakNode Flow end node to exit from the loop   CompleteNode Flow end node to complete the task   ContinueNode Flow end node to transition to next loop   ExitNode Flow end node to end node execution   FlowExitNode Basic type of flow end node   Node Basic type of node   ServiceNode Node that performs resident processing   ServiceNodeBase Basic type of node that performs resident processing   LogicAsset Assets that handle LogicAsset.LogicController   LogicBehavior A component for internally holding and playing LogicBehavior.LogicController   LogicPlayer Component that references and plays LogicAsset   LogicPlayerBase Basic type of component that plays LogicPlayerBase.LogicController   OutputExecutePort Output execution port   Port Basic type of normal port   PortBase Basic type of port   OutputTransitionPort Output transition port   TransitionalPort Basic type of port that handles transitions   ProgressPlayer Progress player\nImplement and use IProgressComponent in NodeComponent.   RefArgument\u0026lt;T, TInputField\u0026gt; A type that handles reference arguments. Mainly used for script generation.   Wire Basic type of wire   SerializableType Structure for handling SerializableType.Type with Unity's serialization system   UniqueId Structure that handles unique IDs   Timer Measure the passage of time   EaseBase Basic type for easing   Interpolator\u0026lt;T\u0026gt; Basic type for interpolation processing   ByteLerp Linear interpolation of type byte   SByteLerp Linear interpolation of type sbyte   CharLerp Linear interpolation of type char   ShortLerp Linear interpolation of type short   UShortLerp Linear interpolation of type ushort   IntLerp Linear interpolation of type int   UIntLerp Linear interpolation of type uint   LongLerp Linear interpolation of type long   ULongLerp Linear interpolation of type ulong   FloatLerp Linear interpolation of type float   DoubleLerp Linear interpolation of type double   Vector2Lerp Linear interpolation of type Vector2   Vector2IntLerp Linear interpolation of type Vector2Int   Vector3Lerp Linear interpolation of type Vector3   Vector3Slerp Spherical linear interpolation of type Vector3   Vector3IntLerp Linear interpolation of type Vector3Int   Vector4Lerp Linear interpolation of type Vector4   ColorLerp Linear interpolation of type Color   QuaternionLerp Linear interpolation of type Quaternion   QuaternionSlerp Spherical linear interpolation of type Quaternion   CompareUtility Utility class for value comparisons   TypeUtility Type utility class   ListAccessorUtility ListAccessor utility class   ValueContainer\u0026lt;T\u0026gt; Class that handles value containers   ValueFlowExtensions Value flow extension class    Interfaces    Type Name Description     ICheckRecompute Interface to determine whether recomputation is necessary\nBy implementing it in ActionComponent, you can determine whether to perform recomputation when using it with a Compute node.   IInputDataPortBase Input data port basic interface   IInputDataPort Input data port interface   IOutputDataPort Output data port basic interface   IProgressComponent Interface for displaying progress bar on NodeComponent   IInputPort Interface that defines the input port   IOutputPort Interface that defines the output port   IPauseReceiver Interface to receive graph pauses   IUpdateReceiver Interface that receives update calls   IEasingFunction Interface that defines easing functions   IValueContainer Interface that defines a container for values   IValueContainer\u0026lt;T\u0026gt; Generic type interface that defines a container for values   IValueGetter Interface that defines the types whose values can be retrieved   IValueGetter\u0026lt;T\u0026gt; Generic type interface that defines types whose values can be retrieved   IValueSetter Interface that defines a type whose value can be set   IValueSetter\u0026lt;T\u0026gt; Generic type interface that defines a settable type   IValueTryGetter Interface that defines the type whose value is attempted to be retrieved   IValueTrySetter Interface that defines the type that attempts to set the value.   IListAccessor Interface that defines list access    Enums    Type Name Description     MemberIconKind Member icon kind   BlackboardDataLinkShareType How to share the Blackboard instance referenced from BlackboardDataLinkReference   BlackboardSource Reference source of Blackboard   FieldPlacement Placement of fields   RecomputeMode Recomputation mode   TaskStatus Task status   PlayState Play status   TimerType Time Type   EasingMode Easing Mode   ComparisonOp Comparison operator    Attributes    Type Name Description     HideInTypePopupAttribute Hides types to which this attribute is applied from the type selection window.   HideInVariableMenuAttribute Hide types to which this attribute is applied from the Variable addition menu.   HideTypeInVariableMenuAttribute Applying this attribute to an assembly hides the specified type from the Add Variable menu.   IgnoreGeneratorAttribute Mark to exclude from script generation   MemberIconAttribute Display member icon on NodeComponent icon   MenuKeywordsAttribute Set keywords in the script selection menu.   MenuNameAttribute Set a name in the script selection menu.   ScriptGeneratedAttribute Mark as generated script   ValueTypeAttribute Restrict types that can be selected with SerializableType to types derived from the specified base type   AllowedTypesAttribute Set the types that are allowed to be used.   DisallowedTypesAttribute Set types that are not allowed to be used.   FieldPlacementAttribute Set the field placement. By applying this attribute to the NodeComponent field, you can specify the field placement.   ConstantColorUsageAttribute Attributes that configure constant configuration for Color\nCan be applied for fields in InputField\u0026lt;Color\u0026gt;.   ConstantDelayedAttribute Attribute that delays the finalization of constant changes.\nIf this attribute is applied, constant changes will not be committed until the user presses the enter key or takes focus from the field.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;, InputField\u0026lt;string\u0026gt;.   ConstantGradientUsageAttribute Attributes that configure constant configuration for Gradient\nCan be applied to fields in InputField\u0026lt;Gradient\u0026gt;.   ConstantMinAttribute Attributes that limit the minimum value, such as float or int. Can be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.   ConstantPropertyAttribute The base type of an attribute that, when applied to a field in InputField\u0026lt;T\u0026gt;, sets the configuration of a field of constant values.   ConstantRangeAttribute Attributes that limit the range of numbers, such as float or int.\nCan be applied to fields such as InputField\u0026lt;float\u0026gt;, InputField\u0026lt;int\u0026gt;.   ConstantTextAreaAttribute An attribute that allows you to edit multi-line strings.\nCan be applied to fields in InputField\u0026lt;string\u0026gt;.   FixedRecomputeModeAttribute Attribute to fix recompute mode   DefaultRecomputeModeAttribute Attribute that sets the default recomputation mode   DontUseComputeAttribute Attributes prohibited from use on Compute nodes   FieldOrderAttribute Attribute that sets field order. By applying this attribute to the fields of NodeComponent, you can set the display order of the fields.   FixedTitleNameAttribute Attribute that fixes the title name. You can fix the node name by applying this attribute to Node.   HideResultFieldAttribute Attribute that hides the Result field that outputs the execution results of TaskComponent. Mainly used for processing that always completes successfully.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees.html",
        "title": "LogicToolkit.BehaviorTrees",
        "tags": [],
        "description": "",
        "summary": "Types    Type Name Description     Decorator Basic type of Decorator used for BehaviorTree nodes   EvaluateDecorator Decorator that evaluates the execution of BehaviorTree nodes   LoopCheckDecorator Decorator that checks for loops in BehaviorTree nodes   ResultChangeDecorator Decorator that changes the execution result of the BehaviorTree node    Interfaces    Type Name Description     IAbortReceiver Receive execution abort of BehaviorTree node.",
        "content": "Types    Type Name Description     Decorator Basic type of Decorator used for BehaviorTree nodes   EvaluateDecorator Decorator that evaluates the execution of BehaviorTree nodes   LoopCheckDecorator Decorator that checks for loops in BehaviorTree nodes   ResultChangeDecorator Decorator that changes the execution result of the BehaviorTree node    Interfaces    Type Name Description     IAbortReceiver Receive execution abort of BehaviorTree node. By implementing it in the main component or Decorator, the IAbortReceiver.OnAbort() method will be called when execution is aborted.    Enums    Type Name Description     AbortFlags Abort flags    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors.html",
        "title": "LogicToolkit.Editors",
        "tags": [],
        "description": "",
        "summary": "Types    Type Name Description     AdvancedMenu Advanced Menu   AdvancedMenuItem Items in AdvancedMenu   ComponentMenuCreator Class that creates items for the node component selection menu   TypeMenuCreator Create a script selection menu   ConstantPropertyDrawer A base type that extends the representation of constant fields in InputField\u0026lt;T\u0026gt;   InputFieldElementBase Basic type of UI element for InputField   InputFieldElementUtility Utility class for InputFieldElement   FieldAssignor Class for assigning values to fields when a node or node component is created   PortFieldAssignor Class for connecting ports when a node or node component is created   GraphEditor Class for editing graphs   NodeComponentEditor Editor extension for NodeComponent   NodeEditor Editor extension for Node   PortConnector Class that manages port connections   NodeContentContainer UI element that serves as a container for the node's content   PortField Port UI elements   PooledObject\u0026lt;T\u0026gt; Manage pooled objects.",
        "content": "Types    Type Name Description     AdvancedMenu Advanced Menu   AdvancedMenuItem Items in AdvancedMenu   ComponentMenuCreator Class that creates items for the node component selection menu   TypeMenuCreator Create a script selection menu   ConstantPropertyDrawer A base type that extends the representation of constant fields in InputField\u0026lt;T\u0026gt;   InputFieldElementBase Basic type of UI element for InputField   InputFieldElementUtility Utility class for InputFieldElement   FieldAssignor Class for assigning values to fields when a node or node component is created   PortFieldAssignor Class for connecting ports when a node or node component is created   GraphEditor Class for editing graphs   NodeComponentEditor Editor extension for NodeComponent   NodeEditor Editor extension for Node   PortConnector Class that manages port connections   NodeContentContainer UI element that serves as a container for the node's content   PortField Port UI elements   PooledObject\u0026lt;T\u0026gt; Manage pooled objects.   SerializableTypeProperty Structure that references SerializableType by SerializedProperty   TypeMenuInfo Type menu information   BaseFieldExt\u0026lt;TValueType\u0026gt; A class that extends BaseField\u0026lt;TValueType\u0026gt;   BasePopupFieldExt\u0026lt;TValueType\u0026gt; Base class for popup field UI elements   SerializableTypeField UI elements for SerializableType    Interfaces    Type Name Description     IBindItem Interface received when binding item to VisualElement   IConnectPortToComponentContext The interface that connects to the port being dragged when the node component is created.   ITypeMenuContext Interface called when creating a node component from the type selection menu   IDataPortConnector Interface that defines data port connections    Enums    Type Name Description     PortType Port type   AssemblySources Assembly type flags   TypeFilters Type filter flags    Attributes    Type Name Description     CustomTypeMenuCreator Attribute that extends the script selection menu by applying it to TypeMenuCreator.   CustomNodeComponentEditor Attributes that extend the editor of NodeComponent by applying them to NodeComponentEditor   CustomNodeEditor Attributes that extend the editor of Node by applying them to NodeEditor   CustomAttribute Basic type of attributes for editor extension    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines.html",
        "title": "LogicToolkit.StateMachines",
        "tags": [],
        "description": "",
        "summary": "Types    Type Name Description     OutputSignalPort Output signal port    Enums    Type Name Description     SignalExpiration Signal expiration time    ",
        "content": "Types    Type Name Description     OutputSignalPort Output signal port    Enums    Type Name Description     SignalExpiration Signal expiration time    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LongLerp.html",
        "title": "LongLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;long\u0026gt;\nDescription Linear interpolation of type long\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;long\u0026gt;\nDescription Linear interpolation of type long\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/LoopCheckDecorator.html",
        "title": "LoopCheckDecorator",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: Decorator\nDescription Decorator that checks for loops in BehaviorTree nodes\nMethods    Method Name Description     OnNext Called when checking whether to loop when the node finishes execution    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: Decorator\nDescription Decorator that checks for loops in BehaviorTree nodes\nMethods    Method Name Description     OnNext Called when checking whether to loop when the node finishes execution    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Enums/AbortFlags/LowerPriority.html",
        "title": "LowerPriority",
        "tags": [],
        "description": "",
        "summary": "Description Aborts a node with a lower priority than the own node, interrupts it, and executes it.",
        "content": "Description Aborts a node with a lower priority than the own node, interrupts it, and executes it.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-MainConnectableWireType.html",
        "title": "MainConnectableWireType",
        "tags": [],
        "description": "",
        "summary": "public Type MainConnectableWireType ;\r\r\rDescription Main connectable wire type",
        "content": "public Type MainConnectableWireType ;\r\r\rDescription Main connectable wire type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicController/P-MainGraph.html",
        "title": "MainGraph",
        "tags": [],
        "description": "",
        "summary": "public NodeGraph MainGraph ;\r\r\rDescription Main graph",
        "content": "public NodeGraph MainGraph ;\r\r\rDescription Main graph\n"
    },
    {
        "uri": "/manual.html",
        "title": "Manual",
        "tags": [],
        "description": "",
        "summary": "This page describes how to use Logic Toolkit.\n Getting started\nThis section explains the basic overview and operation methods for first-time users. Architecture\nThis section explains the architecture. Windows\nThis section explains various windows. Scripting\nThis section explains how to create the available scripts. Editor multilingual support\nThis section explains the editor's multilingual support. Update guide\nThis section explains precautions when updating to the latest version. Migration from other assets",
        "content": "This page describes how to use Logic Toolkit.\n Getting started\nThis section explains the basic overview and operation methods for first-time users. Architecture\nThis section explains the architecture. Windows\nThis section explains various windows. Scripting\nThis section explains how to create the available scripts. Editor multilingual support\nThis section explains the editor's multilingual support. Update guide\nThis section explains precautions when updating to the latest version. Migration from other assets\nThis section explains migration from other assets.  "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantRangeAttribute/F-Max.html",
        "title": "Max",
        "tags": [],
        "description": "",
        "summary": "public float Max ;\r\r\rDescription Maximum value",
        "content": "public float Max ;\r\r\rDescription Maximum value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantTextAreaAttribute/F-MaxLines.html",
        "title": "MaxLines",
        "tags": [],
        "description": "",
        "summary": "public int MaxLines ;\r\r\rDescription Maximum number of lines",
        "content": "public int MaxLines ;\r\r\rDescription Maximum number of lines\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MemberIconAttribute.html",
        "title": "MemberIconAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Display member icon on NodeComponent icon\nConstructors     Description     MemberIconAttribute Display member icon on NodeComponent icon    Fields    Field Name Description     Kind Member icon kind    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Display member icon on NodeComponent icon\nConstructors     Description     MemberIconAttribute Display member icon on NodeComponent icon    Fields    Field Name Description     Kind Member icon kind    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MemberIconAttribute/MemberIconAttribute-ctor.html",
        "title": "MemberIconAttribute",
        "tags": [],
        "description": "",
        "summary": "MemberIconAttribute(MemberIconKind) public MemberIconAttribute(MemberIconKind kind) ;\r\r\rDescription Display member icon on NodeComponent icon\nParameters    Parameter Name Description     kind Member icon kind    ",
        "content": "MemberIconAttribute(MemberIconKind) public MemberIconAttribute(MemberIconKind kind) ;\r\r\rDescription Display member icon on NodeComponent icon\nParameters    Parameter Name Description     kind Member icon kind    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind.html",
        "title": "MemberIconKind",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Member icon kind\nProperties    Property Name Description     Method Method   Field Field   Property Property   Event Event   StaticMethod Static method   StaticField Static field   StaticProperty Static property   StaticEvent Static event    ",
        "content": "Enum in LogicToolkit\nDescription Member icon kind\nProperties    Property Name Description     Method Method   Field Field   Property Property   Event Event   StaticMethod Static method   StaticField Static field   StaticProperty Static property   StaticEvent Static event    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator/P-Menu.html",
        "title": "Menu",
        "tags": [],
        "description": "",
        "summary": "public AdvancedMenu Menu ;\r\r\rDescription Menu",
        "content": "public AdvancedMenu Menu ;\r\r\rDescription Menu\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MenuKeywordsAttribute.html",
        "title": "MenuKeywordsAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set keywords in the script selection menu.\nConstructors     Description     MenuKeywordsAttribute Set keywords in the script selection menu.    Fields    Field Name Description     Keywords Keywords    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set keywords in the script selection menu.\nConstructors     Description     MenuKeywordsAttribute Set keywords in the script selection menu.    Fields    Field Name Description     Keywords Keywords    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MenuKeywordsAttribute/MenuKeywordsAttribute-ctor.html",
        "title": "MenuKeywordsAttribute",
        "tags": [],
        "description": "",
        "summary": "MenuKeywordsAttribute(string[]) public MenuKeywordsAttribute(string[] keywords) ;\r\r\rDescription Set keywords in the script selection menu.\nParameters    Parameter Name Description     keywords Keywords    ",
        "content": "MenuKeywordsAttribute(string[]) public MenuKeywordsAttribute(string[] keywords) ;\r\r\rDescription Set keywords in the script selection menu.\nParameters    Parameter Name Description     keywords Keywords    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-MenuName.html",
        "title": "MenuName",
        "tags": [],
        "description": "",
        "summary": "public string MenuName ;\r\r\rDescription Menu name",
        "content": "public string MenuName ;\r\r\rDescription Menu name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MenuNameAttribute/F-MenuName.html",
        "title": "MenuName",
        "tags": [],
        "description": "",
        "summary": "public string MenuName ;\r\r\rDescription Menu name",
        "content": "public string MenuName ;\r\r\rDescription Menu name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MenuNameAttribute.html",
        "title": "MenuNameAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set a name in the script selection menu.\nConstructors     Description     MenuNameAttribute Set a name in the script selection menu.    Fields    Field Name Description     MenuName Menu name    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Set a name in the script selection menu.\nConstructors     Description     MenuNameAttribute Set a name in the script selection menu.    Fields    Field Name Description     MenuName Menu name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/MenuNameAttribute/MenuNameAttribute-ctor.html",
        "title": "MenuNameAttribute",
        "tags": [],
        "description": "",
        "summary": "MenuNameAttribute(string) public MenuNameAttribute(string menuName) ;\r\r\rDescription Set a name in the script selection menu.\nParameters    Parameter Name Description     menuName Menu name    ",
        "content": "MenuNameAttribute(string) public MenuNameAttribute(string menuName) ;\r\r\rDescription Set a name in the script selection menu.\nParameters    Parameter Name Description     menuName Menu name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-MenuNameRaw.html",
        "title": "MenuNameRaw",
        "tags": [],
        "description": "",
        "summary": "public string MenuNameRaw ;\r\r\rDescription Raw menu name",
        "content": "public string MenuNameRaw ;\r\r\rDescription Raw menu name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/Method.html",
        "title": "Method",
        "tags": [],
        "description": "",
        "summary": "Description Method",
        "content": "Description Method\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantMinAttribute/F-Min.html",
        "title": "Min",
        "tags": [],
        "description": "",
        "summary": "public float Min ;\r\r\rDescription Minimum value allowed",
        "content": "public float Min ;\r\r\rDescription Minimum value allowed\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantRangeAttribute/F-Min.html",
        "title": "Min",
        "tags": [],
        "description": "",
        "summary": "public float Min ;\r\r\rDescription Minimum value",
        "content": "public float Min ;\r\r\rDescription Minimum value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantTextAreaAttribute/F-MinLines.html",
        "title": "MinLines",
        "tags": [],
        "description": "",
        "summary": "public int MinLines ;\r\r\rDescription Minimum number of lines",
        "content": "public int MinLines ;\r\r\rDescription Minimum number of lines\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-Name.html",
        "title": "Name",
        "tags": [],
        "description": "",
        "summary": "public string Name ;\r\r\rDescription Name",
        "content": "public string Name ;\r\r\rDescription Name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLinkReference/P-Name.html",
        "title": "Name",
        "tags": [],
        "description": "",
        "summary": "public string Name ;\r\r\rDescription Name",
        "content": "public string Name ;\r\r\rDescription Name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Node/P-Name.html",
        "title": "Name",
        "tags": [],
        "description": "",
        "summary": "public string Name ;\r\r\rDescription Node name",
        "content": "public string Name ;\r\r\rDescription Node name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-Name.html",
        "title": "Name",
        "tags": [],
        "description": "",
        "summary": "public string Name ;\r\r\rDescription Node graph name",
        "content": "public string Name ;\r\r\rDescription Node graph name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeProperty/P-Namespace.html",
        "title": "Namespace",
        "tags": [],
        "description": "",
        "summary": "public string Namespace ;\r\r\rDescription Namespace",
        "content": "public string Namespace ;\r\r\rDescription Namespace\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId/MS-NewId.html",
        "title": "NewId",
        "tags": [],
        "description": "",
        "summary": "NewId() public static UniqueId NewId() ;\r\r\rDescription Create a new ID\nReturns Created ID",
        "content": "NewId() public static UniqueId NewId() ;\r\r\rDescription Create a new ID\nReturns Created ID\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/RecomputeMode/Node.html",
        "title": "Node",
        "tags": [],
        "description": "",
        "summary": "Description Recompute when the execution node is different",
        "content": "Description Recompute when the execution node is different\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Node.html",
        "title": "Node",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of node\nProperties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of node\nProperties    Property Name Description     Id Node ID   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeComponent/P-Node.html",
        "title": "Node",
        "tags": [],
        "description": "",
        "summary": "public Node Node ;\r\r\rDescription the node that owns this node component",
        "content": "public Node Node ;\r\r\rDescription the node that owns this node component\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/PortBase/P-Node.html",
        "title": "Node",
        "tags": [],
        "description": "",
        "summary": "public Node Node ;\r\r\rDescription Node that owns this port",
        "content": "public Node Node ;\r\r\rDescription Node that owns this port\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeComponent.html",
        "title": "NodeComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of component for adding to nodes\nProperties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of component for adding to nodes\nProperties    Property Name Description     Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeComponentEditor.html",
        "title": "NodeComponentEditor",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Editor extension for NodeComponent\nProperties    Property Name Description     NodeEditor Node editor    Methods    Method Name Description     OnHeaderContextualMenu Called when the header context menu opens   OnRelease Called when releasing   SetupFields Set up fields    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Editor extension for NodeComponent\nProperties    Property Name Description     NodeEditor Node editor    Methods    Method Name Description     OnHeaderContextualMenu Called when the header context menu opens   OnRelease Called when releasing   SetupFields Set up fields    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer.html",
        "title": "NodeContentContainer",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: UnityEngine.UIElements.VisualElement\nDescription UI element that serves as a container for the node's content\nMethods    Method Name Description     Add Add UI elements   AddField Add property field   AddPropertyField Add PropertyField   AddPropertyFields Add child element of property   BuildFields Build the field   RemoveField Remove the field    Static Fields    Field Name Description     BottomViewUssClassName Bottom view USS class name   LeftViewUssClassName Left view USS class name   RightViewUssClassName Right view USS class name   SplitViewUssClassName Split view USS class name   TopViewUssClassName Top view USS class name   UssClassName USS class name    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: UnityEngine.UIElements.VisualElement\nDescription UI element that serves as a container for the node's content\nMethods    Method Name Description     Add Add UI elements   AddField Add property field   AddPropertyField Add PropertyField   AddPropertyFields Add child element of property   BuildFields Build the field   RemoveField Remove the field    Static Fields    Field Name Description     BottomViewUssClassName Bottom view USS class name   LeftViewUssClassName Left view USS class name   RightViewUssClassName Right view USS class name   SplitViewUssClassName Split view USS class name   TopViewUssClassName Top view USS class name   UssClassName USS class name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-NodeCount.html",
        "title": "NodeCount",
        "tags": [],
        "description": "",
        "summary": "public int NodeCount ;\r\r\rDescription Number of nodes",
        "content": "public int NodeCount ;\r\r\rDescription Number of nodes\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeComponentEditor/P-NodeEditor.html",
        "title": "NodeEditor",
        "tags": [],
        "description": "",
        "summary": "public NodeEditor NodeEditor ;\r\r\rDescription Node editor",
        "content": "public NodeEditor NodeEditor ;\r\r\rDescription Node editor\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor.html",
        "title": "NodeEditor",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Editor extension for Node\nProperties    Property Name Description     DisplayName Display name   FixedTitle Fixed title name   GraphEditor Graph editor   Id Node ID   NodeProperty Node property   NodeType Node type   Renamable Flag for whether or not it can be renamed   Selected Whether selected or not    Methods    Method Name Description     AddIgnoreProperty Add properties to ignore   CreateElement Create UI elements   GetSearchableTypes    OnContextualMenu Called when opening the right-click menu   OnDeleteNode Called when deleting a node   OnDestroy Called when destroying the node editor   OnSetupElement Set up UI elements    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Editor extension for Node\nProperties    Property Name Description     DisplayName Display name   FixedTitle Fixed title name   GraphEditor Graph editor   Id Node ID   NodeProperty Node property   NodeType Node type   Renamable Flag for whether or not it can be renamed   Selected Whether selected or not    Methods    Method Name Description     AddIgnoreProperty Add properties to ignore   CreateElement Create UI elements   GetSearchableTypes    OnContextualMenu Called when opening the right-click menu   OnDeleteNode Called when deleting a node   OnDestroy Called when destroying the node editor   OnSetupElement Set up UI elements    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/P-NodeEditor.html",
        "title": "NodeEditor",
        "tags": [],
        "description": "",
        "summary": "public NodeEditor NodeEditor ;\r\r\rDescription Node editor",
        "content": "public NodeEditor NodeEditor ;\r\r\rDescription Node editor\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Node/P-NodeGraph.html",
        "title": "NodeGraph",
        "tags": [],
        "description": "",
        "summary": "public NodeGraph NodeGraph ;\r\r\rDescription the node graph that owns this node",
        "content": "public NodeGraph NodeGraph ;\r\r\rDescription the node graph that owns this node\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph.html",
        "title": "NodeGraph",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of node graph\nProperties    Property Name Description     Blackboard Local blackboard linked to node graph   Id Node graph ID   LogicController NodeGraph.LogicController that controls this node graph   Name Node graph name   NodeCount Number of nodes   Owner The object that owns this node graph   Player LogicPlayerBase playing this node graph   PlayState Play status    Methods    Method Name Description     GetNodeAt Get index nodedata   OnAfterDeserialize Called after deserialization   OnBeforeSerialize Called before serialization   OnFixedUpdate Called when updating at fixed intervals   OnLateUpdate Called after update   OnPause Called when paused   OnPlay Called when playback starts   OnResume Called when resumed   OnStop Called when playback has stopped   OnUpdate Called when updating   TryGetNode Get the node of id    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of node graph\nProperties    Property Name Description     Blackboard Local blackboard linked to node graph   Id Node graph ID   LogicController NodeGraph.LogicController that controls this node graph   Name Node graph name   NodeCount Number of nodes   Owner The object that owns this node graph   Player LogicPlayerBase playing this node graph   PlayState Play status    Methods    Method Name Description     GetNodeAt Get index nodedata   OnAfterDeserialize Called after deserialization   OnBeforeSerialize Called before serialization   OnFixedUpdate Called when updating at fixed intervals   OnLateUpdate Called after update   OnPause Called when paused   OnPlay Called when playback starts   OnResume Called when resumed   OnStop Called when playback has stopped   OnUpdate Called when updating   TryGetNode Get the node of id    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableReference/P-NodeGraph.html",
        "title": "NodeGraph",
        "tags": [],
        "description": "",
        "summary": "public NodeGraph NodeGraph ;\r\r\rDescription VariableReference.NodeGraph that has this instance",
        "content": "public NodeGraph NodeGraph ;\r\r\rDescription VariableReference.NodeGraph that has this instance\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-NodeProperty.html",
        "title": "NodeProperty",
        "tags": [],
        "description": "",
        "summary": "public SerializedProperty NodeProperty ;\r\r\rDescription Node property",
        "content": "public SerializedProperty NodeProperty ;\r\r\rDescription Node property\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-NodeType.html",
        "title": "NodeType",
        "tags": [],
        "description": "",
        "summary": "public Type NodeType ;\r\r\rDescription Node type",
        "content": "public Type NodeType ;\r\r\rDescription Node type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/AssemblySources/None.html",
        "title": "None",
        "tags": [],
        "description": "",
        "summary": "Description None",
        "content": "Description None\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/None.html",
        "title": "None",
        "tags": [],
        "description": "",
        "summary": "Description None",
        "content": "Description None\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TimerType/Normal.html",
        "title": "Normal",
        "tags": [],
        "description": "",
        "summary": "Description Use Time.time.",
        "content": "Description Use Time.time.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/ComparisonOp/NotEquals.html",
        "title": "NotEquals",
        "tags": [],
        "description": "",
        "summary": "Description Not Equals",
        "content": "Description Not Equals\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Interfaces/IAbortReceiver/M-OnAbort.html",
        "title": "OnAbort",
        "tags": [],
        "description": "",
        "summary": "OnAbort() public void OnAbort() ;\r\r\rDescription Called when a node aborts execution",
        "content": "OnAbort() public void OnAbort() ;\r\r\rDescription Called when a node aborts execution\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActionComponent/M-OnAction.html",
        "title": "OnAction",
        "tags": [],
        "description": "",
        "summary": "OnAction() protected void OnAction() ;\r\r\rDescription Perform a process that can be completed in an instant",
        "content": "OnAction() protected void OnAction() ;\r\r\rDescription Perform a process that can be completed in an instant\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableComponent/M-OnActivated.html",
        "title": "OnActivated",
        "tags": [],
        "description": "",
        "summary": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active",
        "content": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableNode/M-OnActivated.html",
        "title": "OnActivated",
        "tags": [],
        "description": "",
        "summary": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active",
        "content": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AsyncOperationComponent-TAsyncOperation-/M-OnActivated.html",
        "title": "OnActivated",
        "tags": [],
        "description": "",
        "summary": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active",
        "content": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/FlowExitNode/M-OnActivated.html",
        "title": "OnActivated",
        "tags": [],
        "description": "",
        "summary": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active",
        "content": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponent-TTarget-TInputField-T-/M-OnActivated.html",
        "title": "OnActivated",
        "tags": [],
        "description": "",
        "summary": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active",
        "content": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponentBase-T-/M-OnActivated.html",
        "title": "OnActivated",
        "tags": [],
        "description": "",
        "summary": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active",
        "content": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/WaitForSeconds/M-OnActivated.html",
        "title": "OnActivated",
        "tags": [],
        "description": "",
        "summary": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active",
        "content": "OnActivated() protected void OnActivated() ;\r\r\rDescription Called when it becomes active\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ComputeNodeBase/M-OnAfterDeserialize.html",
        "title": "OnAfterDeserialize",
        "tags": [],
        "description": "",
        "summary": "OnAfterDeserialize() protected void OnAfterDeserialize() ;\r\r\rDescription Called after deserialization",
        "content": "OnAfterDeserialize() protected void OnAfterDeserialize() ;\r\r\rDescription Called after deserialization\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnAfterDeserialize.html",
        "title": "OnAfterDeserialize",
        "tags": [],
        "description": "",
        "summary": "OnAfterDeserialize() protected void OnAfterDeserialize() ;\r\r\rDescription Called after deserialization",
        "content": "OnAfterDeserialize() protected void OnAfterDeserialize() ;\r\r\rDescription Called after deserialization\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ComputeNodeBase/M-OnBeforeSerialize.html",
        "title": "OnBeforeSerialize",
        "tags": [],
        "description": "",
        "summary": "OnBeforeSerialize() protected void OnBeforeSerialize() ;\r\r\rDescription Called before serialization",
        "content": "OnBeforeSerialize() protected void OnBeforeSerialize() ;\r\r\rDescription Called before serialization\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnBeforeSerialize.html",
        "title": "OnBeforeSerialize",
        "tags": [],
        "description": "",
        "summary": "OnBeforeSerialize() protected void OnBeforeSerialize() ;\r\r\rDescription Called before serialization",
        "content": "OnBeforeSerialize() protected void OnBeforeSerialize() ;\r\r\rDescription Called before serialization\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IBindItem/M-OnBindItem.html",
        "title": "OnBindItem",
        "tags": [],
        "description": "",
        "summary": "OnBindItem(VisualElement) public void OnBindItem(VisualElement element) ;\r\r\rDescription Called when an item is bound to a VisualElement\nParameters    Parameter Name Description     element UI element to which the item is bound    ",
        "content": "OnBindItem(VisualElement) public void OnBindItem(VisualElement element) ;\r\r\rDescription Called when an item is bound to a VisualElement\nParameters    Parameter Name Description     element UI element to which the item is bound    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem/M-OnBindItem.html",
        "title": "OnBindItem",
        "tags": [],
        "description": "",
        "summary": "OnBindItem(VisualElement) public void OnBindItem(VisualElement element) ;\r\r\rDescription Called when an item is bound to a VisualElement\nParameters    Parameter Name Description     element UI element to which the item is bound    ",
        "content": "OnBindItem(VisualElement) public void OnBindItem(VisualElement element) ;\r\r\rDescription Called when an item is bound to a VisualElement\nParameters    Parameter Name Description     element UI element to which the item is bound    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Enums/SignalExpiration/Once.html",
        "title": "Once",
        "tags": [],
        "description": "",
        "summary": "Description Valid for one evaluation only",
        "content": "Description Valid for one evaluation only\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/ICheckRecompute/M-OnCheckRecompute.html",
        "title": "OnCheckRecompute",
        "tags": [],
        "description": "",
        "summary": "OnCheckRecompute() public bool OnCheckRecompute() ;\r\r\rDescription Determine whether recomputation is necessary.\nReturns Returns true if recomputation is necessary. Otherwise returns false.",
        "content": "OnCheckRecompute() public bool OnCheckRecompute() ;\r\r\rDescription Determine whether recomputation is necessary.\nReturns Returns true if recomputation is necessary. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/InputFieldElementBase/M-OnConnectionChanged.html",
        "title": "OnConnectionChanged",
        "tags": [],
        "description": "",
        "summary": "OnConnectionChanged(bool) protected void OnConnectionChanged(bool isConnection) ;\r\r\rDescription Called when the port connection changes\nParameters    Parameter Name Description     isConnection Whether the port is connected    ",
        "content": "OnConnectionChanged(bool) protected void OnConnectionChanged(bool isConnection) ;\r\r\rDescription Called when the port connection changes\nParameters    Parameter Name Description     isConnection Whether the port is connected    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/M-OnContextualMenu.html",
        "title": "OnContextualMenu",
        "tags": [],
        "description": "",
        "summary": "OnContextualMenu(ContextualMenuPopulateEvent) public void OnContextualMenu(ContextualMenuPopulateEvent e) ;\r\r\rDescription Called when opening the right-click menu\nParameters    Parameter Name Description     e Event to open right-click menu    ",
        "content": "OnContextualMenu(ContextualMenuPopulateEvent) public void OnContextualMenu(ContextualMenuPopulateEvent e) ;\r\r\rDescription Called when opening the right-click menu\nParameters    Parameter Name Description     e Event to open right-click menu    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/ITypeMenuContext/M-OnCreated.html",
        "title": "OnCreated",
        "tags": [],
        "description": "",
        "summary": "OnCreated(SerializedProperty) public void OnCreated(SerializedProperty property) ;\r\r\rDescription Called when a node component is created\nParameters    Parameter Name Description     property Property    ",
        "content": "OnCreated(SerializedProperty) public void OnCreated(SerializedProperty property) ;\r\r\rDescription Called when a node component is created\nParameters    Parameter Name Description     property Property    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableComponent/M-OnDeactivated.html",
        "title": "OnDeactivated",
        "tags": [],
        "description": "",
        "summary": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive",
        "content": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ActivatableNode/M-OnDeactivated.html",
        "title": "OnDeactivated",
        "tags": [],
        "description": "",
        "summary": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive",
        "content": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AsyncOperationComponent-TAsyncOperation-/M-OnDeactivated.html",
        "title": "OnDeactivated",
        "tags": [],
        "description": "",
        "summary": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive",
        "content": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/WaitForSeconds/M-OnDeactivated.html",
        "title": "OnDeactivated",
        "tags": [],
        "description": "",
        "summary": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive",
        "content": "OnDeactivated() protected void OnDeactivated() ;\r\r\rDescription Called when it becomes inactive\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/M-OnDeleteNode.html",
        "title": "OnDeleteNode",
        "tags": [],
        "description": "",
        "summary": "OnDeleteNode() protected void OnDeleteNode() ;\r\r\rDescription Called when deleting a node",
        "content": "OnDeleteNode() protected void OnDeleteNode() ;\r\r\rDescription Called when deleting a node\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/M-OnDestroy.html",
        "title": "OnDestroy",
        "tags": [],
        "description": "",
        "summary": "OnDestroy() protected void OnDestroy() ;\r\r\rDescription Called when destroying the node editor",
        "content": "OnDestroy() protected void OnDestroy() ;\r\r\rDescription Called when destroying the node editor\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/EvaluateDecorator/M-OnEnterEvaluation.html",
        "title": "OnEnterEvaluation",
        "tags": [],
        "description": "",
        "summary": "OnEnterEvaluation() protected void OnEnterEvaluation() ;\r\r\rDescription Called when a node enters the evaluation target",
        "content": "OnEnterEvaluation() protected void OnEnterEvaluation() ;\r\r\rDescription Called when a node enters the evaluation target\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/EvaluateDecorator/M-OnEvaluate.html",
        "title": "OnEvaluate",
        "tags": [],
        "description": "",
        "summary": "OnEvaluate() protected bool OnEvaluate() ;\r\r\rDescription Called when performing an evaluation\nReturns return evaluation results",
        "content": "OnEvaluate() protected bool OnEvaluate() ;\r\r\rDescription Called when performing an evaluation\nReturns return evaluation results\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EvaluateComponent/M-OnEvaluate.html",
        "title": "OnEvaluate",
        "tags": [],
        "description": "",
        "summary": "OnEvaluate() protected bool OnEvaluate() ;\r\r\rDescription Perform an evaluation\nReturns Evaluation results",
        "content": "OnEvaluate() protected bool OnEvaluate() ;\r\r\rDescription Perform an evaluation\nReturns Evaluation results\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/EventComponent/M-OnEvent.html",
        "title": "OnEvent",
        "tags": [],
        "description": "",
        "summary": "OnEvent() protected void OnEvent() ;\r\r\rDescription Call when an event occurs",
        "content": "OnEvent() protected void OnEvent() ;\r\r\rDescription Call when an event occurs\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AsyncOperationComponent-TAsyncOperation-/M-OnExecute.html",
        "title": "OnExecute",
        "tags": [],
        "description": "",
        "summary": "OnExecute() protected TaskStatus OnExecute() ;\r\r\rDescription Execute processing.\nReturns Returns the task status.",
        "content": "OnExecute() protected TaskStatus OnExecute() ;\r\r\rDescription Execute processing.\nReturns Returns the task status.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TaskComponent/M-OnExecute.html",
        "title": "OnExecute",
        "tags": [],
        "description": "",
        "summary": "OnExecute() protected TaskStatus OnExecute() ;\r\r\rDescription Execute processing.\nReturns Returns the task status.",
        "content": "OnExecute() protected TaskStatus OnExecute() ;\r\r\rDescription Execute processing.\nReturns Returns the task status.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/WaitForSeconds/M-OnExecute.html",
        "title": "OnExecute",
        "tags": [],
        "description": "",
        "summary": "OnExecute() protected TaskStatus OnExecute() ;\r\r\rDescription Execute processing.\nReturns Returns the task status.",
        "content": "OnExecute() protected TaskStatus OnExecute() ;\r\r\rDescription Execute processing.\nReturns Returns the task status.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnFixedUpdate.html",
        "title": "OnFixedUpdate",
        "tags": [],
        "description": "",
        "summary": "OnFixedUpdate() protected void OnFixedUpdate() ;\r\r\rDescription Called when updating at fixed intervals",
        "content": "OnFixedUpdate() protected void OnFixedUpdate() ;\r\r\rDescription Called when updating at fixed intervals\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeComponentEditor/M-OnHeaderContextualMenu.html",
        "title": "OnHeaderContextualMenu",
        "tags": [],
        "description": "",
        "summary": "OnHeaderContextualMenu(ContextualMenuPopulateEvent) public void OnHeaderContextualMenu(ContextualMenuPopulateEvent e) ;\r\r\rDescription Called when the header context menu opens\nParameters    Parameter Name Description     e Event to open context menu    ",
        "content": "OnHeaderContextualMenu(ContextualMenuPopulateEvent) public void OnHeaderContextualMenu(ContextualMenuPopulateEvent e) ;\r\r\rDescription Called when the header context menu opens\nParameters    Parameter Name Description     e Event to open context menu    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnLateUpdate.html",
        "title": "OnLateUpdate",
        "tags": [],
        "description": "",
        "summary": "OnLateUpdate() protected void OnLateUpdate() ;\r\r\rDescription Called after update",
        "content": "OnLateUpdate() protected void OnLateUpdate() ;\r\r\rDescription Called after update\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/EvaluateDecorator/M-OnLeaveEvaluation.html",
        "title": "OnLeaveEvaluation",
        "tags": [],
        "description": "",
        "summary": "OnLeaveEvaluation() protected void OnLeaveEvaluation() ;\r\r\rDescription Called when a node leaves the evaluation target",
        "content": "OnLeaveEvaluation() protected void OnLeaveEvaluation() ;\r\r\rDescription Called when a node leaves the evaluation target\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/LoopCheckDecorator/M-OnNext.html",
        "title": "OnNext",
        "tags": [],
        "description": "",
        "summary": "OnNext() protected bool OnNext() ;\r\r\rDescription Called when checking whether to loop when the node finishes execution\nReturns Returns true if looping. Otherwise returns false.",
        "content": "OnNext() protected bool OnNext() ;\r\r\rDescription Called when checking whether to loop when the node finishes execution\nReturns Returns true if looping. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IPauseReceiver/M-OnPause.html",
        "title": "OnPause",
        "tags": [],
        "description": "",
        "summary": "OnPause(bool) public void OnPause(bool pause) ;\r\r\rDescription Called when the graph is paused/resumed\nParameters    Parameter Name Description     pause Was it paused?    ",
        "content": "OnPause(bool) public void OnPause(bool pause) ;\r\r\rDescription Called when the graph is paused/resumed\nParameters    Parameter Name Description     pause Was it paused?    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnPause.html",
        "title": "OnPause",
        "tags": [],
        "description": "",
        "summary": "OnPause() protected void OnPause() ;\r\r\rDescription Called when paused",
        "content": "OnPause() protected void OnPause() ;\r\r\rDescription Called when paused\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnPlay.html",
        "title": "OnPlay",
        "tags": [],
        "description": "",
        "summary": "OnPlay() protected void OnPlay() ;\r\r\rDescription Called when playback starts",
        "content": "OnPlay() protected void OnPlay() ;\r\r\rDescription Called when playback starts\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponentBase-T-/M-OnProgress.html",
        "title": "OnProgress",
        "tags": [],
        "description": "",
        "summary": "OnProgress(float) protected void OnProgress(float progress) ;\r\r\rDescription Called when progress changes\nParameters    Parameter Name Description     progress Progress    ",
        "content": "OnProgress(float) protected void OnProgress(float progress) ;\r\r\rDescription Called when progress changes\nParameters    Parameter Name Description     progress Progress    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/WaitForSeconds/M-OnProgress.html",
        "title": "OnProgress",
        "tags": [],
        "description": "",
        "summary": "OnProgress(float) protected void OnProgress(float progress) ;\r\r\rDescription Called when progress changes\nParameters    Parameter Name Description     progress Progress    ",
        "content": "OnProgress(float) protected void OnProgress(float progress) ;\r\r\rDescription Called when progress changes\nParameters    Parameter Name Description     progress Progress    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeComponentEditor/M-OnRelease.html",
        "title": "OnRelease",
        "tags": [],
        "description": "",
        "summary": "OnRelease() public void OnRelease() ;\r\r\rDescription Called when releasing",
        "content": "OnRelease() public void OnRelease() ;\r\r\rDescription Called when releasing\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/ResultChangeDecorator/M-OnResult.html",
        "title": "OnResult",
        "tags": [],
        "description": "",
        "summary": "OnResult(bool) protected bool OnResult(bool result) ;\r\r\rDescription Modify and return the execution result when the node finishes executing\nParameters    Parameter Name Description     result Execution result    Returns Return modified execution results",
        "content": "OnResult(bool) protected bool OnResult(bool result) ;\r\r\rDescription Modify and return the execution result when the node finishes executing\nParameters    Parameter Name Description     result Execution result    Returns Return modified execution results\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnResume.html",
        "title": "OnResume",
        "tags": [],
        "description": "",
        "summary": "OnResume() protected void OnResume() ;\r\r\rDescription Called when resumed",
        "content": "OnResume() protected void OnResume() ;\r\r\rDescription Called when resumed\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/M-OnSetupElement.html",
        "title": "OnSetupElement",
        "tags": [],
        "description": "",
        "summary": "OnSetupElement() protected void OnSetupElement() ;\r\r\rDescription Set up UI elements",
        "content": "OnSetupElement() protected void OnSetupElement() ;\r\r\rDescription Set up UI elements\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnStop.html",
        "title": "OnStop",
        "tags": [],
        "description": "",
        "summary": "OnStop() protected void OnStop() ;\r\r\rDescription Called when playback has stopped",
        "content": "OnStop() protected void OnStop() ;\r\r\rDescription Called when playback has stopped\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IBindItem/M-OnUnbindItem.html",
        "title": "OnUnbindItem",
        "tags": [],
        "description": "",
        "summary": "OnUnbindItem(VisualElement) public void OnUnbindItem(VisualElement element) ;\r\r\rDescription Called when the binding to VisualElement is released\nParameters    Parameter Name Description     element UI element to which the item is bound    ",
        "content": "OnUnbindItem(VisualElement) public void OnUnbindItem(VisualElement element) ;\r\r\rDescription Called when the binding to VisualElement is released\nParameters    Parameter Name Description     element UI element to which the item is bound    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem/M-OnUnbindItem.html",
        "title": "OnUnbindItem",
        "tags": [],
        "description": "",
        "summary": "OnUnbindItem(VisualElement) public void OnUnbindItem(VisualElement element) ;\r\r\rDescription Called when the binding to VisualElement is released\nParameters    Parameter Name Description     element UI element to which the item is bound    ",
        "content": "OnUnbindItem(VisualElement) public void OnUnbindItem(VisualElement element) ;\r\r\rDescription Called when the binding to VisualElement is released\nParameters    Parameter Name Description     element UI element to which the item is bound    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IUpdateReceiver/M-OnUpdate.html",
        "title": "OnUpdate",
        "tags": [],
        "description": "",
        "summary": "OnUpdate() public void OnUpdate() ;\r\r\rDescription Called when updating",
        "content": "OnUpdate() public void OnUpdate() ;\r\r\rDescription Called when updating\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-OnUpdate.html",
        "title": "OnUpdate",
        "tags": [],
        "description": "",
        "summary": "OnUpdate() protected void OnUpdate() ;\r\r\rDescription Called when updating",
        "content": "OnUpdate() protected void OnUpdate() ;\r\r\rDescription Called when updating\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType/op_Inequality.html",
        "title": "operator !=",
        "tags": [],
        "description": "",
        "summary": "operator !=(SerializableType, SerializableType) public static bool operator !=(SerializableType x, SerializableType y) ;\r\r\rDescription Determine whether they are not equal\nParameters    Parameter Name Description     x Target to determine whether they are not equal   y Target to determine whether they are not equal    Returns Unequal or not",
        "content": "operator !=(SerializableType, SerializableType) public static bool operator !=(SerializableType x, SerializableType y) ;\r\r\rDescription Determine whether they are not equal\nParameters    Parameter Name Description     x Target to determine whether they are not equal   y Target to determine whether they are not equal    Returns Unequal or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId/op_Inequality.html",
        "title": "operator !=",
        "tags": [],
        "description": "",
        "summary": "operator !=(UniqueId, UniqueId) public static bool operator !=(UniqueId a, UniqueId b) ;\r\r\rDescription Determine whether they are not equal\nParameters    Parameter Name Description     a Target to determine whether they are not equal   b Target to determine whether they are not equal    Returns Unequal or not",
        "content": "operator !=(UniqueId, UniqueId) public static bool operator !=(UniqueId a, UniqueId b) ;\r\r\rDescription Determine whether they are not equal\nParameters    Parameter Name Description     a Target to determine whether they are not equal   b Target to determine whether they are not equal    Returns Unequal or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType/op_Equality.html",
        "title": "operator ==",
        "tags": [],
        "description": "",
        "summary": "operator ==(SerializableType, SerializableType) public static bool operator ==(SerializableType x, SerializableType y) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     x Target to determine equality   y Target to determine equality    Returns Equal or not",
        "content": "operator ==(SerializableType, SerializableType) public static bool operator ==(SerializableType x, SerializableType y) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     x Target to determine equality   y Target to determine equality    Returns Equal or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId/op_Equality.html",
        "title": "operator ==",
        "tags": [],
        "description": "",
        "summary": "operator ==(UniqueId, UniqueId) public static bool operator ==(UniqueId a, UniqueId b) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     a Target to determine equality   b Target to determine equality    Returns Equal or not",
        "content": "operator ==(UniqueId, UniqueId) public static bool operator ==(UniqueId a, UniqueId b) ;\r\r\rDescription Determine equality\nParameters    Parameter Name Description     a Target to determine equality   b Target to determine equality    Returns Equal or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantPropertyAttribute/P-Order.html",
        "title": "Order",
        "tags": [],
        "description": "",
        "summary": "public int Order ;\r\r\rDescription Specify the order in which multiple ConstantPropertyAttribute are drawn",
        "content": "public int Order ;\r\r\rDescription Specify the order in which multiple ConstantPropertyAttribute are drawn\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FieldOrderAttribute/F-Order.html",
        "title": "Order",
        "tags": [],
        "description": "",
        "summary": "public int Order ;\r\r\rDescription Display order",
        "content": "public int Order ;\r\r\rDescription Display order\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/EasingMode/Out.html",
        "title": "Out",
        "tags": [],
        "description": "",
        "summary": "Description Output side",
        "content": "Description Output side\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/PortType/Output.html",
        "title": "Output",
        "tags": [],
        "description": "",
        "summary": "Description Output port",
        "content": "Description Output port\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPort-T-.html",
        "title": "OutputDataPort&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: DataPort\u0026lt;T\u0026gt;\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;, IValueSetter\u0026lt;T\u0026gt;, IOutputDataPort\nDescription Generic type output data port\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Properties    Property Name Description     HasValue Whether the output data port has a value    Methods    Method Name Description     SetDefault Set to default value   SetValue Set the value.",
        "content": "\r\rClass in LogicToolkit / Inherits from: DataPort\u0026lt;T\u0026gt;\nImplements interfaces: IValueGetter\u0026lt;T\u0026gt;, IValueSetter\u0026lt;T\u0026gt;, IOutputDataPort\nDescription Generic type output data port\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Properties    Property Name Description     HasValue Whether the output data port has a value    Methods    Method Name Description     SetDefault Set to default value   SetValue Set the value.   SetValueWithoutNotify Set the value without notification.    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType.html",
        "title": "OutputDataPortWithType",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: DataPortWithType\nImplements interfaces: IValueTryGetter, IValueTrySetter, IOutputDataPort\nDescription Typeable output data port\nProperties    Property Name Description     HasValue Whether the output data port has a value    Methods    Method Name Description     SetDefault Set to default value   SetDefaultWithoutNotify Set to default value without notification   SetValue Set the value.",
        "content": "\r\rClass in LogicToolkit / Inherits from: DataPortWithType\nImplements interfaces: IValueTryGetter, IValueTrySetter, IOutputDataPort\nDescription Typeable output data port\nProperties    Property Name Description     HasValue Whether the output data port has a value    Methods    Method Name Description     SetDefault Set to default value   SetDefaultWithoutNotify Set to default value without notification   SetValue Set the value.   SetValueWithoutNotify Set value without notification   TrySetValue Set the value.   TrySetValueWithoutNotify Set value without notification    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port   Type Data type    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort.html",
        "title": "OutputExecutePort",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: Port\nImplements interfaces: IOutputPort\nDescription Output execution port\nProperties    Property Name Description     PlayState Play status    Methods    Method Name Description     Pause Pause.   Play Start playing   Restart restart from the beginning   Resume Resume.   Stop Stop playback.   Update Update.",
        "content": "\r\rClass in LogicToolkit / Inherits from: Port\nImplements interfaces: IOutputPort\nDescription Output execution port\nProperties    Property Name Description     PlayState Play status    Methods    Method Name Description     Pause Pause.   Play Start playing   Restart restart from the beginning   Resume Resume.   Stop Stop playback.   Update Update.    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Wire/P-OutputPort.html",
        "title": "OutputPort",
        "tags": [],
        "description": "",
        "summary": "public IOutputPort OutputPort ;\r\r\rDescription Output port",
        "content": "public IOutputPort OutputPort ;\r\r\rDescription Output port\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Types/OutputSignalPort.html",
        "title": "OutputSignalPort",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.StateMachines / Inherits from: TransitionalPort\nDescription Output signal port\nProperties    Property Name Description     Expiration Signal expiration time    Methods    Method Name Description     Reset Reset signal   Send Send a signal    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit.StateMachines / Inherits from: TransitionalPort\nDescription Output signal port\nProperties    Property Name Description     Expiration Signal expiration time    Methods    Method Name Description     Reset Reset signal   Send Send a signal    Inherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputTransitionPort.html",
        "title": "OutputTransitionPort",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: TransitionalPort\nDescription Output transition port\nInherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: TransitionalPort\nDescription Output transition port\nInherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-Owner.html",
        "title": "Owner",
        "tags": [],
        "description": "",
        "summary": "public Object Owner ;\r\r\rDescription The object that owns this node graph",
        "content": "public Object Owner ;\r\r\rDescription The object that owns this node graph\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/AssemblySources/Package.html",
        "title": "Package",
        "tags": [],
        "description": "",
        "summary": "Description Package",
        "content": "Description Package\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/ConstantPropertyDrawer/P-ParentFieldInfo.html",
        "title": "ParentFieldInfo",
        "tags": [],
        "description": "",
        "summary": "protected FieldInfo ParentFieldInfo ;\r\r\rDescription FieldInfo for a field of type InputField",
        "content": "protected FieldInfo ParentFieldInfo ;\r\r\rDescription FieldInfo for a field of type InputField\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ScriptGeneratedAttribute/F-Path.html",
        "title": "Path",
        "tags": [],
        "description": "",
        "summary": "public string Path ;\r\r\rDescription Path to generated information",
        "content": "public string Path ;\r\r\rDescription Path to generated information\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayerBase/M-Pause.html",
        "title": "Pause",
        "tags": [],
        "description": "",
        "summary": "Pause() public void Pause() ;\r\r\rDescription Pause.",
        "content": "Pause() public void Pause() ;\r\r\rDescription Pause.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort/M-Pause.html",
        "title": "Pause",
        "tags": [],
        "description": "",
        "summary": "Pause() public void Pause() ;\r\r\rDescription Pause.",
        "content": "Pause() public void Pause() ;\r\r\rDescription Pause.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Timer/M-Pause.html",
        "title": "Pause",
        "tags": [],
        "description": "",
        "summary": "Pause() public void Pause() ;\r\r\rDescription Pause.",
        "content": "Pause() public void Pause() ;\r\r\rDescription Pause.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/PlayState/Paused.html",
        "title": "Paused",
        "tags": [],
        "description": "",
        "summary": "Description Paused",
        "content": "Description Paused\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FieldPlacementAttribute/F-Placement.html",
        "title": "Placement",
        "tags": [],
        "description": "",
        "summary": "public FieldPlacement Placement ;\r\r\rDescription Placement of fields",
        "content": "public FieldPlacement Placement ;\r\r\rDescription Placement of fields\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayerBase/M-Play.html",
        "title": "Play",
        "tags": [],
        "description": "",
        "summary": "Play() public void Play() ;\r\r\rDescription Start playing",
        "content": "Play() public void Play() ;\r\r\rDescription Start playing\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort/M-Play.html",
        "title": "Play",
        "tags": [],
        "description": "",
        "summary": "Play(Func\u0026lt;OutputExecutePort, FlowExitNode, bool\u0026gt;) public bool Play(Func\u0026lt;OutputExecutePort, FlowExitNode, bool\u0026gt; onExit) ;\r\r\rDescription Start playing\nParameters    Parameter Name Description     onExit Called when finished    Returns Returns true if playback has started. Otherwise returns false.",
        "content": "Play(Func\u0026lt;OutputExecutePort, FlowExitNode, bool\u0026gt;) public bool Play(Func\u0026lt;OutputExecutePort, FlowExitNode, bool\u0026gt; onExit) ;\r\r\rDescription Start playing\nParameters    Parameter Name Description     onExit Called when finished    Returns Returns true if playback has started. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Timer/M-Play.html",
        "title": "Play",
        "tags": [],
        "description": "",
        "summary": "Play(TimerType) public void Play(TimerType timerType) ;\r\r\rDescription Start playing\nParameters    Parameter Name Description     timerType Time type    Play(TimerType, float) public void Play(TimerType timerType, float offset) ;\r\r\rDescription Start playing\nParameters    Parameter Name Description     timerType Time type   offset Starting offset    ",
        "content": "Play(TimerType) public void Play(TimerType timerType) ;\r\r\rDescription Start playing\nParameters    Parameter Name Description     timerType Time type    Play(TimerType, float) public void Play(TimerType timerType, float offset) ;\r\r\rDescription Start playing\nParameters    Parameter Name Description     timerType Time type   offset Starting offset    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/AssemblySources/Player.html",
        "title": "Player",
        "tags": [],
        "description": "",
        "summary": "Description Player",
        "content": "Description Player\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Node/P-Player.html",
        "title": "Player",
        "tags": [],
        "description": "",
        "summary": "public LogicPlayerBase Player ;\r\r\rDescription LogicPlayerBase that is playing this node",
        "content": "public LogicPlayerBase Player ;\r\r\rDescription LogicPlayerBase that is playing this node\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeComponent/P-Player.html",
        "title": "Player",
        "tags": [],
        "description": "",
        "summary": "public LogicPlayerBase Player ;\r\r\rDescription LogicPlayerBase that is playing this node component",
        "content": "public LogicPlayerBase Player ;\r\r\rDescription LogicPlayerBase that is playing this node component\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-Player.html",
        "title": "Player",
        "tags": [],
        "description": "",
        "summary": "public LogicPlayerBase Player ;\r\r\rDescription LogicPlayerBase playing this node graph",
        "content": "public LogicPlayerBase Player ;\r\r\rDescription LogicPlayerBase playing this node graph\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/PlayState/Playing.html",
        "title": "Playing",
        "tags": [],
        "description": "",
        "summary": "Description Playing",
        "content": "Description Playing\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/PlayState.html",
        "title": "PlayState",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Play status\nProperties    Property Name Description     Stopped Playback stopped   Playing Playing   Paused Paused    ",
        "content": "Enum in LogicToolkit\nDescription Play status\nProperties    Property Name Description     Stopped Playback stopped   Playing Playing   Paused Paused    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayerBase/P-PlayState.html",
        "title": "PlayState",
        "tags": [],
        "description": "",
        "summary": "public PlayState PlayState ;\r\r\rDescription Play status",
        "content": "public PlayState PlayState ;\r\r\rDescription Play status\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/P-PlayState.html",
        "title": "PlayState",
        "tags": [],
        "description": "",
        "summary": "public PlayState PlayState ;\r\r\rDescription Play status",
        "content": "public PlayState PlayState ;\r\r\rDescription Play status\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort/P-PlayState.html",
        "title": "PlayState",
        "tags": [],
        "description": "",
        "summary": "public PlayState PlayState ;\r\r\rDescription Play status",
        "content": "public PlayState PlayState ;\r\r\rDescription Play status\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Timer/P-PlayState.html",
        "title": "PlayState",
        "tags": [],
        "description": "",
        "summary": "public PlayState PlayState ;\r\r\rDescription Play status",
        "content": "public PlayState PlayState ;\r\r\rDescription Play status\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PooledObject-T-.html",
        "title": "PooledObject&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "Struct in LogicToolkit.Editors / Inherits from: System.ValueType\nImplements interfaces: System.IDisposable\nDescription Manage pooled objects.\nType Parameters    Type Parameter Name Description Type Constraints     T Type of value being pooled class    Remarks By using the using statement, you can return the value to the pool when exiting the scope",
        "content": "\r\rStruct in LogicToolkit.Editors / Inherits from: System.ValueType\nImplements interfaces: System.IDisposable\nDescription Manage pooled objects.\nType Parameters    Type Parameter Name Description Type Constraints     T Type of value being pooled class    Remarks By using the using statement, you can return the value to the pool when exiting the scope\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Port.html",
        "title": "Port",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: PortBase\nDescription Basic type of normal port\nProperties    Property Name Description     ConnectedWiresCount Number of connected wires    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    Inherited Members Properties    Property Name Description     Node Node that owns this port    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: PortBase\nDescription Basic type of normal port\nProperties    Property Name Description     ConnectedWiresCount Number of connected wires    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    Inherited Members Properties    Property Name Description     Node Node that owns this port    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/PortBase.html",
        "title": "PortBase",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of port\nProperties    Property Name Description     Node Node that owns this port    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of port\nProperties    Property Name Description     Node Node that owns this port    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-PortColor.html",
        "title": "PortColor",
        "tags": [],
        "description": "",
        "summary": "public Color PortColor ;\r\r\rDescription Port Color",
        "content": "public Color PortColor ;\r\r\rDescription Port Color\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector.html",
        "title": "PortConnector",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit.Editors / Inherits from: object\nDescription Class that manages port connections\nProperties    Property Name Description     ConnectableWireTypes Connectable wire types   ConnectorPortType Type of port to connect   FieldInfo Field info   FieldType Field type   MainConnectableWireType Main connectable wire type   PortColor Port Color   PortType Port type   Property Property   Tooltip Tooltip    Methods    Method Name Description     IsConnectable Determine whether connection is possible.",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Class that manages port connections\nProperties    Property Name Description     ConnectableWireTypes Connectable wire types   ConnectorPortType Type of port to connect   FieldInfo Field info   FieldType Field type   MainConnectableWireType Main connectable wire type   PortColor Port Color   PortType Port type   Property Property   Tooltip Tooltip    Methods    Method Name Description     IsConnectable Determine whether connection is possible.    Static Methods    Method Name Description     Get Get PortConnector    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/P-PortConnector.html",
        "title": "PortConnector",
        "tags": [],
        "description": "",
        "summary": "public PortConnector PortConnector ;\r\r\rDescription Port connection data",
        "content": "public PortConnector PortConnector ;\r\r\rDescription Port connection data\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortFieldAssignor/P-PortConnector.html",
        "title": "PortConnector",
        "tags": [],
        "description": "",
        "summary": "public PortConnector PortConnector ;\r\r\rDescription Port connection data",
        "content": "public PortConnector PortConnector ;\r\r\rDescription Port connection data\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/InputFieldElementBase/P-PortField.html",
        "title": "PortField",
        "tags": [],
        "description": "",
        "summary": "public PortField PortField ;\r\r\rDescription Port UI elements",
        "content": "public PortField PortField ;\r\r\rDescription Port UI elements\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField.html",
        "title": "PortField",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit.Editors / Inherits from: BaseFieldExt\u0026lt;PortBase\u0026gt;\nDescription Port UI elements\nConstructors     Description     PortField Constructor    Properties    Property Name Description     NodeEditor Node editor   PortConnector Port connection data   Property Property    Methods    Method Name Description     Disconnect Disconnect    Static Fields    Field Name Description     LabelExpandUssClassName The USS class name of the expansion to give to labels within elements of this type.",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: BaseFieldExt\u0026lt;PortBase\u0026gt;\nDescription Port UI elements\nConstructors     Description     PortField Constructor    Properties    Property Name Description     NodeEditor Node editor   PortConnector Port connection data   Property Property    Methods    Method Name Description     Disconnect Disconnect    Static Fields    Field Name Description     LabelExpandUssClassName The USS class name of the expansion to give to labels within elements of this type.   LabelUssClassName USS class name of labels in elements of this type.   UssClassName USS class name of elements of this type.    Inherited Members Properties    Property Name Description     Label Label name   VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/PortField-ctor.html",
        "title": "PortField",
        "tags": [],
        "description": "",
        "summary": "PortField(SerializedProperty) public PortField(SerializedProperty property) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     property Property    PortField(SerializedProperty, string) public PortField(SerializedProperty property, string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     property Property   label Label name    ",
        "content": "PortField(SerializedProperty) public PortField(SerializedProperty property) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     property Property    PortField(SerializedProperty, string) public PortField(SerializedProperty property, string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     property Property   label Label name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortFieldAssignor/P-PortField.html",
        "title": "PortField",
        "tags": [],
        "description": "",
        "summary": "public PortField PortField ;\r\r\rDescription Port UI elements",
        "content": "public PortField PortField ;\r\r\rDescription Port UI elements\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortFieldAssignor.html",
        "title": "PortFieldAssignor",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: FieldAssignor\nDescription Class for connecting ports when a node or node component is created\nProperties    Property Name Description     ConvertNodePos Transform node position   GraphEditor Graph Editor   PortConnector Port connection data   PortField Port UI elements   PortType Port type    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: FieldAssignor\nDescription Class for connecting ports when a node or node component is created\nProperties    Property Name Description     ConvertNodePos Transform node position   GraphEditor Graph Editor   PortConnector Port connection data   PortField Port UI elements   PortType Port type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/PortType.html",
        "title": "PortType",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit.Editors\nDescription Port type\nProperties    Property Name Description     Input Input port   Output Output port   Reroute Reroute port    ",
        "content": "Enum in LogicToolkit.Editors\nDescription Port type\nProperties    Property Name Description     Input Input port   Output Output port   Reroute Reroute port    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-PortType.html",
        "title": "PortType",
        "tags": [],
        "description": "",
        "summary": "public PortType PortType ;\r\r\rDescription Port type",
        "content": "public PortType PortType ;\r\r\rDescription Port type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortFieldAssignor/P-PortType.html",
        "title": "PortType",
        "tags": [],
        "description": "",
        "summary": "public PortType PortType ;\r\r\rDescription Port type",
        "content": "public PortType PortType ;\r\r\rDescription Port type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Node/P-Position.html",
        "title": "Position",
        "tags": [],
        "description": "",
        "summary": "public RectInt Position ;\r\r\rDescription position of the node on the graph",
        "content": "public RectInt Position ;\r\r\rDescription position of the node on the graph\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/AssemblySources/Precompiled.html",
        "title": "Precompiled",
        "tags": [],
        "description": "",
        "summary": "Description Precompiled",
        "content": "Description Precompiled\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Primitive.html",
        "title": "Primitive",
        "tags": [],
        "description": "",
        "summary": "Description Primitive type",
        "content": "Description Primitive type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AssetInfo/FS-ProductName.html",
        "title": "ProductName",
        "tags": [],
        "description": "",
        "summary": "public static string ProductName ;\r\r\rDescription Product name",
        "content": "public static string ProductName ;\r\r\rDescription Product name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IProgressComponent/P-ProgressPlayer.html",
        "title": "ProgressPlayer",
        "tags": [],
        "description": "",
        "summary": "public ProgressPlayer ProgressPlayer ;\r\r\rDescription Return progress player",
        "content": "public ProgressPlayer ProgressPlayer ;\r\r\rDescription Return progress player\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ProgressPlayer.html",
        "title": "ProgressPlayer",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Progress player\nImplement and use IProgressComponent in NodeComponent.\nProperties    Property Name Description     CurrentProgress Current progress   IsActive Active or not    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Progress player\nImplement and use IProgressComponent in NodeComponent.\nProperties    Property Name Description     CurrentProgress Current progress   IsActive Active or not    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-Property.html",
        "title": "Property",
        "tags": [],
        "description": "",
        "summary": "public SerializedProperty Property ;\r\r\rDescription Property",
        "content": "public SerializedProperty Property ;\r\r\rDescription Property\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/P-Property.html",
        "title": "Property",
        "tags": [],
        "description": "",
        "summary": "public SerializedProperty Property ;\r\r\rDescription Property",
        "content": "public SerializedProperty Property ;\r\r\rDescription Property\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeProperty/F-Property.html",
        "title": "Property",
        "tags": [],
        "description": "",
        "summary": "public SerializedProperty Property ;\r\r\rDescription Property",
        "content": "public SerializedProperty Property ;\r\r\rDescription Property\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/Property.html",
        "title": "Property",
        "tags": [],
        "description": "",
        "summary": "Description Property",
        "content": "Description Property\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AssetInfo/FS-Publisher.html",
        "title": "Publisher",
        "tags": [],
        "description": "",
        "summary": "public static string Publisher ;\r\r\rDescription Publisher name",
        "content": "public static string Publisher ;\r\r\rDescription Publisher name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/QuaternionLerp.html",
        "title": "QuaternionLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Quaternion\u0026gt;\nDescription Linear interpolation of type Quaternion\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Quaternion\u0026gt;\nDescription Linear interpolation of type Quaternion\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/QuaternionSlerp.html",
        "title": "QuaternionSlerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Quaternion\u0026gt;\nDescription Spherical linear interpolation of type Quaternion\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Quaternion\u0026gt;\nDescription Spherical linear interpolation of type Quaternion\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-RaiseValueChanged.html",
        "title": "RaiseValueChanged",
        "tags": [],
        "description": "",
        "summary": "RaiseValueChanged() protected internal void RaiseValueChanged() ;\r\r\rDescription Raises a value change event.",
        "content": "RaiseValueChanged() protected internal void RaiseValueChanged() ;\r\r\rDescription Raises a value change event.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TimerType/Realtime.html",
        "title": "Realtime",
        "tags": [],
        "description": "",
        "summary": "Description Use Time.realtimeSinceStartup.",
        "content": "Description Use Time.realtimeSinceStartup.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/DefaultRecomputeModeAttribute/F-RecomputeMode.html",
        "title": "RecomputeMode",
        "tags": [],
        "description": "",
        "summary": "public RecomputeMode RecomputeMode ;\r\r\rDescription Recomputation mode",
        "content": "public RecomputeMode RecomputeMode ;\r\r\rDescription Recomputation mode\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FixedRecomputeModeAttribute/F-RecomputeMode.html",
        "title": "RecomputeMode",
        "tags": [],
        "description": "",
        "summary": "public RecomputeMode RecomputeMode ;\r\r\rDescription Recomputation mode",
        "content": "public RecomputeMode RecomputeMode ;\r\r\rDescription Recomputation mode\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/RecomputeMode.html",
        "title": "RecomputeMode",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Recomputation mode\nProperties    Property Name Description     Dirty Recompute when input values change   Frame Recompute when update frames are different   Node Recompute when the execution node is different   Component Recompute when execution components are different   Always Always recompute    ",
        "content": "Enum in LogicToolkit\nDescription Recomputation mode\nProperties    Property Name Description     Dirty Recompute when input values change   Frame Recompute when update frames are different   Node Recompute when the execution node is different   Component Recompute when execution components are different   Always Always recompute    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/RefArgument-T-TInputField-.html",
        "title": "RefArgument&lt;T, TInputField&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription A type that handles reference arguments. Mainly used for script generation.\nType Parameters    Type Parameter Name Description Type Constraints     T argument type    TInputField Input field type InputFieldBase\u0026lt;T\u0026gt;    Methods    Method Name Description     GetValue Get the value   SetValue Set the value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription A type that handles reference arguments. Mainly used for script generation.\nType Parameters    Type Parameter Name Description Type Constraints     T argument type    TInputField Input field type InputFieldBase\u0026lt;T\u0026gt;    Methods    Method Name Description     GetValue Get the value   SetValue Set the value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardDataLinkShareType/ReferenceCounter.html",
        "title": "ReferenceCounter",
        "tags": [],
        "description": "",
        "summary": "Description Shared using reference counter method. Released when there are no more references to the same instance.",
        "content": "Description Shared using reference counter method. Released when there are no more references to the same instance.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-RemoveAt.html",
        "title": "RemoveAt",
        "tags": [],
        "description": "",
        "summary": "RemoveAt(IValueGetter, int) public void RemoveAt(IValueGetter listGetter, int index) ;\r\r\rDescription Delete the element at index\nParameters    Parameter Name Description     listGetter Instance to get list   index Index    ",
        "content": "RemoveAt(IValueGetter, int) public void RemoveAt(IValueGetter listGetter, int index) ;\r\r\rDescription Delete the element at index\nParameters    Parameter Name Description     listGetter Instance to get list   index Index    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-RemoveElement.html",
        "title": "RemoveElement",
        "tags": [],
        "description": "",
        "summary": "RemoveElement(IValueGetter, IValueGetter) public bool RemoveElement(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Delete the element\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element value    Returns Returns true if the element is deleted. Otherwise returns false.",
        "content": "RemoveElement(IValueGetter, IValueGetter) public bool RemoveElement(IValueGetter listGetter, IValueGetter elementGetter) ;\r\r\rDescription Delete the element\nParameters    Parameter Name Description     listGetter Instance to get list   elementGetter Instance to get element value    Returns Returns true if the element is deleted. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/M-RemoveField.html",
        "title": "RemoveField",
        "tags": [],
        "description": "",
        "summary": "RemoveField(VisualElement) public void RemoveField(VisualElement element) ;\r\r\rDescription Remove the field\nParameters    Parameter Name Description     element UI element to remove    ",
        "content": "RemoveField(VisualElement) public void RemoveField(VisualElement element) ;\r\r\rDescription Remove the field\nParameters    Parameter Name Description     element UI element to remove    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-Renamable.html",
        "title": "Renamable",
        "tags": [],
        "description": "",
        "summary": "public bool Renamable ;\r\r\rDescription Flag for whether or not it can be renamed",
        "content": "public bool Renamable ;\r\r\rDescription Flag for whether or not it can be renamed\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/PortType/Reroute.html",
        "title": "Reroute",
        "tags": [],
        "description": "",
        "summary": "Description Reroute port",
        "content": "Description Reroute port\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Types/OutputSignalPort/M-Reset.html",
        "title": "Reset",
        "tags": [],
        "description": "",
        "summary": "Reset() public void Reset() ;\r\r\rDescription Reset signal",
        "content": "Reset() public void Reset() ;\r\r\rDescription Reset signal\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort/M-Restart.html",
        "title": "Restart",
        "tags": [],
        "description": "",
        "summary": "Restart() public bool Restart() ;\r\r\rDescription restart from the beginning\nReturns Returns true if playback has started. Otherwise returns false.",
        "content": "Restart() public bool Restart() ;\r\r\rDescription restart from the beginning\nReturns Returns true if playback has started. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable-T-/M-RestoreDefaults.html",
        "title": "RestoreDefaults",
        "tags": [],
        "description": "",
        "summary": "RestoreDefaults() protected internal void RestoreDefaults() ;\r\r\rDescription Restore default value to current value",
        "content": "RestoreDefaults() protected internal void RestoreDefaults() ;\r\r\rDescription Restore default value to current value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-RestoreDefaults.html",
        "title": "RestoreDefaults",
        "tags": [],
        "description": "",
        "summary": "RestoreDefaults() protected internal void RestoreDefaults() ;\r\r\rDescription Restore default value to current value",
        "content": "RestoreDefaults() protected internal void RestoreDefaults() ;\r\r\rDescription Restore default value to current value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableList-T-/M-RestoreDefaults.html",
        "title": "RestoreDefaults",
        "tags": [],
        "description": "",
        "summary": "RestoreDefaults() protected internal void RestoreDefaults() ;\r\r\rDescription Restore default value to current value",
        "content": "RestoreDefaults() protected internal void RestoreDefaults() ;\r\r\rDescription Restore default value to current value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/CompleteNode/P-Result.html",
        "title": "Result",
        "tags": [],
        "description": "",
        "summary": "public bool Result ;\r\r\rDescription Result",
        "content": "public bool Result ;\r\r\rDescription Result\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Types/ResultChangeDecorator.html",
        "title": "ResultChangeDecorator",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: Decorator\nDescription Decorator that changes the execution result of the BehaviorTree node\nMethods    Method Name Description     OnResult Modify and return the execution result when the node finishes executing    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit.BehaviorTrees / Inherits from: Decorator\nDescription Decorator that changes the execution result of the BehaviorTree node\nMethods    Method Name Description     OnResult Modify and return the execution result when the node finishes executing    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayerBase/M-Resume.html",
        "title": "Resume",
        "tags": [],
        "description": "",
        "summary": "Resume() public void Resume() ;\r\r\rDescription Resume.",
        "content": "Resume() public void Resume() ;\r\r\rDescription Resume.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort/M-Resume.html",
        "title": "Resume",
        "tags": [],
        "description": "",
        "summary": "Resume() public void Resume() ;\r\r\rDescription Resume.",
        "content": "Resume() public void Resume() ;\r\r\rDescription Resume.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Timer/M-Resume.html",
        "title": "Resume",
        "tags": [],
        "description": "",
        "summary": "Resume() public void Resume() ;\r\r\rDescription Resume.",
        "content": "Resume() public void Resume() ;\r\r\rDescription Resume.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/FieldPlacement/Right.html",
        "title": "Right",
        "tags": [],
        "description": "",
        "summary": "Description Right side",
        "content": "Description Right side\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/FS-RightViewUssClassName.html",
        "title": "RightViewUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string RightViewUssClassName ;\r\r\rDescription Right view USS class name",
        "content": "public static string RightViewUssClassName ;\r\r\rDescription Right view USS class name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardSource/Root.html",
        "title": "Root",
        "tags": [],
        "description": "",
        "summary": "Description Root",
        "content": "Description Root\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TaskStatus/Running.html",
        "title": "Running",
        "tags": [],
        "description": "",
        "summary": "Description Running",
        "content": "Description Running\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SByteLerp.html",
        "title": "SByteLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;sbyte\u0026gt;\nDescription Linear interpolation of type sbyte\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;sbyte\u0026gt;\nDescription Linear interpolation of type sbyte\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/BlackboardDataLinkShareType/Scene.html",
        "title": "Scene",
        "tags": [],
        "description": "",
        "summary": "Description Share within a scene. Instances are released when a scene is unloaded, and data is not inherited across scenes.",
        "content": "Description Share within a scene. Instances are released when a scene is unloaded, and data is not inherited across scenes.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/SceneObject.html",
        "title": "SceneObject",
        "tags": [],
        "description": "",
        "summary": "Description Objects in the scene (GameObject, Component)",
        "content": "Description Objects in the scene (GameObject, Component)\n"
    },
    {
        "uri": "/scriptreference.html",
        "title": "Script Reference",
        "tags": [],
        "description": "",
        "summary": "Here you will find a reference for scripts that can be used with Logic Toolkit.\nFor more information, please refer to the link in the side menu.",
        "content": "Here you will find a reference for scripts that can be used with Logic Toolkit.\nFor more information, please refer to the link in the side menu.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ScriptGeneratedAttribute.html",
        "title": "ScriptGeneratedAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Mark as generated script\nConstructors     Description     ScriptGeneratedAttribute Mark as generated script    Fields    Field Name Description     Index Generation information index   Path Path to generated information    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Mark as generated script\nConstructors     Description     ScriptGeneratedAttribute Mark as generated script    Fields    Field Name Description     Index Generation information index   Path Path to generated information    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ScriptGeneratedAttribute/ScriptGeneratedAttribute-ctor.html",
        "title": "ScriptGeneratedAttribute",
        "tags": [],
        "description": "",
        "summary": "ScriptGeneratedAttribute(string, int) public ScriptGeneratedAttribute(string path, int index) ;\r\r\rDescription Mark as generated script\nParameters    Parameter Name Description     path Path to generated information   index Generation information index    ",
        "content": "ScriptGeneratedAttribute(string, int) public ScriptGeneratedAttribute(string path, int index) ;\r\r\rDescription Mark as generated script\nParameters    Parameter Name Description     path Path to generated information   index Generation information index    "
    },
    {
        "uri": "/search.html",
        "title": "Search",
        "tags": [],
        "description": "",
        "summary": "",
        "content": ""
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeEditor/P-Selected.html",
        "title": "Selected",
        "tags": [],
        "description": "",
        "summary": "public bool Selected ;\r\r\rDescription Whether selected or not",
        "content": "public bool Selected ;\r\r\rDescription Whether selected or not\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.BehaviorTrees/Enums/AbortFlags/Self.html",
        "title": "Self",
        "tags": [],
        "description": "",
        "summary": "Description Abort own node",
        "content": "Description Abort own node\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Types/OutputSignalPort/M-Send.html",
        "title": "Send",
        "tags": [],
        "description": "",
        "summary": "Send(bool, SignalExpiration) public bool Send(bool signal, SignalExpiration expiration) ;\r\r\rDescription Send a signal\nParameters    Parameter Name Description     signal Signal   expiration Signal expiration time    Returns Returns true if the transition was caused by sending a signal. Otherwise returns false.\nSend(bool) public bool Send(bool signal) ;\r\r\rDescription Send a signal\nParameters    Parameter Name Description     signal Signal    Returns Returns true if the transition was caused by sending a signal.",
        "content": "Send(bool, SignalExpiration) public bool Send(bool signal, SignalExpiration expiration) ;\r\r\rDescription Send a signal\nParameters    Parameter Name Description     signal Signal   expiration Signal expiration time    Returns Returns true if the transition was caused by sending a signal. Otherwise returns false.\nSend(bool) public bool Send(bool signal) ;\r\r\rDescription Send a signal\nParameters    Parameter Name Description     signal Signal    Returns Returns true if the transition was caused by sending a signal. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType.html",
        "title": "SerializableType",
        "tags": [],
        "description": "",
        "summary": "Struct in LogicToolkit / Inherits from: System.ValueType\nImplements interfaces: System.IEquatable\u0026lt;SerializableType\u0026gt;\nDescription Structure for handling SerializableType.Type with Unity's serialization system\nConstructors     Description     SerializableType Constructor    Properties    Property Name Description     Type Get the referenced Type    Methods    Method Name Description     Equals Determine equality   GetHashCode Get the hash code.",
        "content": "\r\rStruct in LogicToolkit / Inherits from: System.ValueType\nImplements interfaces: System.IEquatable\u0026lt;SerializableType\u0026gt;\nDescription Structure for handling SerializableType.Type with Unity's serialization system\nConstructors     Description     SerializableType Constructor    Properties    Property Name Description     Type Get the referenced Type    Methods    Method Name Description     Equals Determine equality   GetHashCode Get the hash code.   ToString Get string    Operators    Operator Name Description     operator != Determine whether they are not equal   operator == Determine equality    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType/SerializableType-ctor.html",
        "title": "SerializableType",
        "tags": [],
        "description": "",
        "summary": "SerializableType(Type) public SerializableType(Type type) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     type Initial value    ",
        "content": "SerializableType(Type) public SerializableType(Type type) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     type Initial value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeField.html",
        "title": "SerializableTypeField",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit.Editors / Inherits from: BasePopupFieldExt\u0026lt;SerializableType\u0026gt;\nDescription UI elements for SerializableType\nConstructors     Description     SerializableTypeField Constructor    Fields    Field Name Description     AssemblyFilters Assembly type filters   ShowNoneItem Whether to display None items   TypeFilters Type filter    Properties    Property Name Description     BaseType Base type    Methods    Method Name Description     SetValueWithoutNotify Set value without notification    Inherited Members Properties    Property Name Description     Label Label name   VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    Static Fields    Field Name Description     ArrowUssClassName USS class name of arrow indicators in elements of this type.",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: BasePopupFieldExt\u0026lt;SerializableType\u0026gt;\nDescription UI elements for SerializableType\nConstructors     Description     SerializableTypeField Constructor    Fields    Field Name Description     AssemblyFilters Assembly type filters   ShowNoneItem Whether to display None items   TypeFilters Type filter    Properties    Property Name Description     BaseType Base type    Methods    Method Name Description     SetValueWithoutNotify Set value without notification    Inherited Members Properties    Property Name Description     Label Label name   VisualInput Elements of input    Methods    Method Name Description     ConfigureField Configure fields    Static Fields    Field Name Description     ArrowUssClassName USS class name of arrow indicators in elements of this type.   IconUssClassName USS class name of icon elements in elements of this type.   InputUssClassName USS class name of input elements in elements of this type.   LabelUssClassName USS class name of labels in elements of this type.   TextUssClassName USS class name of text elements in elements of this type.   UssClassName USS class name of elements of this type.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeField/SerializableTypeField-ctor.html",
        "title": "SerializableTypeField",
        "tags": [],
        "description": "",
        "summary": "SerializableTypeField() public SerializableTypeField() ;\r\r\rDescription Constructor\nSerializableTypeField(string) public SerializableTypeField(string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     label Label name    ",
        "content": "SerializableTypeField() public SerializableTypeField() ;\r\r\rDescription Constructor\nSerializableTypeField(string) public SerializableTypeField(string label) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     label Label name    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeProperty.html",
        "title": "SerializableTypeProperty",
        "tags": [],
        "description": "",
        "summary": "\r\rStruct in LogicToolkit.Editors / Inherits from: System.ValueType\nDescription Structure that references SerializableType by SerializedProperty\nConstructors     Description     SerializableTypeProperty Constructor    Fields    Field Name Description     Property Property    Properties    Property Name Description     AssemblyName Assembly name   Namespace Namespace   TypeName Type name   Value Value    ",
        "content": "\r\rStruct in LogicToolkit.Editors / Inherits from: System.ValueType\nDescription Structure that references SerializableType by SerializedProperty\nConstructors     Description     SerializableTypeProperty Constructor    Fields    Field Name Description     Property Property    Properties    Property Name Description     AssemblyName Assembly name   Namespace Namespace   TypeName Type name   Value Value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeProperty/SerializableTypeProperty-ctor.html",
        "title": "SerializableTypeProperty",
        "tags": [],
        "description": "",
        "summary": "SerializableTypeProperty(SerializedProperty) public SerializableTypeProperty(SerializedProperty property) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     property Property    ",
        "content": "SerializableTypeProperty(SerializedProperty) public SerializableTypeProperty(SerializedProperty property) ;\r\r\rDescription Constructor\nParameters    Parameter Name Description     property Property    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ServiceComponent.html",
        "title": "ServiceComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ActivatableComponent\nDescription Components that perform resident processing\nInherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ActivatableComponent\nDescription Components that perform resident processing\nInherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ServiceNode.html",
        "title": "ServiceNode",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ServiceNodeBase\nImplements interfaces: IPauseReceiver, IUpdateReceiver\nDescription Node that performs resident processing\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ServiceNodeBase\nImplements interfaces: IPauseReceiver, IUpdateReceiver\nDescription Node that performs resident processing\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ServiceNodeBase.html",
        "title": "ServiceNodeBase",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ActivatableNode\nDescription Basic type of node that performs resident processing\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ActivatableNode\nDescription Basic type of node that performs resident processing\nInherited Members Properties    Property Name Description     Id Node ID   IsActive Active or not   Name Node name   NodeGraph the node graph that owns this node   Player LogicPlayerBase that is playing this node   Position position of the node on the graph    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter/M-SetDefault.html",
        "title": "SetDefault",
        "tags": [],
        "description": "",
        "summary": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set default values\nReturns Returns true if the value is set. Otherwise returns false.",
        "content": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set default values\nReturns Returns true if the value is set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPort-T-/M-SetDefault.html",
        "title": "SetDefault",
        "tags": [],
        "description": "",
        "summary": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set to default value\nReturns Returns true if it can be set. Otherwise returns false.",
        "content": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set to default value\nReturns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType/M-SetDefault.html",
        "title": "SetDefault",
        "tags": [],
        "description": "",
        "summary": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set to default value\nReturns Returns true if it can be set. Otherwise returns false.",
        "content": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set to default value\nReturns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueContainer-T-/M-SetDefault.html",
        "title": "SetDefault",
        "tags": [],
        "description": "",
        "summary": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set default values\nReturns Returns true if the value is set. Otherwise returns false.",
        "content": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set default values\nReturns Returns true if the value is set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-SetDefault.html",
        "title": "SetDefault",
        "tags": [],
        "description": "",
        "summary": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set a value to the default value.\nReturns Returns true if it can be set. Otherwise returns false.",
        "content": "SetDefault() public bool SetDefault() ;\r\r\rDescription Set a value to the default value.\nReturns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType/M-SetDefaultWithoutNotify.html",
        "title": "SetDefaultWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set to default value without notification\nReturns Returns true if it can be set. Otherwise returns false.",
        "content": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set to default value without notification\nReturns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable-T-/M-SetDefaultWithoutNotify.html",
        "title": "SetDefaultWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set a value to the default value without notification.\nReturns Returns true if it can be set. Otherwise returns false.",
        "content": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set a value to the default value without notification.\nReturns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-SetDefaultWithoutNotify.html",
        "title": "SetDefaultWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set a value to the default value without notification.\nReturns Returns true if it can be set. Otherwise returns false.",
        "content": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set a value to the default value without notification.\nReturns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableList-T-/M-SetDefaultWithoutNotify.html",
        "title": "SetDefaultWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set a value to the default value without notification.\nReturns Returns true if it can be set. Otherwise returns false.",
        "content": "SetDefaultWithoutNotify() public bool SetDefaultWithoutNotify() ;\r\r\rDescription Set a value to the default value without notification.\nReturns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-SetElement.html",
        "title": "SetElement",
        "tags": [],
        "description": "",
        "summary": "SetElement(IValueGetter, int, IValueGetter) public bool SetElement(IValueGetter listGetter, int index, IValueGetter elementGetter) ;\r\r\rDescription Set the element\nParameters    Parameter Name Description     listGetter Instance to get list   index Element index   elementGetter Instance to get element value    Returns Returns true if the element is set. Otherwise returns false.",
        "content": "SetElement(IValueGetter, int, IValueGetter) public bool SetElement(IValueGetter listGetter, int index, IValueGetter elementGetter) ;\r\r\rDescription Set the element\nParameters    Parameter Name Description     listGetter Instance to get list   index Element index   elementGetter Instance to get element value    Returns Returns true if the element is set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeComponentEditor/M-SetupFields.html",
        "title": "SetupFields",
        "tags": [],
        "description": "",
        "summary": "SetupFields(SerializedProperty, NodeContentContainer) protected void SetupFields(SerializedProperty property, NodeContentContainer contentContainer) ;\r\r\rDescription Set up fields\nParameters    Parameter Name Description     property Property   contentContainer Content container    ",
        "content": "SetupFields(SerializedProperty, NodeContentContainer) protected void SetupFields(SerializedProperty property, NodeContentContainer contentContainer) ;\r\r\rDescription Set up fields\nParameters    Parameter Name Description     property Property   contentContainer Content container    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter-T-/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value value    Returns Returns true if the value is set. Otherwise returns false.",
        "content": "SetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value value    Returns Returns true if the value is set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(IValueGetter) public bool SetValue(IValueGetter valueGetter) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     valueGetter Instance to get the value to set    Returns Returns true if the value is set. Otherwise returns false.",
        "content": "SetValue(IValueGetter) public bool SetValue(IValueGetter valueGetter) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     valueGetter Instance to get the value to set    Returns Returns true if the value is set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPort-T-/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(IValueGetter) public bool SetValue(IValueGetter getter) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     getter IValueGetter to get the value to set    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValue(IValueGetter) public bool SetValue(IValueGetter getter) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     getter IValueGetter to get the value to set    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/RefArgument-T-TInputField-/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(ref T) public void SetValue(ref T value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value Value to set    ",
        "content": "SetValue(ref T) public void SetValue(ref T value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value Value to set    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponent-TTarget-TInputField-T-/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(TTarget, T) protected void SetValue(TTarget target, T value) ;\r\r\rDescription Set the current value.\nParameters    Parameter Name Description     target Target   value Current value    SetValue(T) protected void SetValue(T value) ;\r\r\rDescription Set the current value.\nParameters    Parameter Name Description     value Current value    ",
        "content": "SetValue(TTarget, T) protected void SetValue(TTarget target, T value) ;\r\r\rDescription Set the current value.\nParameters    Parameter Name Description     target Target   value Current value    SetValue(T) protected void SetValue(T value) ;\r\r\rDescription Set the current value.\nParameters    Parameter Name Description     value Current value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponentBase-T-/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(T) protected void SetValue(T value) ;\r\r\rDescription Set the current value.\nParameters    Parameter Name Description     value Current value    ",
        "content": "SetValue(T) protected void SetValue(T value) ;\r\r\rDescription Set the current value.\nParameters    Parameter Name Description     value Current value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueContainer-T-/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(IValueGetter) public bool SetValue(IValueGetter getter) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     getter Instance to get the value to set    Returns Returns true if the value is set. Otherwise returns false.\nSetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value value    Returns Returns true if the value is set.",
        "content": "SetValue(IValueGetter) public bool SetValue(IValueGetter getter) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     getter Instance to get the value to set    Returns Returns true if the value is set. Otherwise returns false.\nSetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value value    Returns Returns true if the value is set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(IValueGetter) public bool SetValue(IValueGetter valueGetter) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     valueGetter Source of value    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValue(IValueGetter) public bool SetValue(IValueGetter valueGetter) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     valueGetter Source of value    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableBase-T-/M-SetValue.html",
        "title": "SetValue",
        "tags": [],
        "description": "",
        "summary": "SetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValue(ref T) public bool SetValue(ref T value) ;\r\r\rDescription Set the value.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueSetter/M-SetValueObject.html",
        "title": "SetValueObject",
        "tags": [],
        "description": "",
        "summary": "SetValueObject(object) public bool SetValueObject(object value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value value    Returns Returns true if the value is set. Otherwise returns false.",
        "content": "SetValueObject(object) public bool SetValueObject(object value) ;\r\r\rDescription Set the value\nParameters    Parameter Name Description     value value    Returns Returns true if the value is set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(TValueType) public void SetValueWithoutNotify(TValueType newValue) ;\r\r\rDescription Allow changing value without triggering any change event.\nParameters    Parameter Name Description     newValue The new value.    ",
        "content": "SetValueWithoutNotify(TValueType) public void SetValueWithoutNotify(TValueType newValue) ;\r\r\rDescription Allow changing value without triggering any change event.\nParameters    Parameter Name Description     newValue The new value.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeField/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(SerializableType) public void SetValueWithoutNotify(SerializableType value) ;\r\r\rDescription Set value without notification\nParameters    Parameter Name Description     value Value    ",
        "content": "SetValueWithoutNotify(SerializableType) public void SetValueWithoutNotify(SerializableType value) ;\r\r\rDescription Set value without notification\nParameters    Parameter Name Description     value Value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPort-T-/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(T) public bool SetValueWithoutNotify(T value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValueWithoutNotify(T) public bool SetValueWithoutNotify(T value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(IValueGetter) public bool SetValueWithoutNotify(IValueGetter getter) ;\r\r\rDescription Set value without notification\nParameters    Parameter Name Description     getter IValueGetter to get the value to set    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValueWithoutNotify(IValueGetter) public bool SetValueWithoutNotify(IValueGetter getter) ;\r\r\rDescription Set value without notification\nParameters    Parameter Name Description     getter IValueGetter to get the value to set    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable-T-/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(ref T) public bool SetValueWithoutNotify(ref T value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValueWithoutNotify(ref T) public bool SetValueWithoutNotify(ref T value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(object) public bool SetValueWithoutNotify(object value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\nSetValueWithoutNotify(IValueGetter) public bool SetValueWithoutNotify(IValueGetter valueGetter) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     valueGetter Source of value    Returns Returns true if it can be set.",
        "content": "SetValueWithoutNotify(object) public bool SetValueWithoutNotify(object value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\nSetValueWithoutNotify(IValueGetter) public bool SetValueWithoutNotify(IValueGetter valueGetter) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     valueGetter Source of value    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableBase-T-/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(ref T) public bool SetValueWithoutNotify(ref T value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\nSetValueWithoutNotify(object) public bool SetValueWithoutNotify(object value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set.",
        "content": "SetValueWithoutNotify(ref T) public bool SetValueWithoutNotify(ref T value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\nSetValueWithoutNotify(object) public bool SetValueWithoutNotify(object value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\nSetValueWithoutNotify(IValueGetter) public bool SetValueWithoutNotify(IValueGetter valueGetter) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     valueGetter Source of value    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableList-T-/M-SetValueWithoutNotify.html",
        "title": "SetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "SetValueWithoutNotify(ref IList\u0026lt;T\u0026gt;) public bool SetValueWithoutNotify(ref IList\u0026lt;T\u0026gt; value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "SetValueWithoutNotify(ref IList\u0026lt;T\u0026gt;) public bool SetValueWithoutNotify(ref IList\u0026lt;T\u0026gt; value) ;\r\r\rDescription Set the value without notification.\nParameters    Parameter Name Description     value Value    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLinkReference/P-ShareType.html",
        "title": "ShareType",
        "tags": [],
        "description": "",
        "summary": "public BlackboardDataLinkShareType ShareType ;\r\r\rDescription Share type",
        "content": "public BlackboardDataLinkShareType ShareType ;\r\r\rDescription Share type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ShortLerp.html",
        "title": "ShortLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;short\u0026gt;\nDescription Linear interpolation of type short\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;short\u0026gt;\nDescription Linear interpolation of type short\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ConstantColorUsageAttribute/F-ShowAlpha.html",
        "title": "ShowAlpha",
        "tags": [],
        "description": "",
        "summary": "public bool ShowAlpha ;\r\r\rDescription If set to true, the alpha value will be displayed.",
        "content": "public bool ShowAlpha ;\r\r\rDescription If set to true, the alpha value will be displayed.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/M-ShowMenu.html",
        "title": "ShowMenu",
        "tags": [],
        "description": "",
        "summary": "ShowMenu() protected void ShowMenu() ;\r\r\rDescription Show menu",
        "content": "ShowMenu() protected void ShowMenu() ;\r\r\rDescription Show menu\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeField/F-ShowNoneItem.html",
        "title": "ShowNoneItem",
        "tags": [],
        "description": "",
        "summary": "public bool ShowNoneItem ;\r\r\rDescription Whether to display None items",
        "content": "public bool ShowNoneItem ;\r\r\rDescription Whether to display None items\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.StateMachines/Enums/SignalExpiration.html",
        "title": "SignalExpiration",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit.StateMachines\nDescription Signal expiration time\nProperties    Property Name Description     Evaluating Valid while being evaluated   ActiveNode Valid while node is active   Once Valid for one evaluation only   Infinite Infinite    ",
        "content": "Enum in LogicToolkit.StateMachines\nDescription Signal expiration time\nProperties    Property Name Description     Evaluating Valid while being evaluated   ActiveNode Valid while node is active   Once Valid for one evaluation only   Infinite Infinite    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/FS-SplitViewUssClassName.html",
        "title": "SplitViewUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string SplitViewUssClassName ;\r\r\rDescription Split view USS class name",
        "content": "public static string SplitViewUssClassName ;\r\r\rDescription Split view USS class name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Static.html",
        "title": "Static",
        "tags": [],
        "description": "",
        "summary": "Description Static type",
        "content": "Description Static type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/StaticEvent.html",
        "title": "StaticEvent",
        "tags": [],
        "description": "",
        "summary": "Description Static event",
        "content": "Description Static event\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/StaticField.html",
        "title": "StaticField",
        "tags": [],
        "description": "",
        "summary": "Description Static field",
        "content": "Description Static field\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/StaticMethod.html",
        "title": "StaticMethod",
        "tags": [],
        "description": "",
        "summary": "Description Static method",
        "content": "Description Static method\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/MemberIconKind/StaticProperty.html",
        "title": "StaticProperty",
        "tags": [],
        "description": "",
        "summary": "Description Static property",
        "content": "Description Static property\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicPlayerBase/M-Stop.html",
        "title": "Stop",
        "tags": [],
        "description": "",
        "summary": "Stop() public void Stop() ;\r\r\rDescription Stop playback.",
        "content": "Stop() public void Stop() ;\r\r\rDescription Stop playback.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort/M-Stop.html",
        "title": "Stop",
        "tags": [],
        "description": "",
        "summary": "Stop() public void Stop() ;\r\r\rDescription Stop playback.",
        "content": "Stop() public void Stop() ;\r\r\rDescription Stop playback.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Timer/M-Stop.html",
        "title": "Stop",
        "tags": [],
        "description": "",
        "summary": "Stop() public void Stop() ;\r\r\rDescription Stop playback",
        "content": "Stop() public void Stop() ;\r\r\rDescription Stop playback\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/PlayState/Stopped.html",
        "title": "Stopped",
        "tags": [],
        "description": "",
        "summary": "Description Playback stopped",
        "content": "Description Playback stopped\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable-T-/M-StoreDefaults.html",
        "title": "StoreDefaults",
        "tags": [],
        "description": "",
        "summary": "StoreDefaults() protected internal void StoreDefaults() ;\r\r\rDescription Store value as default value",
        "content": "StoreDefaults() protected internal void StoreDefaults() ;\r\r\rDescription Store value as default value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/M-StoreDefaults.html",
        "title": "StoreDefaults",
        "tags": [],
        "description": "",
        "summary": "StoreDefaults() protected internal void StoreDefaults() ;\r\r\rDescription Store value as default value",
        "content": "StoreDefaults() protected internal void StoreDefaults() ;\r\r\rDescription Store value as default value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableList-T-/M-StoreDefaults.html",
        "title": "StoreDefaults",
        "tags": [],
        "description": "",
        "summary": "StoreDefaults() protected internal void StoreDefaults() ;\r\r\rDescription Store value as default value",
        "content": "StoreDefaults() protected internal void StoreDefaults() ;\r\r\rDescription Store value as default value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters/Struct.html",
        "title": "Struct",
        "tags": [],
        "description": "",
        "summary": "Description Structure",
        "content": "Description Structure\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TaskStatus/Success.html",
        "title": "Success",
        "tags": [],
        "description": "",
        "summary": "Description Success",
        "content": "Description Success\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/AssemblySources/SystemAssembly.html",
        "title": "SystemAssembly",
        "tags": [],
        "description": "",
        "summary": "Description System",
        "content": "Description System\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLinkReference/P-Tag.html",
        "title": "Tag",
        "tags": [],
        "description": "",
        "summary": "public string Tag ;\r\r\rDescription Tag",
        "content": "public string Tag ;\r\r\rDescription Tag\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TaskComponent.html",
        "title": "TaskComponent",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: ActivatableComponent\nDescription Components that perform operations that take a long time to complete\nMethods    Method Name Description     OnExecute Execute processing.    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: ActivatableComponent\nDescription Components that perform operations that take a long time to complete\nMethods    Method Name Description     OnExecute Execute processing.    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TaskStatus.html",
        "title": "TaskStatus",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Task status\nProperties    Property Name Description     Running Running   Success Success   Failure Failure    ",
        "content": "Enum in LogicToolkit\nDescription Task status\nProperties    Property Name Description     Running Running   Success Success   Failure Failure    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/FS-TextUssClassName.html",
        "title": "TextUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string TextUssClassName ;\r\r\rDescription USS class name of text elements in elements of this type.",
        "content": "public static string TextUssClassName ;\r\r\rDescription USS class name of text elements in elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLink/P-this-int-.html",
        "title": "this[int]",
        "tags": [],
        "description": "",
        "summary": "public BlackboardDataLinkReference this[int index] ;\r\r\rDescription Returns the BlackboardDataLinkReference stored in index.\nParameters    Parameter Name Description     index Index    ",
        "content": "public BlackboardDataLinkReference this[int index] ;\r\r\rDescription Returns the BlackboardDataLinkReference stored in index.\nParameters    Parameter Name Description     index Index    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Timer/P-Time.html",
        "title": "Time",
        "tags": [],
        "description": "",
        "summary": "public float Time ;\r\r\rDescription Elapsed time",
        "content": "public float Time ;\r\r\rDescription Elapsed time\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Timer.html",
        "title": "Timer",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Measure the passage of time\nProperties    Property Name Description     PlayState Play status   Time Elapsed time    Methods    Method Name Description     Pause Pause.   Play Start playing   Resume Resume.   Stop Stop playback    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Measure the passage of time\nProperties    Property Name Description     PlayState Play status   Time Elapsed time    Methods    Method Name Description     Pause Pause.   Play Start playing   Resume Resume.   Stop Stop playback    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TimerType.html",
        "title": "TimerType",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit\nDescription Time Type\nProperties    Property Name Description     Normal Use Time.time.   Unscaled Use Time.unscaledTime.   Fixed Use Time.fixedTime.   FixedUnscaled Use Time.fixedUnscaledTime.   Realtime Use Time.realtimeSinceStartup.    ",
        "content": "Enum in LogicToolkit\nDescription Time Type\nProperties    Property Name Description     Normal Use Time.time.   Unscaled Use Time.unscaledTime.   Fixed Use Time.fixedTime.   FixedUnscaled Use Time.fixedUnscaledTime.   Realtime Use Time.realtimeSinceStartup.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/FixedTitleNameAttribute/F-Title.html",
        "title": "Title",
        "tags": [],
        "description": "",
        "summary": "public string Title ;\r\r\rDescription Title name",
        "content": "public string Title ;\r\r\rDescription Title name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-ToArray.html",
        "title": "ToArray",
        "tags": [],
        "description": "",
        "summary": "ToArray(IValueGetter, IValueSetter) public bool ToArray(IValueGetter input, IValueSetter output) ;\r\r\rDescription Convert list to array\nParameters    Parameter Name Description     input Instance to get list   output Instance that outputs the converted array    Returns Returns true if converted to an array. Otherwise returns false.",
        "content": "ToArray(IValueGetter, IValueSetter) public bool ToArray(IValueGetter input, IValueSetter output) ;\r\r\rDescription Convert list to array\nParameters    Parameter Name Description     input Instance to get list   output Instance that outputs the converted array    Returns Returns true if converted to an array. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IListAccessor/M-ToList.html",
        "title": "ToList",
        "tags": [],
        "description": "",
        "summary": "ToList(IValueGetter, IValueSetter) public bool ToList(IValueGetter input, IValueSetter output) ;\r\r\rDescription Convert list to List\u0026lt;T\u0026gt;\nParameters    Parameter Name Description     input Instance to get list   output Instance that outputs the converted List\u0026lt;T\u0026gt;    Returns Returns true if converted to List\u0026lt;T\u0026gt;. Otherwise returns false.",
        "content": "ToList(IValueGetter, IValueSetter) public bool ToList(IValueGetter input, IValueSetter output) ;\r\r\rDescription Convert list to List\u0026lt;T\u0026gt;\nParameters    Parameter Name Description     input Instance to get list   output Instance that outputs the converted List\u0026lt;T\u0026gt;    Returns Returns true if converted to List\u0026lt;T\u0026gt;. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem/F-Tooltip.html",
        "title": "Tooltip",
        "tags": [],
        "description": "",
        "summary": "public string Tooltip ;\r\r\rDescription Tooltip",
        "content": "public string Tooltip ;\r\r\rDescription Tooltip\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortConnector/P-Tooltip.html",
        "title": "Tooltip",
        "tags": [],
        "description": "",
        "summary": "public string Tooltip ;\r\r\rDescription Tooltip",
        "content": "public string Tooltip ;\r\r\rDescription Tooltip\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/FieldPlacement/Top.html",
        "title": "Top",
        "tags": [],
        "description": "",
        "summary": "Description Top side",
        "content": "Description Top side\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/FS-TopViewUssClassName.html",
        "title": "TopViewUssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string TopViewUssClassName ;\r\r\rDescription Top view USS class name",
        "content": "public static string TopViewUssClassName ;\r\r\rDescription Top view USS class name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType/M-ToString.html",
        "title": "ToString",
        "tags": [],
        "description": "",
        "summary": "ToString() public string ToString() ;\r\r\rDescription Get string\nReturns string",
        "content": "ToString() public string ToString() ;\r\r\rDescription Get string\nReturns string\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId/M-ToString.html",
        "title": "ToString",
        "tags": [],
        "description": "",
        "summary": "ToString() public string ToString() ;\r\r\rDescription Get string\nReturns string",
        "content": "ToString() public string ToString() ;\r\r\rDescription Get string\nReturns string\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ExecuteNode/M-Transition.html",
        "title": "Transition",
        "tags": [],
        "description": "",
        "summary": "Transition(OutputTransitionPort, bool) public bool Transition(OutputTransitionPort transitionPort, bool exitOnFailure) ;\r\r\rDescription Transition execution nodes.\nParameters    Parameter Name Description     transitionPort Port connecting to transition node   exitOnFailure End the flow if the transition is not possible    Returns Returns true if the transition has occurred. Otherwise returns false.",
        "content": "Transition(OutputTransitionPort, bool) public bool Transition(OutputTransitionPort transitionPort, bool exitOnFailure) ;\r\r\rDescription Transition execution nodes.\nParameters    Parameter Name Description     transitionPort Port connecting to transition node   exitOnFailure End the flow if the transition is not possible    Returns Returns true if the transition has occurred. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TransitionalPort.html",
        "title": "TransitionalPort",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Port\nDescription Basic type of port that handles transitions\nInherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Port\nDescription Basic type of port that handles transitions\nInherited Members Properties    Property Name Description     ConnectedWiresCount Number of connected wires   Node Node that owns this port    Methods    Method Name Description     DeleteWireIds Remove wire connections   GetConnectedWireAt Get connected wire   GetConnectedWireIdAt Get connected wire ID    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/BlackboardDataLink/M-TryGet.html",
        "title": "TryGet",
        "tags": [],
        "description": "",
        "summary": "TryGet(UniqueId, out BlackboardDataLinkReference) public bool TryGet(UniqueId id, out BlackboardDataLinkReference reference) ;\r\r\rDescription Get BlackboardDataLinkReference by specifying id.\nParameters    Parameter Name Description     id ID   reference GetBlackboardDataLinkReference    Returns Returns true if the ID specified in id exists. Otherwise returns false.",
        "content": "TryGet(UniqueId, out BlackboardDataLinkReference) public bool TryGet(UniqueId id, out BlackboardDataLinkReference reference) ;\r\r\rDescription Get BlackboardDataLinkReference by specifying id.\nParameters    Parameter Name Description     id ID   reference GetBlackboardDataLinkReference    Returns Returns true if the ID specified in id exists. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/LogicController/M-TryGetFunctionGraph.html",
        "title": "TryGetFunctionGraph",
        "tags": [],
        "description": "",
        "summary": "TryGetFunctionGraph(long, out NodeGraph) public bool TryGetFunctionGraph(long id, out NodeGraph nodeGraph) ;\r\r\rDescription Get the function graph.\nParameters    Parameter Name Description     id Function graph ID   nodeGraph Function graph    Returns Returns true if the graph of id exists. Otherwise returns false.",
        "content": "TryGetFunctionGraph(long, out NodeGraph) public bool TryGetFunctionGraph(long id, out NodeGraph nodeGraph) ;\r\r\rDescription Get the function graph.\nParameters    Parameter Name Description     id Function graph ID   nodeGraph Function graph    Returns Returns true if the graph of id exists. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/NodeGraph/M-TryGetNode.html",
        "title": "TryGetNode",
        "tags": [],
        "description": "",
        "summary": "TryGetNode(long, out Node) public bool TryGetNode(long id, out Node node) ;\r\r\rDescription Get the node of id\nParameters    Parameter Name Description     id Node ID   node Found node    Returns Returns true if the node exists. Otherwise returns false.",
        "content": "TryGetNode(long, out Node) public bool TryGetNode(long id, out Node node) ;\r\r\rDescription Get the node of id\nParameters    Parameter Name Description     id Node ID   node Found node    Returns Returns true if the node exists. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/GraphEditor/M-TryGetNodeEditor.html",
        "title": "TryGetNodeEditor",
        "tags": [],
        "description": "",
        "summary": "TryGetNodeEditor(long, out NodeEditor) public bool TryGetNodeEditor(long nodeId, out NodeEditor nodeEditor) ;\r\r\rDescription Get node editor\nParameters    Parameter Name Description     nodeId Node ID   nodeEditor Node editor    Returns Returns true if the node editor is obtained. Otherwise returns false.",
        "content": "TryGetNodeEditor(long, out NodeEditor) public bool TryGetNodeEditor(long nodeId, out NodeEditor nodeEditor) ;\r\r\rDescription Get node editor\nParameters    Parameter Name Description     nodeId Node ID   nodeEditor Node editor    Returns Returns true if the node editor is obtained. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueTryGetter/M-TryGetValue.html",
        "title": "TryGetValue",
        "tags": [],
        "description": "",
        "summary": "TryGetValue\u0026lt;T\u0026gt;(out T) public bool TryGetValue\u0026lt;T\u0026gt;(out T value) ;\r\r\rDescription Attempt to get the value\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     value Obtained value    Returns Returns true if it can be obtained. Otherwise returns false.",
        "content": "TryGetValue\u0026lt;T\u0026gt;(out T) public bool TryGetValue\u0026lt;T\u0026gt;(out T value) ;\r\r\rDescription Attempt to get the value\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     value Obtained value    Returns Returns true if it can be obtained. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputDataPort-T-/M-TryGetValue.html",
        "title": "TryGetValue",
        "tags": [],
        "description": "",
        "summary": "TryGetValue(out T) public bool TryGetValue(out T value) ;\r\r\rDescription Get value\nParameters    Parameter Name Description     value Obtained value    Returns Returns true if the value can be obtained. Otherwise returns false.",
        "content": "TryGetValue(out T) public bool TryGetValue(out T value) ;\r\r\rDescription Get value\nParameters    Parameter Name Description     value Obtained value    Returns Returns true if the value can be obtained. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputDataPortWithType/M-TryGetValue.html",
        "title": "TryGetValue",
        "tags": [],
        "description": "",
        "summary": "TryGetValue\u0026lt;T\u0026gt;(out T) public bool TryGetValue\u0026lt;T\u0026gt;(out T value) ;\r\r\rDescription Get value\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Parameters    Parameter Name Description     value Obtained value    Returns Returns true if the value can be obtained. Otherwise returns false.",
        "content": "TryGetValue\u0026lt;T\u0026gt;(out T) public bool TryGetValue\u0026lt;T\u0026gt;(out T value) ;\r\r\rDescription Get value\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Parameters    Parameter Name Description     value Obtained value    Returns Returns true if the value can be obtained. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueFlowExtensions/MS-TryGetValue.html",
        "title": "TryGetValue",
        "tags": [],
        "description": "",
        "summary": "TryGetValue\u0026lt;T\u0026gt;(IValueGetter, out T) public static bool TryGetValue\u0026lt;T\u0026gt;(this IValueGetter valueGetter, out T value) ;\r\r\rDescription Get the value.\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     valueGetter Instance to get value   value Obtained value    Returns Returns true if the value could be obtained.",
        "content": "TryGetValue\u0026lt;T\u0026gt;(IValueGetter, out T) public static bool TryGetValue\u0026lt;T\u0026gt;(this IValueGetter valueGetter, out T value) ;\r\r\rDescription Get the value.\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     valueGetter Instance to get value   value Obtained value    Returns Returns true if the value could be obtained. Otherwise returns false.\nRemarks Implicit type conversions and downcasts are performed as necessary.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueFlowExtensions/MS-TryGetValueRaw.html",
        "title": "TryGetValueRaw",
        "tags": [],
        "description": "",
        "summary": "TryGetValueRaw\u0026lt;T\u0026gt;(IValueGetter, out T) public static bool TryGetValueRaw\u0026lt;T\u0026gt;(this IValueGetter valueGetter, out T value) ;\r\r\rDescription Get the value without converting it.\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     valueGetter Instance to get value   value Obtained value    Returns Returns true if the value could be obtained.",
        "content": "TryGetValueRaw\u0026lt;T\u0026gt;(IValueGetter, out T) public static bool TryGetValueRaw\u0026lt;T\u0026gt;(this IValueGetter valueGetter, out T value) ;\r\r\rDescription Get the value without converting it.\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     valueGetter Instance to get value   value Obtained value    Returns Returns true if the value could be obtained. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Blackboard/M-TryGetVariable.html",
        "title": "TryGetVariable",
        "tags": [],
        "description": "",
        "summary": "TryGetVariable(long, out Variable) public bool TryGetVariable(long id, out Variable variable) ;\r\r\rDescription Get Variable of id.\nParameters    Parameter Name Description     id ID   variable Found Variable    Returns Returns true if Variable of id exists. Otherwise returns false.",
        "content": "TryGetVariable(long, out Variable) public bool TryGetVariable(long id, out Variable variable) ;\r\r\rDescription Get Variable of id.\nParameters    Parameter Name Description     id ID   variable Found Variable    Returns Returns true if Variable of id exists. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IValueTrySetter/M-TrySetValue.html",
        "title": "TrySetValue",
        "tags": [],
        "description": "",
        "summary": "TrySetValue\u0026lt;T\u0026gt;(ref T) public bool TrySetValue\u0026lt;T\u0026gt;(ref T value) ;\r\r\rDescription Attempt to set the value\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "TrySetValue\u0026lt;T\u0026gt;(ref T) public bool TrySetValue\u0026lt;T\u0026gt;(ref T value) ;\r\r\rDescription Attempt to set the value\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType/M-TrySetValue.html",
        "title": "TrySetValue",
        "tags": [],
        "description": "",
        "summary": "TrySetValue\u0026lt;T\u0026gt;(ref T) public bool TrySetValue\u0026lt;T\u0026gt;(ref T value) ;\r\r\rDescription Set the value.\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Parameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "TrySetValue\u0026lt;T\u0026gt;(ref T) public bool TrySetValue\u0026lt;T\u0026gt;(ref T value) ;\r\r\rDescription Set the value.\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Parameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueFlowExtensions/MS-TrySetValue.html",
        "title": "TrySetValue",
        "tags": [],
        "description": "",
        "summary": "TrySetValue\u0026lt;T\u0026gt;(IValueSetter, ref T) public static bool TrySetValue\u0026lt;T\u0026gt;(this IValueSetter valueSetter, ref T value) ;\r\r\rDescription Set the value.\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     valueSetter Instance to set value   value value    Returns Returns true if the value could be set.",
        "content": "TrySetValue\u0026lt;T\u0026gt;(IValueSetter, ref T) public static bool TrySetValue\u0026lt;T\u0026gt;(this IValueSetter valueSetter, ref T value) ;\r\r\rDescription Set the value.\nType Parameters    Type Parameter Name Description Type Constraints     T value type     Parameters    Parameter Name Description     valueSetter Instance to set value   value value    Returns Returns true if the value could be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputDataPortWithType/M-TrySetValueWithoutNotify.html",
        "title": "TrySetValueWithoutNotify",
        "tags": [],
        "description": "",
        "summary": "TrySetValueWithoutNotify\u0026lt;T\u0026gt;(ref T) public bool TrySetValueWithoutNotify\u0026lt;T\u0026gt;(ref T value) ;\r\r\rDescription Set value without notification\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Parameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.",
        "content": "TrySetValueWithoutNotify\u0026lt;T\u0026gt;(ref T) public bool TrySetValueWithoutNotify\u0026lt;T\u0026gt;(ref T value) ;\r\r\rDescription Set value without notification\nType Parameters    Type Parameter Name Description Type Constraints     T Data type     Parameters    Parameter Name Description     value Value to set    Returns Returns true if it can be set. Otherwise returns false.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponent-TTarget-TInputField-T-.html",
        "title": "TweenComponent&lt;TTarget, TInputField, T&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: TweenComponentBase\u0026lt;T\u0026gt;\nDescription A component that performs tween animation of parameters by specifying the target.\nType Parameters    Type Parameter Name Description Type Constraints     TTarget Target type class   TInputField Type of input field to retrieve target InputFieldBase\u0026lt;TTarget\u0026gt;new()   T Type of parameter to be tweened     Methods    Method Name Description     GetFromValue Get starting value   OnActivated Called when it becomes active   SetValue Set the current value.",
        "content": "\r\rClass in LogicToolkit / Inherits from: TweenComponentBase\u0026lt;T\u0026gt;\nDescription A component that performs tween animation of parameters by specifying the target.\nType Parameters    Type Parameter Name Description Type Constraints     TTarget Target type class   TInputField Type of input field to retrieve target InputFieldBase\u0026lt;TTarget\u0026gt;new()   T Type of parameter to be tweened     Methods    Method Name Description     GetFromValue Get starting value   OnActivated Called when it becomes active   SetValue Set the current value.    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnDeactivated Called when it becomes inactive   OnExecute Execute processing.   OnProgress Called when progress changes    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TweenComponentBase-T-.html",
        "title": "TweenComponentBase&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: WaitForSeconds\nDescription Basic type of component that performs tweened animation of parameters\nType Parameters    Type Parameter Name Description Type Constraints     T Type of parameter to be tweened     Methods    Method Name Description     GetFromValue Get starting value   OnActivated Called when it becomes active   OnProgress Called when progress changes   SetValue Set the current value.",
        "content": "\r\rClass in LogicToolkit / Inherits from: WaitForSeconds\nDescription Basic type of component that performs tweened animation of parameters\nType Parameters    Type Parameter Name Description Type Constraints     T Type of parameter to be tweened     Methods    Method Name Description     GetFromValue Get starting value   OnActivated Called when it becomes active   OnProgress Called when progress changes   SetValue Set the current value.    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    Methods    Method Name Description     OnDeactivated Called when it becomes inactive   OnExecute Execute processing.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator/P-Type.html",
        "title": "Type",
        "tags": [],
        "description": "",
        "summary": "public Type Type ;\r\r\rDescription Target type",
        "content": "public Type Type ;\r\r\rDescription Target type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/HideTypeInVariableMenuAttribute/F-Type.html",
        "title": "Type",
        "tags": [],
        "description": "",
        "summary": "public Type Type ;\r\r\rDescription Target type",
        "content": "public Type Type ;\r\r\rDescription Target type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/DataPortWithType/P-Type.html",
        "title": "Type",
        "tags": [],
        "description": "",
        "summary": "public Type Type ;\r\r\rDescription Data type",
        "content": "public Type Type ;\r\r\rDescription Data type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/SerializableType/P-Type.html",
        "title": "Type",
        "tags": [],
        "description": "",
        "summary": "public Type Type ;\r\r\rDescription Get the referenced Type",
        "content": "public Type Type ;\r\r\rDescription Get the referenced Type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/TypeFilters.html",
        "title": "TypeFilters",
        "tags": [],
        "description": "",
        "summary": "Enum in LogicToolkit.Editors\nDescription Type filter flags\nProperties    Property Name Description     None None   SceneObject Objects in the scene (GameObject, Component)   AssetObject Asset objects (Unity objects other than scene objects)   Class Class   Struct Structure   Interface Interface   Enum Enum   Primitive Primitive type   Delegate Delegate type   Attribute Attribute type   Static Static type    ",
        "content": "Enum in LogicToolkit.Editors\nDescription Type filter flags\nProperties    Property Name Description     None None   SceneObject Objects in the scene (GameObject, Component)   AssetObject Asset objects (Unity objects other than scene objects)   Class Class   Struct Structure   Interface Interface   Enum Enum   Primitive Primitive type   Delegate Delegate type   Attribute Attribute type   Static Static type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeField/F-TypeFilters.html",
        "title": "TypeFilters",
        "tags": [],
        "description": "",
        "summary": "public TypeFilters TypeFilters ;\r\r\rDescription Type filter",
        "content": "public TypeFilters TypeFilters ;\r\r\rDescription Type filter\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuCreator.html",
        "title": "TypeMenuCreator",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit.Editors / Inherits from: object Description Create a script selection menu Properties Property Name Description Connectable Whether connection is possible FieldAssignor Data to assign to field GraphEditor Graph Editor Menu Menu Type Target type Methods Method Name Description AddMenus Called when adding a menu item. IsAcceptableAssignor フィールドの割り当てを許可できるかを判定する",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Create a script selection menu\nProperties    Property Name Description     Connectable Whether connection is possible   FieldAssignor Data to assign to field   GraphEditor Graph Editor   Menu Menu   Type Target type    Methods    Method Name Description     AddMenus Called when adding a menu item.   IsAcceptableAssignor フィールドの割り当てを許可できるかを判定する    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo.html",
        "title": "TypeMenuInfo",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Type menu information\nFields    Field Name Description     Description Description   DisplayName Display name   HasDisplayNameAttr Does it have DisplayNameAttribute?   HasMenuNameAttr Does it have MenuNameAttribute?   HelpUrl Help URL   Keywords Keywords   MenuName Menu name   MenuNameRaw Raw menu name   Name Name   TypeName Type name    Static Methods    Method Name Description     Get Get type menu infomation    ",
        "content": "\r\rClass in LogicToolkit.Editors / Inherits from: object\nDescription Type menu information\nFields    Field Name Description     Description Description   DisplayName Display name   HasDisplayNameAttr Does it have DisplayNameAttribute?   HasMenuNameAttr Does it have MenuNameAttribute?   HelpUrl Help URL   Keywords Keywords   MenuName Menu name   MenuNameRaw Raw menu name   Name Name   TypeName Type name    Static Methods    Method Name Description     Get Get type menu infomation    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem/F-TypeName.html",
        "title": "TypeName",
        "tags": [],
        "description": "",
        "summary": "public string TypeName ;\r\r\rDescription Type name",
        "content": "public string TypeName ;\r\r\rDescription Type name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeProperty/P-TypeName.html",
        "title": "TypeName",
        "tags": [],
        "description": "",
        "summary": "public string TypeName ;\r\r\rDescription Type name",
        "content": "public string TypeName ;\r\r\rDescription Type name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/TypeMenuInfo/F-TypeName.html",
        "title": "TypeName",
        "tags": [],
        "description": "",
        "summary": "public string TypeName ;\r\r\rDescription Type name",
        "content": "public string TypeName ;\r\r\rDescription Type name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/AllowedTypesAttribute/F-Types.html",
        "title": "Types",
        "tags": [],
        "description": "",
        "summary": "public Type[] Types ;\r\r\rDescription Types that are allowed to be used",
        "content": "public Type[] Types ;\r\r\rDescription Types that are allowed to be used\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/DisallowedTypesAttribute/F-Types.html",
        "title": "Types",
        "tags": [],
        "description": "",
        "summary": "public Type[] Types ;\r\r\rDescription Types that are not allowed to be used",
        "content": "public Type[] Types ;\r\r\rDescription Types that are not allowed to be used\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/AdvancedMenuItem/F-TypeStyleNames.html",
        "title": "TypeStyleNames",
        "tags": [],
        "description": "",
        "summary": "public string[] TypeStyleNames ;\r\r\rDescription Type style name",
        "content": "public string[] TypeStyleNames ;\r\r\rDescription Type style name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/TypeUtility.html",
        "title": "TypeUtility",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Type utility class\nStatic Methods    Method Name Description     GetArrayOrListElementType Get the type of element of array or IList\u0026lt;T\u0026gt;   IsImplementedTo Determine whether baseType is implemented    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Type utility class\nStatic Methods    Method Name Description     GetArrayOrListElementType Get the type of element of array or IList\u0026lt;T\u0026gt;   IsImplementedTo Determine whether baseType is implemented    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UIntLerp.html",
        "title": "UIntLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;uint\u0026gt;\nDescription Linear interpolation of type uint\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;uint\u0026gt;\nDescription Linear interpolation of type uint\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ULongLerp.html",
        "title": "ULongLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;ulong\u0026gt;\nDescription Linear interpolation of type ulong\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;ulong\u0026gt;\nDescription Linear interpolation of type ulong\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UniqueId.html",
        "title": "UniqueId",
        "tags": [],
        "description": "",
        "summary": "Struct in LogicToolkit / Inherits from: System.ValueType\nImplements interfaces: System.IEquatable\u0026lt;UniqueId\u0026gt;\nDescription Structure that handles unique IDs\nMethods    Method Name Description     Equals Determine equality   GetHashCode Get the hash code.   ToString Get string    Static Properties    Property Name Description     Empty Return empty ID    Static Methods    Method Name Description     NewId Create a new ID    Operators    Operator Name Description     operator !",
        "content": "\r\rStruct in LogicToolkit / Inherits from: System.ValueType\nImplements interfaces: System.IEquatable\u0026lt;UniqueId\u0026gt;\nDescription Structure that handles unique IDs\nMethods    Method Name Description     Equals Determine equality   GetHashCode Get the hash code.   ToString Get string    Static Properties    Property Name Description     Empty Return empty ID    Static Methods    Method Name Description     NewId Create a new ID    Operators    Operator Name Description     operator != Determine whether they are not equal   operator == Determine equality    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Enums/AssemblySources/UnityEngine.html",
        "title": "UnityEngine",
        "tags": [],
        "description": "",
        "summary": "Description UnityEngine",
        "content": "Description UnityEngine\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Enums/TimerType/Unscaled.html",
        "title": "Unscaled",
        "tags": [],
        "description": "",
        "summary": "Description Use Time.unscaledTime.",
        "content": "Description Use Time.unscaledTime.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/OutputExecutePort/M-Update.html",
        "title": "Update",
        "tags": [],
        "description": "",
        "summary": "Update() public void Update() ;\r\r\rDescription Update.",
        "content": "Update() public void Update() ;\r\r\rDescription Update.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Interfaces/IDataPortConnector/M-UpdateDataType.html",
        "title": "UpdateDataType",
        "tags": [],
        "description": "",
        "summary": "UpdateDataType() public void UpdateDataType() ;\r\r\rDescription Update data type",
        "content": "UpdateDataType() public void UpdateDataType() ;\r\r\rDescription Update data type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Attributes/CustomAttribute/F-UseForChildren.html",
        "title": "UseForChildren",
        "tags": [],
        "description": "",
        "summary": "public bool UseForChildren ;\r\r\rDescription Whether to use for derived classes as well",
        "content": "public bool UseForChildren ;\r\r\rDescription Whether to use for derived classes as well\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/UShortLerp.html",
        "title": "UShortLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;ushort\u0026gt;\nDescription Linear interpolation of type ushort\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;ushort\u0026gt;\nDescription Linear interpolation of type ushort\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BasePopupFieldExt-TValueType-/FS-UssClassName.html",
        "title": "UssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string UssClassName ;\r\r\rDescription USS class name of elements of this type.",
        "content": "public static string UssClassName ;\r\r\rDescription USS class name of elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/NodeContentContainer/FS-UssClassName.html",
        "title": "UssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string UssClassName ;\r\r\rDescription USS class name",
        "content": "public static string UssClassName ;\r\r\rDescription USS class name\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/PortField/FS-UssClassName.html",
        "title": "UssClassName",
        "tags": [],
        "description": "",
        "summary": "public static string UssClassName ;\r\r\rDescription USS class name of elements of this type.",
        "content": "public static string UssClassName ;\r\r\rDescription USS class name of elements of this type.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/SerializableTypeProperty/P-Value.html",
        "title": "Value",
        "tags": [],
        "description": "",
        "summary": "public Type Value ;\r\r\rDescription Value",
        "content": "public Type Value ;\r\r\rDescription Value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ComponentConstantContainer-T-/P-Value.html",
        "title": "Value",
        "tags": [],
        "description": "",
        "summary": "public T Value ;\r\r\rDescription Constant value",
        "content": "public T Value ;\r\r\rDescription Constant value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ConstantContainer-T-/P-Value.html",
        "title": "Value",
        "tags": [],
        "description": "",
        "summary": "public T Value ;\r\r\rDescription Constant value",
        "content": "public T Value ;\r\r\rDescription Constant value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/GameObjectConstantContainer/P-Value.html",
        "title": "Value",
        "tags": [],
        "description": "",
        "summary": "public GameObject Value ;\r\r\rDescription Constant value",
        "content": "public GameObject Value ;\r\r\rDescription Constant value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/InputFieldBase-T-/P-Value.html",
        "title": "Value",
        "tags": [],
        "description": "",
        "summary": "public T Value ;\r\r\rDescription Get value",
        "content": "public T Value ;\r\r\rDescription Get value\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Interfaces/IInputDataPortBase/M-ValueChanged.html",
        "title": "ValueChanged",
        "tags": [],
        "description": "",
        "summary": "ValueChanged() public void ValueChanged() ;\r\r\rDescription Communicate value changes.",
        "content": "ValueChanged() public void ValueChanged() ;\r\r\rDescription Communicate value changes.\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable/E-ValueChanged.html",
        "title": "ValueChanged",
        "tags": [],
        "description": "",
        "summary": "public event Action ValueChanged ;\r\r\rDescription Callback when value changes",
        "content": "public event Action ValueChanged ;\r\r\rDescription Callback when value changes\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueContainer-T-.html",
        "title": "ValueContainer&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nImplements interfaces: IValueContainer\u0026lt;T\u0026gt;\nDescription Class that handles value containers\nType Parameters    Type Parameter Name Description Type Constraints     T Value type     Methods    Method Name Description     GetValue Get value   SetDefault Set default values   SetValue Set the value    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nImplements interfaces: IValueContainer\u0026lt;T\u0026gt;\nDescription Class that handles value containers\nType Parameters    Type Parameter Name Description Type Constraints     T Value type     Methods    Method Name Description     GetValue Get value   SetDefault Set default values   SetValue Set the value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/ValueFlowExtensions.html",
        "title": "ValueFlowExtensions",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Value flow extension class\nStatic Methods    Method Name Description     TryGetValue Get the value.   TryGetValueRaw Get the value without converting it.   TrySetValue Set the value.    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Value flow extension class\nStatic Methods    Method Name Description     TryGetValue Get the value.   TryGetValueRaw Get the value without converting it.   TrySetValue Set the value.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ValueTypeAttribute/F-ValueType.html",
        "title": "ValueType",
        "tags": [],
        "description": "",
        "summary": "public Type ValueType ;\r\r\rDescription Value type",
        "content": "public Type ValueType ;\r\r\rDescription Value type\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ValueTypeAttribute.html",
        "title": "ValueTypeAttribute",
        "tags": [],
        "description": "",
        "summary": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Restrict types that can be selected with SerializableType to types derived from the specified base type\nConstructors     Description     ValueTypeAttribute Restrict types that can be selected with SerializableType to types derived from the specified base type    Fields    Field Name Description     ValueType Value type    ",
        "content": "\r\rAttribute in LogicToolkit / Inherits from: System.Attribute\nDescription Restrict types that can be selected with SerializableType to types derived from the specified base type\nConstructors     Description     ValueTypeAttribute Restrict types that can be selected with SerializableType to types derived from the specified base type    Fields    Field Name Description     ValueType Value type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Attributes/ValueTypeAttribute/ValueTypeAttribute-ctor.html",
        "title": "ValueTypeAttribute",
        "tags": [],
        "description": "",
        "summary": "ValueTypeAttribute(Type) public ValueTypeAttribute(Type valueType) ;\r\r\rDescription Restrict types that can be selected with SerializableType to types derived from the specified base type\nParameters    Parameter Name Description     valueType Value type    ",
        "content": "ValueTypeAttribute(Type) public ValueTypeAttribute(Type valueType) ;\r\r\rDescription Restrict types that can be selected with SerializableType to types derived from the specified base type\nParameters    Parameter Name Description     valueType Value type    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable.html",
        "title": "Variable",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: object\nImplements interfaces: IValueContainer\nDescription Variables stored in Blackboard\nProperties    Property Name Description     Id ID    Events    Event Name Description     ValueChanged Callback when value changes    Methods    Method Name Description     GetObject Get the value as object type.   GetString Get the value as a string.",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nImplements interfaces: IValueContainer\nDescription Variables stored in Blackboard\nProperties    Property Name Description     Id ID    Events    Event Name Description     ValueChanged Callback when value changes    Methods    Method Name Description     GetObject Get the value as object type.   GetString Get the value as a string.   GetValueType Get the type of a value.   RaiseValueChanged Raises a value change event.   RestoreDefaults Restore default value to current value   SetDefault Set a value to the default value.   SetDefaultWithoutNotify Set a value to the default value without notification.   SetValue Set the value.   SetValueWithoutNotify Set the value without notification.   StoreDefaults Store value as default value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableReference/P-Variable.html",
        "title": "Variable",
        "tags": [],
        "description": "",
        "summary": "public Variable Variable ;\r\r\rDescription Referring to VariableReference.Variable",
        "content": "public Variable Variable ;\r\r\rDescription Referring to VariableReference.Variable\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Variable-T-.html",
        "title": "Variable&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: VariableBase\u0026lt;T\u0026gt;\nDescription Generic type of variables stored in Blackboard\nType Parameters    Type Parameter Name Description Type Constraints     T Variable value type     Methods    Method Name Description     GetValue Get the value.   RestoreDefaults Restore default value to current value   SetDefaultWithoutNotify Set a value to the default value without notification.",
        "content": "\r\rClass in LogicToolkit / Inherits from: VariableBase\u0026lt;T\u0026gt;\nDescription Generic type of variables stored in Blackboard\nType Parameters    Type Parameter Name Description Type Constraints     T Variable value type     Methods    Method Name Description     GetValue Get the value.   RestoreDefaults Restore default value to current value   SetDefaultWithoutNotify Set a value to the default value without notification.   SetValueWithoutNotify Set the value without notification.   StoreDefaults Store value as default value    Inherited Members Properties    Property Name Description     Id ID    Events    Event Name Description     ValueChanged Callback when value changes    Methods    Method Name Description     GetObject Get the value as object type.   GetString Get the value as a string.   GetValueType Get the type of a value.   RaiseValueChanged Raises a value change event.   SetDefault Set a value to the default value.   SetValue Set the value.   SetValue Set the value.   SetValueWithoutNotify Set the value without notification.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableBase-T-.html",
        "title": "VariableBase&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: Variable\nImplements interfaces: IValueContainer\u0026lt;T\u0026gt;\nDescription Generic basic type of variables stored in Blackboard\nType Parameters    Type Parameter Name Description Type Constraints     T Variable value type     Methods    Method Name Description     GetObject Get the value as object type.   GetString Get the value as a string.",
        "content": "\r\rClass in LogicToolkit / Inherits from: Variable\nImplements interfaces: IValueContainer\u0026lt;T\u0026gt;\nDescription Generic basic type of variables stored in Blackboard\nType Parameters    Type Parameter Name Description Type Constraints     T Variable value type     Methods    Method Name Description     GetObject Get the value as object type.   GetString Get the value as a string.   GetValue Get the value.   GetValueType Get the type of a value.   SetValue Set the value.   SetValueWithoutNotify Set the value without notification.    Inherited Members Properties    Property Name Description     Id ID    Events    Event Name Description     ValueChanged Callback when value changes    Methods    Method Name Description     RaiseValueChanged Raises a value change event.   RestoreDefaults Restore default value to current value   SetDefault Set a value to the default value.   SetDefaultWithoutNotify Set a value to the default value without notification.   SetValue Set the value.   StoreDefaults Store value as default value    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableList-T-.html",
        "title": "VariableList&lt;T&gt;",
        "tags": [],
        "description": "",
        "summary": "Class in LogicToolkit / Inherits from: VariableBase\u0026lt;System.Collections.Generic.IList\u0026lt;T\u0026gt;\u0026gt;\nDescription List type variable stored in Blackboard\nType Parameters    Type Parameter Name Description Type Constraints     T Element value type     Methods    Method Name Description     GetValue Get the value.   RestoreDefaults Restore default value to current value   SetDefaultWithoutNotify Set a value to the default value without notification.",
        "content": "\r\rClass in LogicToolkit / Inherits from: VariableBase\u0026lt;System.Collections.Generic.IList\u0026lt;T\u0026gt;\u0026gt;\nDescription List type variable stored in Blackboard\nType Parameters    Type Parameter Name Description Type Constraints     T Element value type     Methods    Method Name Description     GetValue Get the value.   RestoreDefaults Restore default value to current value   SetDefaultWithoutNotify Set a value to the default value without notification.   SetValueWithoutNotify Set the value without notification.   StoreDefaults Store value as default value    Inherited Members Properties    Property Name Description     Id ID    Events    Event Name Description     ValueChanged Callback when value changes    Methods    Method Name Description     GetObject Get the value as object type.   GetString Get the value as a string.   GetValueType Get the type of a value.   RaiseValueChanged Raises a value change event.   SetDefault Set a value to the default value.   SetValue Set the value.   SetValue Set the value.   SetValueWithoutNotify Set the value without notification.    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/VariableReference.html",
        "title": "VariableReference",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Reference to VariableReference.Variable\nProperties    Property Name Description     NodeGraph VariableReference.NodeGraph that has this instance   Variable Referring to VariableReference.Variable    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Reference to VariableReference.Variable\nProperties    Property Name Description     NodeGraph VariableReference.NodeGraph that has this instance   Variable Referring to VariableReference.Variable    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Blackboard/P-VariablesCount.html",
        "title": "VariablesCount",
        "tags": [],
        "description": "",
        "summary": "public int VariablesCount ;\r\r\rDescription Number of variables",
        "content": "public int VariablesCount ;\r\r\rDescription Number of variables\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector2IntLerp.html",
        "title": "Vector2IntLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector2Int\u0026gt;\nDescription Linear interpolation of type Vector2Int\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector2Int\u0026gt;\nDescription Linear interpolation of type Vector2Int\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector2Lerp.html",
        "title": "Vector2Lerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector2\u0026gt;\nDescription Linear interpolation of type Vector2\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector2\u0026gt;\nDescription Linear interpolation of type Vector2\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector3IntLerp.html",
        "title": "Vector3IntLerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector3Int\u0026gt;\nDescription Linear interpolation of type Vector3Int\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector3Int\u0026gt;\nDescription Linear interpolation of type Vector3Int\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector3Lerp.html",
        "title": "Vector3Lerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector3\u0026gt;\nDescription Linear interpolation of type Vector3\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector3\u0026gt;\nDescription Linear interpolation of type Vector3\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector3Slerp.html",
        "title": "Vector3Slerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector3\u0026gt;\nDescription Spherical linear interpolation of type Vector3\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector3\u0026gt;\nDescription Spherical linear interpolation of type Vector3\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Vector4Lerp.html",
        "title": "Vector4Lerp",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector4\u0026gt;\nDescription Linear interpolation of type Vector4\nMethods    Method Name Description     Interpolate Perform interpolation processing    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: Interpolator\u0026lt;UnityEngine.Vector4\u0026gt;\nDescription Linear interpolation of type Vector4\nMethods    Method Name Description     Interpolate Perform interpolation processing    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/AssetInfo/FS-Version.html",
        "title": "Version",
        "tags": [],
        "description": "",
        "summary": "public static string Version ;\r\r\rDescription Version",
        "content": "public static string Version ;\r\r\rDescription Version\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit.Editors/Types/BaseFieldExt-TValueType-/P-VisualInput.html",
        "title": "VisualInput",
        "tags": [],
        "description": "",
        "summary": "public VisualElement VisualInput ;\r\r\rDescription Elements of input",
        "content": "public VisualElement VisualInput ;\r\r\rDescription Elements of input\n"
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/WaitForSeconds.html",
        "title": "WaitForSeconds",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: TaskComponent\nImplements interfaces: IProgressComponent, IPauseReceiver\nDescription Component that waits for a specified number of seconds to elapse\nMethods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   OnExecute Execute processing.   OnProgress Called when progress changes    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: TaskComponent\nImplements interfaces: IProgressComponent, IPauseReceiver\nDescription Component that waits for a specified number of seconds to elapse\nMethods    Method Name Description     OnActivated Called when it becomes active   OnDeactivated Called when it becomes inactive   OnExecute Execute processing.   OnProgress Called when progress changes    Inherited Members Properties    Property Name Description     IsActive Active or not   Node the node that owns this node component   Player LogicPlayerBase that is playing this node component    "
    },
    {
        "uri": "/scriptreference/LogicToolkit/Types/Wire.html",
        "title": "Wire",
        "tags": [],
        "description": "",
        "summary": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of wire\nProperties    Property Name Description     Id Wire ID   InputPort Input port   OutputPort Output port    ",
        "content": "\r\rClass in LogicToolkit / Inherits from: object\nDescription Basic type of wire\nProperties    Property Name Description     Id Wire ID   InputPort Input port   OutputPort Output port    "
    }
];